/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.support.ucu.util;

import com.pingidentity.pf.support.ucu.Log;
import com.pingidentity.pf.support.ucu.exception.UnresolveablePatternException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;

public class Regex {
    private static final String BASE_PROPERTIES_FILE = "Regex.properties";
    private static final String PROP_FILES_PROPERTY = "propertiesFiles";
    private static final String PROP_PREFIX = "com.pingidentity.pf.support.ucu.util.Regex.";
    private static final String DEFAULT = "DEFAULT";
    private static Properties props = null;

    private static void loadProperties() throws Exception {
        if (props == null) {
            try (InputStream inputStreamBaseProp = Regex.class.getResourceAsStream("/Regex.properties");){
                props = new Properties();
                Log.debug(Regex.class, "Loading Regex.properties");
                props.load(inputStreamBaseProp);
                String propertiesFiles = props.getProperty("com.pingidentity.pf.support.ucu.util.Regex.propertiesFiles");
                if (propertiesFiles != null && !propertiesFiles.equals("")) {
                    String[] propertiesFileNames;
                    for (String propertiesFileName : propertiesFileNames = propertiesFiles.split(",")) {
                        try (InputStream inputStreamPropFile = Regex.class.getResourceAsStream("/" + propertiesFileName);){
                            Log.debug(Regex.class, "Loading " + propertiesFileName);
                            props.load(inputStreamPropFile);
                        }
                    }
                }
                Log.trace(Regex.class, "===== REGEX PROPERTIES =====");
                for (String prop : props.stringPropertyNames()) {
                    while (props.getProperty(prop).startsWith(PROP_PREFIX)) {
                        Log.trace(Regex.class, "Replacing : " + prop + "=" + props.getProperty(prop) + " WITH " + props.getProperty(props.getProperty(prop)));
                        props.setProperty(prop, props.getProperty(props.getProperty(prop)));
                    }
                    Log.trace(Regex.class, prop + " = " + props.getProperty(prop));
                }
                Log.trace(Regex.class, "===== REGEX PROPERTIES =====");
            }
        }
    }

    private static String getRegexPattern(String version, String key) throws UnresolveablePatternException {
        try {
            Regex.loadProperties();
        }
        catch (Exception e) {
            Log.debug(Regex.class, "Caught exception: " + e.toString());
            throw new UnresolveablePatternException(PROP_PREFIX + version + "." + key, e);
        }
        String result = props.getProperty(PROP_PREFIX + version + "." + key);
        if (result == null || result.equals("")) {
            result = props.getProperty("com.pingidentity.pf.support.ucu.util.Regex.DEFAULT." + key);
        }
        if (result == null || result.equals("")) {
            result = "(?<" + key + ">[^|]*)?";
        }
        return result;
    }

    public static String getRegex(String version, String log4jPattern) throws UnresolveablePatternException {
        StringBuffer result = new StringBuffer("^");
        ArrayList<String> alreadyUsed = new ArrayList<String>();
        Pattern p = Pattern.compile("%(d|n|X|c|C|F|I|L|m|M|p|r|t|x)(?:\\\\\\{(\\p{Print}+?)\\})?");
        log4jPattern = Regex.stripLog4jEscapes(log4jPattern);
        log4jPattern = Regex.escapeSpecialChars(log4jPattern);
        Matcher m = p.matcher(log4jPattern);
        List<String> unsupportedPatternList = Arrays.asList("c", "C", "F", "I", "L", "m", "M", "p", "r", "t", "x");
        while (m.find()) {
            String conversionPattern = m.group(1);
            String params = m.group(2);
            if (conversionPattern.equals("d")) {
                if (params == null || params.equals("")) {
                    params = "yyyy-MM-dd HH:mm:ss,SSS";
                }
                m.appendReplacement(result, Matcher.quoteReplacement(Regex.getDateFormatRegex(params)));
                continue;
            }
            if (conversionPattern.equals("n")) {
                m.appendReplacement(result, Matcher.quoteReplacement("$"));
                continue;
            }
            if (conversionPattern.equals("X") && params != null && !params.equals("")) {
                String propVal = Regex.getRegexPattern(version, params);
                if (alreadyUsed.contains(propVal)) {
                    propVal = propVal.replaceAll("\\(\\?<.+?>", "(?:");
                } else {
                    alreadyUsed.add(propVal);
                }
                m.appendReplacement(result, Matcher.quoteReplacement(propVal));
                continue;
            }
            if (unsupportedPatternList.contains(conversionPattern)) {
                m.appendReplacement(result, Matcher.quoteReplacement("[^|]*"));
                continue;
            }
            Log.debug(Regex.class, conversionPattern + (params != null && !params.equals("") ? "{" + params + "}" : "") + " --> ERROR: Don't know what to do with this!");
        }
        m.appendTail(result);
        return result.toString();
    }

    private static String stripLog4jEscapes(String str) {
        Pattern p = Pattern.compile("%escape\\{.+?}\\{.+}");
        Matcher m = p.matcher(str);
        StringBuffer result = new StringBuffer();
        while (m.find()) {
            String match = m.group();
            Pattern p1 = Pattern.compile("%escape\\{.+?}\\{(.+)}");
            Matcher m1 = p1.matcher(match);
            if (m1.matches()) {
                m.appendReplacement(result, m1.group(1));
                continue;
            }
            Log.error(Regex.class, "Failure trying to strip log4j2 escape: " + match);
        }
        m.appendTail(result);
        return result.toString();
    }

    public static String getDateFormatRegex(String str) {
        String match;
        Pattern p = Pattern.compile("y+|w+|W+|D+|d+|F+|H+|k+|K+|h+|m+|s+|S+");
        Matcher m = p.matcher(str);
        StringBuffer result = new StringBuffer();
        while (m.find()) {
            match = m.group();
            m.appendReplacement(result, Matcher.quoteReplacement("\\d{" + match.length() + "}"));
        }
        m.appendTail(result);
        p = Pattern.compile("G+|M+|E+|a+");
        m = p.matcher(result.toString());
        result = new StringBuffer();
        while (m.find()) {
            match = m.group();
            if (match.startsWith("G")) {
                m.appendReplacement(result, Matcher.quoteReplacement("(?:AD|BC)"));
                continue;
            }
            if (match.startsWith("M")) {
                if (match.length() == 1) {
                    m.appendReplacement(result, Matcher.quoteReplacement("\\d{1,2}"));
                    continue;
                }
                if (match.length() == 2) {
                    m.appendReplacement(result, Matcher.quoteReplacement("\\d{2}"));
                    continue;
                }
                m.appendReplacement(result, Matcher.quoteReplacement("(?:January|February|March|April|May|June|July|August|September|October|November|December|Jan|Feb|Mar|Apr|Jun|Jul|Aug|Sep|Oct|Nov|Dec)"));
                continue;
            }
            if (match.startsWith("E")) {
                m.appendReplacement(result, Matcher.quoteReplacement("(?:Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|Sun|Mon|Tue|Wed|Thu|Fri|Sat)"));
                continue;
            }
            if (!match.startsWith("a")) continue;
            m.appendReplacement(result, Matcher.quoteReplacement("(?:AM|PM)"));
        }
        m.appendTail(result);
        p = Pattern.compile("z+|Z+");
        m = p.matcher(result.toString());
        result = new StringBuffer();
        while (m.find()) {
            match = m.group();
            if (match.startsWith("z")) {
                m.appendReplacement(result, Matcher.quoteReplacement("(?:[a-zA-Z ]+|GMT[+\\-]\\d{1,2}:\\d{2})"));
                continue;
            }
            if (!match.startsWith("Z")) continue;
            m.appendReplacement(result, Matcher.quoteReplacement("(?:[+\\-]\\d{4}"));
        }
        m.appendTail(result);
        return result.toString();
    }

    public static String escapeSpecialChars(String str) {
        Pattern p = Pattern.compile("\\|\\^|\\$|\\.|\\||\\?|\\*|\\+|\\(|\\)|\\[|\\{|\\\\");
        Matcher m = p.matcher(str);
        StringBuffer result = new StringBuffer();
        while (m.find()) {
            String match = m.group();
            m.appendReplacement(result, Matcher.quoteReplacement("\\" + match));
        }
        m.appendTail(result);
        return result.toString();
    }

    public static String maskRegex(String str) {
        return "%regex%" + DatatypeConverter.printBase64Binary(str.getBytes()) + "%regex%";
    }

    public static String unmaskRegex(String str) {
        StringBuffer result = new StringBuffer();
        Pattern p = Pattern.compile("%regex%(.+)%regex%");
        Matcher m = p.matcher(str);
        result = new StringBuffer();
        while (m.find()) {
            String match = m.group(1);
            m.appendReplacement(result, Matcher.quoteReplacement(new String(DatatypeConverter.parseBase64Binary(match))));
        }
        m.appendTail(result);
        return result.toString();
    }
}

