/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.support.ucu.util;

import com.pingidentity.pf.support.ucu.Log;
import com.pingidentity.pf.support.ucu.exception.UserCountException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ucu-shaded.com.pingidentity.pingcommons.upgrade.zip.UnzipUtil;

public class Version {
    private int major;
    private int minor;
    private int patch;

    public Version(String version) throws UserCountException {
        Pattern regex = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)");
        Matcher matcher = regex.matcher(version);
        if (!matcher.find()) {
            throw new UserCountException("Unexpected version format: " + version);
        }
        this.major = Integer.parseInt(matcher.group(1));
        this.minor = Integer.parseInt(matcher.group(2));
        this.patch = Integer.parseInt(matcher.group(3));
    }

    public Version(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public int compareTo(Version that) {
        int result = this.major - that.major;
        if (result != 0) {
            return result;
        }
        result = this.minor - that.minor;
        if (result != 0) {
            return result;
        }
        result = this.patch - that.patch;
        return result;
    }

    public String toString() {
        return Integer.toString(this.major) + "." + this.minor + "." + this.patch;
    }

    public String toLogString() {
        String build = Integer.toString(this.major) + "." + this.minor + "." + this.patch;
        if (this.patch < 200) {
            return build;
        }
        int rValue = this.patch / 100;
        return Integer.toString(this.major) + "." + this.minor + "-R" + rValue + " (" + build + ")";
    }

    public static int compare(String version1, String version2) throws UserCountException {
        Version v1 = new Version(version1);
        Version v2 = new Version(version2);
        return v1.compareTo(v2);
    }

    public static Version getPingFederateVersion(String pingfederatePath) throws UserCountException {
        Log.debug(Version.class, "Attempting to determin PF version in path " + pingfederatePath);
        Version version = null;
        File tempDir = null;
        FileInputStream pomPropertiesFIS = null;
        try {
            tempDir = Version.createTempDir();
            File pfStartupJar = new File(pingfederatePath, "bin" + File.separator + "pf-startup.jar");
            UnzipUtil.deployToFilesystem(tempDir.getPath(), pfStartupJar);
            File pomPropertiesFile = new File(tempDir, "META-INF" + File.separator + "maven" + File.separator + "pingfederate" + File.separator + "pf-startup" + File.separator + "pom.properties");
            pomPropertiesFIS = new FileInputStream(pomPropertiesFile);
            Properties pomProperties = new Properties();
            pomProperties.load(pomPropertiesFIS);
            String versionFromProp = pomProperties.getProperty("version");
            if (versionFromProp != null) {
                version = new Version(versionFromProp);
                Log.debug(Version.class, "Detected PF Version: " + version);
            }
        }
        catch (IOException ioe) {
            throw new UserCountException("Unable to retrieve PingFederate Version: " + pingfederatePath, ioe);
        }
        finally {
            if (tempDir != null && tempDir.exists()) {
                tempDir.delete();
            }
            if (pomPropertiesFIS != null) {
                try {
                    pomPropertiesFIS.close();
                }
                catch (IOException e) {
                    Log.error(Version.class, "Error while closing pom.properties FileInputStream:" + e);
                }
            }
        }
        return version;
    }

    private static File createTempDir() throws IOException {
        String dirName;
        File newTempDir;
        File sysTempDir = new File(System.getProperty("java.io.tmpdir"));
        int maxAttempts = 9;
        int attemptCount = 0;
        do {
            if (++attemptCount <= 9) continue;
            throw new IOException("The highly improbable has occurred! Failed to create a unique temporary directory after 9 attempts.");
        } while ((newTempDir = new File(sysTempDir, dirName = UUID.randomUUID().toString())).exists());
        if (newTempDir.mkdirs()) {
            return newTempDir;
        }
        throw new IOException("Failed to create temp dir named " + newTempDir.getAbsolutePath());
    }
}

