/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.anttask;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class CheckTargetAdapterName
extends Task {
    private String targetPropName;
    private String rootSrc;
    private String classpathref;

    public String getRootSrc() {
        return this.rootSrc;
    }

    public void setRootSrc(String rootSrc) {
        this.rootSrc = rootSrc;
    }

    public String getTargetPropName() {
        return this.targetPropName;
    }

    public void setTargetPropName(String targetPropName) {
        this.targetPropName = targetPropName;
    }

    public String getClasspathref() {
        return this.classpathref;
    }

    public void setClasspathref(String classpathref) {
        this.classpathref = classpathref;
    }

    public void execute() throws BuildException {
        Hashtable properties = this.getProject().getProperties();
        File srcDir = new File(this.rootSrc);
        String targetAdapterDirectoryName = (String)properties.get(this.targetPropName);
        if (StringUtils.isBlank((String)targetAdapterDirectoryName)) {
            throw new BuildException(this.getMsg(srcDir));
        }
        File targetAdapterDir = new File(this.rootSrc, targetAdapterDirectoryName);
        if (!targetAdapterDir.exists() || !targetAdapterDir.isDirectory()) {
            throw new BuildException("The value of '" + this.targetPropName + "' property does not point to a directory: " + targetAdapterDir.getAbsolutePath() + " is not a directory. " + this.getMsg(srcDir));
        }
    }

    private String getMsg(File srcDir) {
        ArrayList<String> targets = new ArrayList<String>();
        for (File file : srcDir.listFiles()) {
            File javaDir = new File(file, "java");
            if (!javaDir.exists() || !javaDir.isDirectory()) continue;
            targets.add(file.getName());
        }
        return "Please set the '" + this.targetPropName + "' property (in build.local.properties) to the name of the directory (under " + srcDir.getAbsolutePath() + ") of the adapter you want to build. All known valid values are " + targets + ".";
    }
}

