/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.opentoken.config;

import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;

public class PasswordValidator
implements ConfigurationValidator {
    private String passwordField;
    private String confirmPasswordField;
    private String obfuscatePasswordField;

    public PasswordValidator(String passwordField, String confirmPasswordField, String obfuscatePasswordField) {
        this.passwordField = passwordField;
        this.confirmPasswordField = confirmPasswordField;
        this.obfuscatePasswordField = obfuscatePasswordField;
    }

    public void validate(Configuration cfg) throws ValidationException {
        String password = cfg.getFieldValue(this.passwordField);
        String confirm = cfg.getFieldValue(this.confirmPasswordField);
        boolean obfuscatePassword = cfg.getBooleanFieldValue(this.obfuscatePasswordField);
        if (!password.equals(confirm)) {
            throw new ValidationException("Passwords do not match.");
        }
        if (obfuscatePassword && !this.validatePassword(password)) {
            throw new ValidationException("Password must be at least six characters, containing at least one uppercase, one lowercase, and one numeric character.");
        }
    }

    protected boolean validatePassword(String password) {
        if (password.length() < 6) {
            return false;
        }
        boolean isLowerCase = false;
        boolean isUpperCase = false;
        boolean isNumeric = false;
        for (int index = 0; index < password.length(); ++index) {
            if (password.charAt(index) >= 'a' && password.charAt(index) <= 'z') {
                isLowerCase = true;
            }
            if (password.charAt(index) >= 'A' && password.charAt(index) <= 'Z') {
                isUpperCase = true;
            }
            if (password.charAt(index) < '0' || password.charAt(index) > '9') continue;
            isNumeric = true;
        }
        return isLowerCase && isUpperCase && isNumeric;
    }
}

