/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.opentoken.utils;

import com.pingidentity.adapters.opentoken.shade.com.pingidentity.integrations.logger.LogEvent;
import com.pingidentity.adapters.opentoken.shade.com.pingidentity.integrations.logger.LogLevel;

public enum LoggerMessage implements LogEvent
{
    MESSAGE_TRANSPORT_MISMATCHED(LogLevel.DEBUG, "001", "The transport mode configured at the agent may be different from that at the adapter and/or ensure that the agent has the latest agent properties"),
    ERROR_DECODING_TOKEN(LogLevel.ERROR, "002", "Error decoding token"),
    MISSING_NOT_ON_OR_AFTER(LogLevel.ERROR, "003", "Cannot get 'not-on-or-after' value from OpenToken"),
    REPLAY_DETECTED(LogLevel.WARN, "004", "OpenToken replay is detected."),
    OPEN_TOKEN(LogLevel.DEBUG, "005", "Opentoken: %s"),
    REPLAY_PREVENTION_FAILURE(LogLevel.ERROR, "006", "Replay Prevention Service Failure"),
    LOGOUT_SERVICE_NOT_CONFIGURED(LogLevel.DEBUG, "007", "Logout functionality invoked, but no logout service is configured for this adapter. So redirecting to locally process the request."),
    GENERIC_ERROR(LogLevel.ERROR, "008", "%s");

    public static final String APP_MESSAGE_CODE = "OTKN";
    private final LogLevel level;
    public String code;
    public String message;

    private LoggerMessage(LogLevel level, String code, String message) {
        this.level = level;
        this.code = code;
        this.message = message;
    }

    @Override
    public LogLevel getLevel() {
        return this.level;
    }

    @Override
    public String getCode() {
        return "OTKN-" + this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

