/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.opentoken;

import com.pingidentity.opentoken.util.Base64;
import com.pingidentity.opentoken.util.KeyValueSerializer;
import com.pingidentity.opentoken.util.Obfuscator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;

public class AgentConfiguration {
    public static final boolean USE_VERBOSE_TOKEN_EXCEPTION_MESSAGES_DEFAULT = false;
    public static final boolean DETECT_MALFORMED_ATTRIBUTES_DEFAULT = false;
    public static final boolean REMOVE_TRAILING_BACKSLASH_DEFAULT = false;
    public static final int TOKEN_LIFETIME_DEFAULT = 300;
    public static final int RENEW_UNTIL_LIFETIME_DEFALUT = 43200;
    public static final int NOT_BEFORE_TOLERANCE_DEFAULT = 120;
    public static final boolean USE_SUN_JCE_DEFAULT = false;
    public static final boolean OBFUSCATE_PASSWORD_DEFAULT = true;
    public static final boolean SESSION_COOKIE_DEFAULT = false;
    public static final boolean SECURE_COOKIE_DEFAULT = true;
    public static final boolean USE_COOKIE_DEFAULT = false;
    public static final String COOKIE_SAMESITE_DEFAULT = "Nothing";
    public static final String COOKIE_PATH_DEFAULT = "/";
    public static final String COOKIE_DOMAIN_DEFAULT = "";
    public static final String TOKEN_NAME_DEFAULT = "opentoken";
    public static final boolean HTTP_ONLY_DEFAULT = true;
    public static final String AGENT_CONFIG_FILE_DEFALUT = "agent-config.txt";
    public static final boolean TRACK_AUTHNTIME_DEFAULT = true;
    public static final String ISO8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final TimeZone UTC_TZ = TimeZone.getTimeZone("UTC");
    private boolean useVerboseErrorMessages = false;
    private boolean removeTrailingBackslash = false;
    private boolean detectMalformedAttributes = false;
    private int tokenLifetime = 300;
    private int renewUntilLifetime = 43200;
    private int notBeforeTolerance = 120;
    private int cipherSuite = 0;
    private boolean useSunJCE = false;
    private boolean obfuscatePassword = true;
    private String sameSiteCookie = "Nothing";
    private boolean sessionCookie = false;
    private boolean secureCookie = true;
    private boolean useCookie = false;
    private String cookiePath = "/";
    private String cookieDomain = "";
    private byte[] password = null;
    private String tokenName = "opentoken";
    private boolean httpOnly = true;
    private boolean trackAuthnTime = true;

    public boolean isUseVerboseErrorMessages() {
        return this.useVerboseErrorMessages;
    }

    public void setUseVerboseErrorMessages(boolean useVerboseErrorMessages) {
        this.useVerboseErrorMessages = useVerboseErrorMessages;
    }

    public boolean isRemoveTrailingBackslash() {
        return this.removeTrailingBackslash;
    }

    public void setRemoveTrailingBackslash(boolean removeTrailingBackslash) {
        this.removeTrailingBackslash = removeTrailingBackslash;
    }

    public boolean isDetectMalformedAttributes() {
        return this.detectMalformedAttributes;
    }

    public void setDetectMalformedAttributes(boolean detectMalformedAttributes) {
        this.detectMalformedAttributes = detectMalformedAttributes;
    }

    public int getTokenLifetime() {
        return this.tokenLifetime;
    }

    public void setTokenLifetime(int tokenLifetime) {
        this.tokenLifetime = tokenLifetime;
    }

    public int getRenewUntilLifetime() {
        return this.renewUntilLifetime;
    }

    public void setRenewUntilLifetime(int renewUntilLifetime) {
        this.renewUntilLifetime = renewUntilLifetime;
    }

    public int getNotBeforeTolerance() {
        return this.notBeforeTolerance;
    }

    public void setNotBeforeTolerance(int notBeforeTolerance) {
        this.notBeforeTolerance = notBeforeTolerance;
    }

    public int getCipherSuite() {
        return this.cipherSuite;
    }

    public void setCipherSuite(int cipherSuite) {
        this.cipherSuite = cipherSuite;
    }

    public boolean isUseSunJCE() {
        return this.useSunJCE;
    }

    public void setUseSunJCE(boolean useSunJCE) {
        this.useSunJCE = useSunJCE;
    }

    public boolean isObfuscatePassword() {
        return this.obfuscatePassword;
    }

    public void setObfuscatePasword(boolean obfuscatePassword) {
        this.obfuscatePassword = obfuscatePassword;
    }

    public void setObfuscatePassword(boolean obfuscatePassword) {
        this.obfuscatePassword = obfuscatePassword;
    }

    public boolean hasSameSiteCookieAttr() {
        return !this.sameSiteCookie.equals(COOKIE_SAMESITE_DEFAULT);
    }

    public String getSameSiteCookieAttr() {
        return this.sameSiteCookie;
    }

    public void setSameSiteCookieAttr(String attribute) {
        this.sameSiteCookie = attribute;
    }

    public boolean isSessionCookie() {
        return this.sessionCookie;
    }

    public void setSessionCookie(boolean sessionCookie) {
        this.sessionCookie = sessionCookie;
    }

    public boolean isSecureCookie() {
        return this.secureCookie;
    }

    public void setSecureCookie(boolean secureCookie) {
        this.secureCookie = secureCookie;
    }

    public boolean isUseCookie() {
        return this.useCookie;
    }

    public void setUseCookie(boolean useCookie) {
        this.useCookie = useCookie;
    }

    public String getCookiePath() {
        return this.cookiePath;
    }

    public void setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
    }

    public String getCookieDomain() {
        return this.cookieDomain;
    }

    public void setCookieDomain(String cookieDomain) {
        this.cookieDomain = cookieDomain;
    }

    public String getPassword() {
        if (this.password != null && this.password.length > 0) {
            try {
                return new String(this.password, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return new String(this.password);
            }
        }
        return null;
    }

    public byte[] getPasswordBytes() {
        return this.password;
    }

    public void setPassword(String password) {
        if (password != null) {
            try {
                this.password = new byte[password.length()];
                System.arraycopy(password.getBytes("UTF-8"), 0, this.password, 0, password.length());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    public void setPassword(byte[] password) {
        if (password != null && password.length > 0) {
            this.password = new byte[password.length];
            System.arraycopy(password, 0, this.password, 0, password.length);
        }
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public void setTokenName(String tokenName) {
        this.tokenName = tokenName;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    public boolean isTrackAuthnTime() {
        return this.trackAuthnTime;
    }

    public void setTrackAuthnTime(boolean trackAuthnTime) {
        this.trackAuthnTime = trackAuthnTime;
    }

    public AgentConfiguration(InputStream configStream) throws IOException {
        try {
            this.loadConfiguration(configStream);
        }
        finally {
            if (configStream != null) {
                configStream.close();
            }
        }
    }

    public AgentConfiguration() {
        this(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentConfiguration(boolean loadDefaultConfigurationFile) {
        InputStream configStream = this.getClass().getClassLoader().getResourceAsStream(AGENT_CONFIG_FILE_DEFALUT);
        try {
            if (loadDefaultConfigurationFile && configStream != null) {
                this.loadConfiguration(configStream);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (configStream != null) {
                try {
                    configStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public AgentConfiguration(String file) throws IOException {
        try (InputStream configStream = this.getClass().getClassLoader().getResourceAsStream(file);){
            if (configStream != null) {
                this.loadConfiguration(configStream);
            } else {
                configStream = new ByteArrayInputStream(AgentConfiguration.getBytesFromFile(file));
                this.loadConfiguration(configStream);
            }
        }
    }

    public void storeConfiguration(OutputStream os) throws IOException {
        MultiValueMap config = new MultiValueMap();
        config.put((Object)"token-name", (Object)this.tokenName);
        config.put((Object)"token-lifetime", (Object)Integer.toString(this.tokenLifetime));
        config.put((Object)"token-renewuntil", (Object)Integer.toString(this.renewUntilLifetime));
        config.put((Object)"token-notbefore-tolerance", (Object)Integer.toString(this.notBeforeTolerance));
        config.put((Object)"use-cookie", (Object)Boolean.toString(this.useCookie));
        config.put((Object)"cookie-path", (Object)this.cookiePath);
        config.put((Object)"http-only", (Object)Boolean.toString(this.httpOnly));
        config.put((Object)"track-authntime", (Object)Boolean.toString(this.trackAuthnTime));
        if (this.useCookie) {
            config.put((Object)"cookie-samesite-attribute", (Object)this.sameSiteCookie);
            config.put((Object)"cookie-domain", (Object)this.cookieDomain);
            config.put((Object)"session-cookie", (Object)Boolean.toString(this.sessionCookie));
            config.put((Object)"secure-cookie", (Object)Boolean.toString(this.secureCookie));
        }
        config.put((Object)"use-sunjce", (Object)Boolean.toString(this.useSunJCE));
        config.put((Object)"use-verbose-error-messages", (Object)Boolean.toString(this.useVerboseErrorMessages));
        config.put((Object)"obfuscate-password", (Object)Boolean.toString(this.obfuscatePassword));
        if (this.password != null && this.password.length > 0) {
            config.put((Object)"cipher-suite", (Object)Integer.toString(this.cipherSuite));
            if (this.obfuscatePassword) {
                String obfuscatedPassword = COOKIE_DOMAIN_DEFAULT;
                try {
                    obfuscatedPassword = new Obfuscator(this.useSunJCE).obfuscate(this.password);
                }
                catch (Exception e) {
                    throw new IOException("Exception in obfuscating password");
                }
                config.put((Object)"password", (Object)obfuscatedPassword);
            } else {
                config.put((Object)"password", (Object)Base64.encodeBytes(this.password, 8));
            }
        }
        KeyValueSerializer.serialize((MultiMap)config, os);
    }

    public void loadConfiguration(InputStream is) throws IOException {
        MultiMap config = KeyValueSerializer.deserialize(is);
        String name = KeyValueSerializer.convertListToString((List)config.get((Object)"token-name"));
        if ((name = this.removeReturnChar(name)) == null || name.length() <= 0) {
            throw new IOException("Required configuration parameter 'token-name' is missing or empty.");
        }
        boolean useCookie = this.parseBoolean(config, "use-cookie");
        boolean sessionCookie = false;
        boolean secureCookie = true;
        boolean httpOnly = true;
        String samesite = COOKIE_SAMESITE_DEFAULT;
        String domain = COOKIE_DOMAIN_DEFAULT;
        String path = COOKIE_PATH_DEFAULT;
        if (useCookie) {
            if (config.get((Object)"cookie-samesite-attribute") != null) {
                samesite = KeyValueSerializer.convertListToString((List)config.get((Object)"cookie-samesite-attribute"));
                samesite = this.removeReturnChar(samesite);
            }
            if (config.get((Object)"cookie-domain") != null) {
                domain = KeyValueSerializer.convertListToString((List)config.get((Object)"cookie-domain"));
                domain = this.removeReturnChar(domain);
            }
            if (config.get((Object)"cookie-path") != null) {
                path = KeyValueSerializer.convertListToString((List)config.get((Object)"cookie-path"));
                path = this.removeReturnChar(path);
            }
            if (config.get((Object)"session-cookie") != null) {
                sessionCookie = this.parseBoolean(config, "session-cookie");
            }
            if (config.get((Object)"secure-cookie") != null) {
                secureCookie = this.parseBoolean(config, "secure-cookie");
            }
            if (config.get((Object)"http-only") != null) {
                httpOnly = this.parseBoolean(config, "http-only");
            }
        }
        boolean useVerboseErrorMessages = false;
        if (config.get((Object)"use-verbose-error-messages") != null) {
            useVerboseErrorMessages = this.parseBoolean(config, "use-verbose-error-messages");
        }
        int lifetime = this.parseInt(config, "token-lifetime");
        int renewLifetime = this.parseInt(config, "token-renewuntil");
        int notBeforeOffset = this.parseInt(config, "token-notbefore-tolerance");
        boolean useSunJCE = false;
        if (config.get((Object)"use-sunjce") != null) {
            useSunJCE = this.parseBoolean(config, "use-sunjce");
        }
        boolean obfuscatePassword = true;
        if (config.get((Object)"obfuscate-password") != null) {
            obfuscatePassword = this.parseBoolean(config, "obfuscate-password");
        }
        boolean trackAuthnTime = true;
        if (config.get((Object)"track-authntime") != null) {
            trackAuthnTime = this.parseBoolean(config, "track-authntime");
        }
        String password = KeyValueSerializer.convertListToString((List)config.get((Object)"password"));
        if ((password = this.removeReturnChar(password)) != null && password.length() > 0) {
            if (obfuscatePassword) {
                try {
                    this.password = new Obfuscator(useSunJCE).deobfuscate(password);
                }
                catch (Exception e) {
                    throw new IOException("Exception in de-obfuscating password");
                }
            }
            try {
                this.password = Base64.decode(password);
            }
            catch (Exception e) {
                throw new IOException("Required configuration parameter 'password' is not base-64 encoded.");
            }
            this.cipherSuite = this.parseInt(config, "cipher-suite");
            String debug = System.getProperty("opentoken.debug");
            if (debug != null && debug.equals("true")) {
                this.cipherSuite = 0;
            }
        }
        this.tokenName = name;
        this.tokenLifetime = lifetime;
        this.renewUntilLifetime = renewLifetime;
        this.notBeforeTolerance = notBeforeOffset;
        this.useCookie = useCookie;
        this.sameSiteCookie = samesite;
        this.cookieDomain = domain;
        this.cookiePath = path;
        this.sessionCookie = sessionCookie;
        this.secureCookie = secureCookie;
        this.httpOnly = httpOnly;
        this.useSunJCE = useSunJCE;
        this.useVerboseErrorMessages = useVerboseErrorMessages;
        this.obfuscatePassword = obfuscatePassword;
        this.trackAuthnTime = trackAuthnTime;
    }

    private String removeReturnChar(String input) {
        if (input != null) {
            return input.replaceAll("(\\r)", COOKIE_DOMAIN_DEFAULT);
        }
        return input;
    }

    private boolean parseBoolean(MultiMap m, String key) throws IOException {
        String value = KeyValueSerializer.convertListToString((List)m.get((Object)key));
        if (value == null || value.length() <= 0) {
            throw new IOException("Required configuration parameter '" + key + "' is missing or empty.");
        }
        value = this.removeReturnChar(value);
        return Boolean.valueOf(value);
    }

    private int parseInt(MultiMap m, String key) throws IOException {
        String value = KeyValueSerializer.convertListToString((List)m.get((Object)key));
        if (value == null || value.length() <= 0) {
            throw new IOException("Required configuration parameter '" + key + "' is missing or empty.");
        }
        try {
            value = this.removeReturnChar(value);
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IOException("Required configuration parameter '" + key + "' is not a valid integer.");
        }
    }

    public AgentConfiguration copy() {
        try {
            AgentConfiguration clone = (AgentConfiguration)BeanUtils.cloneBean((Object)this);
            clone.setPassword(this.getPasswordBytes());
            clone.setObfuscatePassword(this.isObfuscatePassword());
            return clone;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getBytesFromFile(String FilePath) throws IOException {
        File file = new File(FilePath);
        try (FileInputStream is = new FileInputStream(file);){
            int offset;
            long length = file.length();
            if (length > Integer.MAX_VALUE) {
                // empty if block
            }
            byte[] bytes = new byte[(int)length];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
            byte[] byArray = bytes;
            return byArray;
        }
    }
}

