/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.opentoken;

import com.pingidentity.opentoken.TokenException;
import com.pingidentity.opentoken.key.KeyManager;
import com.pingidentity.opentoken.mac.MACInputStream;
import com.pingidentity.opentoken.mac.MACOutputStream;
import com.pingidentity.opentoken.util.Base64;
import com.pingidentity.opentoken.util.KeyValueSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.NullCipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.collections.MultiMap;

public class Token {
    public static final int CIPHER_SUITE_NULL = 0;
    public static final int CIPHER_SUITE_AES256CBC = 1;
    public static final int CIPHER_SUITE_AES128CBC = 2;
    public static final int CIPHER_SUITE_3DES168CBC = 3;
    public static final String SUN_CRYPTO_PROVIDER = "SunJCE";
    private static final byte[] V1_HEADER = new byte[]{79, 84, 75, 1};
    private static final byte[] EMPTY_PAYLOAD_LEN = new byte[]{0, 0};
    static final byte[] V1_MAC = new byte[20];
    static final int V1_MAC_POS = 5;
    static final int V1_CS_POS = 4;
    static final int V1_IVLEN_POS = 25;
    static final int V1_IV_POS = 26;

    private Token() {
    }

    public static String encode(MultiMap values, KeyManager keyman, boolean useSunJCE) throws TokenException {
        return Token.encode(values, keyman, useSunJCE, false, false);
    }

    public static String encode(MultiMap values, KeyManager keyman, boolean useSunJCE, boolean useVerboseErrorMessages, boolean removeTrailingBackslashes) throws TokenException {
        KeyManager.KeyInfo keyinfo = keyman.getEncryptKey();
        if (!Token.validateKey(keyinfo.cipherSuite, keyinfo.key)) {
            throw new TokenException("Wrong type of key provided for this cipher suite.");
        }
        if (keyinfo.metadata != null && keyinfo.metadata.length > 255) {
            throw new TokenException("Key metadata is longer than 255 bytes.");
        }
        Cipher cipher = Token.setupCipher(keyinfo.cipherSuite, keyinfo.key, 1, null, useSunJCE);
        byte[] iv = cipher.getIV();
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            os.write(V1_HEADER);
            os.write(keyinfo.cipherSuite);
            os.write(V1_MAC);
            int payloadOffset = 26;
            if (keyinfo.cipherSuite != 0 && iv != null && iv.length > 0) {
                os.write((byte)iv.length);
                os.write(iv);
                payloadOffset += iv.length;
            } else {
                os.write(0);
            }
            if (keyinfo.metadata != null && keyinfo.metadata.length > 0) {
                os.write((byte)keyinfo.metadata.length);
                os.write(keyinfo.metadata);
                payloadOffset += 1 + keyinfo.metadata.length;
            } else {
                os.write(0);
                ++payloadOffset;
            }
            os.write(EMPTY_PAYLOAD_LEN);
            payloadOffset += 2;
            boolean useCompression = true;
            String debug = System.getProperty("opentoken.debug");
            if (debug != null && debug.equals("true")) {
                useCompression = false;
            }
            MACOutputStream mos = useCompression ? new MACOutputStream(new DeflaterOutputStream(new CipherOutputStream(os, cipher)), keyinfo.key, useSunJCE) : new MACOutputStream(new DeflaterOutputStream((OutputStream)new CipherOutputStream(os, cipher), new Deflater(0)), keyinfo.key, useSunJCE);
            mos.getMAC().update((byte)1);
            mos.getMAC().update((byte)keyinfo.cipherSuite);
            if (keyinfo.cipherSuite != 0 && iv != null && iv.length > 0) {
                mos.getMAC().update(iv);
            }
            if (keyinfo.metadata != null && keyinfo.metadata.length > 0) {
                mos.getMAC().update(keyinfo.metadata);
            }
            KeyValueSerializer.serialize(values, mos, removeTrailingBackslashes);
            mos.close();
            byte[] rawToken = os.toByteArray();
            byte[] payloadLen = Token.shortToNetwork(rawToken.length - payloadOffset);
            if (payloadLen == null) {
                throw new TokenException("Encoding failed; payload length exceeds 65k.");
            }
            byte[] finalMac = mos.getMAC().doFinal();
            System.arraycopy(finalMac, 0, rawToken, 5, finalMac.length);
            System.arraycopy(payloadLen, 0, rawToken, payloadOffset - 2, payloadLen.length);
            return Token.b64encode(rawToken);
        }
        catch (IOException e) {
            throw new TokenException("Stream error occurred while encoding the token", e);
        }
    }

    public static MultiMap decode(String token, KeyManager keyman, boolean useSunJCE) throws TokenException {
        return Token.decode(token, keyman, useSunJCE, false);
    }

    public static MultiMap decode(String token, KeyManager keyman, boolean useSunJCE, boolean useVerboseErrorMessages) throws TokenException {
        MultiMap result = null;
        try {
            byte[] rawdata = Token.b64decode(token);
            if (rawdata == null) {
                throw new TokenException("Base64 decoding of token failed.");
            }
            for (int i = 0; i < V1_HEADER.length; ++i) {
                if (rawdata[i] == V1_HEADER[i]) continue;
                throw new TokenException("Invalid token header.");
            }
            byte cipherSuite = rawdata[4];
            if (cipherSuite < 0 || cipherSuite > 3) {
                throw new TokenException("Unknown cipher suite used in token.");
            }
            byte[] datamac = new byte[V1_MAC.length];
            System.arraycopy(rawdata, 5, datamac, 0, V1_MAC.length);
            byte ivlen = rawdata[25];
            if (!Token.validateIV(ivlen, cipherSuite)) {
                throw new TokenException("Decode failed; IV length does not work with selected cipher suite.");
            }
            IvParameterSpec ivSpec = null;
            if (ivlen > 0) {
                ivSpec = new IvParameterSpec(rawdata, 26, ivlen);
            }
            int keymetadataLenOffset = 26 + ivlen;
            byte keymetadataLen = rawdata[keymetadataLenOffset];
            byte[] keymetadata = null;
            if (keymetadataLen > 0) {
                throw new TokenException("Decode failed; keyinfo metadata value not supported.");
            }
            KeyManager.KeyInfo keyinfo = keyman.getDecryptKey(keymetadata);
            if (cipherSuite != keyinfo.cipherSuite) {
                throw new TokenException("Decode failed; cipher suite in token does not match cipher suite used by key manager.");
            }
            if (!Token.validateKey(cipherSuite, keyinfo.key)) {
                throw new TokenException("Decode failed; cipher suite in token does not work with provided key.");
            }
            Cipher cipher = Token.setupCipher(cipherSuite, keyinfo.key, 2, ivSpec, useSunJCE);
            int payloadLenOffset = keymetadataLenOffset + keymetadataLen + 1;
            int payloadLen = Token.networkToShort(rawdata, payloadLenOffset);
            int payloadOffset = payloadLenOffset + 2;
            ByteArrayInputStream bis = new ByteArrayInputStream(rawdata, payloadOffset, payloadLen);
            MACInputStream is = new MACInputStream(new InflaterInputStream(new CipherInputStream(bis, cipher)), keyinfo.key, useSunJCE);
            is.getMAC().update((byte)1);
            is.getMAC().update(cipherSuite);
            if (cipherSuite != 0 && ivSpec != null) {
                is.getMAC().update(ivSpec.getIV());
            }
            try {
                result = KeyValueSerializer.deserialize(is);
            }
            catch (IOException e) {
                throw new TokenException("Stream error occurred while decoding the token", e);
            }
            if (!Arrays.equals(datamac, is.getMAC().doFinal())) {
                throw new TokenException("MAC verification failed.");
            }
        }
        catch (Exception e) {
            if (useVerboseErrorMessages) {
                throw new TokenException(e.getMessage(), e);
            }
            throw new TokenException("Error");
        }
        return result;
    }

    private static Cipher setupCipher(int cipherSuite, SecretKey key, int opmode, AlgorithmParameterSpec params, boolean useSunJCE) {
        try {
            Cipher result = null;
            switch (cipherSuite) {
                case 0: {
                    result = new NullCipher();
                    break;
                }
                case 1: 
                case 2: {
                    result = useSunJCE ? Cipher.getInstance("AES/CBC/PKCS5Padding", SUN_CRYPTO_PROVIDER) : Cipher.getInstance("AES/CBC/PKCS5Padding");
                    result.init(opmode, (Key)key, params);
                    break;
                }
                case 3: {
                    result = useSunJCE ? Cipher.getInstance("DESede/CBC/PKCS5Padding", SUN_CRYPTO_PROVIDER) : Cipher.getInstance("DESede/CBC/PKCS5Padding");
                    result.init(opmode, (Key)key, params);
                }
            }
            return result;
        }
        catch (InvalidKeyException e) {
            if (cipherSuite == 1) {
                throw new RuntimeException("The unlimited strength JCE may not be installed to allow cipher suite AES-256/CBC", e);
            }
            throw new RuntimeException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean validateIV(int ivlen, int cipherSuite) {
        switch (cipherSuite) {
            case 0: {
                return ivlen == 0;
            }
            case 1: 
            case 2: {
                return ivlen == 16;
            }
            case 3: {
                return ivlen == 8;
            }
        }
        return false;
    }

    private static boolean validateKey(int cipherSuite, SecretKey key) {
        switch (cipherSuite) {
            case 0: {
                return key == null;
            }
            case 1: {
                return key != null && "AES".equals(key.getAlgorithm()) && key.getEncoded().length == 32;
            }
            case 2: {
                return key != null && "AES".equals(key.getAlgorithm()) && key.getEncoded().length == 16;
            }
            case 3: {
                return key != null && "DESede".equals(key.getAlgorithm()) && key.getEncoded().length == 24;
            }
        }
        return false;
    }

    static String b64encode(byte[] data) {
        String b64 = Base64.encodeBytes(data, 24);
        char[] c = b64.toCharArray();
        for (int i = c.length - 1; i >= 0 && c[i] == '='; --i) {
            c[i] = 42;
        }
        return new String(c);
    }

    static byte[] b64decode(String data) {
        char[] c = data.toCharArray();
        for (int i = c.length - 1; i >= 0 && c[i] == '*'; --i) {
            c[i] = 61;
        }
        return Base64.decode(new String(c), 24);
    }

    static byte[] shortToNetwork(int value) {
        if (value > 65536) {
            return null;
        }
        return new byte[]{(byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
    }

    static int networkToShort(byte[] value, int offset) {
        int result = 0;
        result += (value[offset] & 0xFF) << 8;
        return result += value[offset + 1] & 0xFF;
    }
}

