/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.opentoken.generic.util;

import com.pingidentity.opentoken.generic.AgentConfiguration;
import com.pingidentity.opentoken.generic.util.KeyValueSerializer;
import com.pingidentity.opentoken.generic.util.PingFederateMultiMap;
import com.pingidentity.opentoken.util.Base64;
import com.pingidentity.opentoken.util.Obfuscator;
import java.io.IOException;

public class AgentConfigurationUtil {
    public static final String TOKEN_NAME = "token-name";
    public static final String TOKEN_RENEW_LIFETIME_NAME = "token-renewuntil";
    public static final String TOKEN_OFFSET_NAME = "token-notbefore-tolerance";
    public static final String USE_COOKIE_NAME = "use-cookie";
    public static final String COOKIE_SAMESITE_NAME = "cookie-samesite-attribute";
    public static final String COOKIE_DOMAIN_NAME = "cookie-domain";
    public static final String COOKIE_PATH_NAME = "cookie-path";
    public static final String SESSION_COOKIE_NAME = "session-cookie";
    public static final String SECURE_COOKIE_NAME = "secure-cookie";
    public static final String HTTP_ONLY_NAME = "http-only";
    public static final String USE_VERBOSE_ERROR_MESSAGES_NAME = "use-verbose-error-messages";
    public static final String TOKEN_LIFETIME_NAME = "token-lifetime";
    public static final String USE_SUNJCE_NAME = "use-sunjce";
    public static final String OBFUSCATE_PASSWORD_NAME = "obfuscate-password";
    public static final String TRACK_AUTHNTIME_NAME = "track-authntime";
    public static final String PASSWORD_NAME = "password";
    public static final String CIPHER_SUITE_NAME = "cipher-suite";

    public static AgentConfiguration createWithNativeMultiMap(PingFederateMultiMap map) throws IOException {
        String name = AgentConfigurationUtil.parse(map, TOKEN_NAME);
        int lifetime = AgentConfigurationUtil.parseInt(map, TOKEN_LIFETIME_NAME);
        int renewLifetime = AgentConfigurationUtil.parseInt(map, TOKEN_RENEW_LIFETIME_NAME);
        int notBeforeOffset = AgentConfigurationUtil.parseInt(map, TOKEN_OFFSET_NAME);
        boolean useCookie = AgentConfigurationUtil.parseBoolean(map, USE_COOKIE_NAME);
        boolean sessionCookie = false;
        boolean secureCookie = true;
        boolean httpOnly = true;
        String samesite = "Nothing";
        String domain = "";
        String path = "/";
        if (useCookie) {
            samesite = map.get(COOKIE_SAMESITE_NAME).isEmpty() ? samesite : AgentConfigurationUtil.parse(map, COOKIE_SAMESITE_NAME);
            domain = map.get(COOKIE_DOMAIN_NAME).isEmpty() ? domain : AgentConfigurationUtil.parse(map, COOKIE_DOMAIN_NAME);
            path = map.get(COOKIE_PATH_NAME).isEmpty() ? path : AgentConfigurationUtil.parse(map, COOKIE_PATH_NAME);
            sessionCookie = map.get(SESSION_COOKIE_NAME).isEmpty() ? sessionCookie : AgentConfigurationUtil.parseBoolean(map, SESSION_COOKIE_NAME);
            secureCookie = map.get(SECURE_COOKIE_NAME).isEmpty() ? secureCookie : AgentConfigurationUtil.parseBoolean(map, SECURE_COOKIE_NAME);
            httpOnly = map.get(HTTP_ONLY_NAME).isEmpty() ? httpOnly : AgentConfigurationUtil.parseBoolean(map, HTTP_ONLY_NAME);
        }
        boolean useVerboseErrorMessages = map.get(USE_VERBOSE_ERROR_MESSAGES_NAME).isEmpty() ? false : AgentConfigurationUtil.parseBoolean(map, USE_VERBOSE_ERROR_MESSAGES_NAME);
        boolean useSunJCE = map.get(USE_SUNJCE_NAME).isEmpty() ? false : AgentConfigurationUtil.parseBoolean(map, USE_SUNJCE_NAME);
        boolean obfuscatePassword = map.get(OBFUSCATE_PASSWORD_NAME).isEmpty() ? true : AgentConfigurationUtil.parseBoolean(map, OBFUSCATE_PASSWORD_NAME);
        boolean trackAuthnTime = map.get(TRACK_AUTHNTIME_NAME).isEmpty() ? true : AgentConfigurationUtil.parseBoolean(map, TRACK_AUTHNTIME_NAME);
        String password = KeyValueSerializer.convertListToString(map.get(PASSWORD_NAME));
        password = AgentConfigurationUtil.removeReturnChar(password);
        byte[] passwordBytes = null;
        int cipherSuite = 0;
        if (null != password && !password.isEmpty()) {
            passwordBytes = AgentConfigurationUtil.getDecodedPasswordBytes(password, obfuscatePassword, useSunJCE);
            cipherSuite = AgentConfigurationUtil.parseInt(map, CIPHER_SUITE_NAME);
            String debug = System.getProperty("opentoken.debug");
            if (debug != null && debug.equals(Boolean.TRUE.toString())) {
                cipherSuite = 0;
            }
        }
        AgentConfiguration configuration = new AgentConfiguration();
        configuration.setTokenName(name);
        configuration.setTokenLifetime(lifetime);
        configuration.setRenewUntilLifetime(renewLifetime);
        configuration.setNotBeforeTolerance(notBeforeOffset);
        configuration.setUseCookie(useCookie);
        configuration.setSameSiteCookieAttr(samesite);
        configuration.setCookieDomain(domain);
        configuration.setCookiePath(path);
        configuration.setSessionCookie(sessionCookie);
        configuration.setSecureCookie(secureCookie);
        configuration.setHttpOnly(httpOnly);
        configuration.setUseSunJCE(useSunJCE);
        configuration.setUseVerboseErrorMessages(useVerboseErrorMessages);
        configuration.setObfuscatePassword(obfuscatePassword);
        configuration.setTrackAuthnTime(trackAuthnTime);
        configuration.setPassword(passwordBytes);
        configuration.setCipherSuite(cipherSuite);
        return configuration;
    }

    public static boolean parseBoolean(PingFederateMultiMap m, String key) throws IOException {
        String value = AgentConfigurationUtil.parse(m, key);
        return Boolean.valueOf(value);
    }

    public static int parseInt(PingFederateMultiMap m, String key) throws IOException {
        String value = AgentConfigurationUtil.parse(m, key);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IOException("Required configuration parameter '" + key + "' is not a valid integer.");
        }
    }

    private static String parse(PingFederateMultiMap map, String key) throws IOException {
        String value = KeyValueSerializer.convertListToString(map.get(key));
        if (null == value || value.isEmpty()) {
            throw new IOException("Required configuration parameter '" + key + "' is missing or empty.");
        }
        return AgentConfigurationUtil.removeReturnChar(value);
    }

    private static String removeReturnChar(String input) {
        if (input != null) {
            input.replaceAll("(\\r)", "");
        }
        return input;
    }

    private static byte[] getDecodedPasswordBytes(String password, boolean obfuscatePassword, boolean useSunJCE) throws IOException {
        if (obfuscatePassword) {
            try {
                return new Obfuscator(useSunJCE).deobfuscate(password);
            }
            catch (Exception e) {
                throw new IOException("Exception in de-obfuscating password");
            }
        }
        try {
            return Base64.decode(password);
        }
        catch (Exception e) {
            throw new IOException("Required configuration parameter 'password' is not base-64 encoded.");
        }
    }
}

