/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.opentoken.generic.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class PingFederateMultiMap<K, V> {
    private final Map<K, List<V>> multimap = new HashMap<K, List<V>>();

    public void put(K key, V value) {
        this.multimap.computeIfAbsent(key, k -> new ArrayList()).add(value);
    }

    public List<V> get(K key) {
        return this.multimap.getOrDefault(key, Collections.emptyList());
    }

    public Collection<V> remove(K key) {
        return this.multimap.remove(key);
    }

    public void remove(K key, V value) {
        this.multimap.computeIfPresent(key, (k, list) -> list.remove(value) && list.isEmpty() ? null : list);
    }

    public boolean contains(K key, V value) {
        return this.multimap.getOrDefault(key, Collections.emptyList()).contains(value);
    }

    public boolean containsKey(K key) {
        return null != this.multimap.get(key);
    }

    public int size() {
        return this.multimap.size();
    }

    public Set<K> keySet() {
        return this.multimap.keySet();
    }

    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.multimap.entrySet();
    }

    public List<V> values() {
        return this.multimap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public void clear() {
        this.multimap.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PingFederateMultiMap that = (PingFederateMultiMap)o;
        return Objects.equals(this.multimap, that.multimap);
    }

    public int hashCode() {
        return Objects.hash(this.multimap);
    }
}

