/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.opentoken.key;

import com.pingidentity.opentoken.key.KeyManager;
import com.pingidentity.opentoken.util.PasswordKeyGenerator;
import javax.crypto.SecretKey;

public class PasswordKeyManager
implements KeyManager {
    private volatile KeyManager.KeyInfo keyinfo = new KeyManager.KeyInfo();

    public PasswordKeyManager(SecretKey key, int cipherSuite) {
        this.keyinfo.key = key;
        this.keyinfo.cipherSuite = cipherSuite;
    }

    public PasswordKeyManager(String password, int cipherSuite, boolean useSunJCE) {
        this.keyinfo.key = PasswordKeyGenerator.generate(password, cipherSuite, useSunJCE);
        this.keyinfo.cipherSuite = cipherSuite;
    }

    public PasswordKeyManager(byte[] password, int cipherSuite, boolean useSunJCE) {
        this.keyinfo.key = PasswordKeyGenerator.generate(password, cipherSuite, useSunJCE);
        this.keyinfo.cipherSuite = cipherSuite;
    }

    @Override
    public KeyManager.KeyInfo getDecryptKey(byte[] metadata) {
        return this.keyinfo;
    }

    @Override
    public KeyManager.KeyInfo getEncryptKey() {
        return this.keyinfo;
    }

    public int getCipherSuite() {
        return this.keyinfo.cipherSuite;
    }
}

