/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.opentoken.mac;

import com.pingidentity.opentoken.mac.HmacSHA1Wrapper;
import com.pingidentity.opentoken.mac.MACWrapper;
import com.pingidentity.opentoken.mac.NormalSHA1Wrapper;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.SecretKey;

public class MACOutputStream
extends FilterOutputStream {
    private MACWrapper mac;

    public MACOutputStream(OutputStream out, SecretKey key, boolean useSunJCE) {
        super(out);
        this.mac = key != null ? new HmacSHA1Wrapper(key, useSunJCE) : new NormalSHA1Wrapper(useSunJCE);
    }

    public MACWrapper getMAC() {
        return this.mac;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.mac.update(b, off, len);
        this.out.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.mac.update((byte)b);
        this.out.write(b);
    }
}

