/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.opentoken.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;

public class KeyValueSerializer {
    private static final String UTF8 = "UTF-8";
    private static final Pattern trailingBackslashPattern = Pattern.compile("(.*?)(\\\\*)(['\"])$", 32);
    private static int LINE_START = 0;
    private static int EMPTY_SPACE = 1;
    private static int VALUE_START = 2;
    private static int LINE_END = 3;
    private static int IN_KEY = 4;
    private static int IN_VALUE = 5;
    private static int IN_QUOTED_VALUE = 6;

    private static void serialize(MultiMap values, Writer writer, boolean removeTrailingBackslashes) throws IOException {
        KeyValueSerializer.serializeMap(values.entrySet(), writer, removeTrailingBackslashes);
    }

    static String removeTrailingBackslash(String attrValue) {
        Matcher matcher = trailingBackslashPattern.matcher(attrValue);
        if (matcher.matches()) {
            return matcher.replaceAll("$1$3");
        }
        return attrValue;
    }

    public static void serialize(MultiMap values, OutputStream os) throws IOException {
        KeyValueSerializer.serialize(values, new OutputStreamWriter(os, UTF8), false);
    }

    public static void serialize(MultiMap values, OutputStream os, boolean removeTrailingBackslashes) throws IOException {
        KeyValueSerializer.serialize(values, new OutputStreamWriter(os, UTF8), removeTrailingBackslashes);
    }

    private static void serializeMap(Set<Map.Entry<String, List<List<String>>>> entries, Writer writer, boolean removeTrailingBackslashes) throws IOException {
        Iterator<Map.Entry<String, List<List<String>>>> it = entries.iterator();
        while (true) {
            Map.Entry<String, List<List<String>>> e = it.next();
            String key = e.getKey().toString().trim();
            List<List<String>> value = e.getValue();
            if (key.indexOf(61) > -1) {
                throw new IOException("Invalid key: " + key);
            }
            Iterator<List<String>> itValue = value.iterator();
            while (true) {
                writer.write(key);
                writer.write(61);
                String attrValue = KeyValueSerializer.escapeValue((String)((Object)itValue.next()));
                if (removeTrailingBackslashes) {
                    attrValue = KeyValueSerializer.removeTrailingBackslash(attrValue);
                }
                writer.write(attrValue);
                if (!itValue.hasNext()) break;
                writer.write(10);
            }
            if (!it.hasNext()) break;
            writer.write(10);
        }
        writer.close();
    }

    public static String serialize(MultiMap values) throws IOException {
        StringWriter writer = new StringWriter();
        KeyValueSerializer.serialize(values, writer, false);
        return writer.toString();
    }

    public static String serialize(MultiMap values, boolean removeTrailingBackslashes) throws IOException {
        StringWriter writer = new StringWriter();
        KeyValueSerializer.serialize(values, writer, removeTrailingBackslashes);
        return writer.toString();
    }

    public static String escapeValue(String value) {
        boolean needsQuotes = false;
        int singleQuoteCount = 0;
        int doubleQuoteCount = 0;
        int backSlashCount = 0;
        if (value == null) {
            return "";
        }
        block6: for (int i = 0; i < value.length(); ++i) {
            switch (value.charAt(i)) {
                case '\t': 
                case '\n': 
                case ' ': {
                    needsQuotes = true;
                    continue block6;
                }
                case '\"': {
                    ++doubleQuoteCount;
                    continue block6;
                }
                case '\'': {
                    ++singleQuoteCount;
                    continue block6;
                }
                case '\\': {
                    ++backSlashCount;
                }
            }
        }
        String result = value;
        if (needsQuotes || singleQuoteCount > 0 || doubleQuoteCount > 0 || backSlashCount > 0) {
            result = "'" + value.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\"").replaceAll("'", "\\\\'") + "'";
        }
        return result;
    }

    public static String unescapeValue(String value) {
        return value.replaceAll("\\\\\"", "\"").replaceAll("\\\\'", "'").replaceAll("\\\\\\\\", "\\\\");
    }

    public static MultiMap deserialize(String s) throws IOException {
        return KeyValueSerializer.deserialize(new StringReader(s));
    }

    public static MultiMap deserialize(InputStream s) throws IOException {
        return KeyValueSerializer.deserialize(new InputStreamReader(s, UTF8));
    }

    public static MultiMap deserialize(Reader r) throws IOException {
        int nextVal;
        MultiValueMap values = new MultiValueMap();
        int state = LINE_START;
        char openQuoteChar = '\u0000';
        StringBuffer token = new StringBuffer();
        String currkey = null;
        BufferedReader bufferedIn = new BufferedReader(r);
        block6: while ((nextVal = bufferedIn.read()) != -1) {
            char c = (char)nextVal;
            switch (c) {
                case '\t': 
                case ' ': {
                    bufferedIn.mark(1);
                    nextVal = bufferedIn.read();
                    if (nextVal == -1) {
                        if (state != IN_KEY) continue block6;
                        token.append(c);
                        continue block6;
                    }
                    bufferedIn.reset();
                    char nextChar = (char)nextVal;
                    if (state == IN_KEY) {
                        if (nextChar == '=') {
                            currkey = token.toString();
                            token.setLength(0);
                            state = EMPTY_SPACE;
                            continue block6;
                        }
                        token.append(c);
                        continue block6;
                    }
                    if (state == IN_VALUE) {
                        if (nextChar != '\n') {
                            token.append(c);
                            continue block6;
                        }
                        values.put((Object)currkey, (Object)KeyValueSerializer.unescapeValue(token.toString()));
                        token.setLength(0);
                        state = LINE_END;
                        continue block6;
                    }
                    if (state != IN_QUOTED_VALUE) continue block6;
                    token.append(c);
                    continue block6;
                }
                case '\n': {
                    if (state == IN_VALUE || state == VALUE_START) {
                        values.put((Object)currkey, (Object)KeyValueSerializer.unescapeValue(token.toString()));
                        token.setLength(0);
                        state = LINE_START;
                        continue block6;
                    }
                    if (state == LINE_END) {
                        token.setLength(0);
                        state = LINE_START;
                        continue block6;
                    }
                    if (state != IN_QUOTED_VALUE) continue block6;
                    token.append(c);
                    continue block6;
                }
                case '=': {
                    if (state == IN_KEY) {
                        currkey = token.toString();
                        token.setLength(0);
                        state = VALUE_START;
                        continue block6;
                    }
                    if (state == EMPTY_SPACE) {
                        token.setLength(0);
                        state = VALUE_START;
                        continue block6;
                    }
                    if (state != IN_QUOTED_VALUE && state != IN_VALUE) continue block6;
                    token.append(c);
                    continue block6;
                }
                case '\"': 
                case '\'': {
                    if (state == IN_QUOTED_VALUE) {
                        if (c == openQuoteChar && !KeyValueSerializer.isEscaped(token)) {
                            values.put((Object)currkey, (Object)KeyValueSerializer.unescapeValue(token.toString()));
                            token.setLength(0);
                            state = LINE_END;
                            continue block6;
                        }
                        token.append(c);
                        continue block6;
                    }
                    if (state != VALUE_START) continue block6;
                    state = IN_QUOTED_VALUE;
                    openQuoteChar = c;
                    continue block6;
                }
            }
            if (state == LINE_START) {
                state = IN_KEY;
            } else if (state == VALUE_START) {
                state = IN_VALUE;
            }
            token.append(c);
        }
        if (state == IN_QUOTED_VALUE || state == IN_VALUE) {
            values.put(currkey, (Object)KeyValueSerializer.unescapeValue(token.toString()));
        }
        return values;
    }

    static boolean isEscaped(StringBuffer token) {
        int backslashCount = 0;
        for (int i = token.length() - 1; i >= 0 && token.charAt(i) == '\\'; --i) {
            ++backslashCount;
        }
        return backslashCount & true;
    }

    public static String convertListToString(List values) {
        return (String)values.get(0);
    }
}

