/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.opentoken.util;

import com.pingidentity.opentoken.util.Base64;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Obfuscator {
    private static final String ALGORITHM_NAME = "DESede";
    private static final String TRANSFORMATION = "DESede/CBC/PKCS5Padding";
    private SecretKeySpec specKey;
    private static final String ENCODED_KEY = "WstlCliPDqxMj1oO47qlCmPlIHm4x6yT";
    private static final String ENCODED_IV = "F1jDNRsVlhU=";
    private IvParameterSpec ivSpec;
    private boolean useSunJCE;
    public static final String SUN_CRYPTO_PROVIDER = "SunJCE";

    public Obfuscator(boolean useSunJCE) throws Exception {
        byte[] key = Base64.decode(ENCODED_KEY);
        this.specKey = new SecretKeySpec(key, ALGORITHM_NAME);
        byte[] iv = Base64.decode(ENCODED_IV);
        this.ivSpec = new IvParameterSpec(iv);
        this.useSunJCE = useSunJCE;
    }

    public String obfuscate(byte[] password) throws Exception {
        byte[] encryptedBytes = null;
        try {
            Cipher cipher = this.useSunJCE ? Cipher.getInstance(TRANSFORMATION, SUN_CRYPTO_PROVIDER) : Cipher.getInstance(TRANSFORMATION);
            cipher.init(1, (Key)this.specKey, this.ivSpec);
            encryptedBytes = cipher.doFinal(password);
        }
        catch (NoSuchAlgorithmException e) {
            String eMessage = "obfuscate: Specified algorithm cannot be found";
            throw new Exception(eMessage, e);
        }
        catch (IllegalBlockSizeException e) {
            String eMessage = "obfuscate: Illegal block size";
            throw new Exception(eMessage, e);
        }
        catch (BadPaddingException e) {
            String eMessage = "obfuscate: Bad padding";
            throw new Exception(eMessage, e);
        }
        catch (NoSuchPaddingException e) {
            String eMessage = "obfuscate: Wrong padding";
            throw new Exception(eMessage, e);
        }
        catch (NoSuchProviderException e) {
            String eMessage = "obfuscate: Specified provider cannot be found";
            throw new Exception(eMessage, e);
        }
        catch (InvalidAlgorithmParameterException e) {
            String eMessage = "obfuscate: Invalid algorithm parameter";
            throw new Exception(eMessage, e);
        }
        catch (InvalidKeyException e) {
            String eMessage = "obfuscate: Invalid key";
            throw new Exception(eMessage, e);
        }
        return Base64.encodeBytes(encryptedBytes, 8);
    }

    public byte[] deobfuscate(String password) throws Exception {
        byte[] decryptedBytes = null;
        try {
            decryptedBytes = Base64.decode(password);
            Cipher cipher = this.useSunJCE ? Cipher.getInstance(TRANSFORMATION, SUN_CRYPTO_PROVIDER) : Cipher.getInstance(TRANSFORMATION);
            cipher.init(2, (Key)this.specKey, this.ivSpec);
            decryptedBytes = cipher.doFinal(decryptedBytes);
        }
        catch (NoSuchAlgorithmException e) {
            String eMessage = "deobfuscate: Specified algorithm cannot be found";
            throw new Exception(eMessage, e);
        }
        catch (IllegalBlockSizeException e) {
            String eMessage = "deobfuscate: Illegal block size";
            throw new Exception(eMessage, e);
        }
        catch (BadPaddingException e) {
            String eMessage = "deobfuscate: Bad padding";
            throw new Exception(eMessage, e);
        }
        catch (NoSuchPaddingException e) {
            String eMessage = "deobfuscate: Wrong padding";
            throw new Exception(eMessage, e);
        }
        catch (NoSuchProviderException e) {
            String eMessage = "deobfuscate: Specified provider cannot be found";
            throw new Exception(eMessage, e);
        }
        catch (InvalidAlgorithmParameterException e) {
            String eMessage = "deobfuscate: Invalid algorithm parameter";
            throw new Exception(eMessage, e);
        }
        catch (InvalidKeyException e) {
            String eMessage = "deobfuscate: Invalid key";
            throw new Exception(eMessage, e);
        }
        return decryptedBytes;
    }
}

