/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.opentoken.util;

import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class PasswordKeyGenerator {
    private static int ITERATIONS = 1000;

    private PasswordKeyGenerator() {
    }

    private static Mac getSha1Hmac(String password, boolean useSunJCE) {
        try {
            Mac mac = null;
            mac = useSunJCE ? Mac.getInstance("HmacSHA1", "SunJCE") : Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec(password.getBytes(), "AES"));
            return mac;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Mac getSha1Hmac(byte[] password, boolean useSunJCE) {
        try {
            Mac mac = null;
            mac = useSunJCE ? Mac.getInstance("HmacSHA1", "SunJCE") : Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec(password, "AES"));
            return mac;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] intToBytes(int value) {
        return new byte[]{(byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
    }

    private static byte[] generateBlock(Mac mac, byte[] salt, int count, int index) {
        byte[] result;
        mac.reset();
        byte[] indexBytes = PasswordKeyGenerator.intToBytes(index);
        mac.update(salt);
        mac.update(indexBytes);
        byte[] cur = result = mac.doFinal();
        for (int i = 1; i < count; ++i) {
            cur = mac.doFinal(cur);
            for (int j = 0; j < result.length; ++j) {
                int n = j;
                result[n] = (byte)(result[n] ^ cur[j]);
            }
        }
        return result;
    }

    public static SecretKey generate(String password, int cipherSuite, boolean useSunJCE) {
        return PasswordKeyGenerator.generate(password, cipherSuite, new byte[8], ITERATIONS, useSunJCE);
    }

    public static SecretKey generate(byte[] password, int cipherSuite, boolean useSunJCE) {
        return PasswordKeyGenerator.generate(password, cipherSuite, new byte[8], ITERATIONS, useSunJCE);
    }

    public static SecretKey generate(byte[] password, int cipherSuite, byte[] salt, int iterations, boolean useSunJCE) {
        if (cipherSuite == 0) {
            return null;
        }
        int keysize = 0;
        String algo = null;
        switch (cipherSuite) {
            case 1: {
                keysize = 32;
                algo = "AES";
                break;
            }
            case 2: {
                keysize = 16;
                algo = "AES";
                break;
            }
            case 3: {
                keysize = 24;
                algo = "DESede";
            }
        }
        byte[] key = new byte[keysize];
        Mac mac = PasswordKeyGenerator.getSha1Hmac(password, useSunJCE);
        int blocks = (int)Math.ceil((double)keysize / ((double)mac.getMacLength() * 1.0));
        int keyBufferIndex = 0;
        for (int i = 1; i < blocks + 1; ++i) {
            byte[] block = PasswordKeyGenerator.generateBlock(mac, salt, iterations, i);
            int len = Math.min(block.length, key.length - keyBufferIndex);
            System.arraycopy(block, 0, key, keyBufferIndex, len);
            keyBufferIndex += len;
        }
        return new SecretKeySpec(key, algo);
    }

    public static SecretKey generate(String password, int cipherSuite, byte[] salt, int iterations, boolean useSunJCE) {
        if (cipherSuite == 0) {
            return null;
        }
        int keysize = 0;
        String algo = null;
        switch (cipherSuite) {
            case 1: {
                keysize = 32;
                algo = "AES";
                break;
            }
            case 2: {
                keysize = 16;
                algo = "AES";
                break;
            }
            case 3: {
                keysize = 24;
                algo = "DESede";
            }
        }
        byte[] key = new byte[keysize];
        Mac mac = PasswordKeyGenerator.getSha1Hmac(password, useSunJCE);
        int blocks = (int)Math.ceil((double)keysize / ((double)mac.getMacLength() * 1.0));
        int keyBufferIndex = 0;
        for (int i = 1; i < blocks + 1; ++i) {
            byte[] block = PasswordKeyGenerator.generateBlock(mac, salt, iterations, i);
            int len = Math.min(block.length, key.length - keyBufferIndex);
            System.arraycopy(block, 0, key, keyBufferIndex, len);
            keyBufferIndex += len;
        }
        return new SecretKeySpec(key, algo);
    }
}

