/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.prov.saas.pingidforworkforce;

import com.pingidentity.io.cpl.pingidforworkforce.IWorker;
import com.pingidentity.io.cpl.pingidforworkforce.exception.ResourceException;
import com.pingidentity.io.cpl.pingidforworkforce.exception.ResourceNotFoundException;
import com.pingidentity.io.cpl.pingidforworkforce.exception.ServiceException;
import com.pingidentity.io.cpl.pingidforworkforce.metadata.CapabilityType;
import com.pingidentity.io.cpl.pingidforworkforce.request.ConnectionFields;
import com.pingidentity.io.cpl.pingidforworkforce.request.Request;
import com.pingidentity.io.cpl.pingidforworkforce.resource.ResourceAttributes;
import com.pingidentity.io.cpl.pingidforworkforce.resource.ResourceUniqueId;
import com.pingidentity.io.cpl.pingidforworkforce.resource.User;
import com.pingidentity.io.cpl.pingidforworkforce.response.CheckConnectionResponse;
import com.pingidentity.io.cpl.pingidforworkforce.response.CreateUsersResponse;
import com.pingidentity.io.cpl.pingidforworkforce.response.DeleteUsersResponse;
import com.pingidentity.io.cpl.pingidforworkforce.response.GetUsersResponse;
import com.pingidentity.io.cpl.pingidforworkforce.response.UpdateUsersResponse;
import com.pingidentity.io.cpl.pingidforworkforce.response.UserAttempt;
import com.pingidentity.prov.saas.pingidforworkforce.PluginWorker;
import com.pingidentity.prov.saas.pingidforworkforce.request.RequestBuilderFactory;
import com.pingidentity.prov.saas.pingidforworkforce.request.UserRequestParameters;
import com.pingidentity.provisioner.sdk.SaasUserData;

public class CPLv3PluginWorker
implements PluginWorker {
    protected final IWorker worker;
    protected final RequestBuilderFactory requestBuilderFactory;

    public CPLv3PluginWorker(IWorker worker, RequestBuilderFactory requestBuilderFactory) {
        this.worker = worker;
        this.requestBuilderFactory = requestBuilderFactory;
    }

    @Override
    public String executeCreateUser(SaasUserData userData, ConnectionFields connectionFields) throws ServiceException, ResourceException {
        UserRequestParameters reqParams = new UserRequestParameters(connectionFields, userData);
        Request request = this.requestBuilderFactory.make(CapabilityType.CREATE_USERS).build(reqParams);
        CreateUsersResponse response = (CreateUsersResponse)this.worker.doWork(request);
        if (response.hasServiceExceptions()) {
            throw (ServiceException)response.getServiceExceptions().get(0);
        }
        UserAttempt attempt = (UserAttempt)response.getUserAttempts().get(0);
        if (attempt.getResourceExceptions().size() > 0) {
            throw (ResourceException)attempt.getResourceExceptions().get(0);
        }
        User createdUser = attempt.getUser();
        return createdUser.getResourceUniqueId().getId();
    }

    @Override
    public SaasUserData executeGetUser(SaasUserData saasUserData, ConnectionFields connectionFields) throws ServiceException, ResourceException {
        UserRequestParameters reqParams = new UserRequestParameters(connectionFields, saasUserData);
        Request request = this.requestBuilderFactory.make(CapabilityType.GET_USERS).build(reqParams);
        GetUsersResponse response = (GetUsersResponse)this.worker.doWork(request);
        if (response.hasServiceExceptions()) {
            throw (ServiceException)response.getServiceExceptions().get(0);
        }
        UserAttempt attempt = (UserAttempt)response.getUserAttempts().get(0);
        if (attempt.getResourceExceptions().size() > 0) {
            ResourceException e = (ResourceException)attempt.getResourceExceptions().get(0);
            if (e instanceof ResourceNotFoundException) {
                return null;
            }
            throw e;
        }
        User createdUser = attempt.getUser();
        return this.convertCplUser(createdUser);
    }

    @Override
    public String executeUpdateUser(SaasUserData newUserData, ConnectionFields connectionFields) throws ServiceException, ResourceException {
        UserRequestParameters reqParams = new UserRequestParameters(connectionFields, newUserData);
        Request request = this.requestBuilderFactory.make(CapabilityType.UPDATE_USERS).build(reqParams);
        UpdateUsersResponse response = (UpdateUsersResponse)this.worker.doWork(request);
        if (response.hasServiceExceptions()) {
            throw (ServiceException)response.getServiceExceptions().get(0);
        }
        UserAttempt attempt = (UserAttempt)response.getUserAttempts().get(0);
        if (attempt.getResourceExceptions().size() > 0) {
            throw (ResourceException)attempt.getResourceExceptions().get(0);
        }
        User updatedUser = attempt.getUser();
        return updatedUser.getResourceUniqueId().getId();
    }

    @Override
    public void executeDeleteUser(SaasUserData userData, ConnectionFields connectionFields) throws ServiceException, ResourceException {
        UserRequestParameters reqParams = new UserRequestParameters(connectionFields, userData);
        Request request = this.requestBuilderFactory.make(CapabilityType.DELETE_USERS).build(reqParams);
        DeleteUsersResponse response = (DeleteUsersResponse)this.worker.doWork(request);
        if (response.hasServiceExceptions()) {
            throw (ServiceException)response.getServiceExceptions().get(0);
        }
        UserAttempt attempt = (UserAttempt)response.getUserAttempts().get(0);
        if (attempt.getResourceExceptions().size() > 0) {
            throw (ResourceException)attempt.getResourceExceptions().get(0);
        }
    }

    @Override
    public void executeCheckConnection(ConnectionFields connectionFields) throws ServiceException {
        UserRequestParameters reqParams = new UserRequestParameters(connectionFields, null);
        Request request = this.requestBuilderFactory.make(CapabilityType.CHECK_CONNECTION).build(reqParams);
        CheckConnectionResponse response = (CheckConnectionResponse)this.worker.doWork(request);
        if (response.hasServiceExceptions()) {
            throw (ServiceException)response.getServiceExceptions().get(0);
        }
    }

    private SaasUserData convertCplUser(User user) {
        ResourceUniqueId id = user.getResourceUniqueId();
        SaasUserData saasUser = new SaasUserData(id.getId());
        ResourceAttributes resourceAttributes = user.getResourceAttributes();
        for (String key : resourceAttributes.keySet()) {
            saasUser.addAttribute(key, resourceAttributes.getAll(key));
        }
        return saasUser;
    }
}

