/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.prov.saas.pingidforworkforce.cplv3Mock;

import com.pingidentity.io.cpl.pingidforworkforce.Worker;
import com.pingidentity.io.cpl.pingidforworkforce.request.CreateGroupsRequest;
import com.pingidentity.io.cpl.pingidforworkforce.request.CreateUsersRequest;
import com.pingidentity.io.cpl.pingidforworkforce.request.DeleteGroupsRequest;
import com.pingidentity.io.cpl.pingidforworkforce.request.DeleteUsersRequest;
import com.pingidentity.io.cpl.pingidforworkforce.request.GetAttributesRequest;
import com.pingidentity.io.cpl.pingidforworkforce.request.GetConnectionProfilesRequest;
import com.pingidentity.io.cpl.pingidforworkforce.request.GetGroupsRequest;
import com.pingidentity.io.cpl.pingidforworkforce.request.GetInfoRequest;
import com.pingidentity.io.cpl.pingidforworkforce.request.GetUsersRequest;
import com.pingidentity.io.cpl.pingidforworkforce.request.UpdateGroupsRequest;
import com.pingidentity.io.cpl.pingidforworkforce.request.UpdateUsersRequest;
import com.pingidentity.io.cpl.pingidforworkforce.resource.Group;
import com.pingidentity.io.cpl.pingidforworkforce.resource.ResourceUniqueId;
import com.pingidentity.io.cpl.pingidforworkforce.resource.User;
import com.pingidentity.io.cpl.pingidforworkforce.response.CreateGroupsResponse;
import com.pingidentity.io.cpl.pingidforworkforce.response.CreateUsersResponse;
import com.pingidentity.io.cpl.pingidforworkforce.response.DeleteGroupsResponse;
import com.pingidentity.io.cpl.pingidforworkforce.response.DeleteUsersResponse;
import com.pingidentity.io.cpl.pingidforworkforce.response.GetAttributesResponse;
import com.pingidentity.io.cpl.pingidforworkforce.response.GetConnectionProfilesResponse;
import com.pingidentity.io.cpl.pingidforworkforce.response.GetGroupsResponse;
import com.pingidentity.io.cpl.pingidforworkforce.response.GetInfoResponse;
import com.pingidentity.io.cpl.pingidforworkforce.response.GetUsersResponse;
import com.pingidentity.io.cpl.pingidforworkforce.response.GroupAttempt;
import com.pingidentity.io.cpl.pingidforworkforce.response.GroupAttempts;
import com.pingidentity.io.cpl.pingidforworkforce.response.UpdateGroupsResponse;
import com.pingidentity.io.cpl.pingidforworkforce.response.UpdateUsersResponse;
import com.pingidentity.io.cpl.pingidforworkforce.response.UserAttempt;
import com.pingidentity.io.cpl.pingidforworkforce.response.UserAttempts;
import com.pingidentity.prov.saas.pingidforworkforce.cplv3Mock.MockMetadataBuilder;
import java.util.HashMap;
import java.util.Map;

public class MockWorker
extends Worker {
    private final Map<String, User> users = new HashMap<String, User>();
    private final Map<String, Group> groups = new HashMap<String, Group>();
    private final MockMetadataBuilder mdBuilder = new MockMetadataBuilder();

    @Override
    protected GetInfoResponse getInfo(GetInfoRequest request) {
        GetInfoResponse response = new GetInfoResponse();
        response.setInformation(this.mdBuilder.getInfo());
        return response;
    }

    @Override
    protected GetConnectionProfilesResponse getConnectionProfiles(GetConnectionProfilesRequest request) {
        GetConnectionProfilesResponse response = new GetConnectionProfilesResponse();
        response.setConnectionProfiles(this.mdBuilder.getConnectionProfiles());
        return response;
    }

    @Override
    protected GetAttributesResponse getAttributes(GetAttributesRequest request) {
        GetAttributesResponse response = new GetAttributesResponse();
        response.setAttributeMetadata(this.mdBuilder.getAttributeMetadata());
        return response;
    }

    @Override
    protected UpdateUsersResponse updateUsers(UpdateUsersRequest request) {
        User reqUser = (User)request.getUsers().get(0);
        ResourceUniqueId ruid = reqUser.getResourceUniqueId();
        this.users.put(ruid.getId(), reqUser);
        UserAttempts attempts = this.getUserAttempts(ruid);
        UpdateUsersResponse response = new UpdateUsersResponse(attempts);
        return response;
    }

    @Override
    protected GetUsersResponse getUsers(GetUsersRequest request) {
        User reqUser = (User)request.getUsers().get(0);
        ResourceUniqueId ruid = reqUser.getResourceUniqueId();
        GetUsersResponse response = new GetUsersResponse(this.getUserAttempts(ruid));
        return response;
    }

    @Override
    protected CreateUsersResponse createUsers(CreateUsersRequest request) {
        User user = (User)request.getUsers().get(0);
        ResourceUniqueId ruid = user.getResourceUniqueId();
        String key = user.getResourceUniqueId().getId();
        this.users.put(key, user);
        UserAttempts attempts = this.getUserAttempts(ruid);
        CreateUsersResponse response = new CreateUsersResponse(attempts);
        return response;
    }

    @Override
    protected DeleteUsersResponse deleteUsers(DeleteUsersRequest request) {
        User user = (User)request.getUsers().get(0);
        String key = user.getResourceUniqueId().getId();
        DeleteUsersResponse response = new DeleteUsersResponse(this.getUserAttempts(user.getResourceUniqueId()));
        this.users.remove(key);
        return response;
    }

    @Override
    protected CreateGroupsResponse createGroups(CreateGroupsRequest request) {
        Group group = (Group)request.getGroups().get(0);
        ResourceUniqueId ruid = group.getResourceUniqueId();
        String key = ruid.getId();
        this.groups.put(key, group);
        CreateGroupsResponse response = new CreateGroupsResponse(this.getGroupAttempts(ruid));
        return response;
    }

    @Override
    protected GetGroupsResponse getGroups(GetGroupsRequest request) {
        Group group = (Group)request.getGroups().get(0);
        ResourceUniqueId id = group.getResourceUniqueId();
        return new GetGroupsResponse(this.getGroupAttempts(id));
    }

    @Override
    protected UpdateGroupsResponse updateGroups(UpdateGroupsRequest request) {
        Group group = (Group)request.getGroups().get(0);
        ResourceUniqueId id = group.getResourceUniqueId();
        this.groups.put(id.getId(), group);
        return new UpdateGroupsResponse(this.getGroupAttempts(id));
    }

    @Override
    protected DeleteGroupsResponse deleteGroups(DeleteGroupsRequest request) {
        Group group = (Group)request.getGroups().get(0);
        String key = group.getResourceUniqueId().getId();
        DeleteGroupsResponse response = new DeleteGroupsResponse(this.getGroupAttempts(group.getResourceUniqueId()));
        this.groups.remove(key);
        return response;
    }

    private UserAttempts getUserAttempts(ResourceUniqueId ruid) {
        UserAttempt attempt = new UserAttempt();
        attempt.setUser(this.users.get(ruid.getId()));
        UserAttempts attempts = new UserAttempts();
        attempts.add(attempt);
        return attempts;
    }

    private GroupAttempts getGroupAttempts(ResourceUniqueId ruid) {
        GroupAttempt attempt = new GroupAttempt();
        attempt.setGroup(this.groups.get(ruid.getId()));
        GroupAttempts attempts = new GroupAttempts();
        attempts.add(attempt);
        return attempts;
    }
}

