/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.saas.pingidforworkforce;

import com.pingidentity.provisioner.saas.pingidforworkforce.PingIdProperties;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Properties;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;

public class PingIdPropertiesValidator
implements FieldValidator {
    private static final long serialVersionUID = -2114867035906476518L;
    private final RequiredFieldValidator requiredValidator;

    public PingIdPropertiesValidator(RequiredFieldValidator requiredValidator) {
        this.requiredValidator = requiredValidator;
    }

    public PingIdPropertiesValidator() {
        this(new RequiredFieldValidator());
    }

    public void validate(Field field) throws ValidationException {
        this.requiredValidator.validate(field);
        String propFileContent = field.getFileValueAsString();
        if (propFileContent == null | propFileContent.isEmpty()) {
            throw new ValidationException("Uploaded file is empty");
        }
        ArrayList<String> errorMessages = new ArrayList<String>();
        try {
            String orgAlias;
            String domain;
            String token;
            Properties properties = new Properties();
            properties.load(new StringReader(propFileContent));
            String base64Key = properties.getProperty(PingIdProperties.BASE_64_KEY.getValue());
            if (base64Key == null || base64Key.trim().isEmpty()) {
                errorMessages.add(String.format("Uploaded file is missing %s field", PingIdProperties.BASE_64_KEY.getValue()));
            }
            if ((token = properties.getProperty(PingIdProperties.TOKEN.getValue())) == null || token.trim().isEmpty()) {
                errorMessages.add(String.format("Uploaded file is missing %s field", PingIdProperties.TOKEN.getValue()));
            }
            if ((domain = properties.getProperty(PingIdProperties.IDP_URL.getValue())) == null || domain.trim().isEmpty()) {
                errorMessages.add(String.format("Uploaded file is missing %s field", PingIdProperties.IDP_URL.getValue()));
            }
            if ((orgAlias = properties.getProperty(PingIdProperties.ORG_ALIAS.getValue())) == null || orgAlias.trim().isEmpty()) {
                errorMessages.add(String.format("Uploaded file is missing %s field", PingIdProperties.ORG_ALIAS.getValue()));
            }
        }
        catch (IOException e) {
            throw new ValidationException(errorMessages);
        }
        if (!errorMessages.isEmpty()) {
            throw new ValidationException(errorMessages);
        }
    }
}

