/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.saas.pingidforworkforce;

import com.pingidentity.crypto.Password;
import com.pingidentity.integrations.provisioner.pingidforworkforce.ConnectionFieldKey;
import com.pingidentity.integrations.provisioner.pingidforworkforce.PingIDForWorkforceWorker;
import com.pingidentity.integrations.provisioner.pingidforworkforce.ResourceFieldKey;
import com.pingidentity.io.cpl.pingidforworkforce.exception.ResourceException;
import com.pingidentity.io.cpl.pingidforworkforce.exception.ServiceException;
import com.pingidentity.io.cpl.pingidforworkforce.metadata.AttributeMetadata;
import com.pingidentity.io.cpl.pingidforworkforce.metadata.ConnectionProfile;
import com.pingidentity.io.cpl.pingidforworkforce.metadata.ProvisionerInformation;
import com.pingidentity.io.cpl.pingidforworkforce.request.ConnectionFields;
import com.pingidentity.io.cpl.pingidforworkforce.request.GetAttributesRequest;
import com.pingidentity.io.cpl.pingidforworkforce.request.GetConnectionProfilesRequest;
import com.pingidentity.io.cpl.pingidforworkforce.request.GetInfoRequest;
import com.pingidentity.prov.saas.pingidforworkforce.PluginWorker;
import com.pingidentity.prov.saas.pingidforworkforce.metadata.MetadataService;
import com.pingidentity.prov.saas.pingidforworkforce.request.DefaultUserRequestBuilderFactory;
import com.pingidentity.provisioner.saas.pingidforworkforce.PingIDForWorkforceMetadataServiceFactory;
import com.pingidentity.provisioner.saas.pingidforworkforce.PingIDForWorkforcePluginWorker;
import com.pingidentity.provisioner.saas.pingidforworkforce.PingIdProperties;
import com.pingidentity.provisioner.sdk.AbstractSaasPlugin;
import com.pingidentity.provisioner.sdk.SaasPluginException;
import com.pingidentity.provisioner.sdk.SaasPluginFieldInfo;
import com.pingidentity.provisioner.sdk.SaasUserData;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;

public class ProvisionerSDKPlugin
extends AbstractSaasPlugin {
    private static final long serialVersionUID = -2088797560933737361L;
    private static final int MAX_THREADS = 1;
    private static final String TRUE = Boolean.TRUE.toString();
    private transient PluginWorker worker;
    private transient PingIDForWorkforceWorker cplWorker;
    private transient MetadataService metadataService;
    private static Logger logger;

    public ProvisionerSDKPlugin() {
        ProvisionerSDKPlugin.setLogger(Logger.getLogger(((Object)((Object)this)).getClass()));
        this.cplWorker = new PingIDForWorkforceWorker();
        ProvisionerInformation info = this.cplWorker.getInfo(new GetInfoRequest()).getInformation();
        ConnectionProfile profile = (ConnectionProfile)this.cplWorker.getConnectionProfiles(new GetConnectionProfilesRequest()).getConnectionProfiles().get(0);
        AttributeMetadata attributeMetadata = this.cplWorker.getAttributes(new GetAttributesRequest()).getAttributeMetadata();
        PingIDForWorkforceMetadataServiceFactory metadataServiceFactory = new PingIDForWorkforceMetadataServiceFactory(info, profile, attributeMetadata);
        DefaultUserRequestBuilderFactory requestBuilderFactory = new DefaultUserRequestBuilderFactory(metadataServiceFactory, ResourceFieldKey.ACTIVATE_USER.getLabel(), true);
        this.worker = new PingIDForWorkforcePluginWorker(this.cplWorker, requestBuilderFactory);
        this.metadataService = metadataServiceFactory.make();
    }

    public ProvisionerSDKPlugin(Logger log, PluginWorker worker, MetadataService uiService) {
        ProvisionerSDKPlugin.setLogger(log);
        this.worker = worker;
        this.metadataService = uiService;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void setLogger(Logger logger) {
        ProvisionerSDKPlugin.logger = logger;
    }

    public String getSaasUserIdFieldName() {
        return ResourceFieldKey.getPrimaryId().getLabel();
    }

    public String getSaasUsernameFieldCode() {
        return ResourceFieldKey.getSecondaryId().getLabel();
    }

    public SaasUserData getUser(String saasUserGuid, String saasUsername) throws SaasPluginException {
        ProvisionerSDKPlugin.getLogger().debug((Object)"+ getUser()");
        String saasGuid = saasUserGuid;
        ConnectionFields connectionFields = this.makeConnectionFields();
        if (saasGuid == null || saasGuid.isEmpty()) {
            saasGuid = saasUsername != null && !saasUsername.isEmpty() ? saasUsername : "";
        }
        SaasUserData saasUserData = new SaasUserData(saasGuid);
        ProvisionerSDKPlugin.getLogger().info((Object)String.format("Using %s: [%s] for getUser()", this.getSaasUsernameFieldCode(), saasUsername));
        try {
            saasUserData = this.worker.executeGetUser(saasUserData, connectionFields);
        }
        catch (ServiceException e) {
            throw new SaasPluginException(e.getFormattedMessage());
        }
        catch (ResourceException e) {
            throw new SaasPluginException(e.getFormattedMessage());
        }
        if (saasUserData == null) {
            ProvisionerSDKPlugin.getLogger().info((Object)("User [" + saasUsername + "] was not found in target"));
        } else {
            ProvisionerSDKPlugin.getLogger().info((Object)("User [" + saasUsername + "] was found in target"));
        }
        ProvisionerSDKPlugin.getLogger().debug((Object)"- getUser()");
        return saasUserData;
    }

    public String createUser(SaasUserData userData) throws SaasPluginException {
        ProvisionerSDKPlugin.getLogger().debug((Object)"+ createUser()");
        String userId = userData.getAttributeFirstValue(ResourceFieldKey.getSecondaryId().getLabel());
        ConnectionFields connectionFields = this.makeConnectionFields();
        boolean isCreateUsersEnabled = TRUE.equalsIgnoreCase((String)connectionFields.get(ConnectionFieldKey.CREATE_USERS.getKey()));
        boolean isUserDisabled = !userData.isAccountEnabled();
        boolean isProvisionDisabledUsersEnabled = TRUE.equalsIgnoreCase((String)connectionFields.get(ConnectionFieldKey.PROVISION_DISABLED_USERS.getKey()));
        if (!isCreateUsersEnabled) {
            logger.warn((Object)"Did not create user as the Create Users flag is not enabled.");
        } else if (isUserDisabled && !isProvisionDisabledUsersEnabled) {
            logger.warn((Object)"Unable to create user as user is disabled and the Provision Disabled Users flag is set to false.");
        } else {
            try {
                userId = this.worker.executeCreateUser(userData, connectionFields);
                logger.info((Object)"User was successfully created in target");
            }
            catch (ServiceException e) {
                throw new SaasPluginException(e.getFormattedMessage());
            }
            catch (ResourceException e) {
                throw new SaasPluginException(e.getFormattedMessage());
            }
        }
        ProvisionerSDKPlugin.getLogger().debug((Object)"- createUser()");
        return userId;
    }

    public String updateUser(SaasUserData oldUserData, SaasUserData newUserData) throws SaasPluginException {
        ProvisionerSDKPlugin.getLogger().debug((Object)"+ updateUser()");
        String id = oldUserData.getSaasUserGuid();
        SaasUserData cloneUserData = this.cloneSaasUserDataWithSaasUserGuid(oldUserData.getSaasUserGuid(), newUserData);
        ConnectionFields connectionFields = this.makeConnectionFields();
        boolean isUpdateEnabled = TRUE.equalsIgnoreCase((String)connectionFields.get(ConnectionFieldKey.UPDATE_USERS.getKey()));
        boolean isRemovalAction = !newUserData.isAccountEnabled();
        boolean isRemoveActionDelete = "Delete".equalsIgnoreCase((String)connectionFields.get(ConnectionFieldKey.REMOVE_ACTION.getKey())) && this.metadataService.supportsDelete();
        boolean isRemoveEnabled = TRUE.equalsIgnoreCase((String)connectionFields.get(ConnectionFieldKey.REMOVE_USERS.getKey()));
        if (!isRemovalAction && isUpdateEnabled) {
            id = this.executeUpdateUser(cloneUserData);
        } else if (isRemovalAction && isRemoveEnabled) {
            if (isRemoveActionDelete) {
                this.deleteUser(newUserData);
            } else {
                id = this.disableUser(newUserData);
            }
        } else if (!isUpdateEnabled) {
            logger.warn((Object)String.format("Unable to update user %s as the configured Provisioning Options do not allow for update operations.", id));
        } else {
            logger.warn((Object)String.format("Unable to remove user %s as the configured Provisioning Options do not allow for disable or delete operations.", id));
        }
        ProvisionerSDKPlugin.getLogger().debug((Object)"- updateUser()");
        return id;
    }

    public void initSaasConnection(List<Field> arg0) throws SaasPluginException {
    }

    public void checkSaasConnection() throws SaasPluginException {
        ProvisionerSDKPlugin.getLogger().debug((Object)"+ checkSaasConnection()");
        try {
            this.worker.executeCheckConnection(this.makeConnectionFields());
        }
        catch (ServiceException e) {
            throw new SaasPluginException(e.getFormattedMessage());
        }
        ProvisionerSDKPlugin.getLogger().debug((Object)"- checkSaasConnection()");
    }

    public void closeSaasConnection() throws SaasPluginException {
    }

    public List<FieldDescriptor> getConnectionParameterDescriptors() {
        return this.metadataService.getConnectionDescriptors();
    }

    public String getId() {
        return this.metadataService.getName();
    }

    public String getDescription() {
        return this.metadataService.getDescription();
    }

    public List<SaasPluginFieldInfo> getFieldInfo() throws SaasPluginException {
        return this.metadataService.getAttributeDescriptors();
    }

    public Properties loadDefaultMappings() throws IOException {
        return this.metadataService.getDefaultMappings();
    }

    public int getDefaultMaxThreads() {
        return 1;
    }

    private SaasUserData cloneSaasUserDataWithSaasUserGuid(String saasGuid, SaasUserData saasUserData) {
        SaasUserData clone = new SaasUserData(saasGuid);
        clone.setAccountEnabled(saasUserData.isAccountEnabled());
        clone.setAttributeMap(saasUserData.getAttributeMap());
        clone.setInternalGuid(saasUserData.getInternalGuid());
        return clone;
    }

    private String executeUpdateUser(SaasUserData userData) throws SaasPluginException {
        ProvisionerSDKPlugin.getLogger().debug((Object)"+ executeUpdateUser()");
        ConnectionFields connectionFields = this.makeConnectionFields();
        String saasGuid = null;
        try {
            saasGuid = this.worker.executeUpdateUser(userData, connectionFields);
            ProvisionerSDKPlugin.getLogger().info((Object)"User was successfully updated in target");
        }
        catch (ServiceException e) {
            throw new SaasPluginException(e.getFormattedMessage());
        }
        catch (ResourceException e) {
            throw new SaasPluginException(e.getFormattedMessage());
        }
        ProvisionerSDKPlugin.getLogger().debug((Object)"- executeUpdateUser()");
        return saasGuid;
    }

    private String disableUser(SaasUserData userData) throws SaasPluginException {
        ProvisionerSDKPlugin.getLogger().debug((Object)"+ disableUser()");
        ConnectionFields connectionFields = this.makeConnectionFields();
        String saasGuid = null;
        userData.setAccountEnabled(false);
        try {
            saasGuid = this.worker.executeUpdateUser(userData, connectionFields);
            ProvisionerSDKPlugin.getLogger().info((Object)"User was successfully disabled in target");
        }
        catch (ServiceException e) {
            throw new SaasPluginException(e.getFormattedMessage());
        }
        catch (ResourceException e) {
            throw new SaasPluginException(e.getFormattedMessage());
        }
        ProvisionerSDKPlugin.getLogger().debug((Object)"- disableUser()");
        return saasGuid;
    }

    private void deleteUser(SaasUserData userData) throws SaasPluginException {
        ProvisionerSDKPlugin.getLogger().debug((Object)"+ deleteUser()");
        if (userData.getSaasUserGuid() == null || StringUtils.isEmpty((String)userData.getSaasUserGuid())) {
            String saasUserGuid = userData.getAttributeFirstValue(ResourceFieldKey.USERNAME.getLabel());
            userData = new SaasUserData(saasUserGuid);
        }
        ConnectionFields connectionFields = this.makeConnectionFields();
        userData.setAccountEnabled(false);
        try {
            this.worker.executeDeleteUser(userData, connectionFields);
            ProvisionerSDKPlugin.getLogger().info((Object)"User was successfully deleted in target");
        }
        catch (ServiceException e) {
            throw new SaasPluginException(e.getFormattedMessage());
        }
        catch (ResourceException e) {
            throw new SaasPluginException(e.getFormattedMessage());
        }
        ProvisionerSDKPlugin.getLogger().debug((Object)"- deleteUser()");
    }

    private ConnectionFields makeConnectionFields() throws SaasPluginException {
        ConnectionFields connectionFields = new ConnectionFields();
        String propFileContent = null;
        for (Field field : this._parameters.getFields()) {
            String decryptedTokenValue;
            String encryptedTokenValue;
            if (ConnectionFieldKey.BASE64_KEY.getKey().equalsIgnoreCase(field.getName())) {
                encryptedTokenValue = field.getValue();
                decryptedTokenValue = Password.decodeAndDeobfuscate((String)encryptedTokenValue);
                connectionFields.put(field.getName(), decryptedTokenValue);
                continue;
            }
            if (ConnectionFieldKey.TOKEN.getKey().equalsIgnoreCase(field.getName())) {
                encryptedTokenValue = field.getValue();
                decryptedTokenValue = Password.decodeAndDeobfuscate((String)encryptedTokenValue);
                connectionFields.put(field.getName(), decryptedTokenValue);
                continue;
            }
            if (PingIdProperties.FIELD_NAME.getValue().equals(field.getName())) {
                propFileContent = field.getFileValueAsString();
                continue;
            }
            connectionFields.put(field.getName(), field.getValue());
        }
        if (propFileContent != null) {
            ConnectionFields propFileFields = this.parsePropertiesFile(propFileContent);
            connectionFields.putAll(propFileFields);
        }
        return connectionFields;
    }

    private ConnectionFields parsePropertiesFile(String propFileContent) throws SaasPluginException {
        ConnectionFields cf = new ConnectionFields();
        if (propFileContent == null | propFileContent.isEmpty()) {
            return cf;
        }
        try {
            String orgAlias;
            String domain;
            String token;
            Properties properties = new Properties();
            properties.load(new StringReader(propFileContent));
            String base64Key = properties.getProperty(PingIdProperties.BASE_64_KEY.getValue());
            if (base64Key != null && !base64Key.trim().isEmpty()) {
                cf.put(ConnectionFieldKey.BASE64_KEY.getKey(), base64Key);
            }
            if ((token = properties.getProperty(PingIdProperties.TOKEN.getValue())) != null && !token.trim().isEmpty()) {
                cf.put(ConnectionFieldKey.TOKEN.getKey(), token);
            }
            if ((domain = properties.getProperty(PingIdProperties.IDP_URL.getValue())) != null && !domain.trim().isEmpty()) {
                domain = domain.replaceAll("(https://)|(/pingid)", "");
                cf.put(ConnectionFieldKey.DOMAIN.getKey(), domain);
            }
            if ((orgAlias = properties.getProperty(PingIdProperties.ORG_ALIAS.getValue())) != null && !orgAlias.trim().isEmpty()) {
                cf.put(ConnectionFieldKey.ORG_ALIAS.getKey(), orgAlias);
            }
        }
        catch (IOException e) {
            throw new SaasPluginException(String.format("Unable to load %s.", PingIdProperties.FIELD_NAME.getValue()), (Throwable)e);
        }
        return cf;
    }
}

