/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud;

import com.pingidentity.saas.prov_pingid.shade.com.google.gson.Gson;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.crud.RequestBuilder;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.crud.ResourceException;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.crud.ServiceException;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.PingIdCredential;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.PingIdDevice;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.PingIdDeviceAttribute;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.dto.FormattedRequest;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.dto.RequestHeader;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.dto.create.CreateRequest;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.dto.delete.DeleteRequest;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.dto.search.SearchRequest;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.dto.update.UpdateRequest;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.http.GenericHttpBody;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.http.GenericHttpMethod;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.http.GenericHttpRequest;
import com.pingidentity.saas.prov_pingid.shade.org.jose4j.jws.JsonWebSignature;
import com.pingidentity.saas.prov_pingid.shade.org.jose4j.keys.HmacKey;
import com.pingidentity.saas.prov_pingid.shade.org.jose4j.lang.JoseException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import java.util.Optional;

public class PingIdDeviceRequestBuilder
implements RequestBuilder<PingIdCredential, PingIdDevice> {
    private static final String SCHEME = "https://";
    private static final String CREATE_DEVICE_PATH = "/pingid/rest/4/offlinepairing/do";
    private static final String UPDATE_DEVICE_PATH = "/pingid/rest/4/updatedeviceattr/do";
    private static final String DELETE_DEVICE_PATH = "/pingid/rest/4/unpairdevice/do";
    private static final String SEARCH_DEVICES_PATH = "/pingid/rest/4/getuserdetails/do";
    private final Gson gson;

    public PingIdDeviceRequestBuilder() {
        this(new Gson());
    }

    public PingIdDeviceRequestBuilder(Gson gson) {
        this.gson = gson;
    }

    @Override
    public GenericHttpRequest buildCreateRequest(Map<PingIdCredential, String> connectionConfig, PingIdDevice resource) throws ResourceException, ServiceException {
        boolean isPairingDataNullOrEmpty;
        String domain = connectionConfig.get((Object)PingIdCredential.DOMAIN);
        String formattedUrl = SCHEME + domain + CREATE_DEVICE_PATH;
        String username = resource != null ? resource.getOne(PingIdDeviceAttribute.USERNAME) : null;
        String type = resource != null ? resource.getOne(PingIdDeviceAttribute.TYPE) : null;
        String pairingData = resource != null ? resource.getOne(PingIdDeviceAttribute.PAIRING_DATA) : null;
        String validateUniqueness = Boolean.FALSE.toString();
        boolean isUsernameNullOrEmpty = username == null || username.isEmpty();
        boolean isTypeNullOrEmpty = type == null || type.isEmpty();
        boolean bl = isPairingDataNullOrEmpty = pairingData == null || pairingData.isEmpty();
        if (isUsernameNullOrEmpty || isTypeNullOrEmpty || isPairingDataNullOrEmpty) {
            StringBuilder errMsgBuilder = new StringBuilder("PingId Device is missing required fields for creation:");
            errMsgBuilder = isUsernameNullOrEmpty ? errMsgBuilder.append(" Username") : errMsgBuilder;
            errMsgBuilder = isTypeNullOrEmpty ? errMsgBuilder.append(" Type") : errMsgBuilder;
            errMsgBuilder = isPairingDataNullOrEmpty ? errMsgBuilder.append(" PairingData") : errMsgBuilder;
            throw new ResourceException(errMsgBuilder.toString(), false);
        }
        CreateRequest createReq = new CreateRequest(username, type.toUpperCase(), pairingData, validateUniqueness);
        RequestHeader requestHeader = this.buildRequestHeader(connectionConfig);
        FormattedRequest req = new FormattedRequest(requestHeader, createReq);
        String requestBody = this.buildRequestToken(connectionConfig, req);
        GenericHttpBody body = new GenericHttpBody(requestBody, "application/json", StandardCharsets.UTF_8.toString());
        return new GenericHttpRequest(GenericHttpMethod.POST, formattedUrl, body);
    }

    @Override
    public GenericHttpRequest buildReadRequest(Map<PingIdCredential, String> connectionConfig, PingIdDevice resource) throws ResourceException, ServiceException {
        return RequestBuilder.super.buildReadRequest(connectionConfig, resource);
    }

    @Override
    public GenericHttpRequest buildUpdateRequest(Map<PingIdCredential, String> connectionConfig, PingIdDevice resource) throws ResourceException, ServiceException {
        boolean isNicknameNullOrEmpty;
        String domain = connectionConfig.get((Object)PingIdCredential.DOMAIN);
        String formattedUrl = SCHEME + domain + UPDATE_DEVICE_PATH;
        String deviceId = resource != null ? resource.getId() : null;
        String username = resource != null ? resource.getOne(PingIdDeviceAttribute.USERNAME) : null;
        String primary = resource != null ? resource.getOne(PingIdDeviceAttribute.PRIMARY) : null;
        String nickname = resource != null ? resource.getOne(PingIdDeviceAttribute.NICKNAME) : null;
        boolean isDeviceIdNullOrEmpty = deviceId == null || deviceId.isEmpty();
        boolean isUsernameNullOrEmpty = username == null || username.isEmpty();
        boolean isPrimaryNullOrEmpty = primary == null || primary.isEmpty();
        boolean bl = isNicknameNullOrEmpty = nickname == null || nickname.isEmpty();
        if (isDeviceIdNullOrEmpty || isUsernameNullOrEmpty || isPrimaryNullOrEmpty && isNicknameNullOrEmpty) {
            StringBuilder errMsgBuilder = new StringBuilder("PingId Device is missing required fields for update:");
            errMsgBuilder = isDeviceIdNullOrEmpty ? errMsgBuilder.append(" DeviceId") : errMsgBuilder;
            errMsgBuilder = isUsernameNullOrEmpty ? errMsgBuilder.append(" Username") : errMsgBuilder;
            errMsgBuilder = isPrimaryNullOrEmpty ? errMsgBuilder.append(" Primary") : errMsgBuilder;
            errMsgBuilder = isNicknameNullOrEmpty ? errMsgBuilder.append(" Nickname") : errMsgBuilder;
            throw new ResourceException(errMsgBuilder.toString(), false);
        }
        boolean isPrimary = "true".equalsIgnoreCase(primary);
        String attributeName = isPrimary ? "SET_PRIMARY" : "NICKNAME";
        String attributeValue = isPrimary ? primary : nickname;
        UpdateRequest updateReq = new UpdateRequest(deviceId, username, attributeName, attributeValue);
        RequestHeader requestHeader = this.buildRequestHeader(connectionConfig);
        FormattedRequest req = new FormattedRequest(requestHeader, updateReq);
        String requestBody = this.buildRequestToken(connectionConfig, req);
        GenericHttpBody body = new GenericHttpBody(requestBody, "application/json", StandardCharsets.UTF_8.toString());
        return new GenericHttpRequest(GenericHttpMethod.POST, formattedUrl, body);
    }

    @Override
    public Optional<GenericHttpRequest> buildPartialUpdateRequest(Map<PingIdCredential, String> connectionConfig, PingIdDevice oldResource, PingIdDevice newResource) throws ResourceException, ServiceException {
        return RequestBuilder.super.buildPartialUpdateRequest(connectionConfig, oldResource, newResource);
    }

    @Override
    public GenericHttpRequest buildDeleteRequest(Map<PingIdCredential, String> connectionConfig, PingIdDevice resource) throws ResourceException, ServiceException {
        boolean isUsernameNullOrEmpty;
        String deviceId = resource != null ? resource.getId() : null;
        String username = resource != null ? resource.getOne(PingIdDeviceAttribute.USERNAME) : null;
        boolean isDeviceIdNullOrEmpty = deviceId == null || deviceId.isEmpty();
        boolean bl = isUsernameNullOrEmpty = username == null || username.isEmpty();
        if (isDeviceIdNullOrEmpty || isUsernameNullOrEmpty) {
            StringBuilder errMsgBuilder = new StringBuilder("PingId Device is missing required fields for update:");
            errMsgBuilder = isDeviceIdNullOrEmpty ? errMsgBuilder.append(" DeviceId") : errMsgBuilder;
            errMsgBuilder = isUsernameNullOrEmpty ? errMsgBuilder.append(" Username") : errMsgBuilder;
            throw new ResourceException(errMsgBuilder.toString(), false);
        }
        String domain = connectionConfig.get((Object)PingIdCredential.DOMAIN);
        String formattedUrl = SCHEME + domain + DELETE_DEVICE_PATH;
        DeleteRequest createReq = new DeleteRequest(deviceId, username);
        RequestHeader requestHeader = this.buildRequestHeader(connectionConfig);
        FormattedRequest req = new FormattedRequest(requestHeader, createReq);
        String requestBody = this.buildRequestToken(connectionConfig, req);
        GenericHttpBody body = new GenericHttpBody(requestBody, "application/json", StandardCharsets.UTF_8.toString());
        return new GenericHttpRequest(GenericHttpMethod.POST, formattedUrl, body);
    }

    @Override
    public GenericHttpRequest buildSearchRequest(Map<PingIdCredential, String> connectionConfig, PingIdDevice resource) throws ResourceException, ServiceException {
        String username;
        String domain = connectionConfig.get((Object)PingIdCredential.DOMAIN);
        String formattedUrl = SCHEME + domain + SEARCH_DEVICES_PATH;
        RequestHeader requestHeader = this.buildRequestHeader(connectionConfig);
        String string = username = resource != null ? resource.getOne(PingIdDeviceAttribute.USERNAME) : null;
        if (username == null || username.isEmpty()) {
            throw new ResourceException("Unable to search for PingId devices without a username.", false);
        }
        SearchRequest searchReq = new SearchRequest(username);
        FormattedRequest req = new FormattedRequest(requestHeader, searchReq);
        String requestBody = this.buildRequestToken(connectionConfig, req);
        GenericHttpBody body = new GenericHttpBody(requestBody, "application/json", StandardCharsets.UTF_8.toString());
        return new GenericHttpRequest(GenericHttpMethod.POST, formattedUrl, body);
    }

    private String buildRequestToken(Map<PingIdCredential, String> connectionFields, FormattedRequest formattedReq) throws ResourceException, ServiceException {
        String reqBody = this.gson.toJson(formattedReq);
        JsonWebSignature jws = new JsonWebSignature();
        jws.setAlgorithmHeaderValue("HS256");
        jws.setHeader("org_alias", connectionFields.get((Object)PingIdCredential.ORG_ALIAS));
        jws.setHeader("token", connectionFields.get((Object)PingIdCredential.TOKEN));
        jws.setPayload(reqBody);
        HmacKey key = new HmacKey(Base64.getDecoder().decode(connectionFields.get((Object)PingIdCredential.BASE_64_KEY)));
        jws.setKey(key);
        try {
            return jws.getCompactSerialization();
        }
        catch (JoseException e) {
            throw new ServiceException("Unable to serialize request to PingId.", e);
        }
    }

    private RequestHeader buildRequestHeader(Map<PingIdCredential, String> connectionFields) {
        RequestHeader reqHeader = new RequestHeader();
        reqHeader.setOrgAlias(connectionFields.get((Object)PingIdCredential.ORG_ALIAS));
        reqHeader.setSecretKey(connectionFields.get((Object)PingIdCredential.TOKEN));
        reqHeader.setTimestamp(this.getCurrentTimeStamp());
        return reqHeader;
    }

    private String getCurrentTimeStamp() {
        Date currentDate = new Date();
        SimpleDateFormat PingIDDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return PingIDDateFormat.format(currentDate);
    }
}

