/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud;

import com.pingidentity.saas.prov_pingid.shade.com.google.gson.Gson;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.crud.CrudException;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.crud.ResourceException;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.crud.ServiceException;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.PingIdDevice;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.PingIdDeviceAttribute;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.PingIdDeviceDtoTranslator;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.Translator;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.dto.create.CreateResponse;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.dto.create.CreateResponseBody;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.dto.delete.DeleteResponse;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.dto.delete.DeleteResponseBody;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.dto.search.DeviceDto;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.dto.search.SearchUserDevicesResponse;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.dto.search.SearchUserDevicesResponseBody;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.dto.search.UserDetails;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.dto.update.UpdateResponse;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.dto.update.UpdateResponseBody;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.http.GenericHttpResponse;
import com.pingidentity.saas.prov_pingid.shade.org.jose4j.base64url.Base64;
import com.pingidentity.saas.prov_pingid.shade.org.jose4j.jws.JsonWebSignature;
import com.pingidentity.saas.prov_pingid.shade.org.jose4j.keys.HmacKey;
import com.pingidentity.saas.prov_pingid.shade.org.jose4j.lang.JoseException;
import java.util.ArrayList;
import java.util.List;

public class PingIdDeviceResponseParser {
    private final Gson gson;
    private final Translator<DeviceDto, PingIdDevice> deviceDtoTranslator;

    public PingIdDeviceResponseParser(Gson gson, Translator<DeviceDto, PingIdDevice> deviceDtoTranslator) {
        this.gson = gson;
        this.deviceDtoTranslator = deviceDtoTranslator;
    }

    public PingIdDeviceResponseParser() {
        this(new Gson(), new PingIdDeviceDtoTranslator());
    }

    public PingIdDevice parseCreateResponse(String base64Key, GenericHttpResponse resp) throws CrudException {
        CreateResponseBody responseBody;
        int statusCode = resp.getStatusCode();
        String encodedBody = resp.getBody() != null ? resp.getBody().getContent() : null;
        CreateResponse response = encodedBody != null ? this.decodeJson(base64Key, encodedBody, CreateResponse.class) : null;
        CreateResponseBody createResponseBody = responseBody = response != null ? response.getResponseBody() : new CreateResponseBody();
        if (statusCode != 200 || encodedBody == null || encodedBody.isEmpty()) {
            Integer errorId = responseBody != null ? Integer.valueOf(responseBody.getErrorId()) : null;
            String errorMessage = responseBody != null ? responseBody.getErrorMsg() : null;
            throw new ServiceException(String.format("API Response did not indicate a success. Status code was \"%d\", API error id was \"%d\", API error message was \"%s\".", statusCode, errorId, errorMessage));
        }
        return null;
    }

    public PingIdDevice parseUpdateResponse(String base64Key, GenericHttpResponse resp) throws CrudException {
        UpdateResponseBody responseBody;
        int statusCode = resp.getStatusCode();
        String encodedBody = resp.getBody() != null ? resp.getBody().getContent() : null;
        UpdateResponse response = encodedBody != null ? this.decodeJson(base64Key, encodedBody, UpdateResponse.class) : null;
        UpdateResponseBody updateResponseBody = responseBody = response != null ? response.getResponseBody() : null;
        if (statusCode != 200 || encodedBody == null || encodedBody.isEmpty()) {
            Integer errorId = responseBody != null ? Integer.valueOf(responseBody.getErrorId()) : null;
            String errorMsg = responseBody != null ? responseBody.getErrorMsg() : null;
            throw new ServiceException(String.format("Response did not indicate a success. Status code was \"%d\", API error id was \"%d\", API error message was \"%s\".", statusCode, errorId, errorMsg));
        }
        return null;
    }

    public void parseDeleteResponse(String base64Key, GenericHttpResponse resp) throws CrudException {
        DeleteResponseBody responseBody;
        int statusCode = resp.getStatusCode();
        String encodedBody = resp.getBody() != null ? resp.getBody().getContent() : null;
        DeleteResponse response = encodedBody != null ? this.decodeJson(base64Key, encodedBody, DeleteResponse.class) : null;
        DeleteResponseBody deleteResponseBody = responseBody = response != null ? response.getResponseBody() : null;
        if (statusCode != 200 || encodedBody == null || encodedBody.isEmpty()) {
            Integer errorId = responseBody != null ? Integer.valueOf(responseBody.getErrorId()) : null;
            String errorMsg = responseBody != null ? responseBody.getErrorMsg() : null;
            throw new ServiceException(String.format("Response did not indicate a success. Status code was \"%d\", API error id was \"%d\", API error message was \"%s\".", statusCode, errorId, errorMsg));
        }
    }

    public List<PingIdDevice> parseSearchResponse(String base64Key, GenericHttpResponse resp) throws CrudException {
        SearchUserDevicesResponseBody responseBody;
        ArrayList<PingIdDevice> devices = new ArrayList<PingIdDevice>();
        int statusCode = resp.getStatusCode();
        String encodedBody = resp.getBody() != null ? resp.getBody().getContent() : null;
        SearchUserDevicesResponse response = encodedBody != null ? this.decodeJson(base64Key, encodedBody, SearchUserDevicesResponse.class) : null;
        SearchUserDevicesResponseBody searchUserDevicesResponseBody = responseBody = response != null ? response.getResponseBody() : null;
        if (statusCode != 200 || encodedBody == null || encodedBody.isEmpty()) {
            Integer errorId = responseBody != null ? responseBody.getErrorId() : null;
            String errorMsg = responseBody != null ? responseBody.getErrorMsg() : null;
            throw new ServiceException(String.format("Response did not indicate a success. Status code was \"%d\", API error id was \"%d\", API error message was \"%s\".", statusCode, errorId, errorMsg));
        }
        UserDetails pingIdUserDto = responseBody != null ? responseBody.getUserDetails() : null;
        ArrayList userDevices = pingIdUserDto.getDevices() != null ? pingIdUserDto.getDevices() : new ArrayList();
        for (DeviceDto deviceDto : userDevices) {
            PingIdDevice device = this.deviceDtoTranslator.translate(deviceDto);
            device.add(PingIdDeviceAttribute.USERNAME, pingIdUserDto.getUserName());
            devices.add(device);
        }
        return devices;
    }

    public <T> T decodeJson(String base64Key, String responseToken, Class<T> returnedType) throws ResourceException {
        String responsePayloadJSON = null;
        try {
            JsonWebSignature responseJWS = new JsonWebSignature();
            responseJWS.setCompactSerialization(responseToken);
            HmacKey key = new HmacKey(Base64.decode(base64Key));
            responseJWS.setKey(key);
            responsePayloadJSON = responseJWS.getPayload();
        }
        catch (JoseException e) {
            throw new ResourceException("Unable to deserialize response from the PingId API.", e);
        }
        return this.gson.fromJson(responsePayloadJSON, returnedType);
    }
}

