/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.http.apache5;

import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.http.GenericHttpBody;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.http.GenericHttpHeaders;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.http.GenericHttpMethod;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.http.GenericHttpQueryParams;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.http.GenericHttpRequest;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.http.HttpLogEvent;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.http.HttpRequestBuilder;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.http.HttpServiceException;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.http.apache5.ApacheHttpRequest;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.saas.prov_pingid.shade.org.apache.hc.client5.http.classic.methods.HttpDelete;
import com.pingidentity.saas.prov_pingid.shade.org.apache.hc.client5.http.classic.methods.HttpGet;
import com.pingidentity.saas.prov_pingid.shade.org.apache.hc.client5.http.classic.methods.HttpPatch;
import com.pingidentity.saas.prov_pingid.shade.org.apache.hc.client5.http.classic.methods.HttpPost;
import com.pingidentity.saas.prov_pingid.shade.org.apache.hc.client5.http.classic.methods.HttpPut;
import com.pingidentity.saas.prov_pingid.shade.org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import com.pingidentity.saas.prov_pingid.shade.org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import com.pingidentity.saas.prov_pingid.shade.org.apache.hc.client5.http.entity.EntityBuilder;
import com.pingidentity.saas.prov_pingid.shade.org.apache.hc.core5.http.ContentType;
import com.pingidentity.saas.prov_pingid.shade.org.apache.hc.core5.http.HttpEntity;
import com.pingidentity.saas.prov_pingid.shade.org.apache.hc.core5.net.URIBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.UnsupportedCharsetException;

public class ApacheHttpRequestBuilder
implements HttpRequestBuilder<HttpUriRequest> {
    private static final IntegrationsLogger logger = new IntegrationsLogger(ApacheHttpRequestBuilder.class);

    public ApacheHttpRequest buildHttpRequest(GenericHttpRequest httpRequest) throws HttpServiceException {
        boolean isPayloadEmpty;
        logger.log(HttpLogEvent.HTTP_BUILDING_REQ);
        URI uri = null;
        try {
            URIBuilder uriBuilder = new URIBuilder(httpRequest.getUrl());
            GenericHttpQueryParams params = httpRequest.getParameters();
            params.forEach(key -> params.get((String)key).forEach(value -> uriBuilder.addParameter((String)key, (String)value)));
            uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new HttpServiceException(String.format("Exception building URI: " + e.getMessage(), e));
        }
        HttpUriRequestBase httpUriRequest = null;
        GenericHttpMethod method = httpRequest.getMethod();
        switch (method) {
            case GET: {
                httpUriRequest = new HttpGet(uri);
                break;
            }
            case POST: {
                httpUriRequest = new HttpPost(uri);
                break;
            }
            case PATCH: {
                httpUriRequest = new HttpPatch(uri);
                break;
            }
            case DELETE: {
                httpUriRequest = new HttpDelete(uri);
                break;
            }
            case PUT: {
                httpUriRequest = new HttpPut(uri);
                break;
            }
            default: {
                throw new HttpServiceException(String.format("Method \"%s\" not supported", method.toString()));
            }
        }
        GenericHttpHeaders headers = httpRequest.getHeaders() != null ? httpRequest.getHeaders() : new GenericHttpHeaders();
        for (String headerKey : headers) {
            httpUriRequest.addHeader(headerKey, headers.get(headerKey));
        }
        GenericHttpBody body = httpRequest.getBody();
        boolean bl = isPayloadEmpty = body == null || body.getContent() == null;
        if (httpUriRequest instanceof HttpUriRequestBase && !isPayloadEmpty) {
            HttpEntity entity = null;
            try {
                ContentType contentType = ContentType.create(body.getMimeType(), body.getCharset());
                entity = EntityBuilder.create().setContentType(contentType).setText(body.getContent()).build();
            }
            catch (UnsupportedCharsetException e) {
                throw new HttpServiceException("Exception Building HTTP Body:" + e.getMessage(), e);
            }
            httpUriRequest.setEntity(entity);
        }
        return new ApacheHttpRequest(httpUriRequest);
    }
}

