/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.http.apache5;

import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.http.GenericHttpBody;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.http.GenericHttpHeaders;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.http.GenericHttpResponse;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.http.HttpResponse;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.http.HttpResponseBuilder;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.http.HttpServiceException;
import com.pingidentity.saas.prov_pingid.shade.org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import com.pingidentity.saas.prov_pingid.shade.org.apache.hc.core5.http.ContentType;
import com.pingidentity.saas.prov_pingid.shade.org.apache.hc.core5.http.Header;
import com.pingidentity.saas.prov_pingid.shade.org.apache.hc.core5.http.HttpEntity;
import com.pingidentity.saas.prov_pingid.shade.org.apache.hc.core5.http.ParseException;
import com.pingidentity.saas.prov_pingid.shade.org.apache.hc.core5.http.io.entity.EntityUtils;
import java.io.IOException;
import java.util.HashMap;

public class ApacheHttpResponseBuilder
implements HttpResponseBuilder<CloseableHttpResponse> {
    @Override
    public GenericHttpResponse build(HttpResponse<CloseableHttpResponse> httpResponse) throws HttpServiceException {
        CloseableHttpResponse apacheHttpResponse = httpResponse.getResponse();
        Integer httpStatusCode = apacheHttpResponse.getCode();
        GenericHttpHeaders headers = this.buildResponseHeaders(apacheHttpResponse);
        GenericHttpBody responseBody = this.buildResponseBody(apacheHttpResponse);
        GenericHttpResponse response = new GenericHttpResponse(headers, responseBody, httpStatusCode);
        return response;
    }

    private GenericHttpBody buildResponseBody(CloseableHttpResponse httpResponse) throws HttpServiceException {
        HttpEntity entity = httpResponse.getEntity();
        if (entity == null) {
            return null;
        }
        String responseBody = null;
        ContentType contentType = null;
        try {
            responseBody = EntityUtils.toString(entity);
            contentType = ContentType.parseLenient(entity.getContentType());
        }
        catch (ParseException | IOException | IllegalArgumentException e) {
            throw new HttpServiceException("An exception occured reading the HTTP payload on the response.", e);
        }
        String mimeType = contentType != null && contentType.getMimeType() != null ? contentType.getMimeType() : null;
        String charset = contentType != null && contentType.getCharset() != null ? contentType.getCharset().toString() : null;
        return new GenericHttpBody(responseBody, mimeType, charset);
    }

    private GenericHttpHeaders buildResponseHeaders(com.pingidentity.saas.prov_pingid.shade.org.apache.hc.core5.http.HttpResponse apacheHttpResponse) {
        Header[] headers = apacheHttpResponse.getHeaders();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        for (Header header : headers) {
            headerMap.put(header.getName(), header.getValue());
        }
        return new GenericHttpHeaders(headerMap);
    }
}

