/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.saas.prov_pingid.shade.org.apache.hc.client5.http.impl.cookie;

import com.pingidentity.saas.prov_pingid.shade.org.apache.hc.client5.http.cookie.CommonCookieAttributeHandler;
import com.pingidentity.saas.prov_pingid.shade.org.apache.hc.client5.http.cookie.MalformedCookieException;
import com.pingidentity.saas.prov_pingid.shade.org.apache.hc.client5.http.cookie.SetCookie;
import com.pingidentity.saas.prov_pingid.shade.org.apache.hc.client5.http.impl.cookie.AbstractCookieAttributeHandler;
import com.pingidentity.saas.prov_pingid.shade.org.apache.hc.core5.annotation.Contract;
import com.pingidentity.saas.prov_pingid.shade.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.pingidentity.saas.prov_pingid.shade.org.apache.hc.core5.util.Args;
import java.util.Date;

@Contract(threading=ThreadingBehavior.STATELESS)
public class BasicMaxAgeHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        int age;
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for 'max-age' attribute");
        }
        try {
            age = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid 'max-age' attribute: " + value);
        }
        if (age < 0) {
            throw new MalformedCookieException("Negative 'max-age' attribute: " + value);
        }
        cookie.setExpiryDate(new Date(System.currentTimeMillis() + (long)age * 1000L));
    }

    @Override
    public String getAttributeName() {
        return "max-age";
    }
}

