/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.saas.wrapper.pingidforworkforce;

import com.pingidentity.integrations.provisioner.pingidforworkforce.ConnectionFieldKey;
import com.pingidentity.integrations.provisioner.pingidforworkforce.ManageDeviceOption;
import com.pingidentity.integrations.provisioner.pingidforworkforce.PrimaryDeviceOption;
import com.pingidentity.integrations.provisioner.pingidforworkforce.ResourceFieldKey;
import com.pingidentity.io.cpl.pingidforworkforce.exception.ResourceException;
import com.pingidentity.io.cpl.pingidforworkforce.exception.ResourcePartiallyModifiedException;
import com.pingidentity.io.cpl.pingidforworkforce.exception.ServiceException;
import com.pingidentity.io.cpl.pingidforworkforce.request.ConnectionFields;
import com.pingidentity.io.cpl.pingidforworkforce.resource.ResourceAttributes;
import com.pingidentity.io.cpl.pingidforworkforce.resource.ResourceUniqueId;
import com.pingidentity.io.cpl.pingidforworkforce.resource.User;
import com.pingidentity.saas.definition.pingidforworkforce.SaasHttpService;
import com.pingidentity.saas.definition.pingidforworkforce.SaasUser;
import com.pingidentity.saas.definition.pingidforworkforce.SaasUserApi;
import com.pingidentity.saas.definition.pingidforworkforce.SaasUserBuilder;
import com.pingidentity.saas.definition.pingidforworkforce.UserRequestBuilder;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.crud.CrudClient;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.crud.CrudException;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.PingIdCredential;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.PingIdDevice;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.PingIdDeviceAttribute;
import com.pingidentity.saas.prov_pingid.shade.org.apache.http.client.methods.HttpUriRequest;
import com.pingidentity.saas.wrapper.pingidforworkforce.DeviceType;
import com.pingidentity.saas.wrapper.pingidforworkforce.ManagedDeviceNickname;
import com.pingidentity.saas.wrapper.pingidforworkforce.Translator;
import com.pingidentity.saas.wrapper.pingidforworkforce.http.serialization.SerializationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PingIDForWorkforceSaasApi
implements SaasUserApi {
    private UserRequestBuilder requestBuilder;
    private SaasHttpService httpService;
    private SaasUserBuilder userBuilder;
    private CrudClient<PingIdCredential, PingIdDevice> deviceClient;
    private Translator<ConnectionFields, Map<PingIdCredential, String>> cfTranslator;

    public PingIDForWorkforceSaasApi(UserRequestBuilder requestBuilder, SaasHttpService httpService, SaasUserBuilder userBuilder, CrudClient<PingIdCredential, PingIdDevice> deviceClient, Translator<ConnectionFields, Map<PingIdCredential, String>> cfTranslator) {
        this.requestBuilder = requestBuilder;
        this.httpService = httpService;
        this.userBuilder = userBuilder;
        this.deviceClient = deviceClient;
        this.cfTranslator = cfTranslator;
    }

    @Override
    public SaasUser createUser(ConnectionFields connectionFields, User user) throws ServiceException, ResourceException, SerializationException {
        HttpUriRequest request = this.requestBuilder.buildCreateUserRequest(connectionFields, user);
        this.httpService.executeFullRequest(user, request, connectionFields);
        user.setResourceUniqueId(new ResourceUniqueId(user.getResourceAttributes().getValueOf(ResourceFieldKey.getPrimaryId().getLabel())));
        ManageDeviceOption manageDeviceOption = this.determineManageDeviceOption(connectionFields);
        if (ManageDeviceOption.MERGE == manageDeviceOption || ManageDeviceOption.OVERWRITE == manageDeviceOption) {
            String primaryDevice = (String)connectionFields.get(ConnectionFieldKey.PRIMARY_DEVICE.getKey());
            Map<PingIdCredential, String> pidCreds = this.cfTranslator.translate(connectionFields);
            ResourceFieldKey primaryDeviceKey = this.getPrimaryDeviceKey(primaryDevice);
            List<PingIdDevice> devicesToCreate = this.buildDevices(user.getResourceAttributes(), primaryDeviceKey);
            for (PingIdDevice device : devicesToCreate) {
                try {
                    this.deviceClient.create(pidCreds, device);
                }
                catch (CrudException e) {
                    throw new ResourcePartiallyModifiedException(user, "There was a problem creating the user's devices: " + e.getMessage());
                }
            }
        }
        return this.getUserBySaasGuid(connectionFields, user);
    }

    @Override
    public SaasUser getUserBySaasGuid(ConnectionFields connectionFields, User user) throws ResourceException, ServiceException, SerializationException {
        HttpUriRequest request = this.requestBuilder.buildGetUserRequest(connectionFields, user.getResourceUniqueId());
        String userString = this.httpService.executeFullRequest(user, request, connectionFields);
        return this.userBuilder.buildUser(userString, user, connectionFields);
    }

    @Override
    public SaasUser updateUser(ConnectionFields connectionFields, User user) throws ServiceException, ResourceException, SerializationException {
        HttpUriRequest request = this.requestBuilder.buildUpdateUserRequest(connectionFields, user);
        this.httpService.executeFullRequest(user, request, connectionFields);
        ManageDeviceOption mdo = this.determineManageDeviceOption(connectionFields);
        if (ManageDeviceOption.NONE != mdo) {
            try {
                this.updateDevices(mdo, connectionFields, user.getResourceAttributes());
            }
            catch (CrudException e) {
                throw new ResourcePartiallyModifiedException(user, "An error occurred updating devices: " + e.getMessage());
            }
        }
        return this.getUserBySaasGuid(connectionFields, user);
    }

    @Override
    public void deleteUser(ConnectionFields connectionFields, User user) throws ServiceException, ResourceException, SerializationException {
        HttpUriRequest request = this.requestBuilder.buildDeleteUserRequest(connectionFields, user.getResourceUniqueId());
        this.httpService.executeFullRequest(user, request, connectionFields);
    }

    @Override
    public void checkConnection(ConnectionFields connectionFields) throws ServiceException, SerializationException {
        try {
            HttpUriRequest request = this.requestBuilder.buildGetUserRequest(connectionFields, new ResourceUniqueId("id"));
            this.httpService.executeFullRequest(new User(), request, connectionFields);
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
    }

    @Override
    public void activateOrSuspendUser(ConnectionFields connectionFields, User user) throws ServiceException, ResourceException, SerializationException {
        HttpUriRequest request = this.requestBuilder.buildActivateOrSuspendUserRequest(connectionFields, user);
        this.httpService.executeFullRequest(user, request, connectionFields);
    }

    private List<PingIdDevice> buildDevices(ResourceAttributes ra, ResourceFieldKey primaryDeviceKey) {
        String username = ra.getValueOf(ResourceFieldKey.USERNAME.getLabel());
        ArrayList<PingIdDevice> devices = new ArrayList<PingIdDevice>();
        for (ResourceFieldKey rfk : this.getMfaAttributes()) {
            boolean isPrimaryDevice = rfk.equals((Object)primaryDeviceKey);
            String mfaDeviceValue = ra.getValueOf(rfk.getLabel());
            if (mfaDeviceValue == null || mfaDeviceValue.isEmpty()) continue;
            PingIdDevice device = this.buildDevice(username, isPrimaryDevice, rfk, mfaDeviceValue);
            devices.add(device);
        }
        return devices;
    }

    private PingIdDevice buildDevice(String username, boolean isPrimary, ResourceFieldKey deviceRfk, String mfaDeviceValue) {
        PingIdDevice device = new PingIdDevice();
        device.add(PingIdDeviceAttribute.USERNAME, username);
        DeviceType type = this.getDeviceType(deviceRfk);
        device.add(PingIdDeviceAttribute.TYPE, type != null ? type.getValue() : DeviceType.EMAIL.getValue());
        device.add(PingIdDeviceAttribute.PRIMARY, Boolean.toString(isPrimary));
        device.add(PingIdDeviceAttribute.NICKNAME, this.getLocalDeviceNickname(deviceRfk));
        device.add(PingIdDeviceAttribute.PAIRING_DATA, mfaDeviceValue);
        return device;
    }

    private Collection<ResourceFieldKey> getMfaAttributes() {
        ArrayList<ResourceFieldKey> deviceRfks = new ArrayList<ResourceFieldKey>();
        deviceRfks.add(ResourceFieldKey.MFA_EMAIL_1);
        deviceRfks.add(ResourceFieldKey.MFA_EMAIL_2);
        deviceRfks.add(ResourceFieldKey.MFA_EMAIL_3);
        deviceRfks.add(ResourceFieldKey.MFA_SMS_1);
        deviceRfks.add(ResourceFieldKey.MFA_SMS_2);
        deviceRfks.add(ResourceFieldKey.MFA_SMS_3);
        deviceRfks.add(ResourceFieldKey.MFA_VOICE_1);
        deviceRfks.add(ResourceFieldKey.MFA_VOICE_2);
        deviceRfks.add(ResourceFieldKey.MFA_VOICE_3);
        return deviceRfks;
    }

    private DeviceType getDeviceType(ResourceFieldKey rfk) {
        if (rfk == null) {
            return null;
        }
        switch (rfk) {
            case MFA_EMAIL_1: 
            case MFA_EMAIL_2: 
            case MFA_EMAIL_3: {
                return DeviceType.EMAIL;
            }
            case MFA_SMS_1: 
            case MFA_SMS_2: 
            case MFA_SMS_3: {
                return DeviceType.SMS;
            }
            case MFA_VOICE_1: 
            case MFA_VOICE_2: 
            case MFA_VOICE_3: {
                return DeviceType.VOICE;
            }
        }
        return null;
    }

    private ResourceFieldKey getPrimaryDeviceKey(String value) {
        if (value == null) {
            return null;
        }
        if (PrimaryDeviceOption.EMAIL.getValue().equalsIgnoreCase(value)) {
            return ResourceFieldKey.MFA_EMAIL_1;
        }
        if (PrimaryDeviceOption.SMS.getValue().equalsIgnoreCase(value)) {
            return ResourceFieldKey.MFA_SMS_1;
        }
        if (PrimaryDeviceOption.VOICE.getValue().equalsIgnoreCase(value)) {
            return ResourceFieldKey.MFA_VOICE_1;
        }
        return null;
    }

    private boolean areDevicesEqual(PingIdDevice local, PingIdDevice remote) {
        if (local == null && remote == null) {
            return true;
        }
        if (local == null || remote == null) {
            return false;
        }
        String localType = remote.getOne(PingIdDeviceAttribute.TYPE);
        String remoteType = remote.getOne(PingIdDeviceAttribute.TYPE);
        if (localType == null || !localType.equalsIgnoreCase(remoteType)) {
            return false;
        }
        String localNickname = local.getOne(PingIdDeviceAttribute.NICKNAME);
        String remoteNickname = remote.getOne(PingIdDeviceAttribute.NICKNAME);
        if (localNickname == null || !localNickname.equalsIgnoreCase(remoteNickname)) {
            return false;
        }
        String localPairingData = local.getOne(PingIdDeviceAttribute.PAIRING_DATA);
        localPairingData = localPairingData != null && !localType.equalsIgnoreCase(DeviceType.EMAIL.getValue()) ? localPairingData.replaceAll("[^0-9]", "") : localPairingData;
        String remotePairingData = remote.getOne(PingIdDeviceAttribute.PAIRING_DATA);
        String string = remotePairingData = remotePairingData != null && !remoteType.equalsIgnoreCase(DeviceType.EMAIL.getValue()) ? remotePairingData.replaceAll("[^0-9]", "") : remotePairingData;
        return localPairingData != null && localPairingData.equalsIgnoreCase(remotePairingData);
    }

    private void updateDevices(ManageDeviceOption mdo, ConnectionFields cf, ResourceAttributes ra) throws CrudException {
        List<PingIdDevice> localDevices = this.buildDevices(ra, null);
        Map<PingIdCredential, String> deviceClientCreds = this.cfTranslator.translate(cf);
        PingIdDevice searchDevice = new PingIdDevice();
        searchDevice.add(PingIdDeviceAttribute.USERNAME, ra.getValueOf(ResourceFieldKey.USERNAME.getLabel()));
        List<PingIdDevice> remoteDevices = this.deviceClient.search(this.cfTranslator.translate(cf), searchDevice);
        if (ManageDeviceOption.OVERWRITE == mdo) {
            for (PingIdDevice remoteDevice : remoteDevices) {
                if (this.devicesContainsDevice(remoteDevice, localDevices)) continue;
                this.deviceClient.delete(deviceClientCreds, remoteDevice);
            }
            for (PingIdDevice localDevice : localDevices) {
                if (this.devicesContainsDevice(localDevice, remoteDevices)) continue;
                this.deviceClient.create(deviceClientCreds, localDevice);
            }
        }
        if (ManageDeviceOption.MERGE == mdo) {
            Set managedNicknames = this.getMfaAttributes().stream().map(rfk -> this.getLocalDeviceNickname((ResourceFieldKey)((Object)rfk))).collect(Collectors.toSet());
            List managedRemoteDevices = remoteDevices.stream().filter(rd -> managedNicknames.contains(rd.getOne(PingIdDeviceAttribute.NICKNAME))).collect(Collectors.toList());
            for (PingIdDevice remoteDevice : managedRemoteDevices) {
                if (this.devicesContainsDevice(remoteDevice, localDevices)) continue;
                this.deviceClient.delete(deviceClientCreds, remoteDevice);
            }
            for (PingIdDevice localDevice : localDevices) {
                if (this.devicesContainsDevice(localDevice, remoteDevices)) continue;
                this.deviceClient.create(deviceClientCreds, localDevice);
            }
        }
    }

    private ManageDeviceOption determineManageDeviceOption(ConnectionFields cf) {
        String value = (String)cf.get(ConnectionFieldKey.MANAGE_DEVICES.getKey());
        if (ManageDeviceOption.MERGE.getValue().equalsIgnoreCase(value)) {
            return ManageDeviceOption.MERGE;
        }
        if (ManageDeviceOption.OVERWRITE.getValue().equalsIgnoreCase(value)) {
            return ManageDeviceOption.OVERWRITE;
        }
        return ManageDeviceOption.NONE;
    }

    private boolean devicesContainsDevice(PingIdDevice localDevice, Collection<PingIdDevice> remoteDevices) {
        for (PingIdDevice remoteDevice : remoteDevices) {
            if (!this.areDevicesEqual(localDevice, remoteDevice)) continue;
            return true;
        }
        return false;
    }

    private String getLocalDeviceNickname(ResourceFieldKey rfk) {
        switch (rfk) {
            case MFA_EMAIL_1: {
                return ManagedDeviceNickname.EMAIL_1.getNickname();
            }
            case MFA_EMAIL_2: {
                return ManagedDeviceNickname.EMAIL_2.getNickname();
            }
            case MFA_EMAIL_3: {
                return ManagedDeviceNickname.EMAIL_3.getNickname();
            }
            case MFA_SMS_1: {
                return ManagedDeviceNickname.SMS_1.getNickname();
            }
            case MFA_SMS_2: {
                return ManagedDeviceNickname.SMS_2.getNickname();
            }
            case MFA_SMS_3: {
                return ManagedDeviceNickname.SMS_3.getNickname();
            }
            case MFA_VOICE_1: {
                return ManagedDeviceNickname.VOICE_1.getNickname();
            }
            case MFA_VOICE_2: {
                return ManagedDeviceNickname.VOICE_2.getNickname();
            }
            case MFA_VOICE_3: {
                return ManagedDeviceNickname.VOICE_3.getNickname();
            }
        }
        return "";
    }
}

