/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.saas.wrapper.pingidforworkforce.http;

import com.pingidentity.io.cpl.pingidforworkforce.exception.ResourceException;
import com.pingidentity.io.cpl.pingidforworkforce.exception.ServiceException;
import com.pingidentity.io.cpl.pingidforworkforce.exception.ServiceUnavailableException;
import com.pingidentity.io.cpl.pingidforworkforce.request.ConnectionFields;
import com.pingidentity.io.cpl.pingidforworkforce.resource.Resource;
import com.pingidentity.saas.definition.pingidforworkforce.SaasHttpService;
import com.pingidentity.saas.prov_pingid.shade.org.apache.http.HttpEntity;
import com.pingidentity.saas.prov_pingid.shade.org.apache.http.client.methods.CloseableHttpResponse;
import com.pingidentity.saas.prov_pingid.shade.org.apache.http.client.methods.HttpUriRequest;
import com.pingidentity.saas.prov_pingid.shade.org.apache.http.impl.client.CloseableHttpClient;
import com.pingidentity.saas.prov_pingid.shade.org.apache.http.util.EntityUtils;
import com.pingidentity.saas.wrapper.pingidforworkforce.http.HttpClientFactory;
import com.pingidentity.saas.wrapper.pingidforworkforce.http.Validator;
import com.pingidentity.saas.wrapper.pingidforworkforce.http.serialization.SerializationException;
import java.io.IOException;

public class PingIDForWorkforceHttpService
implements SaasHttpService {
    private final Validator validator;
    private HttpClientFactory clientFactory;

    public PingIDForWorkforceHttpService(Validator validator, HttpClientFactory clientFactory) {
        this.validator = validator;
        this.clientFactory = clientFactory;
    }

    @Override
    public String executeFullRequest(Resource resource, HttpUriRequest request, ConnectionFields connectionFields) throws ServiceException, ResourceException, SerializationException {
        CloseableHttpClient httpClient = this.clientFactory.buildClient();
        CloseableHttpResponse response = null;
        HttpEntity entity = null;
        String body = "";
        try {
            response = httpClient.execute(request);
            this.validator.validateFullRequest(resource, response, connectionFields);
            entity = response.getEntity();
            if (entity != null) {
                body = EntityUtils.toString(entity);
            }
        }
        catch (IOException e) {
            try {
                throw new ServiceUnavailableException(String.format("There was a problem with the HTTP Request sent to PingIDForWorkforce, PingIDForWorkforce responded with the message: %s", e.getMessage()));
            }
            catch (Throwable throwable) {
                this.tidyUpHttpClient(httpClient, response, entity);
                throw throwable;
            }
        }
        this.tidyUpHttpClient(httpClient, response, entity);
        return body;
    }

    @Override
    public String executeServiceOnlyRequest(Resource resource, HttpUriRequest request, ConnectionFields connectionFields) throws ServiceException, SerializationException {
        CloseableHttpClient httpClient = this.clientFactory.buildClient();
        CloseableHttpResponse response = null;
        HttpEntity entity = null;
        String body = "";
        try {
            response = httpClient.execute(request);
            this.validator.validateServiceRequest(resource, response, connectionFields);
            entity = response.getEntity();
            if (entity != null) {
                body = EntityUtils.toString(entity);
            }
        }
        catch (IOException e) {
            try {
                throw new ServiceUnavailableException(String.format("There was a problem with the HTTP Request sent to PingIDForWorkforce, PingIDForWorkforce responded with the message: %s", e.getMessage()));
            }
            catch (Throwable throwable) {
                this.tidyUpHttpClient(httpClient, response, entity);
                throw throwable;
            }
        }
        this.tidyUpHttpClient(httpClient, response, entity);
        return body;
    }

    private void tidyUpHttpClient(CloseableHttpClient httpClient, CloseableHttpResponse response, HttpEntity entity) throws ServiceUnavailableException {
        if (entity != null) {
            EntityUtils.consumeQuietly(entity);
        }
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException e) {
                throw new ServiceUnavailableException(String.format("There was a problem closing the PingIDForWorkforce http response: %s", e.getMessage()));
            }
        }
        if (httpClient != null) {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                throw new ServiceUnavailableException(String.format("There was a problem closing the http client: %2s", e.getMessage()));
            }
        }
    }
}

