/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.saas.wrapper.pingidforworkforce.resource_builder.deserialization;

import com.pingidentity.integrations.provisioner.pingidforworkforce.ConnectionFieldKey;
import com.pingidentity.integrations.provisioner.pingidforworkforce.ResourceFieldKey;
import com.pingidentity.io.cpl.pingidforworkforce.exception.ResourceException;
import com.pingidentity.io.cpl.pingidforworkforce.exception.ResourceUnknownStateException;
import com.pingidentity.io.cpl.pingidforworkforce.request.ConnectionFields;
import com.pingidentity.io.cpl.pingidforworkforce.resource.User;
import com.pingidentity.saas.prov_pingid.shade.com.google.gson.Gson;
import com.pingidentity.saas.prov_pingid.shade.com.google.gson.JsonSyntaxException;
import com.pingidentity.saas.prov_pingid.shade.org.jose4j.base64url.Base64;
import com.pingidentity.saas.prov_pingid.shade.org.jose4j.jws.JsonWebSignature;
import com.pingidentity.saas.prov_pingid.shade.org.jose4j.keys.HmacKey;
import com.pingidentity.saas.wrapper.pingidforworkforce.resource_builder.deserialization.DeserializationException;
import com.pingidentity.saas.wrapper.pingidforworkforce.resource_builder.deserialization.Deserializer;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class PingIDForWorkforceDeserializer
implements Deserializer {
    private Gson gson = new Gson();

    @Override
    public <T> T deserialize(String input, Class<T> outputType) throws DeserializationException {
        try {
            T object = this.gson.fromJson(input, outputType);
            return object;
        }
        catch (JsonSyntaxException e) {
            throw new DeserializationException(e.getMessage(), e);
        }
    }

    @Override
    public String decryptJSON(String responseToken, User user, ConnectionFields connectionFields) throws ResourceException {
        JSONParser parser = new JSONParser();
        JSONObject responsePayloadJSON = null;
        String returnString = null;
        try {
            JsonWebSignature responseJWS = new JsonWebSignature();
            responseJWS.setCompactSerialization(responseToken);
            HmacKey key = new HmacKey(Base64.decode((String)connectionFields.get(ConnectionFieldKey.BASE64_KEY.getKey())));
            responseJWS.setKey(key);
            responsePayloadJSON = (JSONObject)parser.parse(responseJWS.getPayload());
            if (responsePayloadJSON.containsKey((Object)"responseBody")) {
                responsePayloadJSON = (JSONObject)responsePayloadJSON.get((Object)"responseBody");
            }
        }
        catch (Exception e) {
            throw new ResourceUnknownStateException(user, String.format("Unable to parse Response Token: %s.", e.getMessage()), user.getResourceAttributes().getValueOf(ResourceFieldKey.USERNAME.getLabel()));
        }
        if (responsePayloadJSON != null) {
            JSONObject userDetails = (JSONObject)responsePayloadJSON.get((Object)"userDetails");
            returnString = userDetails.toString();
        }
        return returnString;
    }
}

