/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins.datastore.p14c;

import com.pingidentity.plugins.datastore.p14c.CustomExpressionEvaluatorResult;
import com.pingidentity.plugins.datastore.p14c.CustomExpressionVariable;
import com.pingidentity.plugins.datastore.p14c.DataStoreLogEvent;
import com.pingidentity.plugins.datastore.p14c.exception.InvalidCustomExpressionException;
import com.pingidentity.plugins.datastore.p14c.shade.com.fasterxml.jackson.databind.JsonNode;
import com.pingidentity.plugins.datastore.p14c.shade.com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.plugins.datastore.p14c.shade.com.fasterxml.jackson.databind.node.MissingNode;
import com.pingidentity.plugins.datastore.p14c.shade.com.fasterxml.jackson.databind.node.NullNode;
import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.integrations.logger.LogEvent;
import com.pingidentity.plugins.datastore.p14c.util.DataSourceUtils;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CustomExpressionEvaluator {
    public static String PERIOD = ".";
    private static final IntegrationsLogger logger = new IntegrationsLogger(CustomExpressionEvaluator.class);
    public String searchExpression = null;

    public CustomExpressionEvaluator() {
    }

    public CustomExpressionEvaluator(String searchExpression) {
        this.searchExpression = searchExpression;
    }

    public String getSearchExpression() {
        return this.searchExpression;
    }

    public void setSearchExpression(String searchExpression) {
        this.searchExpression = searchExpression;
    }

    public boolean validateSearchExpression() {
        if (this.searchExpression == null || this.searchExpression.isEmpty() || this.searchExpression.endsWith(PERIOD)) {
            return false;
        }
        try {
            Deque<CustomExpressionVariable> customExpressionVariableStack = this.parseExpression();
            if (customExpressionVariableStack.isEmpty()) {
                return false;
            }
        }
        catch (InvalidCustomExpressionException ice) {
            return false;
        }
        return true;
    }

    private Deque<CustomExpressionVariable> parseExpression() throws InvalidCustomExpressionException {
        boolean isQuotationComponent = false;
        boolean isBracketComponent = false;
        StringBuilder variableName = new StringBuilder();
        ArrayDeque<CustomExpressionVariable> customExpressionVariableStack = new ArrayDeque<CustomExpressionVariable>();
        boolean justProcessedArrayElement = false;
        for (int index = 0; index < this.searchExpression.length(); ++index) {
            CustomExpressionVariable CustomExpressionVariable2;
            char charValue = this.searchExpression.charAt(index);
            if (charValue == '\"') {
                if (isQuotationComponent) {
                    isQuotationComponent = false;
                    if (!justProcessedArrayElement && variableName.toString().trim().isEmpty()) {
                        logger.log((LogEvent)DataStoreLogEvent.INVALID_EXPRESSION, this.searchExpression);
                        throw new InvalidCustomExpressionException("Invalid expression");
                    }
                    CustomExpressionVariable2 = new CustomExpressionVariable(variableName.toString().trim());
                    customExpressionVariableStack.push(CustomExpressionVariable2);
                    variableName.delete(0, variableName.length());
                    continue;
                }
                isQuotationComponent = true;
                continue;
            }
            if (charValue == '.') {
                if (isQuotationComponent && justProcessedArrayElement) {
                    logger.log((LogEvent)DataStoreLogEvent.INVALID_EXPRESSION, this.searchExpression);
                    throw new InvalidCustomExpressionException("Invalid expression");
                }
                if (justProcessedArrayElement) {
                    justProcessedArrayElement = false;
                }
                if (isQuotationComponent) {
                    variableName.append(charValue);
                    continue;
                }
                if (variableName.toString().isEmpty()) continue;
                CustomExpressionVariable2 = new CustomExpressionVariable(variableName.toString().trim());
                customExpressionVariableStack.push(CustomExpressionVariable2);
                variableName.delete(0, variableName.length());
                continue;
            }
            if (charValue == '[') {
                if (!variableName.toString().isEmpty()) {
                    CustomExpressionVariable2 = new CustomExpressionVariable(variableName.toString().trim());
                    customExpressionVariableStack.push(CustomExpressionVariable2);
                    variableName.delete(0, variableName.length());
                }
                isBracketComponent = true;
                continue;
            }
            if (charValue == ']') {
                if (!isBracketComponent) {
                    logger.log((LogEvent)DataStoreLogEvent.INVALID_EXPRESSION, this.searchExpression);
                    throw new InvalidCustomExpressionException("Invalid expression");
                }
                isBracketComponent = false;
                if (variableName.toString().isEmpty()) {
                    logger.log((LogEvent)DataStoreLogEvent.INVALID_EXPRESSION, this.searchExpression);
                    throw new InvalidCustomExpressionException("Invalid expression");
                }
                CustomExpressionVariable2 = (CustomExpressionVariable)customExpressionVariableStack.pop();
                CustomExpressionVariable2.setArrayElement(true);
                try {
                    CustomExpressionVariable2.setArrayIndex(Integer.parseInt(variableName.toString().trim()));
                    justProcessedArrayElement = true;
                }
                catch (NumberFormatException nfe) {
                    logger.log((LogEvent)DataStoreLogEvent.INVALID_EXPRESSION, this.searchExpression);
                    throw new InvalidCustomExpressionException("Invalid expression: " + nfe.getMessage());
                }
                customExpressionVariableStack.push(CustomExpressionVariable2);
                variableName.delete(0, variableName.length());
                continue;
            }
            variableName.append(charValue);
        }
        if (justProcessedArrayElement && !variableName.toString().isEmpty()) {
            logger.log((LogEvent)DataStoreLogEvent.INVALID_EXPRESSION, this.searchExpression);
            throw new InvalidCustomExpressionException("Invalid expression");
        }
        if (!variableName.toString().isEmpty()) {
            CustomExpressionVariable CustomExpressionVariable3 = new CustomExpressionVariable(variableName.toString());
            customExpressionVariableStack.push(CustomExpressionVariable3);
            variableName.delete(0, variableName.length());
        }
        if (isQuotationComponent || isBracketComponent || !variableName.toString().isEmpty()) {
            logger.log((LogEvent)DataStoreLogEvent.INVALID_EXPRESSION, this.searchExpression);
            throw new InvalidCustomExpressionException("Invalid expression");
        }
        return customExpressionVariableStack;
    }

    public boolean validateJsonPointerExpression() {
        if (this.searchExpression == null || this.searchExpression.isEmpty()) {
            return false;
        }
        return this.searchExpression.startsWith("/");
    }

    public CustomExpressionEvaluatorResult evaluateJsonPointer(String jsonDataString) {
        logger.log((LogEvent)DataStoreLogEvent.EVALUATING_EXPRESSION, this.searchExpression);
        JsonNode result = null;
        if (jsonDataString == null || this.searchExpression == null || jsonDataString.isEmpty() || this.searchExpression.isEmpty()) {
            logger.log(DataStoreLogEvent.INVALID_CRITERIA);
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode root = mapper.readTree(jsonDataString);
            result = root.at(this.searchExpression);
            if (result instanceof MissingNode || result instanceof NullNode) {
                result = null;
            }
        }
        catch (IOException e) {
            logger.log((LogEvent)DataStoreLogEvent.RETRIEVE_ERROR, this.searchExpression);
        }
        logger.log((LogEvent)DataStoreLogEvent.RETRIEVED_RESULT, result);
        CustomExpressionEvaluatorResult validatorResult = new CustomExpressionEvaluatorResult();
        validatorResult.setResult(result);
        return validatorResult;
    }

    public CustomExpressionEvaluatorResult evaluateCustomExpression(String jsonString) throws InvalidCustomExpressionException, JSONException {
        logger.log((LogEvent)DataStoreLogEvent.EVALUATING_EXPRESSION, this.searchExpression);
        Map<String, Object> result = null;
        if (jsonString == null || this.searchExpression == null || jsonString.isEmpty() || this.searchExpression.isEmpty()) {
            logger.log(DataStoreLogEvent.INVALID_CRITERIA);
            return null;
        }
        Deque<CustomExpressionVariable> customExpressionVariableStack = this.parseExpression();
        String resultKey = customExpressionVariableStack.getFirst().getKey();
        Object jsonObject = new JSONObject(jsonString);
        while (!customExpressionVariableStack.isEmpty()) {
            JSONArray jsonArray;
            CustomExpressionVariable variable = customExpressionVariableStack.removeLast();
            if (!variable.isArrayElement()) {
                if (customExpressionVariableStack.isEmpty()) {
                    if (!jsonObject.has(variable.getKey())) break;
                    if ((jsonObject = jsonObject.get(variable.getKey())) instanceof JSONArray) {
                        result = DataSourceUtils.getListObject((JSONArray)jsonObject);
                        continue;
                    }
                    if (jsonObject instanceof JSONObject) {
                        result = DataSourceUtils.getMapObject((JSONObject)jsonObject);
                        continue;
                    }
                    result = jsonObject.toString();
                    continue;
                }
                if (!jsonObject.has(variable.getKey())) break;
                jsonObject = jsonObject.get(variable.getKey());
                continue;
            }
            if (!jsonObject.has(variable.getKey()) || !(jsonObject.get(variable.getKey()) instanceof JSONArray) || (jsonArray = jsonObject.getJSONArray(variable.getKey())).length() <= variable.getArrayIndex()) break;
            jsonObject = jsonArray.get(variable.getArrayIndex());
            if (!customExpressionVariableStack.isEmpty()) continue;
            if (jsonObject instanceof JSONArray) {
                result = DataSourceUtils.getListObject((JSONArray)jsonObject);
                continue;
            }
            if (jsonObject instanceof String) {
                result = jsonObject;
                continue;
            }
            result = DataSourceUtils.getMapObject((JSONObject)jsonObject);
        }
        logger.log((LogEvent)DataStoreLogEvent.RETRIEVED_RESULT, result);
        CustomExpressionEvaluatorResult validatorResult = new CustomExpressionEvaluatorResult();
        validatorResult.setKey(resultKey);
        validatorResult.setResult(result);
        return validatorResult;
    }
}

