/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins.datastore.p14c;

import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.common.http.apache5.ApacheHttpClient;
import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.common.http.apache5.ApacheHttpClientFactory;
import com.pingidentity.plugins.datastore.p14c.shade.org.apache.hc.client5.http.config.RequestConfig;
import com.pingidentity.plugins.datastore.p14c.shade.org.apache.hc.client5.http.impl.classic.HttpClients;
import com.pingidentity.plugins.datastore.p14c.shade.org.apache.hc.core5.http.HttpHost;
import com.pingidentity.plugins.datastore.p14c.shade.org.apache.hc.core5.util.Timeout;
import com.pingidentity.plugins.datastore.p14c.util.StringUtils;

public class CustomHttpClientFactory
extends ApacheHttpClientFactory {
    private int requestTimeout;
    private String proxySettings;
    private String proxyHost;
    private int proxyPort;

    public CustomHttpClientFactory setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public CustomHttpClientFactory setProxySettings(String proxySettings) {
        this.proxySettings = proxySettings;
        return this;
    }

    public CustomHttpClientFactory setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        return this;
    }

    public CustomHttpClientFactory setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    @Override
    public ApacheHttpClient make() {
        if (StringUtils.isBlank(this.proxySettings)) {
            throw new IllegalArgumentException();
        }
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(Timeout.ofMilliseconds(this.requestTimeout)).setResponseTimeout(Timeout.ofMilliseconds(this.requestTimeout)).build();
        if ("No Proxy".equals(this.proxySettings)) {
            return new ApacheHttpClient(HttpClients.custom().setDefaultRequestConfig(requestConfig).setUserAgent("PingFederate").build());
        }
        if ("System Defaults".equals(this.proxySettings)) {
            return new ApacheHttpClient(HttpClients.custom().setDefaultRequestConfig(requestConfig).setUserAgent("PingFederate").useSystemProperties().build());
        }
        return new ApacheHttpClient(HttpClients.custom().setDefaultRequestConfig(requestConfig).setUserAgent("PingFederate").setProxy(new HttpHost(this.proxyHost, this.proxyPort)).build());
    }
}

