/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins.datastore.p14c;

import com.pingidentity.pingone.api.AccessTokenResponse;
import com.pingidentity.pingone.impl.AccessTokenHolder;
import com.pingidentity.plugins.datastore.p14c.CustomHttpClientFactory;
import com.pingidentity.plugins.datastore.p14c.DataStoreLogEvent;
import com.pingidentity.plugins.datastore.p14c.ExponentialBackOffCalculator;
import com.pingidentity.plugins.datastore.p14c.RequestResponse;
import com.pingidentity.plugins.datastore.p14c.configuration.DataStoreConfiguration;
import com.pingidentity.plugins.datastore.p14c.configuration.Region;
import com.pingidentity.plugins.datastore.p14c.exception.AccessTokenProviderException;
import com.pingidentity.plugins.datastore.p14c.exception.PingOneDataStoreException;
import com.pingidentity.plugins.datastore.p14c.shade.com.fasterxml.jackson.annotation.JsonInclude;
import com.pingidentity.plugins.datastore.p14c.shade.com.fasterxml.jackson.databind.DeserializationFeature;
import com.pingidentity.plugins.datastore.p14c.shade.com.fasterxml.jackson.databind.JsonNode;
import com.pingidentity.plugins.datastore.p14c.shade.com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.plugins.datastore.p14c.shade.com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.common.http.GenericHttpBody;
import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.common.http.GenericHttpHeaders;
import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.common.http.GenericHttpMethod;
import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.common.http.GenericHttpQueryParams;
import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.common.http.GenericHttpRequest;
import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.common.http.GenericHttpResponse;
import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.common.http.HttpService;
import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.common.http.HttpServiceException;
import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.common.http.apache5.ApacheHttpRequestBuilder;
import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.common.http.apache5.ApacheHttpResponseBuilder;
import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.common.http.apache5.ApacheHttpServiceFactory;
import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.integrations.logger.LogEvent;
import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.util.JsonNodeUtil;
import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.util.JsonPointerUtil;
import com.pingidentity.plugins.datastore.p14c.shade.org.apache.hc.core5.http.ContentType;
import com.pingidentity.plugins.datastore.p14c.util.DataSourceUtils;
import com.pingidentity.plugins.datastore.p14c.util.ReflectivePingOneEnvironmentAccessor;
import com.pingidentity.plugins.datastore.p14c.util.StringUtils;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.GuiConfigDescriptorBuilder;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sources.ConfigurableDriver;
import com.pingidentity.sources.CustomDataSourceDriver;
import com.pingidentity.sources.CustomDataSourceDriverDescriptor;
import com.pingidentity.sources.SourceDescriptor;
import com.pingidentity.sources.gui.FilterFieldsGuiDescriptor;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.SimpleFieldList;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.gui.AdapterConfigurationGuiDescriptor;

public class PingOneForCustomersDataStore
implements CustomDataSourceDriver {
    public static final String TOKEN_ENDPOINT = "/as/token";
    public static final String ENVIRONMENTS_ENDPOINT = "/environments";
    public static final String USERS_ENDPOINT = "/users";
    private static final String DEVICES_ENDPOINT = "/devices";
    private static final String GROUP_QUERY_PARAM = "include=memberOfGroupNames,memberOfGroupIDs";
    private String pingOneEnvironment;
    private ReflectivePingOneEnvironmentAccessor pingOneEnvironmentAccessor;
    private String baseUrl = "PingOne API Service";
    private String tokenServerUrl = "PingOne Authorization Service";
    private String environmentId = "Environment ID";
    private String environmentIdEndpoint = "Environment ID Endpoint";
    private String clientId = "Client ID";
    private String clientSecret = "Client Secret";
    private int maxRetriesAttempt = 5;
    private boolean retryRequest;
    private boolean retrieveUserGroupInfo = true;
    private boolean retrieveDeviceInfo = true;
    private List<String> errorCodeForRetries = new ArrayList<String>();
    private Map<String, String> customAttributesTable = new HashMap<String, String>();
    private final CustomDataSourceDriverDescriptor descriptor;
    private static ObjectMapper mapper;
    private AccessTokenHolder accessTokenHolder = new AccessTokenHolder();
    private HttpService httpService;
    ExponentialBackOffCalculator backoffCalculator = new ExponentialBackOffCalculator();
    private static final IntegrationsLogger logger;
    private static final Set<String> CORE_ATTRIBUTES;
    private static boolean supportsSetMetadata;
    private static boolean supportsPluginServiceAssociation;
    static boolean isPingFederate92AndAbove;

    public PingOneForCustomersDataStore() {
        FilterFieldsGuiDescriptor filterFieldsDescriptor = DataStoreConfiguration.getFilterFieldsGuiDescriptor();
        AdapterConfigurationGuiDescriptor dataStoreConfigGuiDesc = DataStoreConfiguration.getAdapterConfigurationGuiDescriptor();
        if (isPingFederate92AndAbove) {
            this.descriptor = new CustomDataSourceDriverDescriptor((ConfigurableDriver)this, "PingOne Data Store 2.7", dataStoreConfigGuiDesc, filterFieldsDescriptor, false){

                public GuiConfigDescriptorBuilder getGuiConfigDescriptorBuilder() {
                    return new GuiConfigDescriptorBuilder(){

                        public GuiConfigDescriptor buildNewGuiDescriptor() {
                            return DataStoreConfiguration.getAdapterConfigurationGuiDescriptor();
                        }

                        public GuiConfigDescriptor buildConfiguredGuiDescriptor(Configuration configuration) {
                            return DataStoreConfiguration.getAdapterConfigurationGuiDescriptor(configuration);
                        }
                    };
                }
            };
            if (supportsSetMetadata && supportsPluginServiceAssociation) {
                try {
                    Class<?> pluginMetadataKeysClass = Class.forName("com.pingidentity.sdk.PluginMetadataKeys");
                    Class<?> pluginServiceAssociationClass = Class.forName("com.pingidentity.sdk.PluginServiceAssociation");
                    Constructor<?> pluginServiceAssociationConstructor = pluginServiceAssociationClass.getConstructor(String.class, String.class);
                    this.descriptor.setMetadata(Collections.singletonMap((String)pluginMetadataKeysClass.getField("PING_ONE_SERVICE_ASSOCIATION").get(null), pluginServiceAssociationConstructor.newInstance("Data Store", pluginServiceAssociationClass.getField("DIRECTORY_SERVICE_DISPLAY_NAME").get(null))));
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            this.descriptor = new CustomDataSourceDriverDescriptor((ConfigurableDriver)this, "PingOne Data Store 2.7", dataStoreConfigGuiDesc, filterFieldsDescriptor);
        }
    }

    public PingOneForCustomersDataStore(Configuration configuration, HttpService httpService) {
        this.configure(configuration);
        this.descriptor = new CustomDataSourceDriverDescriptor((ConfigurableDriver)this, "PingOne Data Store 2.7", null, null, false);
        this.httpService = httpService;
    }

    public SourceDescriptor getSourceDescriptor() {
        return this.descriptor;
    }

    public void configure(Configuration configuration) {
        this.configureP1Environment(configuration);
        this.configureApiRetries(configuration);
        this.configureHttpService(configuration);
        this.configureCustomAttributesTable(configuration);
        if (configuration.getField("Enable User Group Info Retrieval") != null) {
            this.retrieveUserGroupInfo = configuration.getBooleanFieldValue("Enable User Group Info Retrieval");
        }
        if (configuration.getField("Enable Device Info Retrieval") != null) {
            this.retrieveDeviceInfo = configuration.getBooleanFieldValue("Enable Device Info Retrieval");
        }
    }

    private void configureHttpService(Configuration configuration) {
        int requestTimeoutMillis = configuration.getIntFieldValue("Connection Timeout");
        String proxySettings = configuration.getFieldValue("Proxy Settings");
        if (proxySettings == null || proxySettings.isEmpty()) {
            proxySettings = "System Defaults";
        }
        String proxyHost = configuration.getFieldValue("Custom Proxy Host");
        int proxyPort = configuration.getIntFieldValue("Custom Proxy Port");
        CustomHttpClientFactory clientFactory = new CustomHttpClientFactory().setRequestTimeout(requestTimeoutMillis).setProxySettings(proxySettings).setProxyHost(proxyHost).setProxyPort(proxyPort);
        this.httpService = new ApacheHttpServiceFactory().make(new ApacheHttpRequestBuilder(), clientFactory, new ApacheHttpResponseBuilder());
    }

    private void configureApiRetries(Configuration configuration) {
        this.maxRetriesAttempt = configuration.getIntFieldValue("Maximum Retries Limit");
        this.retryRequest = configuration.getBooleanFieldValue("Retry Request");
        String errorCodeValuesForRetries = configuration.getFieldValue("Retry Error Codes");
        this.errorCodeForRetries.clear();
        if (errorCodeValuesForRetries != null && !errorCodeValuesForRetries.isEmpty()) {
            String[] errorCodeArr;
            for (String errorCode : errorCodeArr = errorCodeValuesForRetries.split(",")) {
                this.errorCodeForRetries.add(errorCode.trim());
            }
        }
    }

    private void configureP1Environment(Configuration configuration) {
        if (DataStoreConfiguration.PingOneEnvironmentField.isConfigured(configuration)) {
            this.pingOneEnvironment = DataStoreConfiguration.PingOneEnvironmentField.getPingOneEnvironment(configuration);
            this.pingOneEnvironmentAccessor = new ReflectivePingOneEnvironmentAccessor(this.pingOneEnvironment);
            this.baseUrl = this.pingOneEnvironmentAccessor.getManagementEndpoint() + "/v1";
            this.environmentId = this.pingOneEnvironmentAccessor.getEnvironmentId();
            this.environmentIdEndpoint = "/" + this.environmentId;
            this.tokenServerUrl = this.pingOneEnvironmentAccessor.getAuthenticationEndpoint(false);
        } else {
            Region region = DataStoreConfiguration.RegionField.getRegion(configuration);
            this.baseUrl = region.getApiEndpoint() + "/v1";
            this.environmentId = configuration.getFieldValue("Environment ID");
            this.clientId = configuration.getFieldValue("Client ID");
            this.clientSecret = configuration.getFieldValue("Client Secret");
            this.environmentIdEndpoint = "/" + this.environmentId;
            this.tokenServerUrl = region.getAuthEndpoint();
        }
    }

    private void configureCustomAttributesTable(Configuration configuration) {
        Table customAttrsTable = configuration.getTable("Custom Attributes Details");
        if (customAttrsTable != null && !customAttrsTable.getRows().isEmpty()) {
            for (Row row : customAttrsTable.getRows()) {
                if (row == null) continue;
                String localAttribute = row.getFieldValue("Local Attribute");
                String path = row.getFieldValue("PingOne for Customers Attribute");
                if (localAttribute == null || localAttribute.isEmpty() || path == null || path.isEmpty()) continue;
                this.customAttributesTable.put(localAttribute, path);
            }
        }
    }

    public boolean testConnection() {
        try {
            String url = this.baseUrl + ENVIRONMENTS_ENDPOINT;
            RequestResponse requestResponse = this.doRequest(this.generateGetRequest(url), true, null);
            String response = requestResponse.getResultString();
            JSONObject obj = new JSONObject(response);
            if (obj.getInt("size") != 0) {
                return true;
            }
        }
        catch (Exception e) {
            logger.log((LogEvent)DataStoreLogEvent.ENV_TEST_ERROR, e);
        }
        return false;
    }

    public HashMap<String, Object> retrieveUserDeviceAttributes(String userID) {
        HashMap<String, Object> userDeviceAttributesMap = new HashMap<String, Object>();
        try {
            String url = this.getBasicUrl() + "/" + userID + DEVICES_ENDPOINT;
            RequestResponse returnResponse = this.doRequest(this.generateGetRequest(url), true, null);
            String response = returnResponse.getResultString();
            JSONObject obj = new JSONObject(response);
            if (obj.getInt("size") == 0) {
                logger.log((LogEvent)DataStoreLogEvent.NO_DEVICE_INFO, userID);
                return userDeviceAttributesMap;
            }
            JSONObject emb = obj.getJSONObject("_embedded");
            JSONArray devices = emb.getJSONArray("devices");
            boolean phoneNumberRead = false;
            boolean emailRead = false;
            for (int index = 0; index < devices.length(); ++index) {
                JSONObject device = (JSONObject)devices.get(index);
                String deviceType = (String)device.get("type");
                if (deviceType.equals("EMAIL") && !emailRead) {
                    String emailValue = (String)device.get("email");
                    if (emailValue == null || emailValue.isEmpty()) continue;
                    userDeviceAttributesMap.put("devices.email", emailValue);
                    emailRead = true;
                    continue;
                }
                if (deviceType.equals("SMS") && !phoneNumberRead) {
                    String phoneValue = (String)device.get("phone");
                    if (phoneValue == null || phoneValue.isEmpty()) continue;
                    userDeviceAttributesMap.put("devices.phone", phoneValue);
                    phoneNumberRead = true;
                    continue;
                }
                if (!phoneNumberRead || !emailRead) {
                    continue;
                }
                break;
            }
        }
        catch (IOException | JSONException e) {
            logger.log((LogEvent)DataStoreLogEvent.RESPONSE_PROCESSING_ERROR, e.getMessage());
        }
        catch (HttpServiceException e) {
            logger.log((LogEvent)DataStoreLogEvent.RESPONSE_RETRIEVING_ERROR, e, e.getMessage());
        }
        catch (AccessTokenProviderException e) {
            logger.log((LogEvent)DataStoreLogEvent.ERROR_GETTING_ACCESS_TOKEN, e, e.getMessage());
        }
        return userDeviceAttributesMap;
    }

    public HashMap<String, Object> retrieveUserGroupAttributesAttributes(String userID) {
        HashMap<String, Object> userGroupAttributesMap = new HashMap<String, Object>();
        try {
            String url = this.getBasicUrl() + "/" + userID + "?" + GROUP_QUERY_PARAM;
            RequestResponse returnResponse = this.doRequest(this.generateGetRequest(url), true, null);
            String response = returnResponse.getResultString();
            JSONObject obj = new JSONObject(response);
            if (!obj.isNull("memberOfGroupIDs")) {
                JSONArray groupIDs = obj.getJSONArray("memberOfGroupIDs");
                userGroupAttributesMap.put("memberOfGroupIDs", groupIDs);
            }
            if (!obj.isNull("memberOfGroupNames")) {
                JSONArray groupNames = obj.getJSONArray("memberOfGroupNames");
                userGroupAttributesMap.put("memberOfGroupNames", groupNames);
            }
        }
        catch (IOException | JSONException e) {
            logger.log((LogEvent)DataStoreLogEvent.RESPONSE_PROCESSING_ERROR, e.getMessage());
        }
        catch (HttpServiceException e) {
            logger.log((LogEvent)DataStoreLogEvent.RESPONSE_RETRIEVING_ERROR, e, e.getMessage());
        }
        catch (AccessTokenProviderException e) {
            logger.log((LogEvent)DataStoreLogEvent.ERROR_GETTING_ACCESS_TOKEN, e, e.getMessage());
        }
        return userGroupAttributesMap;
    }

    public Map<String, Object> retrieveValues(Collection<String> attributeNamesToFill, SimpleFieldList filterConfiguration) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        try {
            String url = this.getBasicUrl();
            String attribute = filterConfiguration.getFieldValue("Attribute");
            String value = filterConfiguration.getFieldValue("Value");
            String append = "?filter=" + URLEncoder.encode(attribute, StandardCharsets.UTF_8.displayName()) + URLEncoder.encode(" eq \"", StandardCharsets.UTF_8.displayName()) + URLEncoder.encode(value, StandardCharsets.UTF_8.displayName()) + URLEncoder.encode("\"", StandardCharsets.UTF_8.displayName());
            url = url + append.replace("+", "%20");
            RequestResponse requestResponse = this.doRequest(this.generateGetRequest(url), true, null);
            String response = requestResponse.getResultString();
            JSONObject obj = new JSONObject(response);
            JSONObject emb = obj.getJSONObject("_embedded");
            int size = obj.getInt("size");
            if (size != 1) {
                if (size > 1) {
                    logger.log(DataStoreLogEvent.MULTIPLE_USER);
                    throw new PingOneDataStoreException("Error: Multiple users are returned based on condition given");
                }
                logger.log(DataStoreLogEvent.NO_USER);
                throw new PingOneDataStoreException("Error: No user found matching filter criteria");
            }
            JSONArray users = emb.getJSONArray("users");
            JSONObject user = users.getJSONObject(0);
            String userId = (String)user.get("id");
            HashMap<String, Object> userAttributesMap = DataSourceUtils.retrieveUserDataAttributes(user);
            HashMap<Object, Object> groupAttributesMap = new HashMap();
            if (this.retrieveUserGroupInfo) {
                groupAttributesMap = this.retrieveUserGroupAttributesAttributes(userId);
            }
            HashMap<Object, Object> deviceAttributesMap = new HashMap();
            if (this.retrieveDeviceInfo) {
                deviceAttributesMap = this.retrieveUserDeviceAttributes(userId);
            }
            for (String localAttributeName : attributeNamesToFill) {
                Object attributeValue = "";
                try {
                    if (CORE_ATTRIBUTES.contains(localAttributeName)) {
                        attributeValue = localAttributeName.equals("devices.phone") || localAttributeName.equals("devices.email") ? deviceAttributesMap.get(localAttributeName) : (localAttributeName.equals("memberOfGroupIDs") || localAttributeName.equals("memberOfGroupNames") ? groupAttributesMap.get(localAttributeName) : userAttributesMap.get(localAttributeName));
                    } else {
                        String jsonPointer = this.customAttributesTable.get(localAttributeName);
                        JsonNode result = JsonPointerUtil.evaluateJsonPointer(mapper, jsonPointer, user.toString());
                        attributeValue = JsonNodeUtil.convert(result);
                    }
                }
                catch (Exception e) {
                    logger.log((LogEvent)DataStoreLogEvent.ASSIGNING_ATTR_ERROR, e, localAttributeName);
                }
                logger.log((LogEvent)DataStoreLogEvent.ASSIGNING_ATTR, localAttributeName, attributeValue);
                if (attributeValue == null) continue;
                results.put(localAttributeName, attributeValue);
            }
        }
        catch (IOException e) {
            logger.log((LogEvent)DataStoreLogEvent.NO_USER_INFO, e);
            return new HashMap<String, Object>();
        }
        catch (AccessTokenProviderException e) {
            logger.log((LogEvent)DataStoreLogEvent.ERROR_GETTING_ACCESS_TOKEN, e, e.getMessage());
            return new HashMap<String, Object>();
        }
        catch (Exception e) {
            logger.log((LogEvent)DataStoreLogEvent.INFO_RETRIEVING_ERROR, e);
            return new HashMap<String, Object>();
        }
        Map<String, AttributeValue> convertedMap = DataSourceUtils.getMapOfAttributeValues(results);
        return DataSourceUtils.convert(convertedMap);
    }

    public List<String> getAvailableFields() {
        Set<String> keys = this.customAttributesTable.keySet();
        HashSet<String> availableFields = new HashSet<String>(CORE_ATTRIBUTES);
        availableFields.addAll(keys);
        ArrayList<String> list = new ArrayList<String>(availableFields);
        Collections.sort(list);
        return list;
    }

    private String getAccessToken(boolean refresh) throws IOException, HttpServiceException, AccessTokenProviderException {
        String result = this.accessTokenHolder.getAccessToken();
        if (result == null || refresh) {
            logger.log(DataStoreLogEvent.GET_ACCESS_TOKEN);
            if (this.pingOneEnvironmentAccessor != null) {
                try {
                    result = this.pingOneEnvironmentAccessor.getAccessToken();
                    this.accessTokenHolder.setAccessToken(result);
                }
                catch (Throwable e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new AccessTokenProviderException("Error requesting access token", e);
                }
            } else {
                result = this.retrieveAccessToken();
                this.accessTokenHolder.setAccessToken(result);
            }
        }
        return result;
    }

    private String retrieveAccessToken() throws IOException, HttpServiceException, AccessTokenProviderException {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.toString());
        headerMap.put("Connection", "Keep-Alive");
        String encoding = Base64.getEncoder().encodeToString((this.clientId + ":" + this.clientSecret).getBytes());
        headerMap.put("Authorization", "Basic " + encoding);
        GenericHttpQueryParams params = new GenericHttpQueryParams();
        params.add("grant_type", "client_credentials");
        params.add("action", "getjson");
        String url = this.tokenServerUrl + this.environmentIdEndpoint + TOKEN_ENDPOINT;
        GenericHttpRequest post = new GenericHttpRequest(GenericHttpMethod.POST, url, params, new GenericHttpHeaders(headerMap));
        RequestResponse requestResponse = this.doRequest(post, false, null);
        String response = requestResponse.getResultString();
        AccessTokenResponse accessTokenResponse = mapper.readValue(response, AccessTokenResponse.class);
        return accessTokenResponse.getAccessToken();
    }

    private GenericHttpRequest generateGetRequest(String url) throws IOException, HttpServiceException, AccessTokenProviderException {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-Type", ContentType.APPLICATION_JSON.toString());
        headerMap.put("Connection", "Keep-Alive");
        headerMap.put("Authorization", "Bearer " + this.getAccessToken(false));
        return new GenericHttpRequest(GenericHttpMethod.GET, url, new GenericHttpQueryParams(), new GenericHttpHeaders(headerMap));
    }

    private RequestResponse doRequest(GenericHttpRequest request, boolean refreshAccessTokenIfNecessary, Map<String, String> payloadData) throws IOException, HttpServiceException, AccessTokenProviderException {
        int retryAttemptNumber = 0;
        boolean done = false;
        int statusCode = 0;
        String responseString = null;
        boolean firstAttempt = true;
        while (!done) {
            if (!(firstAttempt || this.backoffCalculator.shouldRetry() && retryAttemptNumber <= this.maxRetriesAttempt)) {
                logger.log(DataStoreLogEvent.EXCEEDING_RETRY);
                throw new IOException("Exceeded configured retries number or maximum retries attempt due to rate limiting");
            }
            if (!firstAttempt && this.backoffCalculator.isBackOffEnforced()) {
                long waitTime = this.backoffCalculator.calculateRetryDelay();
                logger.log((LogEvent)DataStoreLogEvent.BACKOFF_ENFORCED, (double)waitTime / 1000.0);
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException e1) {
                    logger.log((LogEvent)DataStoreLogEvent.THREAD_INTERRUPTED, e1.getMessage());
                    Thread.currentThread().interrupt();
                }
            }
            if (retryAttemptNumber == 0) {
                logger.log((LogEvent)DataStoreLogEvent.SEND_REQUEST, new Object[]{request.getMethod(), request.getUrl()});
            } else {
                logger.log((LogEvent)DataStoreLogEvent.RETRY_REQUEST, new Object[]{request.getMethod(), request.getUrl(), retryAttemptNumber});
            }
            GenericHttpResponse response = this.httpService.execute(request);
            firstAttempt = false;
            responseString = response.getBody().getContent();
            statusCode = response.getStatusCode();
            String statusCodeStr = Integer.toString(statusCode);
            int index = StringUtils.indexOfAny(statusCodeStr, this.errorCodeForRetries.toArray(new String[this.errorCodeForRetries.size()]));
            if (index != -1 && this.retryRequest) {
                if (!this.backoffCalculator.isBackOffEnforced()) {
                    this.backoffCalculator.enableBackOffEnforcement();
                }
                ++retryAttemptNumber;
                continue;
            }
            if ((statusCode == 401 || statusCode == 403) && refreshAccessTokenIfNecessary) {
                logger.log((LogEvent)DataStoreLogEvent.REFRESH_ACCESS_TOKEN, statusCode);
                refreshAccessTokenIfNecessary = false;
                GenericHttpHeaders headers = request.getHeaders();
                headers.addHeader("Authorization", "Bearer " + this.getAccessToken(true));
                if (payloadData != null) {
                    GenericHttpBody httpBody = PingOneForCustomersDataStore.getBody(payloadData);
                    request = new GenericHttpRequest(request.getMethod(), request.getUrl(), request.getParameters(), headers, httpBody);
                    continue;
                }
                request = new GenericHttpRequest(request.getMethod(), request.getUrl(), request.getParameters(), headers);
                continue;
            }
            done = true;
            if (!this.backoffCalculator.isBackOffEnforced()) continue;
            this.backoffCalculator.resetBackOffEnforcement();
        }
        if (statusCode != 200) {
            logger.log((LogEvent)DataStoreLogEvent.REQUEST_RESPONSE, new Object[]{request.getMethod(), request.getUrl(), statusCode + ": " + responseString});
        } else {
            logger.log((LogEvent)DataStoreLogEvent.REQUEST_RESPONSE, new Object[]{request.getMethod(), request.getUrl(), statusCode});
        }
        return new RequestResponse(responseString, statusCode);
    }

    private static ObjectMapper makeLowerCaseWithUnderscoresObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    private String getBasicUrl() {
        return this.baseUrl + ENVIRONMENTS_ENDPOINT + this.environmentIdEndpoint + USERS_ENDPOINT;
    }

    private static GenericHttpBody getBody(Map<String, String> values) {
        String content = new JSONObject(values).toString();
        return new GenericHttpBody(content, ContentType.APPLICATION_JSON.getMimeType(), ContentType.APPLICATION_JSON.getCharset().toString());
    }

    static {
        Method[] methods;
        Constructor<?>[] constructors;
        mapper = PingOneForCustomersDataStore.makeLowerCaseWithUnderscoresObjectMapper();
        logger = new IntegrationsLogger(PingOneForCustomersDataStore.class);
        CORE_ATTRIBUTES = new HashSet<String>();
        CORE_ATTRIBUTES.add("email");
        CORE_ATTRIBUTES.add("name.family");
        CORE_ATTRIBUTES.add("name.formatted");
        CORE_ATTRIBUTES.add("name.given");
        CORE_ATTRIBUTES.add("name.honorificPrefix");
        CORE_ATTRIBUTES.add("name.honorificSuffix");
        CORE_ATTRIBUTES.add("name.middle");
        CORE_ATTRIBUTES.add("nickname");
        CORE_ATTRIBUTES.add("photo.href");
        CORE_ATTRIBUTES.add("id");
        CORE_ATTRIBUTES.add("createdAt");
        CORE_ATTRIBUTES.add("updatedAt");
        CORE_ATTRIBUTES.add("username");
        CORE_ATTRIBUTES.add("title");
        CORE_ATTRIBUTES.add("primaryPhone");
        CORE_ATTRIBUTES.add("mobilePhone");
        CORE_ATTRIBUTES.add("enabled");
        CORE_ATTRIBUTES.add("mfaEnabled");
        CORE_ATTRIBUTES.add("locale");
        CORE_ATTRIBUTES.add("preferredLanguage");
        CORE_ATTRIBUTES.add("timezone");
        CORE_ATTRIBUTES.add("address.countryCode");
        CORE_ATTRIBUTES.add("address.locality");
        CORE_ATTRIBUTES.add("address.postalCode");
        CORE_ATTRIBUTES.add("address.region");
        CORE_ATTRIBUTES.add("address.streetAddress");
        CORE_ATTRIBUTES.add("devices.phone");
        CORE_ATTRIBUTES.add("devices.email");
        CORE_ATTRIBUTES.add("memberOfGroupIDs");
        CORE_ATTRIBUTES.add("memberOfGroupNames");
        isPingFederate92AndAbove = false;
        for (Constructor<?> constructor : constructors = CustomDataSourceDriverDescriptor.class.getConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != 5 || !"boolean".equals(parameterTypes[4].getName())) continue;
            isPingFederate92AndAbove = true;
            break;
        }
        if (Arrays.stream(methods = PluginDescriptor.class.getMethods()).anyMatch(m -> "setMetadata".equals(m.getName()))) {
            supportsSetMetadata = true;
        }
        try {
            Class.forName("com.pingidentity.sdk.PluginServiceAssociation");
            supportsPluginServiceAssociation = true;
        }
        catch (ClassNotFoundException ignored) {
            supportsPluginServiceAssociation = false;
        }
    }
}

