/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins.datastore.p14c;

import com.pingidentity.plugins.datastore.p14c.CustomHttpClientFactory;
import com.pingidentity.plugins.datastore.p14c.DataStoreLogEvent;
import com.pingidentity.plugins.datastore.p14c.RequestResponse;
import com.pingidentity.plugins.datastore.p14c.configuration.DataStoreConfiguration;
import com.pingidentity.plugins.datastore.p14c.configuration.Region;
import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.common.http.GenericHttpHeaders;
import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.common.http.GenericHttpMethod;
import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.common.http.GenericHttpQueryParams;
import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.common.http.GenericHttpRequest;
import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.common.http.GenericHttpResponse;
import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.common.http.HttpService;
import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.common.http.HttpServiceException;
import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.common.http.apache5.ApacheHttpRequestBuilder;
import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.common.http.apache5.ApacheHttpResponseBuilder;
import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.common.http.apache5.ApacheHttpService;
import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.common.http.apache5.ApacheHttpServiceFactory;
import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.integrations.logger.LogEvent;
import com.pingidentity.plugins.datastore.p14c.shade.org.apache.hc.core5.http.ContentType;
import com.pingidentity.plugins.datastore.p14c.util.ReflectivePingOneEnvironmentAccessor;
import java.util.Base64;
import java.util.HashMap;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.ActionDescriptor;

public class TestConnectionAction
implements ActionDescriptor.Action {
    private static final long serialVersionUID = 8734416890550935404L;
    private static final IntegrationsLogger logger = new IntegrationsLogger(TestConnectionAction.class);

    public String actionInvoked(Configuration configuration) {
        String actionResult;
        logger.log(DataStoreLogEvent.TEST_CONNECTION);
        if (DataStoreConfiguration.PingOneEnvironmentField.isConfigured(configuration)) {
            String pingOneEnvironment = DataStoreConfiguration.PingOneEnvironmentField.getPingOneEnvironment(configuration);
            ReflectivePingOneEnvironmentAccessor pingOneEnvironmentAccessor = new ReflectivePingOneEnvironmentAccessor(pingOneEnvironment);
            try {
                pingOneEnvironmentAccessor.getAccessToken();
                actionResult = "Connection test successful";
            }
            catch (Throwable e) {
                logger.log((LogEvent)DataStoreLogEvent.TEST_CONNECTION_ERROR, e.getMessage());
                actionResult = "An error occurred while testing the connection. Check server log for more details.";
            }
        } else {
            Region region = DataStoreConfiguration.RegionField.getRegion(configuration);
            String tokenServerUrl = region.getAuthEndpoint();
            String environmentId = configuration.getFieldValue("Environment ID");
            String clientId = configuration.getFieldValue("Client ID");
            String clientSecret = configuration.getFieldValue("Client Secret");
            int requestTimeoutMillis = configuration.getIntFieldValue("Connection Timeout");
            String proxySettings = configuration.getFieldValue("Proxy Settings");
            if (proxySettings == null || proxySettings.isEmpty()) {
                proxySettings = "System Defaults";
            }
            String proxyHost = configuration.getFieldValue("Custom Proxy Host");
            int proxyPort = configuration.getIntFieldValue("Custom Proxy Port");
            CustomHttpClientFactory clientFactory = new CustomHttpClientFactory().setRequestTimeout(requestTimeoutMillis).setProxySettings(proxySettings).setProxyHost(proxyHost).setProxyPort(proxyPort);
            ApacheHttpService httpService = new ApacheHttpServiceFactory().make(new ApacheHttpRequestBuilder(), clientFactory, new ApacheHttpResponseBuilder());
            try {
                String environmentIdEndpoint = "/" + environmentId;
                RequestResponse result = this.testConnection(tokenServerUrl, environmentIdEndpoint, clientId, clientSecret, httpService);
                if (result.getStatusCode() == 200) {
                    logger.log((LogEvent)DataStoreLogEvent.TEST_CONNECTION_SUCCESS, result.getStatusCode(), result.getResultString());
                    actionResult = "Connection test successful";
                } else {
                    logger.log((LogEvent)DataStoreLogEvent.TEST_CONNECTION_FAIL, result.getStatusCode(), result.getResultString());
                    actionResult = "Connection test failed. Invalid client credentials. Check server log for more details.";
                }
            }
            catch (HttpServiceException e) {
                logger.log((LogEvent)DataStoreLogEvent.TEST_CONNECTION_ERROR, e.getMessage());
                actionResult = "An error occurred while testing the connection. Check server log for more details.";
            }
        }
        return actionResult;
    }

    private RequestResponse testConnection(String tokenServerURL, String environmentIdEndpoint, String clientId, String clientSecret, HttpService httpService) throws HttpServiceException {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.toString());
        headerMap.put("Connection", "Keep-Alive");
        String encoding = Base64.getEncoder().encodeToString((clientId + ":" + clientSecret).getBytes());
        headerMap.put("Authorization", "Basic " + encoding);
        GenericHttpQueryParams params = new GenericHttpQueryParams();
        params.add("grant_type", "client_credentials");
        params.add("action", "getjson");
        String url = tokenServerURL + environmentIdEndpoint + "/as/token";
        GenericHttpRequest post = new GenericHttpRequest(GenericHttpMethod.POST, url, params, new GenericHttpHeaders(headerMap));
        logger.log((LogEvent)DataStoreLogEvent.SEND_REQUEST, new Object[]{post.getMethod(), post.getUrl()});
        GenericHttpResponse response = httpService.execute(post);
        String responseString = response.getBody().getContent();
        int statusCode = response.getStatusCode();
        return new RequestResponse(responseString, statusCode);
    }
}

