/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.util;

import com.pingidentity.plugins.datastore.p14c.shade.com.fasterxml.jackson.databind.JsonNode;
import com.pingidentity.plugins.datastore.p14c.shade.com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.plugins.datastore.p14c.shade.com.fasterxml.jackson.databind.node.MissingNode;
import com.pingidentity.plugins.datastore.p14c.shade.com.fasterxml.jackson.databind.node.NullNode;
import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.util.JsonNodeUtil;
import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.util.JsonPointerUtilException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sourceid.saml20.adapter.attribute.AttributeValue;

public class JsonPointerUtil {
    private static final Logger LOG = LoggerFactory.getLogger(JsonPointerUtil.class);

    public static JsonNode evaluateJsonPointer(ObjectMapper objectMapper, String jsonPointer, String jsonData) throws JsonPointerUtilException {
        JsonNode result;
        boolean isEmptyJsonPointer;
        boolean bl = isEmptyJsonPointer = jsonPointer == null || !jsonPointer.isEmpty() && !jsonPointer.startsWith("/");
        if ((jsonData == null || jsonData.isEmpty()) && isEmptyJsonPointer) {
            LOG.error(JsonPointerUtilException.INVALID_SEARCH_CRITERIA);
            throw new JsonPointerUtilException(JsonPointerUtilException.INVALID_SEARCH_CRITERIA);
        }
        if (jsonData == null || jsonData.isEmpty()) {
            LOG.error(JsonPointerUtilException.INVALID_JSON_DATA);
            throw new JsonPointerUtilException(JsonPointerUtilException.INVALID_JSON_DATA);
        }
        if (isEmptyJsonPointer) {
            LOG.error(JsonPointerUtilException.INVALID_JSON_POINTER_EXPRESSION);
            throw new JsonPointerUtilException(JsonPointerUtilException.INVALID_JSON_POINTER_EXPRESSION);
        }
        try {
            JsonNode root = objectMapper.readTree(jsonData);
            result = root.at(jsonPointer);
            if (result instanceof MissingNode || result instanceof NullNode) {
                result = null;
            }
        }
        catch (IOException e) {
            LOG.error(JsonPointerUtilException.ERROR_PROCESSING_DATA + ":" + jsonPointer);
            throw new JsonPointerUtilException(JsonPointerUtilException.ERROR_PROCESSING_DATA, e);
        }
        if (result != null) {
            LOG.trace("Retrieved result: [" + result.toString() + "]");
        } else {
            LOG.trace("Retrieved result: [null]");
        }
        return result;
    }

    public static Map<String, AttributeValue> mapResponse(ObjectMapper objectMapper, Map<String, String> responseMappings, String jsonData) {
        HashMap<String, AttributeValue> attributes = new HashMap<String, AttributeValue>();
        for (Map.Entry<String, String> entry : responseMappings.entrySet()) {
            JsonNode jsonPointerEvaluatorResult;
            String localAttribute = entry.getKey();
            String jsonPointer = entry.getValue();
            try {
                jsonPointerEvaluatorResult = JsonPointerUtil.evaluateJsonPointer(objectMapper, jsonPointer, jsonData);
            }
            catch (JsonPointerUtilException e) {
                jsonPointerEvaluatorResult = null;
            }
            if (jsonPointerEvaluatorResult == null) {
                LOG.debug(String.format("There was a problem fulfilling attribute '%s'. Expected to resolve JSON pointer '%s' but result was null.", localAttribute, jsonPointer));
            }
            attributes.put(localAttribute, JsonNodeUtil.convert(jsonPointerEvaluatorResult));
        }
        return attributes;
    }
}

