/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins.datastore.p14c.shade.org.apache.hc.core5.http.io.entity;

import com.pingidentity.plugins.datastore.p14c.shade.org.apache.hc.core5.annotation.Contract;
import com.pingidentity.plugins.datastore.p14c.shade.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.pingidentity.plugins.datastore.p14c.shade.org.apache.hc.core5.http.ContentType;
import com.pingidentity.plugins.datastore.p14c.shade.org.apache.hc.core5.http.io.entity.AbstractHttpEntity;
import com.pingidentity.plugins.datastore.p14c.shade.org.apache.hc.core5.util.Args;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class PathEntity
extends AbstractHttpEntity {
    private final Path path;

    public PathEntity(Path path, ContentType contentType, String contentEncoding) {
        super(contentType, contentEncoding);
        this.path = Args.notNull(path, "Path");
    }

    public PathEntity(Path path, ContentType contentType) {
        super(contentType, null);
        this.path = Args.notNull(path, "Path");
    }

    @Override
    public final boolean isRepeatable() {
        return true;
    }

    @Override
    public final long getContentLength() {
        try {
            return Files.size(this.path);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public final InputStream getContent() throws IOException {
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    @Override
    public final boolean isStreaming() {
        return false;
    }

    @Override
    public final void close() throws IOException {
    }
}

