/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins.datastore.p14c.util;

import com.pingidentity.plugins.datastore.p14c.shade.com.fasterxml.jackson.databind.JsonNode;
import com.pingidentity.plugins.datastore.p14c.shade.com.fasterxml.jackson.databind.node.ArrayNode;
import com.pingidentity.plugins.datastore.p14c.shade.com.fasterxml.jackson.databind.node.MissingNode;
import com.pingidentity.plugins.datastore.p14c.shade.com.fasterxml.jackson.databind.node.NullNode;
import com.pingidentity.plugins.datastore.p14c.shade.com.fasterxml.jackson.databind.node.ObjectNode;
import com.pingidentity.plugins.datastore.p14c.shade.com.fasterxml.jackson.databind.node.TextNode;
import com.pingidentity.plugins.datastore.p14c.shade.org.json.simple.parser.JSONParser;
import com.pingidentity.plugins.datastore.p14c.shade.org.json.simple.parser.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;

public class DataSourceUtils {
    public static Map<String, Object> convert(Map<String, AttributeValue> from) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (Map.Entry<String, AttributeValue> entry : from.entrySet()) {
            ret.put(entry.getKey(), entry.getValue());
        }
        return ret;
    }

    public static List<Object> getListObject(JSONArray jsonArray) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            List<Object> value = jsonArray.get(i);
            if (value instanceof JSONArray) {
                value = DataSourceUtils.getListObject((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = DataSourceUtils.getMapObject((JSONObject)value);
            }
            list.add(value);
        }
        return list;
    }

    public static Map<String, Object> getMapObject(JSONObject jsonObject) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            List<Object> value = jsonObject.get(key);
            if (value instanceof JSONArray) {
                value = DataSourceUtils.getListObject((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = DataSourceUtils.getMapObject((JSONObject)value);
            }
            map.put(key, value);
        }
        return map;
    }

    public static Map<String, AttributeValue> getMapOfAttributeValues(Map<String, Object> attributesMap) {
        HashMap<String, AttributeValue> mapOfAttributeValues = new HashMap<String, AttributeValue>();
        for (Map.Entry<String, Object> entry : attributesMap.entrySet()) {
            AttributeValue attribute;
            ArrayList<Object> resultObjectList;
            AttributeValue attrValue;
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null || value instanceof MissingNode || value instanceof NullNode) continue;
            if (value instanceof Map) {
                attrValue = AttrValueSupport.make((Object)value);
                mapOfAttributeValues.put(key, attrValue);
                continue;
            }
            if (value instanceof List) {
                attrValue = AttrValueSupport.make((Collection)((List)value), (boolean)false);
                mapOfAttributeValues.put(key, attrValue);
                continue;
            }
            if (value instanceof ObjectNode) {
                try {
                    Object parsedObject = new JSONParser().parse(value.toString());
                    AttributeValue attrValue2 = AttrValueSupport.make((Object)parsedObject);
                    mapOfAttributeValues.put(key, attrValue2);
                }
                catch (ParseException parsedObject) {}
                continue;
            }
            if (value instanceof ArrayNode) {
                Iterator<JsonNode> jsonNodes = ((ArrayNode)value).elements();
                resultObjectList = new ArrayList<Object>();
                jsonNodes.forEachRemaining(jsonNode -> resultObjectList.add(jsonNode.toString()));
                attribute = AttrValueSupport.make(resultObjectList, (boolean)false);
                mapOfAttributeValues.put(key, attribute);
                continue;
            }
            if (value instanceof TextNode) {
                attrValue = AttrValueSupport.make((Object)((TextNode)value).textValue());
                mapOfAttributeValues.put(key, attrValue);
                continue;
            }
            if (value instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)value;
                resultObjectList = new ArrayList();
                for (int i = 0; i < jsonArray.length(); ++i) {
                    try {
                        resultObjectList.add(jsonArray.get(i));
                        continue;
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
                attribute = AttrValueSupport.make(resultObjectList, (boolean)false);
                mapOfAttributeValues.put(key, attribute);
                continue;
            }
            if (value instanceof AttributeValue) {
                mapOfAttributeValues.put(key, (AttributeValue)value);
                continue;
            }
            attrValue = AttrValueSupport.make((Object)value.toString());
            mapOfAttributeValues.put(key, attrValue);
        }
        return mapOfAttributeValues;
    }

    public static HashMap<String, Object> retrieveUserDataAttributes(JSONObject user) throws JSONException {
        JSONObject photoObj;
        HashMap<String, Object> userAttributesMap = new HashMap<String, Object>();
        if (user.has("email")) {
            userAttributesMap.put("email", user.getString("email"));
        }
        if (user.has("name")) {
            JSONObject nameObj = user.getJSONObject("name");
            if (nameObj.has("family")) {
                userAttributesMap.put("name.family", nameObj.getString("family"));
            }
            if (nameObj.has("formatted")) {
                userAttributesMap.put("name.formatted", nameObj.getString("formatted"));
            }
            if (nameObj.has("given")) {
                userAttributesMap.put("name.given", nameObj.getString("given"));
            }
            if (nameObj.has("honorificPrefix")) {
                userAttributesMap.put("name.honorificPrefix", nameObj.getString("honorificPrefix"));
            }
            if (nameObj.has("honorificSuffix")) {
                userAttributesMap.put("name.honorificSuffix", nameObj.getString("honorificSuffix"));
            }
            if (nameObj.has("middle")) {
                userAttributesMap.put("name.middle", nameObj.getString("middle"));
            }
        }
        if (user.has("nickname")) {
            userAttributesMap.put("nickname", user.getString("nickname"));
        }
        if (user.has("photo") && (photoObj = user.getJSONObject("photo")).has("href")) {
            userAttributesMap.put("photo.href", photoObj.getString("href"));
        }
        if (user.has("id")) {
            userAttributesMap.put("id", user.getString("id"));
        }
        if (user.has("createdAt")) {
            userAttributesMap.put("createdAt", user.getString("createdAt"));
        }
        if (user.has("updatedAt")) {
            userAttributesMap.put("updatedAt", user.getString("updatedAt"));
        }
        if (user.has("username")) {
            userAttributesMap.put("username", user.getString("username"));
        }
        if (user.has("title")) {
            userAttributesMap.put("title", user.getString("title"));
        }
        if (user.has("primaryPhone")) {
            userAttributesMap.put("primaryPhone", user.getString("primaryPhone"));
        }
        if (user.has("mobilePhone")) {
            userAttributesMap.put("mobilePhone", user.getString("mobilePhone"));
        }
        if (user.has("mfaEnabled")) {
            userAttributesMap.put("mfaEnabled", Boolean.toString(user.getBoolean("mfaEnabled")));
        }
        if (user.has("enabled")) {
            userAttributesMap.put("enabled", Boolean.toString(user.getBoolean("enabled")));
        }
        if (user.has("locale")) {
            userAttributesMap.put("locale", user.getString("locale"));
        }
        if (user.has("preferredLanguage")) {
            userAttributesMap.put("preferredLanguage", user.getString("preferredLanguage"));
        }
        if (user.has("timezone")) {
            userAttributesMap.put("timezone", user.getString("timezone"));
        }
        if (user.has("address")) {
            JSONObject addressObj = user.getJSONObject("address");
            if (addressObj.has("countryCode")) {
                userAttributesMap.put("address.countryCode", addressObj.getString("countryCode"));
            }
            if (addressObj.has("locality")) {
                userAttributesMap.put("address.locality", addressObj.getString("locality"));
            }
            if (addressObj.has("postalCode")) {
                userAttributesMap.put("address.postalCode", addressObj.getString("postalCode"));
            }
            if (addressObj.has("streetAddress")) {
                userAttributesMap.put("address.streetAddress", addressObj.getString("streetAddress"));
            }
            if (addressObj.has("region")) {
                userAttributesMap.put("address.region", addressObj.getString("region"));
            }
        }
        return userAttributesMap;
    }
}

