/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins.datastore.p14c.validators;

import com.pingidentity.plugins.datastore.p14c.configuration.DataStoreConfiguration;
import com.pingidentity.plugins.datastore.p14c.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;

public class DataStoreConfigurationValidator
implements ConfigurationValidator {
    private Configuration configuration;

    public DataStoreConfigurationValidator(Configuration configuration) {
        this.configuration = configuration;
    }

    /*
     * Unable to fully structure code
     */
    public void validate(Configuration configuration) throws ValidationException {
        isRetryRequestChecked = configuration.getBooleanFieldValue("Retry Request");
        maxRetriesAttemptMissing = false;
        maxRetriesAttemptIsInvalid = false;
        errorCodeMissing = false;
        errorCodeInvalid = false;
        if (DataStoreConfiguration.PingOneEnvironmentField.isConfigured(configuration)) {
            try {
                pingOneEnvironmentValidatorClass = Class.forName("org.sourceid.saml20.adapter.gui.validation.impl.PingOneEnvironmentValidator");
                pingOneEnvironmentValidatorConstructor = pingOneEnvironmentValidatorClass.getConstructor(new Class[0]);
                pingOneEnvironmentValidator = pingOneEnvironmentValidatorConstructor.newInstance(new Object[0]);
                validateMethod = pingOneEnvironmentValidatorClass.getMethod("validate", new Class[]{Field.class});
                validateMethod.invoke(pingOneEnvironmentValidator, new Object[]{configuration.getField("PingOne Environment")});
            }
            catch (InvocationTargetException e) {
                if (!(e.getTargetException() instanceof ValidationException)) ** GOTO lbl22
                throw (ValidationException)e.getTargetException();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {}
        } else if (DataStoreConfiguration.PingOneEnvironmentField.isConfigured(this.configuration) || !DataStoreConfigurationValidator.legacyPingOneFieldsAreConfigured(configuration)) {
            throw new ValidationException("'PingOne Environment' is required.");
        }
lbl22:
        // 5 sources

        if (isRetryRequestChecked) {
            maxRetriesAttemptField = configuration.getField("Maximum Retries Limit");
            if (maxRetriesAttemptField.getValue() == null || maxRetriesAttemptField.getValue().isEmpty()) {
                maxRetriesAttemptMissing = true;
            }
            if ((value = maxRetriesAttemptField.getValueAsInt()) <= 0) {
                maxRetriesAttemptIsInvalid = true;
            }
            if ((errorCodeValuesForRetries = configuration.getFieldValue("Retry Error Codes")) == null || errorCodeValuesForRetries.isEmpty()) {
                errorCodeMissing = true;
            } else {
                for (String errorCode : errorCodeArr = errorCodeValuesForRetries.split(",")) {
                    try {
                        Integer.parseInt(errorCode);
                    }
                    catch (NumberFormatException nfe) {
                        errorCodeInvalid = true;
                    }
                }
            }
        }
        if ((proxySettings = configuration.getFieldValue("Proxy Settings")).equals("Custom")) {
            proxyHost = configuration.getFieldValue("Custom Proxy Host");
            proxyPort = configuration.getFieldValue("Custom Proxy Port");
            invalidHost = proxyHost == null || proxyHost.isEmpty() != false || proxyHost.trim().isEmpty() != false;
            v0 = invalidPort = proxyPort == null || proxyPort.isEmpty() != false || proxyPort.trim().isEmpty() != false;
            if (invalidHost && invalidPort) {
                throw new ValidationException("'Custom Proxy Host' and 'Custom Proxy Port' fields are missing valid values.");
            }
            if (invalidHost) {
                throw new ValidationException("'Custom Proxy Host' field is missing a valid value.");
            }
            if (invalidPort) {
                throw new ValidationException("'Custom Proxy Port' field is missing a valid value.");
            }
            proxyPortNumber = configuration.getField("Custom Proxy Port").getValueAsInt();
            if (proxyPortNumber < 1 || proxyPortNumber > 65535) {
                throw new ValidationException("'Custom Proxy Port' field is missing a valid value, please enter a value between 1 and 65535.");
            }
        }
        if (maxRetriesAttemptIsInvalid || errorCodeMissing || errorCodeInvalid) {
            errorMessage = maxRetriesAttemptIsInvalid != false && errorCodeMissing != false ? (maxRetriesAttemptMissing != false ? "'Maximum Retries Limit' and 'Retry Error Codes' fields are missing valid values." : "'Maximum Retries Limit' is invalid or out of range, and 'Retry Error Codes' is missing a valid value.") : (maxRetriesAttemptIsInvalid != false && errorCodeInvalid != false ? (maxRetriesAttemptMissing != false ? "'Maximum Retries Limit' is missing a valid value, and 'Retry Error Codes' is invalid." : "'Maximum Retries Limit' is invalid or out of range, and 'Retry Error Codes' is invalid.") : (maxRetriesAttemptIsInvalid != false ? (maxRetriesAttemptMissing != false ? "'Maximum Retries Limit' is missing a valid value." : "'Maximum Retries Limit' is invalid or out of range.") : (errorCodeMissing != false ? "'Retry Error Codes' is missing a valid value." : "'Retry Error Codes' is invalid.")));
            throw new ValidationException(errorMessage);
        }
    }

    public static boolean legacyPingOneFieldsAreConfigured(Configuration configuration) {
        if (configuration != null) {
            return StringUtils.isNotBlank(configuration.getFieldValue("Environment ID")) && StringUtils.isNotBlank(configuration.getFieldValue("Client ID")) && StringUtils.isNotBlank(configuration.getFieldValue("Client Secret")) && (StringUtils.isNotBlank(configuration.getFieldValue("Region")) || StringUtils.isNotBlank(configuration.getFieldValue("PingOne API Service")) && StringUtils.isNotBlank(configuration.getFieldValue("PingOne Authorization Service")));
        }
        return false;
    }
}

