/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins.datastore.p14c.validators;

import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.adapter.gui.validation.impl.IntegerValidator;

public class IntegerFieldLabelValidator
extends IntegerValidator {
    private final String label;
    private int lowerBound = Integer.MIN_VALUE;
    private int upperBound = Integer.MAX_VALUE;

    public IntegerFieldLabelValidator(String label) {
        this.label = label;
    }

    public IntegerFieldLabelValidator(String label, int lowerBound, int upperBound) {
        this.label = label;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public void validate(Field field) throws ValidationException {
        try {
            Integer tmpInt = Integer.parseInt(field.getValue());
            if (tmpInt < this.lowerBound || tmpInt > this.upperBound) {
                throw new ValidationException("'" + this.label + "' is out of range, please enter a value between " + this.lowerBound + " and " + this.upperBound + ".");
            }
        }
        catch (NumberFormatException var3) {
            throw new ValidationException("'" + this.label + "' is not a valid Integer: '" + field.getValue() + "'.");
        }
    }
}

