/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.api.client;

import com.pingidentity.adapters.pingone.mfa.api.client.flows.FlowsApiClient;
import com.pingidentity.adapters.pingone.mfa.api.client.flows.FlowsApiClientImpl;
import com.pingidentity.adapters.pingone.mfa.api.client.worker.WorkerApiClient;
import com.pingidentity.adapters.pingone.mfa.config.PingOneMfaAdapterConfiguration;
import com.pingidentity.adapters.pingone.mfa.config.Region;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.lang3.StringUtils;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.HttpHost;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.client.config.RequestConfig;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.client.fluent.Executor;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.impl.client.CloseableHttpClient;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.impl.client.HttpClientBuilder;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.impl.client.HttpClients;
import com.pingidentity.adapters.pingone.mfa.util.ObjectMappers;
import com.pingidentity.adapters.pingone.mfa.util.accestoken.AccessTokenProvider;
import com.pingidentity.adapters.pingone.mfa.util.accestoken.CustomAccessTokenProvider;
import com.pingidentity.adapters.pingone.mfa.util.accestoken.DefaultAccessTokenProvider;
import com.pingidentity.adapters.pingone.mfa.util.accestoken.ReflectivePingOneEnvironmentAccessor;
import com.pingidentity.adapters.pingone.mfa.util.accestoken.TokenService;
import com.pingidentity.adapters.pingone.mfa.util.accestoken.WorkerApiClientAsAccessTokenProvider;
import com.pingidentity.common.util.ldap.PingSslClientTrustManager;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.sourceid.saml20.adapter.conf.Configuration;

public class PingOneClientsFactory {
    private WorkerApiClient workerApiClient = null;
    private FlowsApiClient flowsApiClient = null;
    private TokenService tokenService = null;
    private ReflectivePingOneEnvironmentAccessor pingOneEnvironmentAccessor;
    private String pingOneEnvironmentConnectionId;
    private final String envId;
    private final String applicationId;
    private String workerClientId;
    private String workerClientSecret;
    private final String authenticationPolicy;
    private final String authEndpoint;
    private final String apiEndpoint;
    private final int requestTimeout;
    private final String proxySettings;
    private final String proxyHost;
    private final int proxyPort;

    public PingOneClientsFactory(Configuration adapterConfiguration) {
        if (PingOneMfaAdapterConfiguration.PingOneEnvironmentField.isConfigured(adapterConfiguration)) {
            this.pingOneEnvironmentConnectionId = PingOneMfaAdapterConfiguration.PingOneEnvironmentField.getPingOneEnvironment(adapterConfiguration);
            this.pingOneEnvironmentAccessor = new ReflectivePingOneEnvironmentAccessor(this.pingOneEnvironmentConnectionId);
            this.envId = this.pingOneEnvironmentAccessor.getEnvironmentId();
            this.authEndpoint = this.pingOneEnvironmentAccessor.getAuthenticationEndpoint(false);
            this.apiEndpoint = this.pingOneEnvironmentAccessor.getManagementEndpoint();
        } else {
            this.envId = PingOneMfaAdapterConfiguration.EnvIdField.getEnvId(adapterConfiguration);
            this.workerClientId = PingOneMfaAdapterConfiguration.WorkerClientIdField.getWorkerClientId(adapterConfiguration);
            this.workerClientSecret = PingOneMfaAdapterConfiguration.WorkerClientSecretField.getWorkerClientSecret(adapterConfiguration);
            Region region = PingOneMfaAdapterConfiguration.RegionField.getRegion(adapterConfiguration);
            this.authEndpoint = region.getAuthEndpoint();
            this.apiEndpoint = region.getApiEndpoint();
        }
        this.applicationId = PingOneMfaAdapterConfiguration.ApplicationField.getApplicationId(adapterConfiguration);
        this.authenticationPolicy = PingOneMfaAdapterConfiguration.AuthenticationPolicyField.getAuthenticationPolicy(adapterConfiguration);
        this.requestTimeout = PingOneMfaAdapterConfiguration.RequestTimeoutField.getRequestTimeout(adapterConfiguration);
        this.proxySettings = PingOneMfaAdapterConfiguration.ProxySettingsField.getProxySettings(adapterConfiguration);
        this.proxyHost = PingOneMfaAdapterConfiguration.ProxyHostField.getProxyHost(adapterConfiguration);
        this.proxyPort = PingOneMfaAdapterConfiguration.ProxyPortField.getProxyPort(adapterConfiguration);
    }

    private void buildTokenService() {
        AccessTokenProvider accessTokenProvider = this.pingOneEnvironmentAccessor == null ? new WorkerApiClientAsAccessTokenProvider(this.getWorkerApiClient()) : ("Custom".equals(this.proxySettings) ? new CustomAccessTokenProvider(this.pingOneEnvironmentAccessor, this.buildHttpClient()) : new DefaultAccessTokenProvider(this.pingOneEnvironmentAccessor));
        this.tokenService = new TokenService(accessTokenProvider, Optional.ofNullable(this.pingOneEnvironmentConnectionId).orElse(this.workerClientId));
    }

    private void buildFlowsApiClient() {
        CloseableHttpClient httpClient = this.buildHttpClient();
        Executor executor = Executor.newInstance(httpClient);
        this.flowsApiClient = new FlowsApiClientImpl.Builder().setEnvId(this.envId).setAppId(this.applicationId).setPolicy(this.authenticationPolicy).setAuthPath(this.authEndpoint).setExecutor(executor).setObjectMapper(ObjectMappers.getDefault()).build();
    }

    private void buildWorkerApiClient() {
        CloseableHttpClient httpClient = this.buildHttpClient();
        Executor executor = Executor.newInstance(httpClient);
        this.workerApiClient = new WorkerApiClient.Builder().setExecutor(executor).setAuthPath(this.authEndpoint).setApiPath(this.apiEndpoint).setEnvId(this.envId).setClientId(this.workerClientId).setClientSecret(this.workerClientSecret).build();
    }

    private CloseableHttpClient buildHttpClient() {
        if (StringUtils.isBlank(this.proxySettings)) {
            throw new IllegalArgumentException();
        }
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.requestTimeout).setConnectTimeout(this.requestTimeout).setCookieSpec("ignoreCookies").build();
        HttpClientBuilder httpClientBuilder = HttpClients.custom().disableRedirectHandling().setUserAgent("PingFederate").setDefaultRequestConfig(requestConfig);
        switch (this.proxySettings) {
            case "System Defaults": {
                try {
                    TrustManager[] trustMgrArray = new TrustManager[]{PingSslClientTrustManager.getInstance()};
                    SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
                    sslContext.init(null, trustMgrArray, new SecureRandom());
                    SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
                    return httpClientBuilder.useSystemProperties().setSSLSocketFactory(socketFactory).build();
                }
                catch (KeyManagementException | NoSuchAlgorithmException e) {
                    throw new RuntimeException("Unexpected error creating HTTP client", e);
                }
            }
            case "Custom": {
                if (this.isProxyReachable(this.proxyHost, this.proxyPort)) {
                    return httpClientBuilder.setProxy(new HttpHost(this.proxyHost, this.proxyPort)).build();
                }
                throw new RuntimeException("Failed to connect to the specified proxy at " + this.proxyHost + ":" + this.proxyPort);
            }
        }
        return httpClientBuilder.build();
    }

    private boolean isProxyReachable(String proxyHost, int proxyPort) {
        boolean bl;
        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
        Socket socket = new Socket(proxy);
        try {
            socket.connect(new InetSocketAddress(proxyHost, proxyPort));
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        socket.close();
        return bl;
    }

    public WorkerApiClient getWorkerApiClient() {
        if (this.workerApiClient == null) {
            this.buildWorkerApiClient();
        }
        return this.workerApiClient;
    }

    public TokenService getTokenServiceClient() {
        if (this.tokenService == null) {
            this.buildTokenService();
        }
        return this.tokenService;
    }

    public FlowsApiClient getFlowsApiClient() {
        if (this.flowsApiClient == null) {
            this.buildFlowsApiClient();
        }
        return this.flowsApiClient;
    }

    public String getEnvId() {
        return this.envId;
    }

    public String getAuthPath() {
        return this.authEndpoint;
    }
}

