/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.api.client.flows;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.adapters.pingone.mfa.api.client.flows.FlowsApiClient;
import com.pingidentity.adapters.pingone.mfa.api.handler.FlowResponseHandler;
import com.pingidentity.adapters.pingone.mfa.api.handler.SignoffResponseHandler;
import com.pingidentity.adapters.pingone.mfa.api.model.request.CheckAssertionRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.request.CheckOtpRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.request.CheckUsernameRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.request.SelectDeviceRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.response.FlowResponse;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.lang3.StringUtils;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.logging.Log;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.logging.LogFactory;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.client.fluent.Executor;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.client.fluent.Form;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.client.fluent.Request;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.entity.ContentType;
import com.pingidentity.adapters.pingone.mfa.util.UrlUtil;
import java.io.IOException;
import org.apache.logging.log4j.ThreadContext;

public class FlowsApiClientImpl
implements FlowsApiClient {
    public static final String TRANSACTION_ID_HEADER = "X-Ping-External-Transaction-ID";
    public static final String TRACKING_ID_HEADER = "X-Ping-External-Session-ID";
    public static final String TRANSACTION_ID = "transactionid";
    public static final String TRACKING_ID = "trackingid";
    private static final String PI_FLOW = "pi.flow";
    private static final String USER_LOOKUP = "application/vnd.pingidentity.user.lookup+json";
    private static final String DEVICE_SELECT = "application/vnd.pingidentity.device.select+json";
    private static final String OTP_CHECK = "application/vnd.pingidentity.otp.check+json";
    private static final String ASSERTION_CHECK = "application/vnd.pingidentity.assertion.check+json";
    private static final String ST_COOKIE_TEMPLATE = "ST=%s";
    private final Executor executor;
    private final ObjectMapper objectMapper;
    private final String authPath;
    private final String envId;
    private final String appId;
    private final String policy;
    private String baseFlowUrl;
    private static final Log log = LogFactory.getLog(FlowsApiClientImpl.class);

    private FlowsApiClientImpl(Builder builder) {
        this.executor = builder.executor;
        this.objectMapper = builder.objectMapper;
        this.authPath = UrlUtil.trimTrailingSlash(builder.authPath);
        this.envId = builder.envId;
        this.appId = builder.appId;
        this.policy = builder.policy;
        this.setBaseFlowUrl();
    }

    @Override
    public FlowResponse initiateFlowPostVariant(String loginHintToken, String mobilePayload, String acrValues, String requestParam, String sessionToken) throws IOException {
        return this.initiateFlowPost(this.appId, loginHintToken, mobilePayload, acrValues, requestParam, sessionToken, null, null);
    }

    @Override
    public FlowResponse initiateFlowPost(String appId, String loginHintToken, String mobilePayload, String acrValues, String requestParam, String sessionToken, String userAgent, String prompt) throws IOException {
        String policy = this.policy;
        if (StringUtils.isBlank(policy) && !StringUtils.isBlank(acrValues)) {
            policy = acrValues;
        }
        String initiateFlowUrl = this.getInitiateFlowPostUrl();
        Form form = Form.form();
        if (StringUtils.isNotBlank(policy)) {
            form.add("acr_values", policy.replaceAll("%20", " "));
        }
        if (StringUtils.isNotBlank(loginHintToken)) {
            form.add("login_hint_token", loginHintToken);
        }
        if (StringUtils.isNotBlank(mobilePayload)) {
            form.add("mobilePayload", mobilePayload);
        }
        if (StringUtils.isNotBlank(requestParam)) {
            form.add("request", requestParam);
        }
        form.add("client_id", appId);
        form.add("response_type", "token id_token");
        form.add("response_mode", PI_FLOW);
        form.add("scope", "openid");
        if (StringUtils.isNotBlank(prompt)) {
            form.add("prompt", prompt);
        }
        log.debug("Initiating P1 Authentication API: " + initiateFlowUrl);
        if (StringUtils.isNotBlank(sessionToken)) {
            FlowResponse flowResponse = this.executor.execute(Request.Post(initiateFlowUrl).setHeader("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.toString()).setHeader(TRACKING_ID_HEADER, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER, ThreadContext.get((String)TRANSACTION_ID)).setHeader("Cookie", String.format(ST_COOKIE_TEMPLATE, sessionToken)).setHeader("User-Agent", userAgent).bodyForm(form.build())).handleResponse(new FlowResponseHandler());
            log.debug(flowResponse.toString());
            return flowResponse;
        }
        FlowResponse flowResponse = this.executor.execute(Request.Post(initiateFlowUrl).setHeader("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.toString()).setHeader(TRACKING_ID_HEADER, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER, ThreadContext.get((String)TRANSACTION_ID)).setHeader("User-Agent", userAgent).bodyForm(form.build())).handleResponse(new FlowResponseHandler());
        log.debug(flowResponse.toString());
        return flowResponse;
    }

    @Override
    public FlowResponse initiateFlowVariant(String acrValues) throws IOException {
        String policy = this.policy;
        if (StringUtils.isBlank(policy) && !StringUtils.isBlank(acrValues)) {
            policy = acrValues;
        }
        String initiateFlowUrl = this.getInitiateFlowUrl(this.appId, policy);
        log.debug("Initiating P1 Authentication API: " + initiateFlowUrl);
        return this.executor.execute(Request.Get(initiateFlowUrl).setHeader(TRACKING_ID_HEADER, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER, ThreadContext.get((String)TRANSACTION_ID))).handleResponse(new FlowResponseHandler());
    }

    @Override
    public FlowResponse getFlow(String flowId, String sessionToken) throws IOException {
        String flowUrl = this.getFlowUrl(flowId);
        if (StringUtils.isNotBlank(sessionToken)) {
            return this.executor.execute(Request.Get(flowUrl).setHeader(TRACKING_ID_HEADER, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER, ThreadContext.get((String)TRANSACTION_ID)).setHeader("Cookie", String.format(ST_COOKIE_TEMPLATE, sessionToken))).handleResponse(new FlowResponseHandler());
        }
        return this.executor.execute(Request.Get(flowUrl).setHeader(TRACKING_ID_HEADER, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER, ThreadContext.get((String)TRANSACTION_ID))).handleResponse(new FlowResponseHandler());
    }

    @Override
    public FlowResponse checkUsername(String flowId, CheckUsernameRequest request, String sessionToken) throws IOException {
        String flowUrl = this.getFlowUrl(flowId);
        String bodyString = this.objectMapper.writeValueAsString(request);
        if (StringUtils.isNotBlank(sessionToken)) {
            return this.executor.execute(Request.Post(flowUrl).setHeader("Cookie", String.format(ST_COOKIE_TEMPLATE, sessionToken)).setHeader(TRACKING_ID_HEADER, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER, ThreadContext.get((String)TRANSACTION_ID)).bodyString(bodyString, ContentType.create(USER_LOOKUP))).handleResponse(new FlowResponseHandler());
        }
        return this.executor.execute(Request.Post(flowUrl).setHeader(TRACKING_ID_HEADER, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER, ThreadContext.get((String)TRANSACTION_ID)).bodyString(bodyString, ContentType.create(USER_LOOKUP))).handleResponse(new FlowResponseHandler());
    }

    @Override
    public FlowResponse selectDevice(String flowId, SelectDeviceRequest request, String sessionToken) throws IOException {
        String flowUrl = this.getFlowUrl(flowId);
        String bodyString = this.objectMapper.writeValueAsString(request);
        if (StringUtils.isNotBlank(sessionToken)) {
            return this.executor.execute(Request.Post(flowUrl).setHeader("Cookie", String.format(ST_COOKIE_TEMPLATE, sessionToken)).setHeader(TRACKING_ID_HEADER, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER, ThreadContext.get((String)TRACKING_ID)).bodyString(bodyString, ContentType.create(DEVICE_SELECT))).handleResponse(new FlowResponseHandler());
        }
        return this.executor.execute(Request.Post(flowUrl).setHeader(TRACKING_ID_HEADER, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER, ThreadContext.get((String)TRANSACTION_ID)).bodyString(bodyString, ContentType.create(DEVICE_SELECT))).handleResponse(new FlowResponseHandler());
    }

    @Override
    public FlowResponse checkOtp(String flowId, CheckOtpRequest request, String sessionToken) throws IOException {
        String flowUrl = this.getFlowUrl(flowId);
        String bodyString = this.objectMapper.writeValueAsString(request);
        if (StringUtils.isNotBlank(sessionToken)) {
            return this.executor.execute(Request.Post(flowUrl).setHeader("Cookie", String.format(ST_COOKIE_TEMPLATE, sessionToken)).setHeader(TRACKING_ID_HEADER, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER, ThreadContext.get((String)TRANSACTION_ID)).bodyString(bodyString, ContentType.create(OTP_CHECK))).handleResponse(new FlowResponseHandler());
        }
        return this.executor.execute(Request.Post(flowUrl).setHeader(TRACKING_ID_HEADER, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER, ThreadContext.get((String)TRANSACTION_ID)).bodyString(bodyString, ContentType.create(OTP_CHECK))).handleResponse(new FlowResponseHandler());
    }

    @Override
    public FlowResponse checkAssertion(String flowId, CheckAssertionRequest request, String sessionToken) throws IOException {
        String flowUrl = this.getFlowUrl(flowId);
        String bodyString = this.objectMapper.writeValueAsString(request);
        if (StringUtils.isNotBlank(sessionToken)) {
            return this.executor.execute(Request.Post(flowUrl).setHeader("Cookie", String.format(ST_COOKIE_TEMPLATE, sessionToken)).setHeader(TRACKING_ID_HEADER, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER, ThreadContext.get((String)TRANSACTION_ID)).bodyString(bodyString, ContentType.create(ASSERTION_CHECK))).handleResponse(new FlowResponseHandler());
        }
        return this.executor.execute(Request.Post(flowUrl).setHeader(TRACKING_ID_HEADER, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER, ThreadContext.get((String)TRANSACTION_ID)).bodyString(bodyString, ContentType.create(ASSERTION_CHECK))).handleResponse(new FlowResponseHandler());
    }

    @Override
    public FlowResponse resume(String flowId, String sessionToken) throws IOException {
        String resumeUrl = this.getResumeUrl(flowId);
        return this.executor.execute(Request.Get(resumeUrl).setHeader("Cookie", String.format(ST_COOKIE_TEMPLATE, sessionToken)).setHeader(TRACKING_ID_HEADER, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER, ThreadContext.get((String)TRANSACTION_ID))).handleResponse(new FlowResponseHandler());
    }

    @Override
    public Void signoff(String sessionToken) throws IOException {
        String signoffUrl = this.getSignoffUrl();
        return this.executor.execute(Request.Get(signoffUrl).setHeader("Cookie", String.format(ST_COOKIE_TEMPLATE, sessionToken)).setHeader(TRACKING_ID_HEADER, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER, ThreadContext.get((String)TRANSACTION_ID))).handleResponse(new SignoffResponseHandler());
    }

    private String getInitiateFlowPostUrl() {
        String initiateFlowUrl = this.authPath + "/" + this.envId + "/as/authorize";
        return initiateFlowUrl;
    }

    private String getInitiateFlowUrl(String appId, String policy) {
        String initiateFlowUrl = this.authPath + "/" + this.envId + "/as/authorize?client_id=" + appId + "&response_type=token%20id_token&response_mode=pi.flow&scope=openid";
        if (StringUtils.isNotBlank(policy)) {
            initiateFlowUrl = initiateFlowUrl + "&acr_values=" + policy;
        }
        return initiateFlowUrl;
    }

    private void setBaseFlowUrl() {
        this.baseFlowUrl = this.authPath + "/" + this.envId + "/flows";
    }

    private String getFlowUrl(String flowId) {
        return this.baseFlowUrl + "/" + flowId;
    }

    private String getResumeUrl(String flowId) {
        return this.authPath + "/" + this.envId + "/as/resume?flowId=" + flowId;
    }

    private String getSignoffUrl() {
        return this.authPath + "/" + this.envId + "/as/signoff";
    }

    public static class Builder {
        private Executor executor;
        private ObjectMapper objectMapper;
        private String authPath;
        private String envId;
        private String appId;
        private String policy;

        public Builder setExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public Builder setObjectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public Builder setAuthPath(String authPath) {
            this.authPath = authPath;
            return this;
        }

        public Builder setEnvId(String envId) {
            this.envId = envId;
            return this;
        }

        public Builder setAppId(String appId) {
            this.appId = appId;
            return this;
        }

        public Builder setPolicy(String policy) {
            if (!StringUtils.isBlank(policy)) {
                this.policy = policy.replaceAll(" ", "%20");
            }
            return this;
        }

        public FlowsApiClientImpl build() {
            if (this.executor == null || this.objectMapper == null || StringUtils.isBlank(this.authPath) || StringUtils.isBlank(this.envId) || StringUtils.isBlank(this.appId)) {
                throw new IllegalArgumentException("All fields are required to be non null/blank for an instance of " + this.getClass().getSimpleName());
            }
            return new FlowsApiClientImpl(this);
        }
    }
}

