/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.api.client.worker;

import com.pingidentity.adapters.pingone.mfa.api.handler.ManagementApiResponseHandler;
import com.pingidentity.adapters.pingone.mfa.api.model.applications.Application;
import com.pingidentity.adapters.pingone.mfa.api.model.policies.Action;
import com.pingidentity.adapters.pingone.mfa.api.model.policies.DeviceAuthenticationPolicy;
import com.pingidentity.adapters.pingone.mfa.api.model.policies.SignOnPolicy;
import com.pingidentity.adapters.pingone.mfa.api.model.request.ActivateDeviceRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.request.CheckAssertionRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.request.CheckOtpRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.request.DeviceRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.request.OfflineDeviceRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.request.PairingKeyRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.request.SetDeviceOrderRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.request.TOTPDeviceRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.request.UserRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.request.WebAuthnDeviceRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.request.authenticationcode.CreateAuthenticationCodesRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.request.onetimedeviceotpflow.CreateDeviceAuthenticationRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.request.usernamelessauth.UsernamelessAuthCreateRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.response.ApplicationSecretResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.ApplicationsResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.AuthenticationCodesResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.CreateOneTimeDeviceAuthenticationRequestResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.CreateUsernamelessAuthenticationResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.DeviceAuthenticationPolicyResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.ErrorResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.MFASettingsResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.PairingKey;
import com.pingidentity.adapters.pingone.mfa.api.model.response.PopulationsResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.SignOnPoliciesResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.SignOnPolicyActionsResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.TokenResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.UserDevicesResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.UsernamelessAuthAssertionCheckRequestResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.UsersResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.ValidateOneTimeDeviceAuthenticationRequestResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.users.User;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.OfflineDevice;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.TOTPDevice;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.fido.WebAuthnDevice;
import com.pingidentity.adapters.pingone.mfa.authn.api.Nickname;
import com.pingidentity.adapters.pingone.mfa.exception.ApiResponseException;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.codec.binary.Base64;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.lang3.StringUtils;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.Header;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.client.ResponseHandler;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.client.fluent.Executor;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.client.fluent.Form;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.client.fluent.Request;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.entity.ContentType;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.entity.StringEntity;
import com.pingidentity.adapters.pingone.mfa.util.ObjectMappers;
import com.pingidentity.adapters.pingone.mfa.util.UrlUtil;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import org.apache.logging.log4j.ThreadContext;

public class WorkerApiClient {
    private static final String BASIC_AUTH_CREDS_FORMAT = "%s:%s";
    private static final String BASIC_AUTH_HEADER_FORMAT = "Basic %s";
    private static final String TOKEN_ENDPOINT_TEMPLATE = "%s/%s/as/token";
    private static final String BEARER_TOKEN_FORMAT = "Bearer %s";
    public static final String TRANSACTION_ID_HEADER_NAME = "X-Ping-External-Transaction-ID";
    public static final String TRACKING_ID_HEADER_NAME = "X-Ping-External-Session-ID";
    public static final String TRANSACTION_ID = "transactionid";
    public static final String TRACKING_ID = "trackingid";
    private static final String USERS_ENDPOINT_TEMPLATE = "%s/v1/environments/%s/users";
    private static final String USER_ID_ENDPOINT_TEMPLATE = "%s/v1/environments/%s/users/%s";
    private static final String USER_ENDPOINT_FILTER_TEMPLATE = "%s/v1/environments/%s/users?filter=";
    private static final String USER_DEVICES_ENDPOINT_TEMPLATE = "%s/v1/environments/%s/users/%s/devices";
    private static final String USER_DEVICE_ENDPOINT_TEMPLATE = "%s/v1/environments/%s/users/%s/devices/%s";
    private static final String UPDATE_DEVICE_NICKNAME_ENDPOINT_TEMPLATE = "%s/v1/environments/%s/users/%s/devices/%s/nickname";
    private static final String USERNAME_FILTER_TEMPLATE = "username eq \"%s\"";
    private static final String PAIRING_KEYS_ENDPOINT_TEMPLATE = "%s/v1/environments/%s/users/%s/pairingKeys";
    private static final String PAIRING_KEY_ENDPOINT_TEMPLATE = "%s/v1/environments/%s/users/%s/pairingKeys/%s";
    private static final String SIGN_ON_POLICIES_ENDPOINT_TEMPLATE = "%s/v1/environments/%s/signOnPolicies";
    private static final String SIGN_ON_POLICIES_ACTIONS_ENDPOINT_TEMPLATE = "%s/v1/environments/%s/signOnPolicies/%s/actions";
    private static final String APPLICATION_ENDPOINT_TEMPLATE = "%s/v1/environments/%s/applications/%s";
    private static final String APPLICATION_SECRET_ENDPOINT_TEMPLATE = "%s/v1/environments/%s/applications/%s/secret";
    private static final String APPLICATIONS_ENDPOINT_TEMPLATE = "%s/v1/environments/%s/applications";
    private static final String POPULATIONS_ENDPOINT_TEMPLATE = "%s/v1/environments/%s/populations";
    private static final String MFA_SETTINGS_ENDPOINT_TEMPLATE = "%s/v1/environments/%s/mfaSettings";
    private static final String CREATE_AUTHENTICATION_CODES_ENDPOINT_TEMPLATE = "%s/%s/authenticationCodes";
    private static final String CHECK_AUTHENTICATION_CODES_STATUS_ENDPOINT_TEMPLATE = "%s/%s/authenticationCodes/%s";
    private static final String CREATE_DEVICE_AUTHENTICATION_ENDPOINT_TEMPLATE = "%s/%s/deviceAuthentications";
    private static final String VALIDATE_DEVICE_AUTHENTICATION_ENDPOINT_TEMPLATE = "%s/%s/deviceAuthentications/%s";
    private static final String MFA_POLICY_ENDPOINT_TEMPLATE = "%s/v1/environments/%s/deviceAuthenticationPolicies/%s";
    private static final String MFA_POLICIES_ENDPOINT_TEMPLATE = "%s/v1/environments/%s/deviceAuthenticationPolicies";
    private static final String REORDER_DEVICE = "application/vnd.pingidentity.devices.reorder+json";
    private static final String ACTIVATE_DEVICE_CONTENT_TYPE = "application/vnd.pingidentity.device.activate+json";
    private static final String ONE_TIME_DEVICE_AUTH_OTP_CHECK = "application/vnd.pingidentity.otp.check+json";
    private static final String ASSERTION_CHECK = "application/vnd.pingidentity.assertion.check+json";
    private final Executor executor;
    private final String apiPath;
    private final String authPath;
    private final String envId;
    private final String tokenEndpointUrl;
    private final String basicAuthHeaderValue;

    public WorkerApiClient(Builder builder) {
        this.executor = builder.executor;
        this.apiPath = UrlUtil.trimTrailingSlash(builder.apiPath);
        this.envId = builder.envId;
        String clientId = builder.clientId;
        String clientSecret = builder.clientSecret;
        if (StringUtils.isNotEmpty(clientId) && StringUtils.isNotEmpty(clientSecret)) {
            String basicAuthCreds = String.format(BASIC_AUTH_CREDS_FORMAT, clientId, clientSecret);
            String encodedBasicAuthCreds = Base64.encodeBase64String(basicAuthCreds.getBytes());
            this.basicAuthHeaderValue = String.format(BASIC_AUTH_HEADER_FORMAT, encodedBasicAuthCreds);
        } else {
            this.basicAuthHeaderValue = null;
        }
        this.tokenEndpointUrl = String.format(TOKEN_ENDPOINT_TEMPLATE, UrlUtil.trimTrailingSlash(builder.authPath), this.envId);
        this.authPath = builder.authPath;
    }

    public TokenResponse getAccessToken(ResponseHandler<TokenResponse> responseHandler) throws IOException {
        if (StringUtils.isEmpty(this.basicAuthHeaderValue)) {
            throw new IllegalStateException("Client ID and client secret must be set to request an access token.");
        }
        Form form = Form.form().add("grant_type", "client_credentials");
        return this.executor.execute(Request.Post(this.tokenEndpointUrl).setHeader("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.toString()).setHeader("Authorization", this.basicAuthHeaderValue).bodyForm(form.build())).handleResponse(responseHandler);
    }

    public User getUserById(String accessToken, String userId) throws IOException {
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        userId = URLEncoder.encode(userId, "UTF-8");
        String userEndpoint = String.format(USER_ID_ENDPOINT_TEMPLATE, this.apiPath, this.envId, userId);
        try {
            return this.executor.execute(Request.Get(userEndpoint).setHeader("Authorization", authHeader).setHeader(TRACKING_ID_HEADER_NAME, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER_NAME, ThreadContext.get((String)TRANSACTION_ID))).handleResponse(new ManagementApiResponseHandler<User>(User.class));
        }
        catch (ApiResponseException e) {
            ErrorResponse errorResponse = (ErrorResponse)e.getErrorResponse();
            if (404 == e.getStatusCode() || errorResponse != null && "INVALID_REQUEST".equals(errorResponse.getCode())) {
                return null;
            }
            throw e;
        }
    }

    public Application getApplicationById(String accessToken, String applicationId) throws IOException {
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        String applicationInfoEndpoint = String.format(APPLICATION_ENDPOINT_TEMPLATE, this.apiPath, this.envId, applicationId);
        return this.executor.execute(Request.Get(applicationInfoEndpoint).setHeader("Authorization", authHeader).setHeader(TRACKING_ID_HEADER_NAME, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER_NAME, ThreadContext.get((String)TRANSACTION_ID))).handleResponse(new ManagementApiResponseHandler<Application>(Application.class));
    }

    public ApplicationsResponse getApplications(String accessToken) throws IOException {
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        String applicationInfoEndpoint = String.format(APPLICATIONS_ENDPOINT_TEMPLATE, this.apiPath, this.envId);
        return this.executor.execute(Request.Get(applicationInfoEndpoint).setHeader("Authorization", authHeader)).handleResponse(new ManagementApiResponseHandler<ApplicationsResponse>(ApplicationsResponse.class));
    }

    public ApplicationSecretResponse getApplicationSecret(ResponseHandler<ApplicationSecretResponse> responseHandler, String accessToken, String applicationId) throws IOException {
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        String applicationSecretEndpoint = String.format(APPLICATION_SECRET_ENDPOINT_TEMPLATE, this.apiPath, this.envId, applicationId);
        return this.executor.execute(Request.Get(applicationSecretEndpoint).setHeader("Authorization", authHeader)).handleResponse(responseHandler);
    }

    public List<SignOnPolicy> getSignOnPolicies(String accessToken) throws IOException {
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        String signOnPoliciesEndpoint = String.format(SIGN_ON_POLICIES_ENDPOINT_TEMPLATE, this.apiPath, this.envId);
        return this.executor.execute(Request.Get(signOnPoliciesEndpoint).setHeader("Authorization", authHeader).setHeader(TRACKING_ID_HEADER_NAME, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER_NAME, ThreadContext.get((String)TRANSACTION_ID))).handleResponse(new ManagementApiResponseHandler<SignOnPoliciesResponse>(SignOnPoliciesResponse.class)).getSignOnPolicies();
    }

    public List<Action> getSignOnPolicyActionsFromPolicyName(String accessToken, String policyName) throws IOException {
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        List<SignOnPolicy> signOnPolicyList = this.getSignOnPolicies(accessToken);
        Predicate<SignOnPolicy> predicate = StringUtils.isBlank(policyName) ? authenticationPolicy -> authenticationPolicy.isDefault() : authenticationPolicy -> authenticationPolicy.getName().equals(policyName);
        SignOnPolicy signOnPolicy = signOnPolicyList.stream().filter(predicate).findFirst().orElse(null);
        if (signOnPolicy != null) {
            String signOnPolicyActionEndpoint = String.format(SIGN_ON_POLICIES_ACTIONS_ENDPOINT_TEMPLATE, this.apiPath, this.envId, signOnPolicy.getId());
            return this.executor.execute(Request.Get(signOnPolicyActionEndpoint).setHeader("Authorization", authHeader).setHeader(TRACKING_ID_HEADER_NAME, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER_NAME, ThreadContext.get((String)TRANSACTION_ID))).handleResponse(new ManagementApiResponseHandler<SignOnPolicyActionsResponse>(SignOnPolicyActionsResponse.class)).getSignOnPolicyActions();
        }
        return null;
    }

    public User getUserByUsername(String accessToken, String username) throws IOException {
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        Object userEndpoint = String.format(USER_ENDPOINT_FILTER_TEMPLATE, this.apiPath, this.envId);
        UsersResponse usersResponse = this.executor.execute(Request.Get((String)(userEndpoint = (String)userEndpoint + URLEncoder.encode(String.format(USERNAME_FILTER_TEMPLATE, username), "UTF-8"))).setHeader("Authorization", authHeader).setHeader(TRACKING_ID_HEADER_NAME, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER_NAME, ThreadContext.get((String)TRANSACTION_ID))).handleResponse(new ManagementApiResponseHandler<UsersResponse>(UsersResponse.class));
        if (usersResponse.getUsers() == null || usersResponse.getUsers().isEmpty()) {
            return null;
        }
        return usersResponse.getUsers().get(0);
    }

    public List<Device> getUserDevices(String accessToken, String userId, String filter) throws IOException {
        UserDevicesResponse userDevicesResponse;
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        Object userDevicesEndpoint = String.format(USER_DEVICES_ENDPOINT_TEMPLATE, this.apiPath, this.envId, userId);
        if (StringUtils.isNotBlank(filter)) {
            userDevicesEndpoint = (String)userDevicesEndpoint + String.format("?filter=%s", URLEncoder.encode(filter));
        }
        if ((userDevicesResponse = this.executor.execute(Request.Get((String)userDevicesEndpoint).setHeader("Authorization", authHeader).setHeader(TRACKING_ID_HEADER_NAME, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER_NAME, ThreadContext.get((String)TRANSACTION_ID))).handleResponse(new ManagementApiResponseHandler<UserDevicesResponse>(UserDevicesResponse.class))) == null || userDevicesResponse.getEmbeddedResources() == null) {
            return new ArrayList<Device>();
        }
        return userDevicesResponse.getEmbeddedResources().getDevices();
    }

    public UserDevicesResponse getExpandedUserDevices(String accessToken, String userId, String mfaPolicyId, String ... expandValues) throws IOException {
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        StringBuilder queryParams = new StringBuilder("?filter=").append(URLEncoder.encode("status eq \"ACTIVE\"", StandardCharsets.UTF_8.toString())).append((String)(StringUtils.isNotBlank(mfaPolicyId) ? "&policy=" + mfaPolicyId : "")).append(expandValues.length > 0 ? String.format("&expand=%s", String.join((CharSequence)",", expandValues)) : "");
        String userDevicesEndpoint = String.format(USER_DEVICES_ENDPOINT_TEMPLATE, this.apiPath, this.envId, userId) + queryParams;
        return this.executor.execute(Request.Get(userDevicesEndpoint).setHeader("Authorization", authHeader).setHeader(TRACKING_ID_HEADER_NAME, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER_NAME, ThreadContext.get((String)TRANSACTION_ID))).handleResponse(new ManagementApiResponseHandler<UserDevicesResponse>(UserDevicesResponse.class));
    }

    public PairingKey getPairingKey(String accessToken, String userId, String pairingKeyId) throws IOException {
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        String pairingKeyEndpoint = String.format(PAIRING_KEY_ENDPOINT_TEMPLATE, this.apiPath, this.envId, userId, pairingKeyId);
        return this.executor.execute(Request.Get(pairingKeyEndpoint).setHeader("Authorization", authHeader).setHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType()).setHeader(TRACKING_ID_HEADER_NAME, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER_NAME, ThreadContext.get((String)TRANSACTION_ID))).handleResponse(new ManagementApiResponseHandler<PairingKey>(PairingKey.class));
    }

    public PairingKey createPairingKey(String accessToken, String userId, PairingKeyRequest pairingKeyRequest) throws IOException {
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        String pairingKeyEndpoint = String.format(PAIRING_KEYS_ENDPOINT_TEMPLATE, this.apiPath, this.envId, userId);
        return this.executor.execute(Request.Post(pairingKeyEndpoint).setHeader("Authorization", authHeader).setHeader(TRACKING_ID_HEADER_NAME, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER_NAME, ThreadContext.get((String)TRANSACTION_ID)).setHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType()).body(new StringEntity(ObjectMappers.getDefault().writeValueAsString(pairingKeyRequest), ContentType.APPLICATION_JSON))).handleResponse(new ManagementApiResponseHandler<PairingKey>(PairingKey.class));
    }

    public User createUser(String accessToken, UserRequest userRequest) throws IOException {
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        String endpoint = String.format(USERS_ENDPOINT_TEMPLATE, this.apiPath, this.envId);
        return this.executor.execute(Request.Post(endpoint).setHeader("Authorization", authHeader).setHeader(TRACKING_ID_HEADER_NAME, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER_NAME, ThreadContext.get((String)TRANSACTION_ID)).setHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType()).body(new StringEntity(ObjectMappers.getDefault().writeValueAsString(userRequest), ContentType.APPLICATION_JSON))).handleResponse(new ManagementApiResponseHandler<User>(User.class));
    }

    public PopulationsResponse getPopulations(String accessToken) throws IOException {
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        String populationsEndpoint = String.format(POPULATIONS_ENDPOINT_TEMPLATE, this.apiPath, this.envId);
        return this.executor.execute(Request.Get(populationsEndpoint).setHeader("Authorization", authHeader).setHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType())).handleResponse(new ManagementApiResponseHandler<PopulationsResponse>(PopulationsResponse.class));
    }

    public MFASettingsResponse getMFASettings(String accessToken) throws IOException {
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        String mfaSettingsEndpoint = String.format(MFA_SETTINGS_ENDPOINT_TEMPLATE, this.apiPath, this.envId);
        return this.executor.execute(Request.Get(mfaSettingsEndpoint).setHeader("Authorization", authHeader).setHeader(TRACKING_ID_HEADER_NAME, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER_NAME, ThreadContext.get((String)TRANSACTION_ID)).setHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType())).handleResponse(new ManagementApiResponseHandler<MFASettingsResponse>(MFASettingsResponse.class));
    }

    public void setDefaultDevice(String accessToken, String userId, String deviceId) throws IOException {
        List<Device> devices = this.getUserDevices(accessToken, userId, null);
        ArrayList<String> devicesIds = new ArrayList<String>();
        devicesIds.add(deviceId);
        for (Device device : devices) {
            if (device.getId().equals(deviceId)) continue;
            devicesIds.add(device.getId());
        }
        SetDeviceOrderRequest setDeviceOrderRequest = new SetDeviceOrderRequest(devicesIds);
        this.reorderDevices(accessToken, userId, setDeviceOrderRequest);
    }

    public TOTPDevice createTOTPDevice(String accessToken, String userId, TOTPDeviceRequest totpDeviceRequest) throws IOException {
        return (TOTPDevice)this.createDevice(new ManagementApiResponseHandler<TOTPDevice>(TOTPDevice.class), accessToken, userId, totpDeviceRequest);
    }

    public WebAuthnDevice createWebAuthnDevice(String accessToken, String userId, WebAuthnDeviceRequest webAuthnDeviceRequest) throws IOException {
        return (WebAuthnDevice)this.createDevice(new ManagementApiResponseHandler<WebAuthnDevice>(WebAuthnDevice.class), accessToken, userId, webAuthnDeviceRequest);
    }

    public <T extends OfflineDevice> T createOfflineDevice(String accessToken, String userId, OfflineDeviceRequest deviceRequest) throws IOException {
        return (T)((OfflineDevice)this.createDevice(new ManagementApiResponseHandler<OfflineDevice>(OfflineDevice.class), accessToken, userId, deviceRequest));
    }

    public Device activateDevice(String accessToken, String userId, String deviceId, ActivateDeviceRequest activateDeviceRequest) throws IOException {
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        String endpoint = String.format(USER_DEVICE_ENDPOINT_TEMPLATE, this.apiPath, this.envId, userId, deviceId);
        return this.executor.execute(Request.Post(endpoint).setHeader("Authorization", authHeader).setHeader(TRACKING_ID_HEADER_NAME, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER_NAME, ThreadContext.get((String)TRANSACTION_ID)).setHeader("Content-Type", ACTIVATE_DEVICE_CONTENT_TYPE).body(new StringEntity(ObjectMappers.getDefault().writeValueAsString(activateDeviceRequest), ContentType.APPLICATION_JSON))).handleResponse(new ManagementApiResponseHandler<Device>(Device.class));
    }

    public void deleteDevice(String accessToken, String userId, String deviceId) throws IOException {
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        String endpoint = String.format(USER_DEVICE_ENDPOINT_TEMPLATE, this.apiPath, this.envId, userId, deviceId);
        this.executor.execute(Request.Delete(endpoint).setHeader("Authorization", authHeader).setHeader(TRACKING_ID_HEADER_NAME, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER_NAME, ThreadContext.get((String)TRANSACTION_ID)));
    }

    public CreateUsernamelessAuthenticationResponse createUsernamelessAuthenticationRequest(ResponseHandler<? extends CreateUsernamelessAuthenticationResponse> responseHandler, String accessToken, UsernamelessAuthCreateRequest usernamelessAuthCreateRequest) throws IOException {
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        String endpoint = String.format(CREATE_DEVICE_AUTHENTICATION_ENDPOINT_TEMPLATE, this.authPath, this.envId);
        Request request = Request.Post(endpoint).setHeader("Authorization", authHeader).setHeader(TRACKING_ID_HEADER_NAME, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER_NAME, ThreadContext.get((String)TRANSACTION_ID)).setHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType()).body(new StringEntity(ObjectMappers.getDefault().writeValueAsString(usernamelessAuthCreateRequest), ContentType.APPLICATION_JSON));
        CreateUsernamelessAuthenticationResponse createUsernamelessAuthenticationResponse = this.executor.execute(request).handleResponse(responseHandler);
        Header[] headers = ((ManagementApiResponseHandler)responseHandler).getHeaders();
        createUsernamelessAuthenticationResponse.setHeaders(headers);
        return createUsernamelessAuthenticationResponse;
    }

    public UsernamelessAuthAssertionCheckRequestResponse checkUsernamelessAuthenticationCheckAssertionRequest(String accessToken, CheckAssertionRequest checkAssertionRequest, String deviceAuthenticationId) throws IOException {
        String checkAssertionRequestAsString = ObjectMappers.getDefault().writeValueAsString(checkAssertionRequest);
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        String endpoint = String.format(VALIDATE_DEVICE_AUTHENTICATION_ENDPOINT_TEMPLATE, this.authPath, this.envId, deviceAuthenticationId);
        Request request = Request.Post(endpoint).setHeader("Authorization", authHeader).setHeader(TRACKING_ID_HEADER_NAME, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER_NAME, ThreadContext.get((String)TRANSACTION_ID)).setHeader("Content-Type", ASSERTION_CHECK).body(new StringEntity(checkAssertionRequestAsString, ContentType.APPLICATION_JSON));
        return this.executor.execute(request).handleResponse(new ManagementApiResponseHandler<UsernamelessAuthAssertionCheckRequestResponse>(UsernamelessAuthAssertionCheckRequestResponse.class));
    }

    public AuthenticationCodesResponse createAuthenticationCodes(String accessToken, CreateAuthenticationCodesRequest createAuthenticationCodesRequest) throws IOException {
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        String endpoint = String.format(CREATE_AUTHENTICATION_CODES_ENDPOINT_TEMPLATE, this.authPath, this.envId);
        Request request = Request.Post(endpoint).setHeader("Authorization", authHeader).setHeader(TRACKING_ID_HEADER_NAME, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER_NAME, ThreadContext.get((String)TRANSACTION_ID)).setHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType()).body(new StringEntity(ObjectMappers.getDefault().writeValueAsString(createAuthenticationCodesRequest), ContentType.APPLICATION_JSON));
        ManagementApiResponseHandler<AuthenticationCodesResponse> responseHandler = new ManagementApiResponseHandler<AuthenticationCodesResponse>(AuthenticationCodesResponse.class);
        AuthenticationCodesResponse authenticationCodesRequestResponse = this.executor.execute(request).handleResponse(responseHandler);
        Header[] headers = responseHandler.getHeaders();
        authenticationCodesRequestResponse.setHeaders(headers);
        return authenticationCodesRequestResponse;
    }

    public AuthenticationCodesResponse checkAuthenticationCodeRequestStatus(String accessToken, String authenticationCodeId) throws IOException {
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        String endpoint = String.format(CHECK_AUTHENTICATION_CODES_STATUS_ENDPOINT_TEMPLATE, this.authPath, this.envId, authenticationCodeId);
        Request request = Request.Get(endpoint).setHeader("Authorization", authHeader).setHeader(TRACKING_ID_HEADER_NAME, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER_NAME, ThreadContext.get((String)TRANSACTION_ID)).setHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        return this.executor.execute(request).handleResponse(new ManagementApiResponseHandler<AuthenticationCodesResponse>(AuthenticationCodesResponse.class));
    }

    public CreateOneTimeDeviceAuthenticationRequestResponse createOneTimeDeviceAuthenticationRequest(ResponseHandler<? extends CreateOneTimeDeviceAuthenticationRequestResponse> responseHandler, String accessToken, CreateDeviceAuthenticationRequest createDeviceAuthenticationRequest) throws IOException {
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        String endpoint = String.format(CREATE_DEVICE_AUTHENTICATION_ENDPOINT_TEMPLATE, this.authPath, this.envId);
        Request request = Request.Post(endpoint).setHeader("Authorization", authHeader).setHeader(TRACKING_ID_HEADER_NAME, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER_NAME, ThreadContext.get((String)TRANSACTION_ID)).setHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType()).body(new StringEntity(ObjectMappers.getDefault().writeValueAsString(createDeviceAuthenticationRequest), ContentType.APPLICATION_JSON));
        CreateOneTimeDeviceAuthenticationRequestResponse createOneTimeDeviceAuthenticationRequestResponse = this.executor.execute(request).handleResponse(responseHandler);
        Header[] headers = ((ManagementApiResponseHandler)responseHandler).getHeaders();
        createOneTimeDeviceAuthenticationRequestResponse.setHeaders(headers);
        return createOneTimeDeviceAuthenticationRequestResponse;
    }

    public ValidateOneTimeDeviceAuthenticationRequestResponse validateOneTimeDeviceAuthenticationRequestOTP(String accessToken, CheckOtpRequest checkOtpRequest, String deviceAuthenticationRequestId) throws IOException {
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        String endpoint = String.format(VALIDATE_DEVICE_AUTHENTICATION_ENDPOINT_TEMPLATE, this.authPath, this.envId, deviceAuthenticationRequestId);
        Request request = Request.Post(endpoint).setHeader("Authorization", authHeader).setHeader(TRACKING_ID_HEADER_NAME, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER_NAME, ThreadContext.get((String)TRANSACTION_ID)).setHeader("Content-Type", ONE_TIME_DEVICE_AUTH_OTP_CHECK).body(new StringEntity(ObjectMappers.getDefault().writeValueAsString(checkOtpRequest), ContentType.APPLICATION_JSON));
        return this.executor.execute(request).handleResponse(new ManagementApiResponseHandler<ValidateOneTimeDeviceAuthenticationRequestResponse>(ValidateOneTimeDeviceAuthenticationRequestResponse.class));
    }

    private Device createDevice(ResponseHandler<? extends Device> responseHandler, String accessToken, String userId, DeviceRequest deviceRequest) throws IOException {
        String userAgent;
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        String endpoint = String.format(USER_DEVICES_ENDPOINT_TEMPLATE, this.apiPath, this.envId, userId);
        Request request = Request.Post(endpoint).setHeader("Authorization", authHeader).setHeader(TRACKING_ID_HEADER_NAME, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER_NAME, ThreadContext.get((String)TRANSACTION_ID)).setHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType()).body(new StringEntity(ObjectMappers.getDefault().writeValueAsString(deviceRequest), ContentType.APPLICATION_JSON));
        if (deviceRequest instanceof WebAuthnDeviceRequest && StringUtils.isNotBlank(userAgent = ((WebAuthnDeviceRequest)deviceRequest).getUserAgent())) {
            request.addHeader("User-Agent", userAgent);
        }
        return this.executor.execute(request).handleResponse(responseHandler);
    }

    public DeviceAuthenticationPolicy getMFAPolicyFromAuthenticationPolicy(String accessToken, String authenticationPolicyName) throws IOException {
        List<Action> authenticationPolicyAction = this.getSignOnPolicyActionsFromPolicyName(accessToken, authenticationPolicyName);
        Action multiFactorAuthenticationAction = authenticationPolicyAction.stream().filter(it -> "MULTI_FACTOR_AUTHENTICATION".equals(it.getType())).findFirst().orElseThrow(() -> new RuntimeException());
        UUID mfaPolicyId = Optional.ofNullable(multiFactorAuthenticationAction.getDeviceAuthenticationPolicy()).map(DeviceAuthenticationPolicy::getId).orElse(null);
        Predicate<DeviceAuthenticationPolicy> predicate = mfaPolicyId == null ? mfaPolicy -> mfaPolicy.isDefault() : mfaPolicy -> mfaPolicy.getId().equals(mfaPolicyId);
        List<DeviceAuthenticationPolicy> allMFAPolicies = this.getAllMFAPolicies(accessToken);
        return allMFAPolicies.stream().filter(predicate).findFirst().get();
    }

    public DeviceAuthenticationPolicy getDefaultMFAPolicy(String accessToken) throws IOException {
        List<DeviceAuthenticationPolicy> allMFAPolicies = this.getAllMFAPolicies(accessToken);
        return allMFAPolicies.stream().filter(mfaPolicy -> mfaPolicy.isDefault()).findFirst().get();
    }

    public List<DeviceAuthenticationPolicy> getAllMFAPolicies(String accessToken) throws IOException {
        return this.getDeviceAuthenticationPoliciesResponse(accessToken).getMfaPolicies();
    }

    public DeviceAuthenticationPolicyResponse getDeviceAuthenticationPoliciesResponse(String accessToken) throws IOException {
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        String mfaPoliciesEndpoint = String.format(MFA_POLICIES_ENDPOINT_TEMPLATE, this.apiPath, this.envId);
        return this.executor.execute(Request.Get(mfaPoliciesEndpoint).setHeader("Authorization", authHeader).setHeader(TRACKING_ID_HEADER_NAME, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER_NAME, ThreadContext.get((String)TRANSACTION_ID))).handleResponse(new ManagementApiResponseHandler<DeviceAuthenticationPolicyResponse>(DeviceAuthenticationPolicyResponse.class));
    }

    public DeviceAuthenticationPolicy getMFAPolicyById(String accessToken, String mfaPolicyId) throws IOException {
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        String mfaPolicyEndpoint = String.format(MFA_POLICY_ENDPOINT_TEMPLATE, this.apiPath, this.envId, mfaPolicyId);
        return this.executor.execute(Request.Get(mfaPolicyEndpoint).setHeader("Authorization", authHeader).setHeader(TRACKING_ID_HEADER_NAME, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER_NAME, ThreadContext.get((String)TRANSACTION_ID))).handleResponse(new ManagementApiResponseHandler<DeviceAuthenticationPolicy>(DeviceAuthenticationPolicy.class));
    }

    public Nickname updateDeviceNickname(String accessToken, String userId, Nickname updatedNickname) throws IOException {
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        String devicesEndpoint = String.format(UPDATE_DEVICE_NICKNAME_ENDPOINT_TEMPLATE, this.apiPath, this.envId, userId, updatedNickname.getId());
        return this.executor.execute(Request.Put(devicesEndpoint).setHeader("Authorization", authHeader).setHeader(TRACKING_ID_HEADER_NAME, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER_NAME, ThreadContext.get((String)TRANSACTION_ID)).body(new StringEntity(ObjectMappers.getDefault().writeValueAsString(updatedNickname), ContentType.APPLICATION_JSON))).handleResponse(new ManagementApiResponseHandler<Nickname>(Nickname.class));
    }

    public void reorderDevices(String accessToken, String userId, SetDeviceOrderRequest orderRequest) throws IOException {
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        String endpoint = String.format(USER_DEVICES_ENDPOINT_TEMPLATE, this.apiPath, this.envId, userId);
        this.executor.execute(Request.Post(endpoint).setHeader("Authorization", authHeader).setHeader("Content-Type", REORDER_DEVICE).setHeader(TRACKING_ID_HEADER_NAME, ThreadContext.get((String)TRACKING_ID)).setHeader(TRANSACTION_ID_HEADER_NAME, ThreadContext.get((String)TRANSACTION_ID)).body(new StringEntity(ObjectMappers.getDefault().writeValueAsString(orderRequest), ContentType.APPLICATION_JSON))).handleResponse(new ManagementApiResponseHandler<UserDevicesResponse>(UserDevicesResponse.class));
    }

    public static class Builder {
        private Executor executor;
        private String authPath;
        private String apiPath;
        private String envId;
        private String clientId;
        private String clientSecret;

        public Builder setExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public Builder setAuthPath(String authPath) {
            this.authPath = authPath;
            return this;
        }

        public Builder setApiPath(String apiPath) {
            this.apiPath = apiPath;
            return this;
        }

        public Builder setEnvId(String envId) {
            this.envId = envId;
            return this;
        }

        public Builder setClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public WorkerApiClient build() {
            if (this.executor == null || StringUtils.isBlank(this.authPath) || StringUtils.isBlank(this.apiPath) || StringUtils.isBlank(this.envId)) {
                throw new IllegalArgumentException("All fields are required to be non null/blank for an instance of " + this.getClass().getSimpleName());
            }
            return new WorkerApiClient(this);
        }
    }
}

