/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.api.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.InvalidTypeIdException;
import com.pingidentity.adapters.pingone.mfa.PingOneMfaIdpAdapterLogEvent;
import com.pingidentity.adapters.pingone.mfa.api.model.ApiErrorResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.ApiResponse;
import com.pingidentity.adapters.pingone.mfa.exception.ApiResponseException;
import com.pingidentity.adapters.pingone.mfa.exception.RateLimitApiResponseException;
import com.pingidentity.adapters.pingone.mfa.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.lang3.StringUtils;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.Header;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.HttpEntity;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.HttpResponse;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.StatusLine;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.client.ResponseHandler;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.message.BasicHeader;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.util.EntityUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;

public class ApiResponseHandler<T extends ApiResponse, S extends ApiErrorResponse>
implements ResponseHandler<T> {
    private final ObjectMapper objectMapper;
    private final Class<T> tClass;
    private final Class<S> sClass;
    private Header[] headers;
    private static final IntegrationsLogger LOG = new IntegrationsLogger(ApiResponseHandler.class);

    public ApiResponseHandler(ObjectMapper objectMapper, Class<T> tClass, Class<S> sClass) {
        this.objectMapper = objectMapper;
        this.tClass = tClass;
        this.sClass = sClass;
    }

    @Override
    public T handleResponse(HttpResponse response) throws IOException {
        try {
            StatusLine statusLine = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            this.checkForHttpErrors(statusLine, response, entity);
            String responseBody = EntityUtils.toString(entity);
            Header[] headers = response.getAllHeaders();
            this.setHeaders(headers);
            this.setCorrelationIdForAuditLog(headers);
            ApiResponse deserializedObject = (ApiResponse)this.objectMapper.readValue(responseBody, this.tClass);
            return (T)deserializedObject;
        }
        catch (InvalidTypeIdException e) {
            LOG.log(PingOneMfaIdpAdapterLogEvent.UNSUPPORTED_RESPONSE);
            throw new IOException(e.getMessage());
        }
    }

    private void setCorrelationIdForAuditLog(Header[] headers) {
        if (headers == null) {
            return;
        }
        Header correlationIdHeader = Arrays.stream(headers).filter(it -> it.getName().equals("Correlation-Id")).findFirst().orElse(new BasicHeader("Correlation-Id", null));
        if (StringUtils.isBlank(correlationIdHeader.getValue())) {
            return;
        }
        try {
            Class<?> clazz = Class.forName("org.sourceid.websso.AuditLogger");
            Method method = clazz.getMethod("put", String.class, String.class);
            method.invoke(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), "correlationId", correlationIdHeader.getValue());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void checkForHttpErrors(StatusLine statusLine, HttpResponse response, HttpEntity entity) throws IOException {
        if (statusLine.getStatusCode() >= 300 && entity != null) {
            String responseBody = EntityUtils.toString(entity);
            if (StringUtils.isNotBlank(responseBody)) {
                try {
                    ApiErrorResponse errorResponse = (ApiErrorResponse)this.objectMapper.readValue(responseBody, this.sClass);
                    if (statusLine.getStatusCode() == 429) {
                        throw new RateLimitApiResponseException(statusLine.getStatusCode(), errorResponse);
                    }
                    throw new ApiResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase(), errorResponse, response.getAllHeaders());
                }
                catch (Throwable throwable) {
                    EntityUtils.consume(entity);
                    throw throwable;
                }
            }
            EntityUtils.consume(entity);
            throw new ApiResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase(), response.getAllHeaders());
        }
    }

    public Header[] getHeaders() {
        return this.headers;
    }

    public void setHeaders(Header[] headers) {
        this.headers = headers;
    }
}

