/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.api.model.policies;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.pingidentity.adapters.pingone.mfa.api.model.ApiResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.policies.AvailableMethod;
import com.pingidentity.adapters.pingone.mfa.api.model.policies.OfflineDeviceAvailableMethod;
import com.pingidentity.adapters.pingone.mfa.api.model.policies.mfasettings.AuthenticationConfig;
import com.pingidentity.adapters.pingone.mfa.api.model.policies.mfasettings.MobileAvailableMethod;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device;
import java.io.Serializable;
import java.util.Optional;
import java.util.UUID;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DeviceAuthenticationPolicy
implements ApiResponse,
Serializable {
    private UUID id;
    private String name;
    @JsonProperty(value="authentication")
    AuthenticationConfig authenticationConfig;
    private OfflineDeviceAvailableMethod sms;
    private AvailableMethod boundBiometrics;
    private AvailableMethod securityKey;
    private AvailableMethod totp;
    private OfflineDeviceAvailableMethod email;
    private OfflineDeviceAvailableMethod voice;
    private MobileAvailableMethod mobile;
    private AvailableMethod fido2;
    private OfflineDeviceAvailableMethod whatsApp;
    @JsonProperty(value="default")
    private boolean isDefault;

    public boolean isSupported(String deviceType) {
        switch (deviceType.toLowerCase()) {
            case "sms": {
                return Optional.ofNullable(this.sms).map(AvailableMethod::isEnabled).orElse(false);
            }
            case "platform": {
                return Optional.ofNullable(this.boundBiometrics).map(AvailableMethod::isEnabled).orElse(false);
            }
            case "security_key": {
                return Optional.ofNullable(this.securityKey).map(AvailableMethod::isEnabled).orElse(false);
            }
            case "totp": {
                return Optional.ofNullable(this.totp).map(AvailableMethod::isEnabled).orElse(false);
            }
            case "email": {
                return Optional.ofNullable(this.email).map(AvailableMethod::isEnabled).orElse(false);
            }
            case "voice": {
                return Optional.ofNullable(this.voice).map(AvailableMethod::isEnabled).orElse(false);
            }
            case "mobile": {
                return Optional.ofNullable(this.mobile).map(AvailableMethod::isEnabled).orElse(false);
            }
            case "fido2": {
                return Optional.ofNullable(this.fido2).map(AvailableMethod::isEnabled).orElse(false);
            }
            case "whatsapp": {
                return Optional.ofNullable(this.whatsApp).map(AvailableMethod::isEnabled).orElse(false);
            }
        }
        return false;
    }

    public boolean isPromptForNicknameOnPairing(String deviceType) {
        switch (deviceType.toLowerCase()) {
            case "sms": {
                return Optional.ofNullable(this.sms).map(AvailableMethod::isPromptForNicknameOnPairing).orElse(false);
            }
            case "platform": {
                return Optional.ofNullable(this.boundBiometrics).map(AvailableMethod::isPromptForNicknameOnPairing).orElse(false);
            }
            case "security_key": {
                return Optional.ofNullable(this.securityKey).map(AvailableMethod::isPromptForNicknameOnPairing).orElse(false);
            }
            case "totp": {
                return Optional.ofNullable(this.totp).map(AvailableMethod::isPromptForNicknameOnPairing).orElse(false);
            }
            case "email": {
                return Optional.ofNullable(this.email).map(AvailableMethod::isPromptForNicknameOnPairing).orElse(false);
            }
            case "voice": {
                return Optional.ofNullable(this.voice).map(AvailableMethod::isPromptForNicknameOnPairing).orElse(false);
            }
            case "mobile": {
                return Optional.ofNullable(this.mobile).map(AvailableMethod::isPromptForNicknameOnPairing).orElse(false);
            }
            case "fido2": {
                return Optional.ofNullable(this.fido2).map(AvailableMethod::isPromptForNicknameOnPairing).orElse(false);
            }
            case "whatsapp": {
                return Optional.ofNullable(this.whatsApp).map(AvailableMethod::isPromptForNicknameOnPairing).orElse(false);
            }
        }
        return false;
    }

    public OfflineDeviceAvailableMethod.Otp.Lifetime getOtpLifeTime(String deviceType) {
        switch (deviceType.toLowerCase()) {
            case "sms": {
                return Optional.ofNullable(this.sms).map(e -> e.getOtp().getLifeTime()).orElse(null);
            }
            case "email": {
                return Optional.ofNullable(this.email).map(e -> e.getOtp().getLifeTime()).orElse(null);
            }
            case "voice": {
                return Optional.ofNullable(this.voice).map(e -> e.getOtp().getLifeTime()).orElse(null);
            }
            case "whatsapp": {
                return Optional.ofNullable(this.whatsApp).map(e -> e.getOtp().getLifeTime()).orElse(null);
            }
        }
        return null;
    }

    public int getOtpLength(String deviceType) {
        switch (deviceType.toLowerCase()) {
            case "sms": {
                return Optional.ofNullable(this.sms).map(e -> Optional.ofNullable(e.getOtp()).map(OfflineDeviceAvailableMethod.Otp::getOtpLength).orElse(10)).orElse(10);
            }
            case "email": {
                return Optional.ofNullable(this.email).map(e -> Optional.ofNullable(e.getOtp()).map(OfflineDeviceAvailableMethod.Otp::getOtpLength).orElse(10)).orElse(10);
            }
            case "voice": {
                return Optional.ofNullable(this.voice).map(e -> Optional.ofNullable(e.getOtp()).map(OfflineDeviceAvailableMethod.Otp::getOtpLength).orElse(10)).orElse(10);
            }
            case "whatsapp": {
                return Optional.ofNullable(this.whatsApp).map(e -> Optional.ofNullable(e.getOtp()).map(OfflineDeviceAvailableMethod.Otp::getOtpLength).orElse(10)).orElse(10);
            }
            case "totp": {
                return 6;
            }
        }
        return 10;
    }

    public boolean isSupported(Device device) {
        return this.isSupported(device.getType());
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="authentication")
    public void setAuthenticationConfig(AuthenticationConfig authenticationConfig) {
        this.authenticationConfig = authenticationConfig;
    }

    public void setSms(OfflineDeviceAvailableMethod sms) {
        this.sms = sms;
    }

    public void setBoundBiometrics(AvailableMethod boundBiometrics) {
        this.boundBiometrics = boundBiometrics;
    }

    public void setSecurityKey(AvailableMethod securityKey) {
        this.securityKey = securityKey;
    }

    public void setTotp(AvailableMethod totp) {
        this.totp = totp;
    }

    public void setEmail(OfflineDeviceAvailableMethod email) {
        this.email = email;
    }

    public void setVoice(OfflineDeviceAvailableMethod voice) {
        this.voice = voice;
    }

    public void setMobile(MobileAvailableMethod mobile) {
        this.mobile = mobile;
    }

    public void setFido2(AvailableMethod fido2) {
        this.fido2 = fido2;
    }

    public void setWhatsApp(OfflineDeviceAvailableMethod whatsApp) {
        this.whatsApp = whatsApp;
    }

    @JsonProperty(value="default")
    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public AuthenticationConfig getAuthenticationConfig() {
        return this.authenticationConfig;
    }

    public OfflineDeviceAvailableMethod getSms() {
        return this.sms;
    }

    public AvailableMethod getBoundBiometrics() {
        return this.boundBiometrics;
    }

    public AvailableMethod getSecurityKey() {
        return this.securityKey;
    }

    public AvailableMethod getTotp() {
        return this.totp;
    }

    public OfflineDeviceAvailableMethod getEmail() {
        return this.email;
    }

    public OfflineDeviceAvailableMethod getVoice() {
        return this.voice;
    }

    public MobileAvailableMethod getMobile() {
        return this.mobile;
    }

    public AvailableMethod getFido2() {
        return this.fido2;
    }

    public OfflineDeviceAvailableMethod getWhatsApp() {
        return this.whatsApp;
    }

    public boolean isDefault() {
        return this.isDefault;
    }
}

