/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.api.model.response;

import com.pingidentity.adapters.pingone.mfa.api.model.ApiErrorResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.ErrorDetail;
import com.pingidentity.adapters.pingone.mfa.api.model.response.InnerError;
import com.pingidentity.adapters.pingone.mfa.api.model.response.UnavailableDevice;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Notification;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ErrorResponse
implements Serializable,
ApiErrorResponse {
    private String id;
    private String code;
    private String message;
    private List<ErrorDetail> details = new ArrayList<ErrorDetail>();

    public String getPrettyErrorDetails() {
        StringBuilder printableDetails = new StringBuilder("[code='" + this.code + "', message='" + this.message + "'");
        if (this.details != null && !this.details.isEmpty()) {
            printableDetails.append(", details='");
            for (ErrorDetail detail : this.details) {
                String detailCode = detail.getCode();
                String detailTarget = detail.getTarget();
                String detailMessage = detail.getMessage();
                String message = "[code='" + detailCode + ", target='" + detailTarget + "', message='" + detailMessage + "']";
                printableDetails.append(message);
            }
        }
        printableDetails.append("'").append("]");
        return printableDetails.toString();
    }

    public Long getAttemptsRemaining() {
        if (this.details != null && !this.details.isEmpty()) {
            InnerError innerError = this.details.get(0).getInnerError();
            return Optional.ofNullable(innerError).map(InnerError::getAttemptsRemaining).orElse(null);
        }
        return null;
    }

    public Long getCoolDownExpiresAt() {
        if (this.details == null || this.details.isEmpty()) {
            return null;
        }
        InnerError innerError = this.details.get(0).getInnerError();
        if (innerError == null) {
            return null;
        }
        Long expiresAt = innerError.getCoolDownExpiresAt();
        if (expiresAt != null) {
            return expiresAt;
        }
        return innerError.getUnusableDevices().stream().findFirst().map(UnavailableDevice::getNotification).map(Notification::getExpiresAt).orElse(null);
    }

    public Long getQuotaLimit() {
        if (this.details != null && !this.details.isEmpty()) {
            InnerError innerError = this.details.get(0).getInnerError();
            return Optional.ofNullable(innerError).map(InnerError::getQuotaLimit).orElse(null);
        }
        return null;
    }

    public String getErrorDetailCode() {
        if (this.details != null && !this.details.isEmpty()) {
            return Optional.ofNullable(this.details.get(0)).map(ErrorDetail::getCode).orElse("");
        }
        return "";
    }

    public String getErrorDetailTarget() {
        if (this.details != null && !this.details.isEmpty()) {
            return Optional.ofNullable(this.details.get(0)).map(ErrorDetail::getTarget).orElse("");
        }
        return "";
    }

    public String getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public List<ErrorDetail> getDetails() {
        return this.details;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setDetails(List<ErrorDetail> details) {
        this.details = details;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErrorResponse)) {
            return false;
        }
        ErrorResponse other = (ErrorResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        List<ErrorDetail> this$details = this.getDetails();
        List<ErrorDetail> other$details = other.getDetails();
        return !(this$details == null ? other$details != null : !((Object)this$details).equals(other$details));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ErrorResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        List<ErrorDetail> $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : ((Object)$details).hashCode());
        return result;
    }

    public String toString() {
        return "ErrorResponse(id=" + this.getId() + ", code=" + this.getCode() + ", message=" + this.getMessage() + ", details=" + this.getDetails() + ")";
    }
}

