/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.authn.api;

import com.pingidentity.adapters.pingone.mfa.api.model.ApiResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.policies.OfflineDeviceAvailableMethod;
import com.pingidentity.adapters.pingone.mfa.api.model.request.onetimedeviceotpflow.OneTimeDeviceInfo;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Notification;
import com.pingidentity.adapters.pingone.mfa.authn.api.OneTimeDeviceForResponse;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;

@Schema(description="Validate the OTP (one-time passcode) from the user.")
public class OneTimeDeviceOtpInputRequiredResponse
implements ApiResponse {
    private List<OneTimeDeviceForResponse> devices;
    private OneTimeDeviceForResponse selectedDevice;
    @Schema(description="The lifespan of the OTP, indicating the time period for which the OTP is valid.")
    private OfflineDeviceAvailableMethod.Otp.Lifetime otpLifetime;
    @Schema(description="Indicates the time until which the user must wait before being allowed to resend the OTP.")
    private Notification notification;
    private boolean isChangeDevicePermitted;

    @Schema(description="The selected device for One-Time Device OTP authentication flow.")
    public OneTimeDeviceForResponse getSelectedDevice() {
        return this.selectedDevice;
    }

    @Schema(description="The list of all One-Time Device OTP devices object.")
    public List<OneTimeDeviceForResponse> getDevices() {
        return this.devices;
    }

    public OneTimeDeviceOtpInputRequiredResponse() {
    }

    private OneTimeDeviceForResponse getOneTimeDeviceForResponse(OneTimeDeviceInfo selectedDevice) {
        switch (selectedDevice.getType()) {
            case Voice: {
                return new OneTimeDeviceForResponse(OneTimeDeviceForResponse.Type.Voice, selectedDevice.retrieveMaskedTarget(), selectedDevice.getId());
            }
            case Email: {
                return new OneTimeDeviceForResponse(OneTimeDeviceForResponse.Type.Email, selectedDevice.retrieveMaskedTarget(), selectedDevice.getId());
            }
            case SMS: {
                return new OneTimeDeviceForResponse(OneTimeDeviceForResponse.Type.SMS, selectedDevice.retrieveMaskedTarget(), selectedDevice.getId());
            }
            case WhatsApp: {
                return new OneTimeDeviceForResponse(OneTimeDeviceForResponse.Type.WhatsApp, selectedDevice.retrieveMaskedTarget(), selectedDevice.getId());
            }
        }
        return null;
    }

    public OneTimeDeviceOtpInputRequiredResponse(OneTimeDeviceInfo selectedDevice, ArrayList<OneTimeDeviceInfo> devices) {
        this.selectedDevice = this.getOneTimeDeviceForResponse(selectedDevice);
        this.devices = new ArrayList<OneTimeDeviceForResponse>();
        for (OneTimeDeviceInfo device : devices) {
            this.devices.add(this.getOneTimeDeviceForResponse(device));
        }
    }

    @Schema(description="Indicates whether the user can switch devices used for authentication.")
    public boolean isChangeDevicePermitted() {
        return this.isChangeDevicePermitted;
    }

    public void setChangeDevicePermitted(boolean changeDevicePermitted) {
        this.isChangeDevicePermitted = changeDevicePermitted;
    }

    public OfflineDeviceAvailableMethod.Otp.Lifetime getOtpLifetime() {
        return this.otpLifetime;
    }

    public void setOtpLifetime(OfflineDeviceAvailableMethod.Otp.Lifetime otpLifetime) {
        this.otpLifetime = otpLifetime;
    }

    public Notification getNotification() {
        return this.notification;
    }

    public void setNotification(Notification notification) {
        this.notification = notification;
    }
}

