/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.authn.api;

import com.pingidentity.adapters.pingone.mfa.api.model.policies.OfflineDeviceAvailableMethod;
import com.pingidentity.adapters.pingone.mfa.api.model.request.authenticationcode.Application;
import com.pingidentity.adapters.pingone.mfa.api.model.request.authenticationcode.ClientContext;
import com.pingidentity.adapters.pingone.mfa.api.model.request.authenticationcode.LifeTime;
import com.pingidentity.adapters.pingone.mfa.api.model.request.onetimedeviceotpflow.OneTimeDeviceInfo;
import com.pingidentity.adapters.pingone.mfa.api.model.request.onetimedeviceotpflow.OneTimeDevicesInfo;
import com.pingidentity.adapters.pingone.mfa.api.model.response.AuthSession;
import com.pingidentity.adapters.pingone.mfa.api.model.response.AuthenticationCodesResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Notification;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.OfflineDevice;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.TOTPDevice;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Test;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.fido.PublicKeyCredentialRequestOptions;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.fido.RelyingParty;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.fido.WebAuthnDevice;
import com.pingidentity.adapters.pingone.mfa.authn.api.ActionSpec;
import com.pingidentity.adapters.pingone.mfa.authn.api.CreateAuthenticationCodesRequestResponse;
import com.pingidentity.adapters.pingone.mfa.authn.api.CustomAssertionRequired;
import com.pingidentity.adapters.pingone.mfa.authn.api.CustomAuthenticationRequired;
import com.pingidentity.adapters.pingone.mfa.authn.api.CustomDevicePairingMethodFailed;
import com.pingidentity.adapters.pingone.mfa.authn.api.CustomDeviceSelectionRequired;
import com.pingidentity.adapters.pingone.mfa.authn.api.CustomMfaFailed;
import com.pingidentity.adapters.pingone.mfa.authn.api.CustomOtpRequired;
import com.pingidentity.adapters.pingone.mfa.authn.api.CustomPushConfirmationRejected;
import com.pingidentity.adapters.pingone.mfa.authn.api.CustomPushConfirmationTimedOut;
import com.pingidentity.adapters.pingone.mfa.authn.api.CustomPushConfirmationWaiting;
import com.pingidentity.adapters.pingone.mfa.authn.api.Device;
import com.pingidentity.adapters.pingone.mfa.authn.api.DevicePairingMethod;
import com.pingidentity.adapters.pingone.mfa.authn.api.DevicePairingMethodRequired;
import com.pingidentity.adapters.pingone.mfa.authn.api.MfaSetupRequired;
import com.pingidentity.adapters.pingone.mfa.authn.api.MobileActivationRequired;
import com.pingidentity.adapters.pingone.mfa.authn.api.OfflineDeviceActivationRequired;
import com.pingidentity.adapters.pingone.mfa.authn.api.OfflineTargetRequired;
import com.pingidentity.adapters.pingone.mfa.authn.api.OneTimeDeviceOTPMethodTypeInputRequiredResponse;
import com.pingidentity.adapters.pingone.mfa.authn.api.OneTimeDeviceOtpInputRequiredResponse;
import com.pingidentity.adapters.pingone.mfa.authn.api.StateSpec;
import com.pingidentity.adapters.pingone.mfa.authn.api.TotpActivationRequired;
import com.pingidentity.adapters.pingone.mfa.authn.api.UpdateDeviceNickname;
import com.pingidentity.adapters.pingone.mfa.authn.api.WebAuthnActivationRequired;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.lang3.StringUtils;
import com.pingidentity.adapters.pingone.mfa.util.PingOneMfaStateSupport;
import com.pingidentity.sdk.api.authn.common.CommonActionSpec;
import com.pingidentity.sdk.api.authn.common.CommonStateSpec;
import com.pingidentity.sdk.api.authn.model.AuthnState;
import com.pingidentity.sdk.api.authn.model.ResourceRef;
import com.pingidentity.sdk.api.authn.model.User;
import com.pingidentity.sdk.api.authn.model.state.MfaCompleted;
import com.pingidentity.sdk.api.authn.model.state.MobilePairingRequired;
import com.pingidentity.sdk.api.authn.spec.AuthnStateSpec;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PingOneMfaAuthnApiSupport {
    private static final Map<String, AuthnStateSpec<?>> STATE_SPEC_MAP = new LinkedHashMap();
    private final AuthnApiSupport authnApiSupport;
    private final boolean changeDeviceAllowed;

    public PingOneMfaAuthnApiSupport(AuthnApiSupport authnApiSupport, boolean changeDeviceAllowed) {
        this.authnApiSupport = authnApiSupport;
        this.changeDeviceAllowed = changeDeviceAllowed;
    }

    public boolean isUsePasswordAuthRequest(HttpServletRequest req) {
        return ActionSpec.USE_PASSWORD_AUTHENTICATION.isRequested(req);
    }

    public boolean isAuthenticateRequest(HttpServletRequest req) {
        return ActionSpec.AUTHENTICATE.isRequested(req);
    }

    public boolean isSelectDeviceRequest(HttpServletRequest req) {
        return ActionSpec.SELECT_DEVICE.isRequested(req);
    }

    public boolean isOneTimeDeviceSelectDeviceRequest(HttpServletRequest req) {
        return ActionSpec.SELECT_ONE_TIME_DEVICE_METHOD.isRequested(req);
    }

    public boolean isSetDefaultDevice(HttpServletRequest req) {
        return ActionSpec.SET_DEFAULT_DEVICE.isRequested(req);
    }

    public boolean isCheckOtpRequest(HttpServletRequest req) {
        return ActionSpec.CHECK_OTP.isRequested(req);
    }

    public boolean isCheckAssertionRequest(HttpServletRequest req) {
        return ActionSpec.CHECK_ASSERTION.isRequested(req);
    }

    public boolean isPollRequest(HttpServletRequest req) {
        return CommonActionSpec.POLL.isRequested(req);
    }

    public boolean isContinueAuthenticationRequest(HttpServletRequest req) {
        return CommonActionSpec.CONTINUE_AUTHENTICATION.isRequested(req);
    }

    public boolean isCancelAuthenticationRequest(HttpServletRequest req) {
        return CommonActionSpec.CANCEL_AUTHENTICATION.isRequested(req);
    }

    public boolean isContinueBiometricAuthenticationRequest(HttpServletRequest req) {
        return ActionSpec.CONTINUE_BIOMETRIC_DEVICE_AUTHENTICATION.isRequested(req);
    }

    public boolean isSetupMfaRequest(HttpServletRequest req) {
        return ActionSpec.SETUP_MFA.isRequested(req);
    }

    public boolean isRemoveDeviceRequest(HttpServletRequest req) {
        return ActionSpec.REMOVE_DEVICE.isRequested(req);
    }

    public boolean isUpdateDeviceRequest(HttpServletRequest req) {
        return ActionSpec.UPDATE_DEVICE_NICKNAME.isRequested(req);
    }

    public boolean isSkipUpdateNicknameDuringDevicePairingRequest(HttpServletRequest req) {
        return ActionSpec.SKIP_UPDATE_NICKNAME_DURING_DEVICE_PAIRING.isRequested(req);
    }

    public boolean isCancelRemoveDeviceRequest(HttpServletRequest req) {
        return ActionSpec.CANCEL_REMOVE_DEVICE.isRequested(req);
    }

    public boolean isSkipMfaRequest(HttpServletRequest req) {
        return ActionSpec.SKIP_MFA.isRequested(req);
    }

    public boolean isSelectDevicePairingMethodRequest(HttpServletRequest req) {
        return ActionSpec.SELECT_DEVICE_PAIRING_METHOD.isRequested(req);
    }

    public boolean isCancelDevicePairingRequest(HttpServletRequest req) {
        return ActionSpec.CANCEL_DEVICE_PAIRING.isRequested(req);
    }

    public boolean isSubmitEmailTargetRequest(HttpServletRequest req) {
        return ActionSpec.SUBMIT_EMAIL_TARGET.isRequested(req);
    }

    public boolean isSubmitVoiceTargetRequest(HttpServletRequest req) {
        return ActionSpec.SUBMIT_VOICE_TARGET.isRequested(req);
    }

    public boolean isSubmitSmsTargetRequest(HttpServletRequest req) {
        return ActionSpec.SUBMIT_SMS_TARGET.isRequested(req);
    }

    public boolean isSubmitWhatsAppTargetRequest(HttpServletRequest req) {
        return ActionSpec.SUBMIT_WHATSAPP_TARGET.isRequested(req);
    }

    public boolean isActivateOfflineDeviceRequest(HttpServletRequest req) {
        return ActionSpec.ACTIVATE_EMAIL_DEVICE.isRequested(req) || ActionSpec.ACTIVATE_VOICE_DEVICE.isRequested(req) || ActionSpec.ACTIVATE_SMS_DEVICE.isRequested(req) || ActionSpec.ACTIVATE_TOTP_DEVICE.isRequested(req) || ActionSpec.ACTIVATE_WHATSAPP_DEVICE.isRequested(req);
    }

    public boolean isResendOtpRequest(HttpServletRequest req) {
        return ActionSpec.RESEND_OTP.isRequested(req);
    }

    public boolean isOneTimeOTPResendOtpRequest(HttpServletRequest req) {
        return ActionSpec.RESEND_OTP_ONE_TIME_DEVICE_OTP_FLOW.isRequested(req);
    }

    public boolean isActivateWebAuthnDevice(HttpServletRequest req) {
        return ActionSpec.ACTIVATE_SECURITY_KEY_DEVICE.isRequested(req) || ActionSpec.ACTIVATE_PLATFORM_DEVICE.isRequested(req) || ActionSpec.ACTIVATE_FIDO2_DEVICE.isRequested(req);
    }

    public boolean isValidPingOneMfaAdapterAuthnApiPost(HttpServletRequest req, HttpServletResponse resp, String status) throws IOException {
        return this.authnApiSupport.isValidAuthnApiPostRequest(req, resp, this.getExpectedActionIdToModelMapping(status));
    }

    public void writeAuthenticationRequiredResponse(HttpServletRequest req, HttpServletResponse resp, String username) throws IOException {
        CustomAuthenticationRequired model = new CustomAuthenticationRequired();
        User user = new User();
        user.setUsername(username);
        model.setUser(user);
        model.setDevices(null);
        AuthnState authnState = this.authnApiSupport.makeAuthnState(req, StateSpec.AUTHENTICATION_REQUIRED, (Object)model);
        this.authnApiSupport.writeAuthnStateResponse(req, resp, authnState);
    }

    public void writeDeviceSelectionRequiredResponse(HttpServletRequest req, HttpServletResponse resp, List<Device> devices, User user, PingOneMfaStateSupport stateSupport, boolean isManualPairingPermitted, boolean usePasswordPolicyAction, boolean isManageDevicesAllowed) throws IOException {
        CustomDeviceSelectionRequired model = new CustomDeviceSelectionRequired();
        model.setDevices(devices);
        if (user != null) {
            model.setUser(user);
        }
        model.setManualPairingPermitted(isManualPairingPermitted);
        model.setManualPairing(stateSupport.isManualPairingFlow());
        model.setNewPairingAuthRequired(!stateSupport.getBypassMfaBeforeDeviceMgmt());
        model.setUsePasswordAuthenticationEnabled(usePasswordPolicyAction);
        model.setChangeDevicePermitted(this.changeDeviceAllowed);
        model.setManageDevicesAllowed(isManageDevicesAllowed);
        model.setMaxAllowedDevices(stateSupport.getMaxAllowedDevices());
        AuthnState authnState = this.authnApiSupport.makeAuthnState(req, StateSpec.DEVICE_SELECTION_REQUIRED, (Object)model);
        this.authnApiSupport.writeAuthnStateResponse(req, resp, authnState);
    }

    public void writeOneTimeDeviceMethodSelectionInputRequiredResponse(HttpServletRequest req, HttpServletResponse resp, OneTimeDevicesInfo oneTimeDevicesInfo) throws IOException {
        OneTimeDeviceOTPMethodTypeInputRequiredResponse model = new OneTimeDeviceOTPMethodTypeInputRequiredResponse();
        model.setDevices(oneTimeDevicesInfo.getDevicesWithMaskedInfoValues());
        model.setChangeDevicePermitted(this.changeDeviceAllowed);
        AuthnState authnState = this.authnApiSupport.makeAuthnState(req, StateSpec.ONE_TIME_DEVICE_OTP_METHOD_TYPE_INPUT_REQUIRED_RESPONSE, (Object)model);
        this.authnApiSupport.writeAuthnStateResponse(req, resp, authnState);
    }

    public void writeOneTimeDeviceMethodOtpInputRequiredResponse(HttpServletRequest req, HttpServletResponse resp, OneTimeDeviceInfo selectedOneTimeDeviceInfo, OneTimeDevicesInfo oneTimeDevicesInfo, OfflineDeviceAvailableMethod.Otp.Lifetime otpLifeTime, Notification notification) throws IOException {
        OneTimeDeviceOtpInputRequiredResponse model = new OneTimeDeviceOtpInputRequiredResponse(selectedOneTimeDeviceInfo, oneTimeDevicesInfo.getDevices());
        model.setChangeDevicePermitted(this.changeDeviceAllowed);
        model.setOtpLifetime(otpLifeTime);
        model.setNotification(notification);
        AuthnState authnState = this.authnApiSupport.makeAuthnState(req, StateSpec.ONE_TIME_DEVICE_OTP_INPUT_REQUIRED_RESPONSE, (Object)model);
        this.authnApiSupport.writeAuthnStateResponse(req, resp, authnState);
    }

    public void writeBiometricAuthenticationInfoRequiredResponse(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        AuthnState authnState = this.authnApiSupport.makeAuthnState(req, StateSpec.BIOMETRIC_DEVICE_AUTHENTICATION_INFO_REQUIRED, null);
        this.authnApiSupport.writeAuthnStateResponse(req, resp, authnState);
    }

    public void writeAuthenticationCodeResponseRequiredResponse(HttpServletRequest req, HttpServletResponse resp, AuthenticationCodesResponse createAuthCodeResponse) throws IOException {
        CreateAuthenticationCodesRequestResponse model = new CreateAuthenticationCodesRequestResponse();
        model.setCode(createAuthCodeResponse.getCode());
        model.setAuthenticationCodeId(createAuthCodeResponse.getId());
        model.setExpiresAt(createAuthCodeResponse.getExpiresAt());
        model.setCreatedAt(createAuthCodeResponse.getCreatedAt());
        model.setRequestStatus(createAuthCodeResponse.getStatus());
        model.setUpdatedAt(createAuthCodeResponse.getUpdatedAt());
        model.setUri(createAuthCodeResponse.getUri());
        model.setUserApproval(createAuthCodeResponse.getUserApproval());
        if (createAuthCodeResponse.getApplication() != null) {
            model.setApplication(new Application(createAuthCodeResponse.getApplication().getId()));
        }
        if (createAuthCodeResponse.getClientContext() != null) {
            model.setClientContext(new ClientContext(createAuthCodeResponse.getClientContext().getHeader(), createAuthCodeResponse.getClientContext().getBody()));
        }
        if (createAuthCodeResponse.getLifeTime() != null) {
            model.setLifeTime(new LifeTime(createAuthCodeResponse.getLifeTime().getDuration(), createAuthCodeResponse.getLifeTime().getTimeUnit()));
        }
        AuthnState authnState = this.authnApiSupport.makeAuthnState(req, StateSpec.AUTHENTICATION_CODE_RESPONSE_REQUIRED, (Object)model);
        this.authnApiSupport.writeAuthnStateResponse(req, resp, authnState);
    }

    public void writeUsernamelessFlowAssertionRequiredResponse(HttpServletRequest req, HttpServletResponse resp, PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions) throws IOException {
        CustomAssertionRequired model = new CustomAssertionRequired();
        model.setPublicKeyCredentialRequestOptions(publicKeyCredentialRequestOptions);
        AuthnState authnState = this.authnApiSupport.makeAuthnState(req, StateSpec.USERNAMELESS_AUTH_ASSERTION_REQUIRED, (Object)model);
        this.authnApiSupport.writeAuthnStateResponse(req, resp, authnState);
    }

    public void writeAssertionRequiredResponse(HttpServletRequest req, HttpServletResponse resp, List<Device> devices, User user, ResourceRef selectedDeviceRef, PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions, PingOneMfaStateSupport stateSupport, boolean isManualPairingPermitted, boolean isManagedDevicesAllowed) throws IOException {
        CustomAssertionRequired model = new CustomAssertionRequired();
        model.setSelectedDeviceRef(selectedDeviceRef);
        model.setDevices(devices);
        model.setUser(user);
        model.setPublicKeyCredentialRequestOptions(publicKeyCredentialRequestOptions);
        model.setManualPairingPermitted(isManualPairingPermitted);
        model.setManualPairing(stateSupport.isManualPairingFlow());
        model.setChangeDevicePermitted(this.changeDeviceAllowed);
        model.setManageDevicesAllowed(isManagedDevicesAllowed);
        AuthnState authnState = this.authnApiSupport.makeAuthnState(req, StateSpec.ASSERTION_REQUIRED, (Object)model);
        this.authnApiSupport.writeAuthnStateResponse(req, resp, authnState);
    }

    public void writeOtpRequiredResponse(HttpServletRequest req, HttpServletResponse resp, List<Device> devices, User user, String otp, PingOneMfaStateSupport stateSupport, boolean isManualPairingPermitted, boolean isDeviceManagementAllowed, OfflineDeviceAvailableMethod.Otp.Lifetime otpLifeTime) throws IOException {
        CustomOtpRequired model = new CustomOtpRequired();
        model.setSelectedDeviceRef(stateSupport.getSelectedDeviceRef());
        model.setOtp(otp);
        model.setDevices(devices);
        model.setUser(user);
        model.setManualPairingPermitted(isManualPairingPermitted);
        model.setManualPairing(stateSupport.isManualPairingFlow());
        model.setChangeDevicePermitted(this.changeDeviceAllowed);
        model.setManageDevicesAllowed(isDeviceManagementAllowed);
        model.setOtpLifetime(otpLifeTime);
        AuthnState authnState = this.authnApiSupport.makeAuthnState(req, StateSpec.OTP_REQUIRED, (Object)model);
        this.authnApiSupport.writeAuthnStateResponse(req, resp, authnState);
    }

    public void writePushConfirmationWaitingResponse(HttpServletRequest req, HttpServletResponse resp, List<Device> devices, User user, ResourceRef selectedDeviceRef, PingOneMfaStateSupport stateSupport, boolean isManualPairingPermitted, boolean isDeviceManagementAllowed, AuthSession.NumberMatching numberMatching) throws IOException {
        CustomPushConfirmationWaiting model = new CustomPushConfirmationWaiting();
        model.setSelectedDeviceRef(selectedDeviceRef);
        model.setDevices(devices);
        model.setUser(user);
        model.setManualPairingPermitted(isManualPairingPermitted);
        model.setChangeDevicePermitted(this.changeDeviceAllowed);
        model.setManualPairing(stateSupport.isManualPairingFlow());
        model.setManageDevicesAllowed(isDeviceManagementAllowed);
        model.setNumberMatching(numberMatching);
        AuthnState authnState = this.authnApiSupport.makeAuthnState(req, StateSpec.PUSH_CONFIRMATION_WAITING, (Object)model);
        this.authnApiSupport.writeAuthnStateResponse(req, resp, authnState);
    }

    public void writePushConfirmationTimedOutResponse(HttpServletRequest req, HttpServletResponse resp, List<Device> devices, User user, ResourceRef selectedDeviceRef, PingOneMfaStateSupport stateSupport, boolean isManualPairingPermitted) throws IOException {
        CustomPushConfirmationTimedOut model = new CustomPushConfirmationTimedOut();
        model.setSelectedDeviceRef(selectedDeviceRef);
        model.setDevices(devices);
        model.setUser(user);
        model.setManualPairingPermitted(isManualPairingPermitted);
        model.setManualPairing(stateSupport.isManualPairingFlow());
        model.setChangeDevicePermitted(this.changeDeviceAllowed);
        AuthnState authnState = this.authnApiSupport.makeAuthnState(req, StateSpec.PUSH_CONFIRMATION_TIMED_OUT, (Object)model);
        this.authnApiSupport.writeAuthnStateResponse(req, resp, authnState);
    }

    public void writePushConfirmationRejectedResponse(HttpServletRequest req, HttpServletResponse resp, List<Device> devices, User user, ResourceRef selectedDeviceRef, CustomPushConfirmationRejected.Reason reason, PingOneMfaStateSupport stateSupport, boolean isManualPairingPermitted) throws IOException {
        CustomPushConfirmationRejected model = new CustomPushConfirmationRejected();
        model.setSelectedDeviceRef(selectedDeviceRef);
        model.setDevices(devices);
        model.setUser(user);
        model.setReason(reason.name());
        model.setManualPairingPermitted(isManualPairingPermitted);
        model.setManualPairing(stateSupport.isManualPairingFlow());
        model.setChangeDevicePermitted(this.changeDeviceAllowed);
        AuthnState authnState = this.authnApiSupport.makeAuthnState(req, StateSpec.PUSH_CONFIRMATION_REJECTED, (Object)model);
        this.authnApiSupport.writeAuthnStateResponse(req, resp, authnState);
    }

    public void writeMobilePairingRequiredResponse(HttpServletRequest req, HttpServletResponse resp, String idToken) throws IOException {
        MobilePairingRequired model = new MobilePairingRequired();
        model.setServerPayload(idToken);
        AuthnState authnState = this.authnApiSupport.makeAuthnState(req, CommonStateSpec.MOBILE_PAIRING_REQUIRED, (Object)model);
        this.authnApiSupport.writeAuthnStateResponse(req, resp, authnState);
    }

    public void writeMfaCompletedResponse(HttpServletRequest req, HttpServletResponse resp, String mfaCompletedCode) throws IOException {
        MfaCompleted model = new MfaCompleted();
        model.setCode(mfaCompletedCode);
        AuthnState authnState = this.authnApiSupport.makeAuthnState(req, CommonStateSpec.MFA_COMPLETED, (Object)model);
        this.authnApiSupport.writeAuthnStateResponse(req, resp, authnState);
    }

    public void writeMfaFailedResponse(HttpServletRequest req, HttpServletResponse resp, String message, String code, String userMessageKey) throws IOException {
        this.writeMfaFailedResponseWithCoolDown(req, resp, message, code, userMessageKey, null);
    }

    public void writeMfaFailedResponseWithCoolDown(HttpServletRequest req, HttpServletResponse resp, String message, String code, String userMessageKey, Long secondsUntilUnlock) throws IOException {
        CustomMfaFailed model = new CustomMfaFailed();
        if (StringUtils.isNotBlank(code)) {
            model.setCode(code);
        }
        if (StringUtils.isNotBlank(message)) {
            model.setMessage(message);
        }
        if (StringUtils.isNotBlank(userMessageKey)) {
            model.setUserMessageKey(userMessageKey);
        }
        if (secondsUntilUnlock != null) {
            model.setSecondsUntilUnlock(secondsUntilUnlock);
        }
        AuthnState authnState = this.authnApiSupport.makeAuthnState(req, StateSpec.MFA_FAILED, (Object)model);
        this.authnApiSupport.writeAuthnStateResponse(req, resp, authnState);
    }

    public void writeDevicePairingMethodFailedResponse(HttpServletRequest req, HttpServletResponse resp, String message, String code, String userMessageKey) throws IOException {
        CustomDevicePairingMethodFailed model = new CustomDevicePairingMethodFailed();
        if (StringUtils.isNotBlank(code)) {
            model.setCode(code);
        }
        if (StringUtils.isNotBlank(message)) {
            model.setMessage(message);
        }
        if (StringUtils.isNotBlank(userMessageKey)) {
            model.setUserMessageKey(userMessageKey);
        }
        AuthnState authnState = this.authnApiSupport.makeAuthnState(req, StateSpec.MFA_DEVICE_PAIRING_METHOD_FAILED, (Object)model);
        this.authnApiSupport.writeAuthnStateResponse(req, resp, authnState);
    }

    public void writeMfaFailedAccountLockedOutResponse(HttpServletRequest req, HttpServletResponse resp, String message, String code, String userMessage, Long secondsUntilUnlock) throws IOException {
        CustomMfaFailed model = new CustomMfaFailed();
        if (StringUtils.isNotBlank(code)) {
            model.setCode(code);
        }
        if (StringUtils.isNotBlank(message)) {
            model.setMessage(message);
        }
        if (StringUtils.isNotBlank(userMessage)) {
            model.setUserMessage(userMessage);
        }
        if (secondsUntilUnlock != null) {
            model.setSecondsUntilUnlock(secondsUntilUnlock);
        }
        AuthnState authnState = this.authnApiSupport.makeAuthnState(req, StateSpec.MFA_FAILED, (Object)model);
        this.authnApiSupport.writeAuthnStateResponse(req, resp, authnState);
    }

    public void writeMfaSetupRequiredResponse(HttpServletRequest req, HttpServletResponse resp, boolean allowSkipMfa) throws IOException {
        MfaSetupRequired model = new MfaSetupRequired();
        model.setAllowSkipMfa(allowSkipMfa);
        AuthnState authnState = this.authnApiSupport.makeAuthnState(req, StateSpec.MFA_SETUP_REQUIRED, (Object)model);
        this.authnApiSupport.writeAuthnStateResponse(req, resp, authnState);
    }

    public void writeDevicePairingMethodRequiredResponse(HttpServletRequest req, HttpServletResponse resp, List<DevicePairingMethod> devicePairingMethods) throws IOException {
        DevicePairingMethodRequired model = new DevicePairingMethodRequired();
        model.setDevicePairingMethods(devicePairingMethods);
        AuthnState authnState = this.authnApiSupport.makeAuthnState(req, StateSpec.DEVICE_PAIRING_METHOD_REQUIRED, (Object)model);
        this.authnApiSupport.writeAuthnStateResponse(req, resp, authnState);
    }

    public void writeUpdateNicknameDuringDevicePairingResponse(HttpServletRequest req, HttpServletResponse resp, com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device pairedDevice) throws IOException {
        UpdateDeviceNickname model = new UpdateDeviceNickname();
        com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device device = new com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device();
        device.setId(pairedDevice.getId());
        model.setPairedDevice(device);
        AuthnState authnState = this.authnApiSupport.makeAuthnState(req, StateSpec.UPDATE_NICKNAME, (Object)model);
        this.authnApiSupport.writeAuthnStateResponse(req, resp, authnState);
    }

    public void writeOfflinePairingRequiredResponse(HttpServletRequest req, HttpServletResponse resp, String allowedValue, AuthnStateSpec<OfflineTargetRequired> authnStateSpec) throws IOException {
        OfflineTargetRequired model = new OfflineTargetRequired();
        model.setAllowedValue(allowedValue);
        this.authnApiSupport.writeAuthnStateResponse(req, resp, this.authnApiSupport.makeAuthnState(req, authnStateSpec, (Object)model));
    }

    public void writeMobileActivationRequiredResponse(HttpServletRequest req, HttpServletResponse resp, String applicationName, String pairingKey) throws IOException {
        MobileActivationRequired model = new MobileActivationRequired();
        model.setApplicationName(applicationName);
        model.setPairingKey(pairingKey);
        AuthnState authnState = this.authnApiSupport.makeAuthnState(req, StateSpec.MOBILE_ACTIVATION_REQUIRED, (Object)model);
        this.authnApiSupport.writeAuthnStateResponse(req, resp, authnState);
    }

    public void writeTotpActivationRequiredResponse(HttpServletRequest req, HttpServletResponse resp, TOTPDevice totpDevice) throws IOException {
        String pairingKey = totpDevice.getSecret();
        String keyUri = totpDevice.getKeyUri();
        TotpActivationRequired model = new TotpActivationRequired();
        model.setPairingKey(pairingKey);
        model.setKeyUri(keyUri);
        AuthnState authnState = this.authnApiSupport.makeAuthnState(req, StateSpec.TOTP_ACTIVATION_REQUIRED, (Object)model);
        this.authnApiSupport.writeAuthnStateResponse(req, resp, authnState);
    }

    public void writeOfflineActivationRequiredResponse(HttpServletRequest req, HttpServletResponse resp, OfflineDevice offlineDevice, OfflineDeviceAvailableMethod.Otp.Lifetime otpLifetime) throws IOException {
        OfflineDeviceActivationRequired model = offlineDevice.getOfflineActivationRequiredModel();
        model.setTarget(offlineDevice.getTarget());
        model.setOtp(Optional.ofNullable(offlineDevice.getTest()).map(Test::getOTP).orElse(null));
        model.setOtpLifetime(otpLifetime);
        model.setNotification(offlineDevice.getNotification());
        AuthnState authnState = this.authnApiSupport.makeAuthnState(req, offlineDevice.getAuthnStateSpecForPairingTargetRequired(), (Object)model);
        this.authnApiSupport.writeAuthnStateResponse(req, resp, authnState);
    }

    public void writeWebAuthnActivationRequiredResponse(HttpServletRequest req, HttpServletResponse resp, WebAuthnDevice webAuthnDevice) throws IOException {
        WebAuthnActivationRequired model = new WebAuthnActivationRequired();
        RelyingParty rp = new RelyingParty(webAuthnDevice.getRp().getId(), webAuthnDevice.getRp().getName());
        model.setRelyingParty(rp);
        model.setPublicKeyCredentialCreationOptions(webAuthnDevice.getPublicKeyCredentialCreationOptions());
        Object authnStateSpec = null;
        if (webAuthnDevice.getType().equalsIgnoreCase(Device.Type.FIDO2.getName())) {
            authnStateSpec = StateSpec.FIDO2_ACTIVATION_REQUIRED;
        }
        if (webAuthnDevice.getType().equalsIgnoreCase(Device.Type.SECURITY_KEY.getName())) {
            authnStateSpec = StateSpec.SECURITY_KEY_ACTIVATION_REQUIRED;
        }
        if (webAuthnDevice.getType().equalsIgnoreCase(Device.Type.PLATFORM.getName())) {
            authnStateSpec = StateSpec.PLATFORM_ACTIVATION_REQUIRED;
        }
        AuthnState authnState = this.authnApiSupport.makeAuthnState(req, authnStateSpec, (Object)model);
        this.authnApiSupport.writeAuthnStateResponse(req, resp, authnState);
    }

    public static List<AuthnStateSpec<?>> getAuthnStateSpecs() {
        return new ArrayList(STATE_SPEC_MAP.values());
    }

    private Map<String, Class<?>> getExpectedActionIdToModelMapping(String status) {
        HashMap actionIdToModelMapping = new HashMap();
        AuthnStateSpec<?> authnStateSpec = STATE_SPEC_MAP.get(status);
        authnStateSpec.getActions().forEach(action -> actionIdToModelMapping.put(action.getId(), action.getModelClass()));
        return actionIdToModelMapping;
    }

    static {
        STATE_SPEC_MAP.put(StateSpec.ASSERTION_REQUIRED.getStatus(), StateSpec.ASSERTION_REQUIRED);
        STATE_SPEC_MAP.put(StateSpec.AUTHENTICATION_CODE_RESPONSE_REQUIRED.getStatus(), StateSpec.AUTHENTICATION_CODE_RESPONSE_REQUIRED);
        STATE_SPEC_MAP.put(StateSpec.AUTHENTICATION_REQUIRED.getStatus(), StateSpec.AUTHENTICATION_REQUIRED);
        STATE_SPEC_MAP.put(StateSpec.BIOMETRIC_DEVICE_AUTHENTICATION_INFO_REQUIRED.getStatus(), StateSpec.BIOMETRIC_DEVICE_AUTHENTICATION_INFO_REQUIRED);
        STATE_SPEC_MAP.put(StateSpec.DEVICE_PAIRING_METHOD_REQUIRED.getStatus(), StateSpec.DEVICE_PAIRING_METHOD_REQUIRED);
        STATE_SPEC_MAP.put(StateSpec.DEVICE_SELECTION_REQUIRED.getStatus(), StateSpec.DEVICE_SELECTION_REQUIRED);
        STATE_SPEC_MAP.put(StateSpec.UPDATE_NICKNAME.getStatus(), StateSpec.UPDATE_NICKNAME);
        STATE_SPEC_MAP.put(StateSpec.EMAIL_ACTIVATION_REQUIRED.getStatus(), StateSpec.EMAIL_ACTIVATION_REQUIRED);
        STATE_SPEC_MAP.put(StateSpec.EMAIL_PAIRING_TARGET_REQUIRED.getStatus(), StateSpec.EMAIL_PAIRING_TARGET_REQUIRED);
        STATE_SPEC_MAP.put(CommonStateSpec.MFA_COMPLETED.getStatus(), CommonStateSpec.MFA_COMPLETED);
        STATE_SPEC_MAP.put(StateSpec.MFA_DEVICE_PAIRING_METHOD_FAILED.getStatus(), StateSpec.MFA_DEVICE_PAIRING_METHOD_FAILED);
        STATE_SPEC_MAP.put(StateSpec.MFA_FAILED.getStatus(), StateSpec.MFA_FAILED);
        STATE_SPEC_MAP.put(StateSpec.MFA_SETUP_REQUIRED.getStatus(), StateSpec.MFA_SETUP_REQUIRED);
        STATE_SPEC_MAP.put(StateSpec.MOBILE_ACTIVATION_REQUIRED.getStatus(), StateSpec.MOBILE_ACTIVATION_REQUIRED);
        STATE_SPEC_MAP.put(CommonStateSpec.MOBILE_PAIRING_REQUIRED.getStatus(), CommonStateSpec.MOBILE_PAIRING_REQUIRED);
        STATE_SPEC_MAP.put(StateSpec.ONE_TIME_DEVICE_OTP_METHOD_TYPE_INPUT_REQUIRED_RESPONSE.getStatus(), StateSpec.ONE_TIME_DEVICE_OTP_METHOD_TYPE_INPUT_REQUIRED_RESPONSE);
        STATE_SPEC_MAP.put(StateSpec.ONE_TIME_DEVICE_OTP_INPUT_REQUIRED_RESPONSE.getStatus(), StateSpec.ONE_TIME_DEVICE_OTP_INPUT_REQUIRED_RESPONSE);
        STATE_SPEC_MAP.put(StateSpec.OTP_REQUIRED.getStatus(), StateSpec.OTP_REQUIRED);
        STATE_SPEC_MAP.put(StateSpec.PUSH_CONFIRMATION_REJECTED.getStatus(), StateSpec.PUSH_CONFIRMATION_REJECTED);
        STATE_SPEC_MAP.put(StateSpec.PUSH_CONFIRMATION_TIMED_OUT.getStatus(), StateSpec.PUSH_CONFIRMATION_TIMED_OUT);
        STATE_SPEC_MAP.put(StateSpec.PUSH_CONFIRMATION_WAITING.getStatus(), StateSpec.PUSH_CONFIRMATION_WAITING);
        STATE_SPEC_MAP.put(StateSpec.FIDO2_ACTIVATION_REQUIRED.getStatus(), StateSpec.FIDO2_ACTIVATION_REQUIRED);
        STATE_SPEC_MAP.put(StateSpec.SECURITY_KEY_ACTIVATION_REQUIRED.getStatus(), StateSpec.SECURITY_KEY_ACTIVATION_REQUIRED);
        STATE_SPEC_MAP.put(StateSpec.PLATFORM_ACTIVATION_REQUIRED.getStatus(), StateSpec.PLATFORM_ACTIVATION_REQUIRED);
        STATE_SPEC_MAP.put(StateSpec.SMS_ACTIVATION_REQUIRED.getStatus(), StateSpec.SMS_ACTIVATION_REQUIRED);
        STATE_SPEC_MAP.put(StateSpec.SMS_PAIRING_TARGET_REQUIRED.getStatus(), StateSpec.SMS_PAIRING_TARGET_REQUIRED);
        STATE_SPEC_MAP.put(StateSpec.TOTP_ACTIVATION_REQUIRED.getStatus(), StateSpec.TOTP_ACTIVATION_REQUIRED);
        STATE_SPEC_MAP.put(StateSpec.VOICE_ACTIVATION_REQUIRED.getStatus(), StateSpec.VOICE_ACTIVATION_REQUIRED);
        STATE_SPEC_MAP.put(StateSpec.VOICE_PAIRING_TARGET_REQUIRED.getStatus(), StateSpec.VOICE_PAIRING_TARGET_REQUIRED);
        STATE_SPEC_MAP.put(StateSpec.WHATSAPP_ACTIVATION_REQUIRED.getStatus(), StateSpec.WHATSAPP_ACTIVATION_REQUIRED);
        STATE_SPEC_MAP.put(StateSpec.WHATSAPP_PAIRING_TARGET_REQUIRED.getStatus(), StateSpec.WHATSAPP_PAIRING_TARGET_REQUIRED);
    }
}

