/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.config;

import com.pingidentity.adapters.pingone.mfa.config.ApplicationsHelper;
import com.pingidentity.adapters.pingone.mfa.config.GetPopulationsAction;
import com.pingidentity.adapters.pingone.mfa.config.MfaPolicyForRegistrationHelper;
import com.pingidentity.adapters.pingone.mfa.config.PingOneMfaAdapterConfigurationValidator;
import com.pingidentity.adapters.pingone.mfa.config.PingOnePreRenderCallback;
import com.pingidentity.adapters.pingone.mfa.config.PopulationsHelper;
import com.pingidentity.adapters.pingone.mfa.config.Region;
import com.pingidentity.adapters.pingone.mfa.config.TestUserAction;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.lang3.StringUtils;
import com.pingidentity.adapters.pingone.mfa.util.UrlUtil;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.AbstractSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.ActionDescriptor;
import org.sourceid.saml20.adapter.gui.AdapterConfigurationGuiDescriptor;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.RadioGroupFieldDescriptor;
import org.sourceid.saml20.adapter.gui.SelectFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.event.PreRenderCallback;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.IntegerValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.URLValidator;

public class PingOneMfaAdapterConfiguration {
    private static boolean supportsPingOneEnvironmentFieldDescriptor;
    private static boolean supportsSetHidden;
    private static boolean supportsLoggingUtil;
    public static final EnvIdField ENV_ID_FIELD;
    private static final EndUserClientSecretField END_USER_CLIENT_SECRET_FIELD;
    public static final WorkerClientIdField WORKER_CLIENT_ID_FIELD;
    public static final WorkerClientSecretField WORKER_CLIENT_SECRET_FIELD;
    private static final AuthenticationPolicyField AUTHENTICATION_POLICY_FIELD;
    private static final RegistrationPolicyField REGISTRATION_POLICY_FIELD;
    private static final NotificationTemplateVariantOverrideField NOTIFICATION_TEMPLATE_VARIANT_OVERRIDE_FIELD;
    private static final RequestTimeoutField REQUEST_TIMEOUT_FIELD;
    private static final HtmlTemplateField HTML_TEMPLATE_FIELD;
    private static final MessagePropertiesField MESSAGE_PROPERTIES_FIELD;
    private static final AllowSetupMfaField ALLOW_SETUP_MFA_FIELD;
    private static final AllowSkipMfaField ALLOW_SKIP_MFA_FIELD;
    private static final AllowAddMethodField ALLOW_ADD_OR_REMOVE_METHOD_FIELD;
    private static final ProvisionUserField PROVISION_USER_FIELD;
    private static final UpdateAuthenticationMethodsField UPDATE_AUTHENTICATION_METHODS_FIELD;
    private static final OverwriteAuthenticationMethodsConfigurationField OVERWRITE_AUTHENTICATION_METHODS_CONFIGURATION_FIELD;
    private static final AllowOnlyPredefineValuesForPhoneOrEmailDevicesField FORCE_OFFLINE_DEVICES_INPUT_FIELD;
    private static final BypassMFABeforeDeviceMgmtAttributeField BYPASS_MFA_BEFORE_NEW_PAIRING_ATTRIBUTE_FIELD;
    private static final UsePasswordPolicyActionField USE_PASSWORD_POLICY_ACTION_FIELD;
    private static final EnableCookieTrackingField ENABLE_COOKIE_TRACKING_FIELD;
    private static final UsernameAttributeField USERNAME_ATTRIBUTE_FIELD;
    private static final SmsAttributeField SMS_ATTRIBUTE_FIELD;
    private static final VoiceAttributeField VOICE_ATTRIBUTE_FIELD;
    private static final EmailAttributeField EMAIL_ATTRIBUTE_FIELD;
    private static final WhatsAppAttributeField WHATSAPP_ATTRIBUTE_FIELD;
    private static final AuthCodeFlowAppIDField AUTH_CODE_FLOW_APP_ID_FIELD;
    private static final DefaultDeviceTypeField DEFAULT_DEVICE_TYPE_FIELD;
    private static final UserNotFoundFailureModeField USERNOTFOUND_FAILURE_MODE_FIELD;
    private static final ServiceUnavailableFailureModeField SERVICEUNAVAILABLE_FAILURE_MODE_FIELD;
    private static final SuccessScreensField SUCCESS_SCREENS_CONFIG_FIELD;
    private static final ErrorScreensField ERROR_SCREENS_CONFIG_FIELD;
    private static final TimeoutScreensField TIMEOUT_SCREENS_CONFIG_FIELD;
    private static final EnableAuditLogField ENABLE_AUDIT_LOG_CONFIG_FIELD;
    private static final ChangeDeviceField CHANGE_DEVICE_CONFIG_FIELD;
    private static final ProxySettingsField PROXY_SETTINGS_RADIO_GROUP_FIELD;
    private static final ProxyHostField PROXY_HOST_FIELD;
    private static final ProxyPortField PROXY_PORT_FIELD;
    private static final TestUsernameField TEST_USER_ID_FIELD;

    public static AdapterConfigurationGuiDescriptor adapterConfigurationGuiDescriptor() {
        return PingOneMfaAdapterConfiguration.adapterConfigurationGuiDescriptor(null);
    }

    public static AdapterConfigurationGuiDescriptor adapterConfigurationGuiDescriptor(Configuration configuration) {
        AdapterConfigurationGuiDescriptor adapterConfigurationGuiDescriptor = new AdapterConfigurationGuiDescriptor();
        adapterConfigurationGuiDescriptor.setDescription("PingOne MFA IdP Adapter works with PingOne MFA to enable multi-factor authentication.");
        if (supportsPingOneEnvironmentFieldDescriptor) {
            adapterConfigurationGuiDescriptor.addField(PingOneEnvironmentField.newPingOneEnvironmentField(configuration));
            if (configuration == null || PingOneEnvironmentField.isConfigured(configuration)) {
                adapterConfigurationGuiDescriptor.addField(PopulationField.newPopulationField(configuration, Collections.singletonList(SelectFieldDescriptor.SELECT_ONE)));
                adapterConfigurationGuiDescriptor.addPreRenderCallback((PreRenderCallback)new PingOnePreRenderCallback(new PopulationsHelper()));
                adapterConfigurationGuiDescriptor.addField(ApplicationField.newApplicationField(configuration, Collections.singletonList(SelectFieldDescriptor.SELECT_ONE)));
                adapterConfigurationGuiDescriptor.addPreRenderCallback((PreRenderCallback)new PingOnePreRenderCallback(new ApplicationsHelper()));
                adapterConfigurationGuiDescriptor.addField((FieldDescriptor)EnvIdField.hiddenInstance());
                adapterConfigurationGuiDescriptor.addField((FieldDescriptor)RegionField.hiddenInstance());
                adapterConfigurationGuiDescriptor.addField(PopulationField.hiddenInstance());
                adapterConfigurationGuiDescriptor.addField(ApplicationField.hiddenInstance());
                adapterConfigurationGuiDescriptor.addField((FieldDescriptor)EndUserClientSecretField.hiddenInstance());
                adapterConfigurationGuiDescriptor.addField((FieldDescriptor)WorkerClientIdField.hiddenInstance());
                adapterConfigurationGuiDescriptor.addField((FieldDescriptor)WorkerClientSecretField.hiddenInstance());
                adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)ApiPathField.hiddenInstance());
                adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)AuthPathField.hiddenInstance());
            }
        }
        if (!supportsPingOneEnvironmentFieldDescriptor || configuration != null && !PingOneEnvironmentField.isConfigured(configuration)) {
            adapterConfigurationGuiDescriptor.addField((FieldDescriptor)ENV_ID_FIELD);
            adapterConfigurationGuiDescriptor.addField((FieldDescriptor)new RegionField(configuration));
            adapterConfigurationGuiDescriptor.addField(PopulationField.newPopulationField());
            adapterConfigurationGuiDescriptor.addField(ApplicationField.newApplicationField());
            adapterConfigurationGuiDescriptor.addField((FieldDescriptor)END_USER_CLIENT_SECRET_FIELD);
        }
        if (!supportsPingOneEnvironmentFieldDescriptor || configuration != null && !PingOneEnvironmentField.isConfigured(configuration)) {
            adapterConfigurationGuiDescriptor.addField((FieldDescriptor)WORKER_CLIENT_ID_FIELD);
            adapterConfigurationGuiDescriptor.addField((FieldDescriptor)WORKER_CLIENT_SECRET_FIELD);
        }
        adapterConfigurationGuiDescriptor.addField((FieldDescriptor)AUTHENTICATION_POLICY_FIELD);
        adapterConfigurationGuiDescriptor.addField((FieldDescriptor)REGISTRATION_POLICY_FIELD);
        adapterConfigurationGuiDescriptor.addPreRenderCallback((PreRenderCallback)new PingOnePreRenderCallback(new MfaPolicyForRegistrationHelper()));
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)NOTIFICATION_TEMPLATE_VARIANT_OVERRIDE_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)TEST_USER_ID_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)HTML_TEMPLATE_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)MESSAGE_PROPERTIES_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)ALLOW_SETUP_MFA_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)ALLOW_SKIP_MFA_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)ALLOW_ADD_OR_REMOVE_METHOD_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)PROVISION_USER_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)new ProvisionAuthenticationMethodsField(configuration));
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)UPDATE_AUTHENTICATION_METHODS_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)OVERWRITE_AUTHENTICATION_METHODS_CONFIGURATION_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)FORCE_OFFLINE_DEVICES_INPUT_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)ENABLE_COOKIE_TRACKING_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)USE_PASSWORD_POLICY_ACTION_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)BYPASS_MFA_BEFORE_NEW_PAIRING_ATTRIBUTE_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)USERNAME_ATTRIBUTE_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)SMS_ATTRIBUTE_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)VOICE_ATTRIBUTE_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)EMAIL_ATTRIBUTE_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)WHATSAPP_ATTRIBUTE_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)AUTH_CODE_FLOW_APP_ID_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)DEFAULT_DEVICE_TYPE_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)USERNOTFOUND_FAILURE_MODE_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)SERVICEUNAVAILABLE_FAILURE_MODE_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)CHANGE_DEVICE_CONFIG_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)SUCCESS_SCREENS_CONFIG_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)ERROR_SCREENS_CONFIG_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)TIMEOUT_SCREENS_CONFIG_FIELD);
        if (supportsLoggingUtil) {
            adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)ENABLE_AUDIT_LOG_CONFIG_FIELD);
        }
        if (!supportsPingOneEnvironmentFieldDescriptor || configuration != null && !PingOneEnvironmentField.isConfigured(configuration)) {
            if (configuration != null && !RegionField.isConfigured(configuration) && ApiPathField.isConfigured(configuration) && AuthPathField.isConfigured(configuration)) {
                adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)new ApiPathField());
                adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)new AuthPathField());
            } else {
                adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)ApiPathField.hiddenInstance());
                adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)AuthPathField.hiddenInstance());
            }
        }
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)REQUEST_TIMEOUT_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)PROXY_SETTINGS_RADIO_GROUP_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)PROXY_HOST_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)PROXY_PORT_FIELD);
        adapterConfigurationGuiDescriptor.addValidator((ConfigurationValidator)new PingOneMfaAdapterConfigurationValidator(configuration));
        adapterConfigurationGuiDescriptor.addAction(new ActionDescriptor("Test Connection", "Validate your configuration by fetching user information.", (ActionDescriptor.Action)new TestUserAction()));
        adapterConfigurationGuiDescriptor.addAction(new ActionDescriptor("Get Populations", "Get available user populations from PingOne.", (ActionDescriptor.Action)new GetPopulationsAction()));
        return adapterConfigurationGuiDescriptor;
    }

    public static boolean containsField(AdapterConfigurationGuiDescriptor adapterConfigurationGuiDescriptor, String fieldName) {
        return adapterConfigurationGuiDescriptor.getFields().stream().anyMatch(it -> fieldName.equals(it.getName()));
    }

    public static FieldDescriptor getField(AdapterConfigurationGuiDescriptor adapterConfigurationGuiDescriptor, String name) {
        return adapterConfigurationGuiDescriptor.getFields().stream().filter(it -> name.equals(it.getName())).findFirst().orElse(null);
    }

    public static boolean supportsPingOneEnvironmentFieldDescriptor() {
        return supportsPingOneEnvironmentFieldDescriptor;
    }

    public static boolean legacyPingOneFieldsAreConfigured(Configuration configuration) {
        return EnvIdField.isConfigured(configuration) && (RegionField.isConfigured(configuration) || ApiPathField.isConfigured(configuration) && AuthPathField.isConfigured(configuration)) && WorkerClientIdField.isConfigured(configuration) && WorkerClientSecretField.isConfigured(configuration);
    }

    static {
        try {
            Class.forName("org.sourceid.saml20.adapter.gui.PingOneEnvironmentFieldDescriptor");
            supportsPingOneEnvironmentFieldDescriptor = true;
        }
        catch (ClassNotFoundException ignored) {
            supportsPingOneEnvironmentFieldDescriptor = false;
        }
        try {
            Class.forName("com.pingidentity.sdk.logging.LoggingUtil");
            supportsLoggingUtil = true;
        }
        catch (ClassNotFoundException ignored) {
            supportsLoggingUtil = false;
        }
        Method[] methods = FieldDescriptor.class.getMethods();
        if (Arrays.stream(methods).anyMatch(m -> "setHidden".equals(m.getName()))) {
            supportsSetHidden = true;
        }
        ENV_ID_FIELD = new EnvIdField();
        END_USER_CLIENT_SECRET_FIELD = new EndUserClientSecretField();
        WORKER_CLIENT_ID_FIELD = new WorkerClientIdField();
        WORKER_CLIENT_SECRET_FIELD = new WorkerClientSecretField();
        AUTHENTICATION_POLICY_FIELD = new AuthenticationPolicyField();
        REGISTRATION_POLICY_FIELD = new RegistrationPolicyField();
        NOTIFICATION_TEMPLATE_VARIANT_OVERRIDE_FIELD = new NotificationTemplateVariantOverrideField();
        REQUEST_TIMEOUT_FIELD = new RequestTimeoutField();
        HTML_TEMPLATE_FIELD = new HtmlTemplateField();
        MESSAGE_PROPERTIES_FIELD = new MessagePropertiesField();
        ALLOW_SETUP_MFA_FIELD = new AllowSetupMfaField();
        ALLOW_SKIP_MFA_FIELD = new AllowSkipMfaField();
        ALLOW_ADD_OR_REMOVE_METHOD_FIELD = new AllowAddMethodField();
        PROVISION_USER_FIELD = new ProvisionUserField();
        UPDATE_AUTHENTICATION_METHODS_FIELD = new UpdateAuthenticationMethodsField();
        OVERWRITE_AUTHENTICATION_METHODS_CONFIGURATION_FIELD = new OverwriteAuthenticationMethodsConfigurationField();
        FORCE_OFFLINE_DEVICES_INPUT_FIELD = new AllowOnlyPredefineValuesForPhoneOrEmailDevicesField();
        BYPASS_MFA_BEFORE_NEW_PAIRING_ATTRIBUTE_FIELD = new BypassMFABeforeDeviceMgmtAttributeField();
        USE_PASSWORD_POLICY_ACTION_FIELD = new UsePasswordPolicyActionField();
        ENABLE_COOKIE_TRACKING_FIELD = new EnableCookieTrackingField();
        USERNAME_ATTRIBUTE_FIELD = new UsernameAttributeField();
        SMS_ATTRIBUTE_FIELD = new SmsAttributeField();
        VOICE_ATTRIBUTE_FIELD = new VoiceAttributeField();
        EMAIL_ATTRIBUTE_FIELD = new EmailAttributeField();
        WHATSAPP_ATTRIBUTE_FIELD = new WhatsAppAttributeField();
        AUTH_CODE_FLOW_APP_ID_FIELD = new AuthCodeFlowAppIDField();
        DEFAULT_DEVICE_TYPE_FIELD = new DefaultDeviceTypeField();
        USERNOTFOUND_FAILURE_MODE_FIELD = new UserNotFoundFailureModeField();
        SERVICEUNAVAILABLE_FAILURE_MODE_FIELD = new ServiceUnavailableFailureModeField();
        SUCCESS_SCREENS_CONFIG_FIELD = new SuccessScreensField();
        ERROR_SCREENS_CONFIG_FIELD = new ErrorScreensField();
        TIMEOUT_SCREENS_CONFIG_FIELD = new TimeoutScreensField();
        ENABLE_AUDIT_LOG_CONFIG_FIELD = new EnableAuditLogField();
        CHANGE_DEVICE_CONFIG_FIELD = new ChangeDeviceField();
        PROXY_SETTINGS_RADIO_GROUP_FIELD = new ProxySettingsField();
        PROXY_HOST_FIELD = new ProxyHostField();
        PROXY_PORT_FIELD = new ProxyPortField();
        TEST_USER_ID_FIELD = new TestUsernameField();
    }

    public static class ProxyPortField
    extends TextFieldDescriptor {
        public ProxyPortField() {
            super("Custom Proxy Port", "The proxy server port to use when 'Proxy Settings' is set to 'Custom'.");
            this.addValidator((FieldValidator)new IntegerValidator(1, 65535), true);
        }

        public static int getProxyPort(Configuration configuration) {
            return configuration.getIntFieldValue("Custom Proxy Port");
        }
    }

    public static class ProxyHostField
    extends TextFieldDescriptor {
        public ProxyHostField() {
            super("Custom Proxy Host", "The proxy server hostname to use when 'Proxy Settings' is set to 'Custom'.");
        }

        public static String getProxyHost(Configuration configuration) {
            return configuration.getFieldValue("Custom Proxy Host");
        }
    }

    public static class ProxySettingsField
    extends RadioGroupFieldDescriptor {
        private static final String[] OPTION_VALUES = new String[]{"No Proxy", "System Defaults", "Custom"};

        public ProxySettingsField() {
            super("Proxy Settings", "Defines proxy settings for outbound HTTP requests.", OPTION_VALUES);
            this.setDefaultValue("System Defaults");
        }

        public static String getProxySettings(Configuration configuration) {
            return configuration.getFieldValue("Proxy Settings");
        }
    }

    public static class TimeoutScreensField
    extends CheckBoxFieldDescriptor {
        private TimeoutScreensField() {
            super("Show Timeout Screens", "Determines whether the adapter shows a \"timed out\" page when an MFA push notification times out.");
            this.setDefaultValue(true);
        }

        public static boolean showTimeoutScreenToUsers(Configuration configuration) {
            return configuration.getBooleanFieldValue("Show Timeout Screens");
        }
    }

    public static class EnableAuditLogField
    extends CheckBoxFieldDescriptor {
        private EnableAuditLogField() {
            super("Enable Audit Log", "When selected, the adapter will log end-user browser details along with selected authentication method info such as device type, correlation ID, and device nickname in PingFederate audit log.");
            this.setDefaultValue(false);
        }

        public static boolean isAuditLogEnabled(Configuration configuration) {
            return configuration.getBooleanFieldValue("Enable Audit Log");
        }
    }

    public static class ErrorScreensField
    extends CheckBoxFieldDescriptor {
        private ErrorScreensField() {
            super("Show Error Screens", "Determines whether the adapter shows a page when the MFA step generates an error.");
            this.setDefaultValue(true);
        }

        public static boolean showErrorScreenToUsers(Configuration configuration) {
            return configuration.getBooleanFieldValue("Show Error Screens");
        }
    }

    public static class SuccessScreensField
    extends CheckBoxFieldDescriptor {
        private SuccessScreensField() {
            super("Show Success Screens", "Determines whether the adapter shows a success page when the MFA step is successful.");
            this.setDefaultValue(true);
        }

        public static boolean showSuccessScreenToUsers(Configuration configuration) {
            return configuration.getBooleanFieldValue("Show Success Screens");
        }
    }

    public static class ServiceUnavailableFailureModeField
    extends RadioGroupFieldDescriptor {
        private static final String[] OPTION_VALUES = new String[]{"Block user", "Bypass authentication"};

        private ServiceUnavailableFailureModeField() {
            super("Service Unavailable Failure Mode", "This setting determines whether the adapter should block the user's sign-on attempt or bypass when the adapter is unable to access PingOne.", OPTION_VALUES);
            this.setDefaultValue("Bypass authentication");
        }

        public static boolean bypassEnabled(Configuration configuration) {
            return configuration.getFieldValue("Service Unavailable Failure Mode").equals("Bypass authentication");
        }
    }

    public static class UserNotFoundFailureModeField
    extends RadioGroupFieldDescriptor {
        private static final String[] OPTION_VALUES = new String[]{"Block user", "Bypass authentication"};

        private UserNotFoundFailureModeField() {
            super("User Not Found Failure Mode", "Determines whether the adapter blocks the user\u2019s sign-on attempt when it cannot find the user in PingOne, or the user is not enabled for MFA.", OPTION_VALUES);
            this.setDefaultValue("Block user");
        }

        public static boolean bypassEnabled(Configuration configuration) {
            return configuration.getFieldValue("User Not Found Failure Mode").equals("Bypass authentication");
        }
    }

    public static class DefaultDeviceTypeField
    extends RadioGroupFieldDescriptor {
        private static final String[] OPTION_VALUES = new String[]{"SMS", "Voice", "Email"};

        private DefaultDeviceTypeField() {
            super("DEFAULT AUTHENTICATION METHOD FOR PROVISIONED USERS", "When provisioning a new user to PingOne, the adapter sets the user's default authentication method based on this setting.\nApplies only when 'Update Authentication Methods' is selected.", OPTION_VALUES);
            this.setDefaultValue("SMS");
            this.setDefaultForLegacyConfig("SMS");
            this.setLabel("Default Authentication Method for Provisioned Users");
            this.addValidator((FieldValidator)new RequiredFieldValidator());
        }

        public static String getDefaultDeviceType(Configuration configuration) {
            if (StringUtils.isNotEmpty(configuration.getFieldValue("DEFAULT AUTHENTICATION METHOD FOR PROVISIONED USERS"))) {
                return configuration.getFieldValue("DEFAULT AUTHENTICATION METHOD FOR PROVISIONED USERS");
            }
            return "SMS";
        }
    }

    public static class WhatsAppAttributeField
    extends TextFieldDescriptor {
        private WhatsAppAttributeField() {
            super("WhatsApp Attribute", "When provisioning users or updating authentication methods, the adapter checks for phone numbers in each attribute that begins with this prefix. The adapter adds these phone numbers as whatsapp authentication methods in PingOne MFA.\nThis can be a multi-value attribute.\nThe default value is \"whatsapp\". Applies only when 'Update Authentication Methods' is selected.");
            this.setDefaultValue("whatsapp");
            this.setDefaultForLegacyConfig("whatsapp");
            this.addValidator((FieldValidator)new RequiredFieldValidator());
        }

        public static String getWhatsAppAttribute(Configuration configuration) {
            if (StringUtils.isNotEmpty(configuration.getFieldValue("WhatsApp Attribute"))) {
                return configuration.getFieldValue("WhatsApp Attribute");
            }
            return "whatsapp";
        }
    }

    public static class EmailAttributeField
    extends TextFieldDescriptor {
        private EmailAttributeField() {
            super("Email Attribute", "When provisioning users or updating authentication methods, the adapter checks for email addresses in each attribute that begins with this prefix. The adapter adds these email addresses as email authentication methods in PingOne MFA.\nThis can be a multi-value attribute.\nThe default value is \"email\". Applies only when 'Update Authentication Methods' is selected.");
            this.setDefaultValue("email");
            this.setDefaultForLegacyConfig("email");
            this.addValidator((FieldValidator)new RequiredFieldValidator());
        }

        public static String getEmailAttribute(Configuration configuration) {
            if (StringUtils.isNotEmpty(configuration.getFieldValue("Email Attribute"))) {
                return configuration.getFieldValue("Email Attribute");
            }
            return "email";
        }
    }

    public static class AuthCodeFlowAppIDField
    extends TextFieldDescriptor {
        private AuthCodeFlowAppIDField() {
            super("Application ID For Authentication Code Flow", "The application ID to use for authentication code based flow.");
        }

        public static String getAuthCodeFlowAppID(Configuration configuration) {
            return configuration.getFieldValue("Application ID For Authentication Code Flow");
        }
    }

    public static class VoiceAttributeField
    extends TextFieldDescriptor {
        private VoiceAttributeField() {
            super("Voice Attribute", "When provisioning users or updating authentication methods, the adapter checks for phone numbers in each attribute that begins with this prefix. The adapter adds these phone numbers as voice authentication methods in PingOne MFA.\nThis can be a multi-value attribute.\nThe default value is \"voice\". Applies only when 'Update Authentication Methods' is selected.");
            this.setDefaultValue("voice");
            this.setDefaultForLegacyConfig("voice");
            this.addValidator((FieldValidator)new RequiredFieldValidator());
        }

        public static String getVoiceAttribute(Configuration configuration) {
            if (StringUtils.isNotEmpty(configuration.getFieldValue("Voice Attribute"))) {
                return configuration.getFieldValue("Voice Attribute");
            }
            return "voice";
        }
    }

    public static class SmsAttributeField
    extends TextFieldDescriptor {
        private SmsAttributeField() {
            super("SMS Attribute", "When provisioning users or updating authentication methods, the adapter checks for phone numbers in each attribute that begins with this prefix. The adapter adds these phone numbers as SMS authentication methods in PingOne MFA.\nThis can be a multi-value attribute.\nThe default value is \"sms\". Applies only when 'Update Authentication Methods' is selected.");
            this.setDefaultValue("sms");
            this.setDefaultForLegacyConfig("sms");
            this.addValidator((FieldValidator)new RequiredFieldValidator());
        }

        public static String getSmsAttribute(Configuration configuration) {
            if (StringUtils.isNotEmpty(configuration.getFieldValue("SMS Attribute"))) {
                return configuration.getFieldValue("SMS Attribute");
            }
            return "sms";
        }
    }

    public static class UsernameAttributeField
    extends TextFieldDescriptor {
        private UsernameAttributeField() {
            super("Username Attribute", "Determines the username for users provisioned to PingOne. If you identify users based on their PingOne username, leave this field blank. If you identify users based on their PingOne user ID, enter the name of an attribute. New users are given a PingOne username based on this attribute.\nApplies only when 'Provision Users' is selected.\n");
        }

        public static String getUsernameAttribute(Configuration configuration) {
            return configuration.getFieldValue("Username Attribute");
        }
    }

    public static class OverwriteAuthenticationMethodsConfigurationField
    extends RadioGroupFieldDescriptor {
        private static final AbstractSelectionFieldDescriptor.OptionValue[] OPTION_VALUES = new AbstractSelectionFieldDescriptor.OptionValue[]{new AbstractSelectionFieldDescriptor.OptionValue("None", "false", true), new AbstractSelectionFieldDescriptor.OptionValue("All (SMS, Voice, WHATSAPP, and Email)", "true", false), new AbstractSelectionFieldDescriptor.OptionValue("Specific Methods", "specific methods", false)};

        private OverwriteAuthenticationMethodsConfigurationField() {
            super("Overwrite Authentication Methods", "When 'All' is selected, all of the user\u2019s existing SMS, voice, WHATSAPP, and email methods will be overwritten with the newly provided information. When 'Specific Methods' is selected, only those specific device types that match those that are provided will be overwritten, all other methods remain the same. Applies only to SMS, voice, WHATSAPP, and email methods. Applies only when 'Update Authentication Methods' is selected, and one of the authentication methods is being changed.", Arrays.asList(OPTION_VALUES));
            this.setLabel("Overwrite Authentication Methods Configurations");
            this.setDefaultValue("false");
        }

        public static String getOverwriteAuthenticationMethodsConfigurations(Configuration configuration) {
            return Optional.ofNullable(configuration.getFieldValue("Overwrite Authentication Methods")).orElse("None");
        }
    }

    public static class UpdateAuthenticationMethodsField
    extends CheckBoxFieldDescriptor {
        private UpdateAuthenticationMethodsField() {
            super("Update Authentication Methods", "When an existing user signs on, the adapter checks the user's 'SMS Attribute', 'Voice Attribute', 'WhatsApp Attribute', and 'Email Attribute' values. If there are any new values, the adapter adds them as authentication methods in PingOne.");
            this.setDefaultValue(false);
            this.setDefaultForLegacyConfig(Boolean.FALSE.toString());
        }

        public static boolean isUpdateAuthenticationMethods(Configuration configuration) {
            if (configuration.getFieldValue("Update Authentication Methods") != null) {
                return configuration.getBooleanFieldValue("Update Authentication Methods");
            }
            return false;
        }
    }

    public static class UsePasswordPolicyActionField
    extends TextFieldDescriptor {
        private UsePasswordPolicyActionField() {
            super("Use Password Config Attribute", " If true, this input attribute field will support a \"Use Password\" policy action from the device selection screen. The \"Use Password\" policy action will automatically exit the user from the current flow when the user has no device to perform  MFA and is not authenticated prior to reaching the adapter.");
        }

        public static String getUsePasswordPolicyActionField(Configuration configuration) {
            return configuration.getFieldValue("Use Password Config Attribute");
        }
    }

    public static class EnableCookieTrackingField
    extends CheckBoxFieldDescriptor {
        private EnableCookieTrackingField() {
            super("Enable Cookie Based Tracking", "When selected, the adapter tracks previously authenticated FIDO security key or platform device in a cookie.");
            this.setDefaultValue(false);
            this.setDefaultForLegacyConfig(Boolean.FALSE.toString());
        }

        public static boolean isCookieTrackingEnabled(Configuration configuration) {
            if (configuration.getFieldValue("Enable Cookie Based Tracking") != null) {
                return configuration.getBooleanFieldValue("Enable Cookie Based Tracking");
            }
            return false;
        }
    }

    public static class BypassMFABeforeDeviceMgmtAttributeField
    extends TextFieldDescriptor {
        private BypassMFABeforeDeviceMgmtAttributeField() {
            super("Bypass MFA for device management attribute", "If true, the input attribute field specifies whether MFA should be skipped when a user using an already paired device attempts to manage their devices.");
        }

        public static String getBypassMFAForDeviceMgmtAttributeField(Configuration configuration) {
            return configuration.getFieldValue("Bypass MFA for device management attribute");
        }
    }

    public static class ProvisionAuthenticationMethodsField
    extends CheckBoxFieldDescriptor {
        private ProvisionAuthenticationMethodsField(Configuration configuration) {
            super("Provision Authentication Methods", "Determines whether the adapter adds authentication methods based on the user's 'SMS Attribute', 'Voice Attribute', 'WhatsApp Attribute', and 'Email Attribute' values.");
            if (configuration != null) {
                this.setDefaultValue(ProvisionUserField.isProvisionUser(configuration));
                this.setDefaultForLegacyConfig(String.valueOf(ProvisionUserField.isProvisionUser(configuration)));
            } else {
                this.setDefaultValue(false);
                this.setDefaultForLegacyConfig(Boolean.FALSE.toString());
            }
        }

        public static boolean isProvisionAuthenticationMethods(Configuration configuration) {
            if (configuration.getFieldValue("Provision Authentication Methods") != null) {
                return configuration.getBooleanFieldValue("Provision Authentication Methods");
            }
            if (configuration.getFieldValue("Provision Users and Authentication Methods") != null) {
                return ProvisionUserField.isProvisionUser(configuration);
            }
            return false;
        }
    }

    public static class ProvisionUserField
    extends CheckBoxFieldDescriptor {
        private ProvisionUserField() {
            super("Provision Users and Authentication Methods", "If a user does not already exist in PingOne, the adapter provisions the user to PingOne.");
            this.setLabel("Provision Users");
            this.setDefaultValue(false);
            this.setDefaultForLegacyConfig(Boolean.FALSE.toString());
        }

        public static boolean isProvisionUser(Configuration configuration) {
            if (configuration.getFieldValue("Provision Users and Authentication Methods") != null) {
                return configuration.getBooleanFieldValue("Provision Users and Authentication Methods");
            }
            return false;
        }
    }

    public static class ChangeDeviceField
    extends RadioGroupFieldDescriptor {
        private static final String[] OPTION_VALUES = new String[]{"Allow", "Deny"};

        private ChangeDeviceField() {
            super("Change Device", "Determines whether users are allowed to go back and change their authentication device during a sign-on session.", OPTION_VALUES);
            this.setDefaultValue("Allow");
            this.setLabel("Change Authentication Method");
        }

        public static boolean isChangeDeviceAllowed(Configuration configuration) {
            return configuration.getFieldValue("Change Device").equals("Allow");
        }
    }

    public static class MessagePropertiesField
    extends TextFieldDescriptor {
        public MessagePropertiesField() {
            super("Messages Files", "Identifies the customizable language-pack file that the adapter uses.\nIf you customized the language-pack file names in \"/server/default/conf/language-packs\", enter the new name here. \nThe default value is \"pingone-mfa-messages\".\n");
            this.setDefaultValue("pingone-mfa-messages");
            this.addValidator((FieldValidator)new RequiredFieldValidator());
        }

        public MessagePropertiesField(String description) {
            super("Messages Files", description);
            this.setDefaultValue("pingone-mfa-messages");
            this.addValidator((FieldValidator)new RequiredFieldValidator());
        }

        public static String getMessageProperties(Configuration configuration) {
            return configuration.getFieldValue("Messages Files");
        }
    }

    public static class AllowAddMethodField
    extends CheckBoxFieldDescriptor {
        private AllowAddMethodField() {
            super("Allow Users to Add Additional Authentication Methods", "Determines whether users can add an additional authentication method or remove an existing one during sign on.\nThe user must sign on with their existing method first.");
            this.setLabel("Allow Users to Manage Authentication Methods");
            this.setDefaultValue(false);
            this.setDefaultForLegacyConfig(Boolean.FALSE.toString());
        }

        public static boolean isAllowAddOrRemoveMethod(Configuration configuration) {
            return configuration.getBooleanFieldValue("Allow Users to Manage Authentication Methods") || configuration.getBooleanFieldValue("Allow Users to Add Additional Authentication Methods");
        }
    }

    public static class AllowSkipMfaField
    extends CheckBoxFieldDescriptor {
        private AllowSkipMfaField() {
            super("Allow Users to Skip MFA Setup", "Determines whether the MFA setup prompt includes a 'Skip' option.\nThis allows the user to sign on without setting up MFA.\nApplies only when 'Prompt Users to Set Up MFA' is selected.");
            this.setDefaultValue(false);
            this.setDefaultForLegacyConfig(Boolean.FALSE.toString());
        }

        public static boolean isAllowSkipMfa(Configuration configuration) {
            if (StringUtils.isNotEmpty(configuration.getFieldValue("Allow Users to Skip MFA Setup"))) {
                return configuration.getBooleanFieldValue("Allow Users to Skip MFA Setup");
            }
            return false;
        }
    }

    public static class AllowSetupMfaField
    extends CheckBoxFieldDescriptor {
        private AllowSetupMfaField() {
            super("Prompt Users to Set Up MFA", "Determines whether users with no authentication methods are prompted to add an authentication method.");
            this.setDefaultValue(false);
            this.setDefaultForLegacyConfig(Boolean.FALSE.toString());
        }

        public static boolean isAllowSetupMfa(Configuration configuration) {
            if (configuration.getFieldValue("Prompt Users to Set Up MFA") != null) {
                return configuration.getBooleanFieldValue("Prompt Users to Set Up MFA");
            }
            return false;
        }
    }

    public static class HtmlTemplateField
    extends TextFieldDescriptor {
        public HtmlTemplateField() {
            super("HTML Template Prefix", "Identifies the set of HTML templates that the adapter uses.\nIf you customized the template file names in \"/server/default/conf/template\", enter the new prefix here.\nThe default value is \"pingone-mfa\".");
            this.setDefaultValue("pingone-mfa");
            this.addValidator((FieldValidator)new RequiredFieldValidator());
        }

        public static String getHtmlTemplate(Configuration configuration) {
            return configuration.getFieldValue("HTML Template Prefix");
        }
    }

    public static class TestUsernameField
    extends TextFieldDescriptor {
        public TestUsernameField() {
            super("Test Username", "The username used to test the configuration on the 'Actions' tab.");
        }

        public static String getTestUserID(Configuration configuration) {
            return configuration.getFieldValue("Test Username");
        }
    }

    public static class RequestTimeoutField
    extends TextFieldDescriptor {
        public RequestTimeoutField() {
            super("API Request Timeout", "The amount of time in milliseconds that PingFederate allows when establishing a connection with PingOne or waiting for a response to a request. A value of 0 disables the timeout. A negative value uses the PingFederate system defaults.");
            this.addValidator((FieldValidator)new RequiredFieldValidator());
            this.addValidator((FieldValidator)new IntegerValidator());
            this.setDefaultValue("12000");
        }

        public static int getRequestTimeout(Configuration configuration) {
            return configuration.getIntFieldValue("API Request Timeout");
        }
    }

    public static class PopulationField {
        public static FieldDescriptor hiddenInstance() {
            TextFieldDescriptor populationField = new TextFieldDescriptor("Population ID", "If a user does not already exist in PingOne, the adapter provisions the user to this PingOne population. Your population ID appears on Identities > Populations in PingOne.\nApplies only when 'Provision Users' is selected. Deprecated. Replaced by 'PingOne Population'.");
            if (supportsSetHidden) {
                populationField.setHidden(true);
            }
            return populationField;
        }

        public static FieldDescriptor newPopulationField() {
            return PopulationField.newPopulationField(null, null);
        }

        public static FieldDescriptor newPopulationField(Configuration configuration, List<AbstractSelectionFieldDescriptor.OptionValue> optionValues) {
            TextFieldDescriptor populationField;
            if (optionValues != null) {
                String defaultValue = SelectFieldDescriptor.SELECT_ONE.getValue();
                if (configuration != null) {
                    PopulationsHelper populationsHelper;
                    String legacyPopulationId = configuration.getFieldValue("Population ID");
                    if (PingOneEnvironmentField.isConfigured(configuration) && !PopulationField.isPopulationSelectConfigured(configuration) && StringUtils.isNotEmpty(legacyPopulationId) && (optionValues = (populationsHelper = new PopulationsHelper()).getOptionValues(configuration)).stream().anyMatch(it -> legacyPopulationId.equals(it.getValue()))) {
                        defaultValue = legacyPopulationId;
                    }
                }
                populationField = new SelectFieldDescriptor("PingOne Population", "If a user does not already exist in PingOne, the adapter provisions the user to this PingOne population. This list is populated when you select a PingOne Environment.\nApplies only when 'Provision Users' is selected.", optionValues);
                populationField.setDefaultValue(defaultValue);
                populationField.setDefaultForLegacyConfig(defaultValue);
            } else {
                populationField = new TextFieldDescriptor("Population ID", "If a user does not already exist in PingOne, the adapter provisions the user to this PingOne population. Your population ID appears on Identities > Populations in PingOne.\nApplies only when 'Provision Users' is selected.");
            }
            return populationField;
        }

        public static boolean isPopulationSelectConfigured(Configuration configuration) {
            if (configuration != null) {
                return StringUtils.isNotBlank(configuration.getFieldValue("PingOne Population"));
            }
            return false;
        }

        public static boolean isPopulationTextConfigured(Configuration configuration) {
            if (configuration != null) {
                return StringUtils.isNotBlank(configuration.getFieldValue("Population ID"));
            }
            return false;
        }

        public static String getPingOnePopulation(Configuration configuration) {
            String populationSelectField = configuration.getFieldValue("PingOne Population");
            return StringUtils.isNotEmpty(populationSelectField) ? populationSelectField : configuration.getFieldValue("Population ID");
        }
    }

    public static class RegionField
    extends SelectFieldDescriptor {
        private static final List<AbstractSelectionFieldDescriptor.OptionValue> OPTION_VALUES = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>();

        private RegionField(String description) {
            super("Region", description, OPTION_VALUES);
        }

        public RegionField() {
            this((Configuration)null);
        }

        public RegionField(Configuration configuration) {
            this("The region shown in your environment properties on the PingOne console. This determines which PingOne API service endpoints are used.");
            Region region = RegionField.getRegion(configuration);
            this.setDefaultValue(region.getValue());
            this.setDefaultForLegacyConfig(region.getValue());
        }

        public static RegionField hiddenInstance() {
            RegionField regionField = new RegionField("The region shown in your environment properties on the PingOne console. This determines which PingOne API service endpoints are used. Deprecated. Replaced by 'PingOne Environment'.");
            if (supportsSetHidden) {
                regionField.setHidden(true);
            }
            return regionField;
        }

        public static Region getRegion(Configuration configuration) {
            Region region;
            if (configuration == null) {
                region = Region.getDefault();
            } else {
                String value = configuration.getFieldValue("Region");
                if (StringUtils.isBlank(value)) {
                    String apiPath = ApiPathField.getApiPath(configuration);
                    String authPath = AuthPathField.getAuthPath(configuration);
                    region = apiPath != null && Region.fromApiEndpoint(apiPath) != null ? Region.fromApiEndpoint(apiPath) : (authPath != null && Region.fromAuthEndpoint(authPath) != null ? Region.fromAuthEndpoint(authPath) : Region.getDefault());
                } else {
                    region = Region.fromValue(value);
                }
            }
            return region;
        }

        public static boolean isConfigured(Configuration configuration) {
            return configuration != null && StringUtils.isNotBlank(configuration.getFieldValue("Region"));
        }

        static {
            OPTION_VALUES.add(SelectFieldDescriptor.SELECT_ONE);
            OPTION_VALUES.addAll(Arrays.stream(Region.values()).map(region -> new AbstractSelectionFieldDescriptor.OptionValue(region.getName(), region.getValue())).collect(Collectors.toList()));
        }
    }

    public static class ApiPathField
    extends TextFieldDescriptor {
        public ApiPathField(String description) {
            super("PingOne Management API", description);
            this.setDefaultValue("https://api.pingone.com");
            this.addValidator((FieldValidator & Serializable)field -> {
                String fieldValue = field.getValue();
                if (fieldValue != null && !fieldValue.isEmpty()) {
                    URLValidator fieldValidator = new URLValidator();
                    fieldValidator.validate(field);
                }
            });
        }

        public ApiPathField() {
            this("The PingOne API service URL. The endpoint for your region is shown on the PingOne console. See the Configuration tab for your PingFederate connection.");
        }

        public static ApiPathField hiddenInstance() {
            ApiPathField apiPathField = new ApiPathField("The PingOne API service URL. The endpoint for your region is shown on the PingOne console. See the Configuration tab for your PingFederate connection. Deprecated. Replaced by 'PingOne Environment'.");
            if (supportsSetHidden) {
                apiPathField.setHidden(true);
            }
            return apiPathField;
        }

        public static boolean isConfigured(Configuration configuration) {
            return configuration != null && configuration.getFieldValue("PingOne Management API") != null && !configuration.getFieldValue("PingOne Management API").isEmpty();
        }

        public static String getApiPath(Configuration configuration) {
            return UrlUtil.trimTrailingSlash(configuration.getFieldValue("PingOne Management API"));
        }
    }

    public static class AuthPathField
    extends TextFieldDescriptor {
        public AuthPathField(String description) {
            super("PingOne Authentication API", description);
            this.setDefaultValue("https://auth.pingone.com");
            this.addValidator((FieldValidator & Serializable)field -> {
                String fieldValue = field.getValue();
                if (fieldValue != null && !fieldValue.isEmpty()) {
                    URLValidator fieldValidator = new URLValidator();
                    fieldValidator.validate(field);
                }
            });
        }

        public AuthPathField() {
            this("The PingOne authentication and authorization URL. The endpoint for your region is shown on the PingOne console. See the Configuration tab for your PingFederate connection.");
        }

        public static AuthPathField hiddenInstance() {
            AuthPathField authPathField = new AuthPathField("The PingOne authentication and authorization URL. The endpoint for your region is shown on the PingOne console. See the Configuration tab for your PingFederate connection. Deprecated. Replaced by 'PingOne Environment'.");
            if (supportsSetHidden) {
                authPathField.setHidden(true);
            }
            return authPathField;
        }

        public static boolean isConfigured(Configuration configuration) {
            return configuration != null && configuration.getFieldValue("PingOne Authentication API") != null && !configuration.getFieldValue("PingOne Authentication API").isEmpty();
        }

        public static String getAuthPath(Configuration configuration) {
            return UrlUtil.trimTrailingSlash(configuration.getFieldValue("PingOne Authentication API"));
        }
    }

    public static class AllowOnlyPredefineValuesForPhoneOrEmailDevicesField
    extends CheckBoxFieldDescriptor {
        public AllowOnlyPredefineValuesForPhoneOrEmailDevicesField() {
            super("Allow only predefine values for phone or email devices", "When set to true, the phone number or email address will be automatically populated from user's profile and can not be edited by the user");
            this.setDefaultValue(false);
        }

        public static boolean getAllowOnlyPredefineValuesForPhoneOrEmailDevicesField(Configuration configuration) {
            return configuration.getBooleanFieldValue("Allow only predefine values for phone or email devices");
        }
    }

    public static class RegistrationPolicyField
    extends SelectFieldDescriptor {
        private RegistrationPolicyField() {
            super("MFA policy for registration", "A PingOne MFA policy that will dictate available methods for device pairing. If empty, the default MFA policy will be used");
        }

        public static String getRegistrationPolicy(Configuration configuration) {
            return configuration.getFieldValue("MFA policy for registration");
        }
    }

    public static class AuthenticationPolicyField
    extends TextFieldDescriptor {
        public AuthenticationPolicyField() {
            super("PingOne Authentication Policy", "The PingOne authentication policy, or policies to use. This overrides any policy received in the requested authentication context. Separate multiple values with a space.");
        }

        public AuthenticationPolicyField(String description) {
            super("PingOne Authentication Policy", description);
        }

        public static String getAuthenticationPolicy(Configuration configuration) {
            return configuration.getFieldValue("PingOne Authentication Policy");
        }
    }

    public static class NotificationTemplateVariantOverrideField
    extends TextFieldDescriptor {
        public NotificationTemplateVariantOverrideField() {
            super("Notification Template Variant Override", "Overrides the notification template variant that PingOne uses for transaction approval flows. The adapter ignores any \u2018pi.template.variant\u2019 attribute and uses this value instead.\nEnter the name of the template variant. For example, if you have a PingOne \"transaction\" template variant called \"money-transfer\", enter \"money-transfer\".");
        }

        public NotificationTemplateVariantOverrideField(String description) {
            super("Notification Template Variant Override", description);
        }

        public static String getNotificationTemplateOverride(Configuration configuration) {
            return configuration.getFieldValue("Notification Template Variant Override");
        }
    }

    public static class WorkerClientSecretField
    extends TextFieldDescriptor {
        private WorkerClientSecretField(String description) {
            super("PingFederate Connection Client Secret", description, true);
        }

        public WorkerClientSecretField() {
            this("The client secret for your PingFederate connection in PingOne.");
            this.addValidator((FieldValidator)new RequiredFieldValidator());
        }

        public static WorkerClientSecretField hiddenInstance() {
            WorkerClientSecretField workerClientSecretField = new WorkerClientSecretField("The client secret for your PingFederate connection in PingOne. Deprecated. Replaced by 'PingOne Environment'.");
            if (supportsSetHidden) {
                workerClientSecretField.setHidden(true);
            }
            return workerClientSecretField;
        }

        public static String getWorkerClientSecret(Configuration configuration) {
            return configuration.getFieldValue("PingFederate Connection Client Secret") != null ? configuration.getFieldValue("PingFederate Connection Client Secret").trim() : null;
        }

        public static boolean isConfigured(Configuration configuration) {
            return configuration != null && StringUtils.isNotBlank(WorkerClientSecretField.getWorkerClientSecret(configuration));
        }
    }

    public static class WorkerClientIdField
    extends TextFieldDescriptor {
        private WorkerClientIdField(String description) {
            super("PingFederate Connection Client ID", description);
        }

        public WorkerClientIdField() {
            this("The client ID for your PingFederate connection in PingOne.");
            this.addValidator((FieldValidator)new RequiredFieldValidator());
        }

        public static WorkerClientIdField hiddenInstance() {
            WorkerClientIdField workerClientIdField = new WorkerClientIdField("The client ID for your PingFederate connection in PingOne. Deprecated. Replaced by 'PingOne Environment'.");
            if (supportsSetHidden) {
                workerClientIdField.setHidden(true);
            }
            return workerClientIdField;
        }

        public static String getWorkerClientId(Configuration configuration) {
            return configuration.getFieldValue("PingFederate Connection Client ID") != null ? configuration.getFieldValue("PingFederate Connection Client ID").trim() : null;
        }

        public static boolean isConfigured(Configuration configuration) {
            return configuration != null && StringUtils.isNotBlank(WorkerClientIdField.getWorkerClientId(configuration));
        }
    }

    public static class EndUserClientSecretField
    extends TextFieldDescriptor {
        private EndUserClientSecretField(String description) {
            super("Application Client Secret", description, true);
        }

        public EndUserClientSecretField() {
            this("The client secret for your application in PingOne.");
            this.addValidator((FieldValidator)new RequiredFieldValidator());
        }

        public static String getEndUserClientSecret(Configuration configuration) {
            return configuration.getFieldValue("Application Client Secret");
        }

        public static EndUserClientSecretField hiddenInstance() {
            EndUserClientSecretField endUserClientSecretField = new EndUserClientSecretField("The client secret for your application in PingOne. Deprecated.");
            if (supportsSetHidden) {
                endUserClientSecretField.setHidden(true);
            }
            return endUserClientSecretField;
        }
    }

    public static class ApplicationField {
        private ApplicationField() {
        }

        public static FieldDescriptor newApplicationField() {
            return ApplicationField.newApplicationField(null, null);
        }

        public static FieldDescriptor newApplicationField(Configuration configuration, List<AbstractSelectionFieldDescriptor.OptionValue> optionValues) {
            TextFieldDescriptor applicationField;
            if (optionValues != null) {
                String defaultValue = SelectFieldDescriptor.SELECT_ONE.getValue();
                if (configuration != null) {
                    ApplicationsHelper applicationsHelper;
                    String legacyApplicationId = configuration.getFieldValue("Application Client ID");
                    if (PingOneEnvironmentField.isConfigured(configuration) && !ApplicationField.isApplicationFieldConfigured(configuration) && StringUtils.isNotEmpty(legacyApplicationId) && (optionValues = (applicationsHelper = new ApplicationsHelper()).getOptionValues(configuration)).stream().anyMatch(it -> legacyApplicationId.equals(it.getValue()))) {
                        defaultValue = legacyApplicationId;
                    }
                }
                applicationField = new SelectFieldDescriptor("Application", "Your PingOne application. This list is populated when you select a PingOne Environment.", optionValues);
                applicationField.setDefaultValue(defaultValue);
                applicationField.setDefaultForLegacyConfig(defaultValue);
            } else {
                applicationField = new TextFieldDescriptor("Application Client ID", "The client ID for your application in PingOne.");
            }
            return applicationField;
        }

        public static FieldDescriptor hiddenInstance() {
            TextFieldDescriptor applicationField = new TextFieldDescriptor("Application Client ID", "The client ID for your application in PingOne. Deprecated. Replaced by 'Application'.");
            if (supportsSetHidden) {
                applicationField.setHidden(true);
            }
            return applicationField;
        }

        public static boolean isApplicationFieldConfigured(Configuration configuration) {
            if (configuration != null) {
                return StringUtils.isNotBlank(configuration.getFieldValue("Application")) && !SelectFieldDescriptor.SELECT_ONE.getValue().equals(configuration.getFieldValue("Application"));
            }
            return false;
        }

        public static boolean isApplicationIdFieldConfigured(Configuration configuration) {
            if (configuration != null) {
                return StringUtils.isNotBlank(configuration.getFieldValue("Application Client ID"));
            }
            return false;
        }

        public static String getApplicationId(Configuration configuration) {
            String applicationField = configuration.getFieldValue("Application");
            return StringUtils.isNotEmpty(applicationField) ? applicationField : configuration.getFieldValue("Application Client ID");
        }
    }

    public static class EnvIdField
    extends TextFieldDescriptor {
        public EnvIdField() {
            this("Your PingOne environment ID.");
            this.addValidator((FieldValidator)new RequiredFieldValidator());
        }

        private EnvIdField(String description) {
            super("Environment ID", description);
        }

        public static EnvIdField hiddenInstance() {
            EnvIdField envIdField = new EnvIdField("Your PingOne environment ID. Deprecated. Replaced by 'PingOne Environment'.");
            if (supportsSetHidden) {
                envIdField.setHidden(true);
            }
            return envIdField;
        }

        public static String getEnvId(Configuration configuration) {
            return configuration.getFieldValue("Environment ID") != null ? configuration.getFieldValue("Environment ID").trim() : null;
        }

        public static boolean isConfigured(Configuration configuration) {
            return configuration != null && StringUtils.isNotBlank(EnvIdField.getEnvId(configuration));
        }
    }

    public static class PingOneEnvironmentField {
        public static FieldDescriptor newPingOneEnvironmentField() {
            return PingOneEnvironmentField.newPingOneEnvironmentField(null);
        }

        public static FieldDescriptor newPingOneEnvironmentField(Configuration configuration) {
            try {
                Class<?> pingOneEnvironmentFieldClass = Class.forName("org.sourceid.saml20.adapter.gui.PingOneEnvironmentFieldDescriptor");
                Constructor<?> pingOneEnvironmentFieldConstructor = pingOneEnvironmentFieldClass.getConstructor(String.class, String.class);
                return (FieldDescriptor)pingOneEnvironmentFieldConstructor.newInstance("PingOne Environment", "Your PingOne environment. Create connections in System > External Systems > PingOne Connections.");
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }

        public static String getPingOneEnvironment(Configuration configuration) {
            return configuration.getFieldValue("PingOne Environment");
        }

        public static boolean isConfigured(Configuration configuration) {
            return configuration != null && StringUtils.isNotEmpty(PingOneEnvironmentField.getPingOneEnvironment(configuration));
        }
    }
}

