/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.config;

import com.pingidentity.adapters.pingone.mfa.api.client.PingOneClientsFactory;
import com.pingidentity.adapters.pingone.mfa.api.client.worker.WorkerApiClient;
import com.pingidentity.adapters.pingone.mfa.api.model.policies.Action;
import com.pingidentity.adapters.pingone.mfa.api.model.policies.SignOnPolicyApplication;
import com.pingidentity.adapters.pingone.mfa.config.PingOneMfaAdapterConfiguration;
import com.pingidentity.adapters.pingone.mfa.config.ReflectivePingOneEnvironmentValidator;
import com.pingidentity.adapters.pingone.mfa.exception.AccessTokenProviderException;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.lang3.StringUtils;
import com.pingidentity.adapters.pingone.mfa.util.accestoken.TokenService;
import java.io.IOException;
import java.util.List;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;

class PingOneMfaAdapterConfigurationValidator
implements ConfigurationValidator {
    private final Configuration configuration;
    private final FieldValidator pingOneEnvironmentFieldValidator;
    private WorkerApiClient workerApiClient;
    private TokenService tokenService;

    public PingOneMfaAdapterConfigurationValidator(Configuration configuration) {
        this.configuration = configuration;
        this.pingOneEnvironmentFieldValidator = new ReflectivePingOneEnvironmentValidator();
    }

    public PingOneMfaAdapterConfigurationValidator(Configuration configuration, FieldValidator pingOneEnvironmentValidator) {
        this.configuration = configuration;
        this.pingOneEnvironmentFieldValidator = pingOneEnvironmentValidator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validate(Configuration conf) throws ValidationException {
        if (PingOneMfaAdapterConfiguration.PingOneEnvironmentField.isConfigured(conf)) {
            this.pingOneEnvironmentFieldValidator.validate(conf.getField("PingOne Environment"));
            if (PingOneMfaAdapterConfiguration.ProvisionUserField.isProvisionUser(conf) && !PingOneMfaAdapterConfiguration.PopulationField.isPopulationSelectConfigured(conf)) {
                if (PingOneMfaAdapterConfiguration.PingOneEnvironmentField.isConfigured(this.configuration)) throw new ValidationException("'PingOne Population' is required when 'Provision Users' is selected.");
                if (!PingOneMfaAdapterConfiguration.PopulationField.isPopulationTextConfigured(conf)) {
                    throw new ValidationException("'Population ID' is required when 'Provision Users' is selected.");
                }
            }
            if (!PingOneMfaAdapterConfiguration.ApplicationField.isApplicationFieldConfigured(conf)) {
                if (PingOneMfaAdapterConfiguration.PingOneEnvironmentField.isConfigured(this.configuration)) throw new ValidationException("'Application' is required.");
                if (!PingOneMfaAdapterConfiguration.ApplicationField.isApplicationIdFieldConfigured(conf)) {
                    throw new ValidationException("'Application Client ID' is required.");
                }
            }
        } else {
            if (PingOneMfaAdapterConfiguration.PingOneEnvironmentField.isConfigured(this.configuration) || !PingOneMfaAdapterConfiguration.legacyPingOneFieldsAreConfigured(conf)) {
                throw new ValidationException("'PingOne Environment' is required.");
            }
            if (PingOneMfaAdapterConfiguration.ProvisionUserField.isProvisionUser(conf) && !PingOneMfaAdapterConfiguration.PopulationField.isPopulationTextConfigured(conf)) {
                throw new ValidationException("'Population ID' is required when 'Provision Users and Authentication Methods' is selected.");
            }
            if (!PingOneMfaAdapterConfiguration.ApplicationField.isApplicationIdFieldConfigured(conf)) {
                throw new ValidationException("'Application Client ID' is required.");
            }
        }
        this.validatePolicyConfigAndAuthenticationCodeApplicationId(conf);
    }

    private void validatePolicyConfigAndAuthenticationCodeApplicationId(Configuration configuration) throws ValidationException {
        if (configuration != null) {
            String authCodeFlowAppId = PingOneMfaAdapterConfiguration.AuthCodeFlowAppIDField.getAuthCodeFlowAppID(configuration);
            this.initPingOneClients(configuration);
            String authenticationPolicy = PingOneMfaAdapterConfiguration.AuthenticationPolicyField.getAuthenticationPolicy(configuration);
            try {
                String accessToken = this.tokenService.getToken();
                this.validateAuthenticationPolicy(accessToken, authenticationPolicy, authCodeFlowAppId);
            }
            catch (AccessTokenProviderException | IOException exception) {
                // empty catch block
            }
        }
    }

    private void initPingOneClients(Configuration configuration) {
        PingOneClientsFactory clientsFactory = new PingOneClientsFactory(configuration);
        this.workerApiClient = clientsFactory.getWorkerApiClient();
        this.tokenService = clientsFactory.getTokenServiceClient();
    }

    private void validateAuthenticationPolicy(String accessToken, String authenticationPolicy, String authCodeFlowAppId) throws ValidationException, IOException {
        if (StringUtils.isNotBlank(authenticationPolicy)) {
            String[] policies;
            for (String policyName : policies = authenticationPolicy.split(" ")) {
                List<Action> signOnPolicyActions = this.workerApiClient.getSignOnPolicyActionsFromPolicyName(accessToken, policyName);
                if (signOnPolicyActions == null) {
                    throw new ValidationException("Invalid authentication policy value: " + policyName);
                }
                Action multiFactorAuthenticationAction = signOnPolicyActions.stream().filter(it -> "MULTI_FACTOR_AUTHENTICATION".equals(it.getType())).findFirst().orElse(null);
                if (multiFactorAuthenticationAction == null) {
                    throw new ValidationException("Authentication policy: '" + policyName + "' found but does not contain the required Multi-factor Authentication type.");
                }
                if (!StringUtils.isNotBlank(authCodeFlowAppId)) continue;
                if (multiFactorAuthenticationAction.getApplications() == null || multiFactorAuthenticationAction.getApplications().isEmpty()) {
                    throw new ValidationException("No mobile application configured to support authentication code flow. Remove 'Application ID For Authentication Code Flow' field configuration or verify entered value and PingOne authentication policy configuration.");
                }
                List<SignOnPolicyApplication> signOnPolicyApplications = multiFactorAuthenticationAction.getApplications();
                for (SignOnPolicyApplication signOnPolicyApplication : signOnPolicyApplications) {
                    if (authCodeFlowAppId.equals(signOnPolicyApplication.getId())) continue;
                    throw new ValidationException("No mobile application configured to support authentication code flow. Remove 'Application ID For Authentication Code Flow' field configuration or verify entered value and PingOne authentication policy configuration.");
                }
            }
        } else {
            if (StringUtils.isBlank(authCodeFlowAppId)) {
                return;
            }
            try {
                this.workerApiClient.getApplicationById(accessToken, authCodeFlowAppId);
            }
            catch (IOException e) {
                throw new ValidationException("Invalid value: " + authCodeFlowAppId + " for 'Application ID For Authentication Code Flow' field configuration. No such application found.");
            }
        }
    }
}

