/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.config;

import com.pingidentity.adapters.pingone.mfa.api.client.PingOneClientsFactory;
import com.pingidentity.adapters.pingone.mfa.api.client.flows.FlowsApiClient;
import com.pingidentity.adapters.pingone.mfa.api.client.worker.WorkerApiClient;
import com.pingidentity.adapters.pingone.mfa.api.model.ApiErrorResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.applications.Application;
import com.pingidentity.adapters.pingone.mfa.api.model.policies.Action;
import com.pingidentity.adapters.pingone.mfa.api.model.policies.DeviceAuthenticationPolicy;
import com.pingidentity.adapters.pingone.mfa.api.model.policies.SignOnPolicyApplication;
import com.pingidentity.adapters.pingone.mfa.api.model.response.ErrorResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.FlowResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.TokenErrorResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.users.User;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.EmailDevice;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.MobileDevice;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.SmsDevice;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.TOTPDevice;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.fido.PlatformDevice;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.fido.SecurityKeyDevice;
import com.pingidentity.adapters.pingone.mfa.config.PingOneMfaAdapterConfiguration;
import com.pingidentity.adapters.pingone.mfa.exception.AccessTokenProviderException;
import com.pingidentity.adapters.pingone.mfa.exception.ApiResponseException;
import com.pingidentity.adapters.pingone.mfa.shade.com.google.common.cache.CacheBuilder;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.lang3.StringUtils;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.lang.JoseException;
import com.pingidentity.adapters.pingone.mfa.util.AppSecretCache;
import com.pingidentity.adapters.pingone.mfa.util.DefaultAppSecretProvider;
import com.pingidentity.adapters.pingone.mfa.util.ErrorResponseUtil;
import com.pingidentity.adapters.pingone.mfa.util.LoginHintTokenUtil;
import com.pingidentity.adapters.pingone.mfa.util.accestoken.TokenService;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.ActionDescriptor;

public class TestUserAction
implements ActionDescriptor.Action {
    public String actionInvoked(Configuration configuration) {
        Object badActorMessage;
        String errorMessage;
        String accessToken;
        PingOneClientsFactory clientsFactory = new PingOneClientsFactory(configuration);
        WorkerApiClient workerApiClient = clientsFactory.getWorkerApiClient();
        TokenService tokenService = clientsFactory.getTokenServiceClient();
        FlowsApiClient flowsApiClient = clientsFactory.getFlowsApiClient();
        String applicationId = PingOneMfaAdapterConfiguration.ApplicationField.getApplicationId(configuration);
        String authenticationPolicy = PingOneMfaAdapterConfiguration.AuthenticationPolicyField.getAuthenticationPolicy(configuration);
        String registrationPolicy = PingOneMfaAdapterConfiguration.RegistrationPolicyField.getRegistrationPolicy(configuration);
        String envId = clientsFactory.getEnvId();
        String authPath = clientsFactory.getAuthPath();
        String testUsername = PingOneMfaAdapterConfiguration.TestUsernameField.getTestUserID(configuration);
        boolean isConfigValid = true;
        if (StringUtils.isBlank(testUsername)) {
            return "Enter a valid value for 'Test Username' field to test.";
        }
        StringBuilder result = new StringBuilder();
        AppSecretCache appSecretCache = new AppSecretCache("appSecret.", CacheBuilder.newBuilder().expireAfterWrite(Duration.ZERO).build(), new DefaultAppSecretProvider(configuration, tokenService, workerApiClient));
        boolean workerApiConfigValid = true;
        boolean clientApiConfigValid = true;
        try {
            accessToken = tokenService.getToken();
            result.append("---------------------------------\n");
            result.append("'Environment ID': Valid\n");
            result.append("'PingFederate Connection Client ID': Valid\n");
            result.append("'PingFederate Connection Client Secret': Valid\n");
            result.append("---------------------------------\n");
        }
        catch (AccessTokenProviderException e) {
            result.append("Unable to retrieve access token. Verify 'Environment ID', PingFederate Connection Client ID', PingFederate Connection Client Secret' values. ");
            return result.toString();
        }
        try {
            User user = workerApiClient.getUserByUsername(accessToken, testUsername);
            List<Object> devices = new ArrayList();
            String userName = null;
            if (user != null) {
                userName = user.getUsername();
                String userId = user.getId();
                devices = workerApiClient.getUserDevices(accessToken, userId, null);
            }
            ArrayList<CallSite> deviceDetails = new ArrayList<CallSite>();
            for (Device device : devices) {
                String nickName;
                if (device instanceof EmailDevice) {
                    deviceDetails.add((CallSite)((Object)(device.getType() + ": " + ((EmailDevice)device).getEmail() + ", Status: " + device.getStatus())));
                }
                if (device instanceof SmsDevice) {
                    deviceDetails.add((CallSite)((Object)(device.getType() + ": " + ((SmsDevice)device).getPhone() + ", Status: " + device.getStatus())));
                }
                if (device instanceof MobileDevice) {
                    deviceDetails.add((CallSite)((Object)(device.getType() + ": " + ((MobileDevice)device).getModel().getMarketingName() + ", Status: " + device.getStatus())));
                }
                if (device instanceof TOTPDevice) {
                    nickName = device.getNickname();
                    if (StringUtils.isBlank(nickName)) {
                        deviceDetails.add((CallSite)((Object)(device.getType() + ": " + device.getId() + ", Status: " + device.getStatus())));
                    } else {
                        deviceDetails.add((CallSite)((Object)(device.getType() + ": " + nickName + ", Status: " + device.getStatus())));
                    }
                }
                if (device instanceof PlatformDevice) {
                    deviceDetails.add((CallSite)((Object)(device.getType() + ": " + device.getId() + ", Platform: " + ((PlatformDevice)device).getPlatform())));
                }
                if (!(device instanceof SecurityKeyDevice)) continue;
                nickName = device.getNickname();
                if (StringUtils.isNotBlank(nickName)) {
                    deviceDetails.add((CallSite)((Object)(device.getType() + ": " + device.getId() + ", Name: " + nickName)));
                    continue;
                }
                deviceDetails.add((CallSite)((Object)(device.getType() + ": " + device.getId())));
            }
            Object userDevices = "";
            if (!deviceDetails.isEmpty()) {
                userDevices = deviceDetails.toString();
            }
            if (StringUtils.isBlank(userName)) {
                result.append("No such user with username: 'Test Username': " + testUsername + "\n");
                isConfigValid = false;
            } else if (((String)userDevices).isEmpty()) {
                result.append("User with username: '" + testUsername + "' found but with no devices").append("\n");
                isConfigValid = false;
            } else {
                result.append("User with username: '" + testUsername + "' found with devices - \n").append(deviceDetails.stream().collect(Collectors.joining("\n")));
                result.append("\n");
            }
            result.append("---------------------------------\n");
        }
        catch (IOException e) {
            result.append("---------------------------------\n");
            result.append("Unable to retrieve user information.\n");
            result.append("Error details: " + e.getMessage());
            result.append("\n---------------------------------\n");
        }
        try {
            accessToken = tokenService.getToken();
            List<Action> signOnPolicyActions = workerApiClient.getSignOnPolicyActionsFromPolicyName(accessToken, authenticationPolicy);
            if (signOnPolicyActions != null) {
                Optional<Action> actionOptional = signOnPolicyActions.stream().filter(it -> "MULTI_FACTOR_AUTHENTICATION".equals(it.getType())).findFirst();
                if (actionOptional.isPresent()) {
                    Action action = actionOptional.get();
                    result.append("Authentication policy: '" + authenticationPolicy + "' found with details:\n");
                    if (action.getEmail() != null && action.getEmail().isEnabled()) {
                        result.append("Email: Enabled.\n");
                    } else {
                        result.append("Email: Disabled.\n");
                    }
                    if (action.getFido2() != null) {
                        if (action.getFido2().isEnabled()) {
                            result.append("FIDO2: Enabled.\n");
                        } else {
                            result.append("FIDO2: Disabled.\n");
                        }
                    } else {
                        if (action.getSecurityKey() != null && action.getSecurityKey().isEnabled()) {
                            result.append("Security Key: Enabled.\n");
                        } else {
                            result.append("Security Key: Disabled.\n");
                        }
                        if (action.getBoundBiometrics() != null && action.getBoundBiometrics().isEnabled()) {
                            result.append("Biometrics: Enabled.\n");
                        } else {
                            result.append("Biometrics: Disabled.\n");
                        }
                    }
                    if (action.getSms() != null && action.getSms().isEnabled()) {
                        result.append("SMS: Enabled.\n");
                    } else {
                        result.append("SMS: Disabled.\n");
                    }
                    if (action.getVoice() != null && action.getVoice().isEnabled()) {
                        result.append("Voice: Enabled.\n");
                    } else {
                        result.append("Voice: Disabled.\n");
                    }
                    if (action.getAuthenticator() != null && action.getAuthenticator().isEnabled()) {
                        result.append("Authenticator App: Enabled.\n");
                    } else {
                        result.append("Authenticator App: Disabled.\n");
                    }
                    if (action.getApplications() == null || action.getApplications().isEmpty()) {
                        result.append("Mobile Applications: None configured.\n");
                    } else {
                        result.append("Mobile Applications: \n");
                        List<SignOnPolicyApplication> signOnPolicyApplications = action.getApplications();
                        for (SignOnPolicyApplication signOnPolicyApplication : signOnPolicyApplications) {
                            result.append("Application ID: " + signOnPolicyApplication.getId() + ", ");
                            if (signOnPolicyApplication.getAutoEnrollment().isEnabled()) {
                                result.append("Auto Enrollment: Enabled, ");
                            } else {
                                result.append("Auto Enrollment: Disabled, ");
                            }
                            if (signOnPolicyApplication.getDeviceAuthorization().isEnabled()) {
                                result.append("Device Authorization: Enabled, ");
                                result.append("Extra Verification: " + signOnPolicyApplication.getDeviceAuthorization().getExtraVerification() + "\n");
                                continue;
                            }
                            result.append("Device Authorization: Disabled.\n");
                        }
                    }
                    result.append("---------------------------------\n");
                } else {
                    isConfigValid = false;
                    result.append("Authentication policy: '" + authenticationPolicy + "' found but does not contain the required Multi-factor Authentication type.\n");
                    result.append("---------------------------------\n");
                }
            } else if (StringUtils.isNotBlank(authenticationPolicy)) {
                isConfigValid = false;
                result.append("Authentication policy: '" + authenticationPolicy + "' is not found.\n");
                result.append("---------------------------------\n");
            }
        }
        catch (IOException e) {
            workerApiConfigValid = false;
            boolean needsEnvAdmin = false;
            if (e instanceof ApiResponseException) {
                errorMessage = ((ApiResponseException)e).getErrorResponse().getMessage();
                badActorMessage = "The actor attempting to perform the request is not authorized.";
                if (StringUtils.isNotBlank(errorMessage) && ((String)badActorMessage).equals(errorMessage)) {
                    needsEnvAdmin = true;
                }
            }
            result.append("\n---------------------------------\n");
            if (needsEnvAdmin) {
                result.append("Unable to retrieve authentication policy information. This test additionally requires 'Environment Admin' role assigned to PingOne connection.");
            } else {
                result.append("Unable to retrieve authentication policy information due to error below.\n");
                result.append(this.getErrorDetails(e));
            }
            result.append("\n---------------------------------\n");
        }
        catch (AccessTokenProviderException e) {
            workerApiConfigValid = false;
            result.append("\n---------------------------------\n");
            result.append("Unable to retrieve authentication policy information due to error below.\n");
            if (e.getCause() instanceof ApiResponseException) {
                result.append(this.getErrorDetails((ApiResponseException)e.getCause()));
            } else {
                result.append("Error exchanging credential for access token.");
            }
            result.append("\n---------------------------------\n");
        }
        try {
            if (StringUtils.isNotBlank(registrationPolicy)) {
                accessToken = tokenService.getToken();
                List<DeviceAuthenticationPolicy> allMFAPolicies = workerApiClient.getAllMFAPolicies(accessToken);
                if (allMFAPolicies.stream().filter(mfaPolicy -> mfaPolicy.getName().equals(registrationPolicy)).findAny().isPresent()) {
                    DeviceAuthenticationPolicy mfaPolicy2 = allMFAPolicies.stream().filter(policy -> policy.getName().equals(registrationPolicy)).findAny().get();
                    result.append("Registration policy: '" + registrationPolicy + "' found with details:\n");
                    if (mfaPolicy2.getEmail() != null && mfaPolicy2.getEmail().isEnabled()) {
                        result.append("Email: Enabled.\n");
                    } else {
                        result.append("Email: Disabled.\n");
                    }
                    if (mfaPolicy2.getFido2() != null) {
                        if (mfaPolicy2.getFido2().isEnabled()) {
                            result.append("FIDO2: Enabled.\n");
                        } else {
                            result.append("FIDO2: Disabled.\n");
                        }
                    } else {
                        if (mfaPolicy2.getSecurityKey() != null && mfaPolicy2.getSecurityKey().isEnabled()) {
                            result.append("Security Key: Enabled.\n");
                        } else {
                            result.append("Security Key: Disabled.\n");
                        }
                        if (mfaPolicy2.getBoundBiometrics() != null && mfaPolicy2.getBoundBiometrics().isEnabled()) {
                            result.append("Biometrics: Enabled.\n");
                        } else {
                            result.append("Biometrics: Disabled.\n");
                        }
                    }
                    if (mfaPolicy2.getSms() != null && mfaPolicy2.getSms().isEnabled()) {
                        result.append("SMS: Enabled.\n");
                    } else {
                        result.append("SMS: Disabled.\n");
                    }
                    if (mfaPolicy2.getVoice() != null && mfaPolicy2.getVoice().isEnabled()) {
                        result.append("Voice: Enabled.\n");
                    } else {
                        result.append("Voice: Disabled.\n");
                    }
                    if (mfaPolicy2.getTotp() != null && mfaPolicy2.getTotp().isEnabled()) {
                        result.append("Authenticator App: Enabled.\n");
                    } else {
                        result.append("Authenticator App: Disabled.\n");
                    }
                    if (mfaPolicy2.getMobile() == null || !mfaPolicy2.getMobile().isEnabled() || mfaPolicy2.getMobile().getApplications().isEmpty()) {
                        result.append("Mobile Applications: None configured.\n");
                    } else {
                        result.append("Mobile Applications: \n");
                        List<SignOnPolicyApplication> signOnPolicyApplications = mfaPolicy2.getMobile().getApplications();
                        for (SignOnPolicyApplication signOnPolicyApplication : signOnPolicyApplications) {
                            result.append("Application ID: " + signOnPolicyApplication.getId() + ", ");
                            if (signOnPolicyApplication.getAutoEnrollment().isEnabled()) {
                                result.append("Auto Enrollment: Enabled, ");
                            } else {
                                result.append("Auto Enrollment: Disabled, ");
                            }
                            if (signOnPolicyApplication.getDeviceAuthorization().isEnabled()) {
                                result.append("Device Authorization: Enabled, ");
                                result.append("Extra Verification: " + signOnPolicyApplication.getDeviceAuthorization().getExtraVerification() + "\n");
                                continue;
                            }
                            result.append("Device Authorization: Disabled.\n");
                        }
                    }
                    result.append("---------------------------------\n");
                } else if (StringUtils.isNotBlank(registrationPolicy)) {
                    isConfigValid = false;
                    result.append("Registration policy: '" + registrationPolicy + "' was not found.\n");
                    result.append("---------------------------------\n");
                }
            }
        }
        catch (IOException e) {
            workerApiConfigValid = false;
            boolean needsEnvAdmin = false;
            if (e instanceof ApiResponseException) {
                errorMessage = ((ApiResponseException)e).getErrorResponse().getMessage();
                badActorMessage = "The actor attempting to perform the request is not authorized.";
                if (StringUtils.isNotBlank(errorMessage) && ((String)badActorMessage).equals(errorMessage)) {
                    needsEnvAdmin = true;
                }
            }
            result.append("\n---------------------------------\n");
            if (needsEnvAdmin) {
                result.append("Unable to retrieve registration policy information. This test additionally requires 'Environment Admin' role assigned to PingOne connection.");
            } else {
                result.append("Unable to retrieve registration policy information due to error below.\n");
                result.append(this.getErrorDetails(e));
            }
            result.append("\n---------------------------------\n");
        }
        catch (AccessTokenProviderException e) {
            workerApiConfigValid = false;
            result.append("\n---------------------------------\n");
            result.append("Unable to retrieve registration policy information due to error below.\n");
            if (e.getCause() instanceof ApiResponseException) {
                result.append(this.getErrorDetails((ApiResponseException)e.getCause()));
            } else {
                result.append("Error exchanging credential for access token.");
            }
            result.append("\n---------------------------------\n");
        }
        try {
            Application applicationInfo = workerApiClient.getApplicationById(accessToken, applicationId);
            if (!applicationInfo.isEnabled()) {
                isConfigValid = false;
                result.append("Client ID: '" + applicationId + "' is disabled.\n");
            }
            ArrayList<String> responseTypes = applicationInfo.getResponseTypes();
            ArrayList<String> grantTypes = applicationInfo.getGrantTypes();
            if (!(grantTypes != null && grantTypes.contains("IMPLICIT") && responseTypes != null && responseTypes.contains("ID_TOKEN") && responseTypes.contains("TOKEN"))) {
                result.append("Client ID: '" + applicationId + "' needs update.\n");
                isConfigValid = false;
                if (applicationInfo.getGrantTypes() == null || !applicationInfo.getGrantTypes().contains("IMPLICIT")) {
                    result.append("Grant type must have 'IMPLICIT'.\n");
                }
                if (responseTypes == null) {
                    result.append("Response type config must include 'TOKEN' and 'ID_TOKEN'.\n");
                } else if (!applicationInfo.getResponseTypes().contains("TOKEN")) {
                    result.append("Response type config must include 'TOKEN'.\n");
                } else {
                    result.append("Response type config must include 'ID_TOKEN'.\n");
                }
            }
        }
        catch (IOException e) {
            boolean needsEnvAdmin = false;
            if (e instanceof ApiResponseException) {
                errorMessage = ((ApiResponseException)e).getErrorResponse().getMessage();
                badActorMessage = "The actor attempting to perform the request is not authorized.";
                if (StringUtils.isNotBlank(errorMessage) && ((String)badActorMessage).equals(errorMessage)) {
                    needsEnvAdmin = true;
                }
                if (needsEnvAdmin) {
                    result.append("Unable to retrieve application client information. This test additionally requires 'Environment Admin' role assigned to PingOne connection.");
                } else {
                    result.append("Unable to retrieve application client information due to error below.\n");
                    result.append(this.getErrorDetails(e));
                }
            } else {
                result.append("Error exchanging credential for access token.");
            }
            result.append("\n---------------------------------\n");
        }
        String workerApiTestResult = result.toString();
        StringBuilder initFlowResult = new StringBuilder();
        if (isConfigValid) {
            try {
                String appSecret = appSecretCache.getAppSecret(applicationId);
                String loginHintToken = LoginHintTokenUtil.generateLoginHintToken(authPath, applicationId, appSecret, envId, testUsername);
                FlowResponse flowResponse = flowsApiClient.initiateFlowPostVariant(loginHintToken, "", "", "", "");
                initFlowResult.append("Authentication flow initiated. Response status: " + flowResponse.getStatus());
                initFlowResult.append("\n---------------------------------\n");
            }
            catch (JoseException e) {
                clientApiConfigValid = false;
                initFlowResult.append("Test initiating authentication failed. Error generating valid login hint token: ").append(e.getMessage());
            }
            catch (AccessTokenProviderException | IOException e) {
                clientApiConfigValid = false;
                initFlowResult.append("Unable to initiate authentication flow test.\n");
                if (e instanceof ApiResponseException) {
                    initFlowResult.append(this.getErrorDetails(e));
                } else {
                    initFlowResult.append("Error exchanging credential for access token.");
                }
                initFlowResult.append("---------------------------------\n");
            }
        }
        if (!workerApiConfigValid || !clientApiConfigValid) {
            initFlowResult.append("Check configuration and/or server log for more details.");
        }
        return workerApiTestResult.trim() + "\n" + initFlowResult.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getErrorDetails(Exception e) {
        StringBuilder result = new StringBuilder();
        if (e instanceof ApiResponseException) {
            ApiErrorResponse errorResponse = ((ApiResponseException)e).getErrorResponse();
            if (errorResponse instanceof TokenErrorResponse) {
                result.append("\nError details: ").append(((TokenErrorResponse)errorResponse).getPrettyErrorDetails());
                return result.toString();
            } else if (errorResponse instanceof ErrorResponse) {
                ErrorResponse errorResponseObj = (ErrorResponse)errorResponse;
                String code = errorResponseObj.getCode();
                String errorDetailCode = errorResponseObj.getErrorDetailCode();
                String errorDetailTarget = ErrorResponseUtil.getErrorDetailTarget(errorResponseObj);
                String errorDetailMessage = ErrorResponseUtil.getErrorDetailMessage(errorResponseObj);
                switch (code) {
                    case "INVALID_REQUEST": {
                        if (!"INVALID_PARAMETER".equals(errorDetailCode) || !"response_type".equals(errorDetailTarget)) return result.toString();
                        result.append("\nResponse type config must include both 'TOKEN' and 'ID_TOKEN'");
                        return result.toString();
                    }
                    case "INVALID_DATA": {
                        if (!"INVALID_VALUE".equals(errorDetailCode) || !"scope".equals(errorDetailTarget)) return result.toString();
                        result.append("\n").append(errorDetailMessage);
                        return result.toString();
                    }
                    case "ACCESS_FAILED": {
                        if ("INVALID_VALUE".equals(errorDetailCode)) {
                            if (!"client_id".equals(errorDetailTarget)) return result.toString();
                            result.append("\n").append(errorDetailMessage);
                            return result.toString();
                        }
                        result.append("\n").append(errorResponseObj.getMessage());
                        return result.toString();
                    }
                    default: {
                        result.append("\nError details: ").append(((ErrorResponse)errorResponse).getPrettyErrorDetails());
                        return result.toString();
                    }
                }
            } else {
                result.append(e.getLocalizedMessage());
            }
            return result.toString();
        } else {
            result.append(e.getLocalizedMessage());
        }
        return result.toString();
    }
}

