/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.text.lookup;

import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.text.lookup.AbstractStringLookup;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.text.lookup.IllegalArgumentExceptions;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

abstract class AbstractPathFencedLookup
extends AbstractStringLookup {
    protected final List<Path> fences;

    AbstractPathFencedLookup(Path ... fences) {
        this.fences = fences != null ? Arrays.stream(fences).map(Path::toAbsolutePath).collect(Collectors.toList()) : Collections.emptyList();
    }

    protected Path getPath(String fileName) {
        Path path = Paths.get(fileName, new String[0]);
        if (this.fences.isEmpty()) {
            return path;
        }
        Path pathAbs = path.normalize().toAbsolutePath();
        Optional<Path> first = this.fences.stream().filter(pathAbs::startsWith).findFirst();
        if (first.isPresent()) {
            return path;
        }
        throw IllegalArgumentExceptions.format("[%s] -> [%s] not in %s", fileName, pathAbs, this.fences);
    }
}

