/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.text.lookup;

import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.lang3.function.FailableSupplier;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.text.lookup.AbstractStringLookup;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;

final class InetAddressStringLookup
extends AbstractStringLookup {
    static final InetAddressStringLookup LOCAL_HOST = new InetAddressStringLookup(InetAddress::getLocalHost);
    static final InetAddressStringLookup LOOPACK_ADDRESS = new InetAddressStringLookup(InetAddress::getLoopbackAddress);
    private final FailableSupplier<InetAddress, UnknownHostException> inetAddressSupplier;

    private InetAddressStringLookup(FailableSupplier<InetAddress, UnknownHostException> inetAddressSupplier) {
        this.inetAddressSupplier = Objects.requireNonNull(inetAddressSupplier, "inetAddressSupplier");
    }

    private InetAddress getInetAddress() throws UnknownHostException {
        return this.inetAddressSupplier.get();
    }

    @Override
    public String lookup(String key) {
        if (key == null) {
            return null;
        }
        try {
            switch (key) {
                case "name": {
                    return this.getInetAddress().getHostName();
                }
                case "canonical-name": {
                    return this.getInetAddress().getCanonicalHostName();
                }
                case "address": {
                    return this.getInetAddress().getHostAddress();
                }
            }
            throw new IllegalArgumentException(key);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }
}

