/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.impl.entity;

import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.Header;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.HttpEntity;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.HttpException;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.HttpMessage;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.annotation.Contract;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.annotation.ThreadingBehavior;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.entity.BasicHttpEntity;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.entity.ContentLengthStrategy;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.impl.io.ChunkedInputStream;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.impl.io.ContentLengthInputStream;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.impl.io.IdentityInputStream;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.io.SessionInputBuffer;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.util.Args;
import java.io.IOException;

@Deprecated
@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class EntityDeserializer {
    private final ContentLengthStrategy lenStrategy;

    public EntityDeserializer(ContentLengthStrategy lenStrategy) {
        this.lenStrategy = Args.notNull(lenStrategy, "Content length strategy");
    }

    protected BasicHttpEntity doDeserialize(SessionInputBuffer inBuffer, HttpMessage message) throws HttpException, IOException {
        Header contentEncodingHeader;
        BasicHttpEntity entity = new BasicHttpEntity();
        long len = this.lenStrategy.determineLength(message);
        if (len == -2L) {
            entity.setChunked(true);
            entity.setContentLength(-1L);
            entity.setContent(new ChunkedInputStream(inBuffer));
        } else if (len == -1L) {
            entity.setChunked(false);
            entity.setContentLength(-1L);
            entity.setContent(new IdentityInputStream(inBuffer));
        } else {
            entity.setChunked(false);
            entity.setContentLength(len);
            entity.setContent(new ContentLengthInputStream(inBuffer, len));
        }
        Header contentTypeHeader = message.getFirstHeader("Content-Type");
        if (contentTypeHeader != null) {
            entity.setContentType(contentTypeHeader);
        }
        if ((contentEncodingHeader = message.getFirstHeader("Content-Encoding")) != null) {
            entity.setContentEncoding(contentEncodingHeader);
        }
        return entity;
    }

    public HttpEntity deserialize(SessionInputBuffer inBuffer, HttpMessage message) throws HttpException, IOException {
        Args.notNull(inBuffer, "Session input buffer");
        Args.notNull(message, "HTTP message");
        return this.doDeserialize(inBuffer, message);
    }
}

