/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.shade.org.apache.velocity.runtime.directive;

import com.pingidentity.adapters.pingone.mfa.shade.org.apache.velocity.app.event.EventHandlerUtil;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.velocity.context.InternalContextAdapter;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.velocity.exception.MethodInvocationException;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.velocity.exception.ResourceNotFoundException;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.velocity.exception.TemplateInitException;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.velocity.exception.VelocityException;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.velocity.runtime.RuntimeServices;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.velocity.runtime.directive.InputBase;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.velocity.runtime.parser.node.Node;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.velocity.runtime.resource.Resource;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.velocity.util.StringUtils;
import java.io.IOException;
import java.io.Writer;

public class Include
extends InputBase {
    private String outputMsgStart = "";
    private String outputMsgEnd = "";

    @Override
    public String getName() {
        return "include";
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public boolean isScopeProvided() {
        return false;
    }

    @Override
    public void init(RuntimeServices rs, InternalContextAdapter context, Node node) throws TemplateInitException {
        super.init(rs, context, node);
        this.outputMsgStart = this.rsvc.getString("directive.include.output_error_start");
        this.outputMsgStart = this.outputMsgStart + " ";
        this.outputMsgEnd = this.rsvc.getString("directive.include.output_error_end");
        this.outputMsgEnd = " " + this.outputMsgEnd;
    }

    @Override
    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException, MethodInvocationException, ResourceNotFoundException {
        int argCount = node.jjtGetNumChildren();
        for (int i = 0; i < argCount; ++i) {
            Node n = node.jjtGetChild(i);
            if (n.getType() == 9 || n.getType() == 20) {
                if (this.renderOutput(n, context, writer)) continue;
                this.outputErrorToStream(writer, "error with arg " + i + " please see log.");
                continue;
            }
            String msg = "invalid #include() argument '" + n.toString() + "' at " + StringUtils.formatFileString(this);
            this.log.error(msg);
            this.outputErrorToStream(writer, "error with arg " + i + " please see log.");
            throw new VelocityException(msg, null, this.rsvc.getLogContext().getStackTrace());
        }
        return true;
    }

    private boolean renderOutput(Node node, InternalContextAdapter context, Writer writer) throws IOException, MethodInvocationException, ResourceNotFoundException {
        if (node == null) {
            this.log.error("#include() null argument");
            return false;
        }
        Object value = node.value(context);
        if (value == null) {
            this.log.error("#include() null argument");
            return false;
        }
        String sourcearg = value.toString();
        String arg = EventHandlerUtil.includeEvent(this.rsvc, context, sourcearg, context.getCurrentTemplateName(), this.getName());
        boolean blockinput = false;
        if (arg == null) {
            blockinput = true;
        }
        Resource resource = null;
        try {
            if (!blockinput) {
                resource = this.getResource(arg, this.getInputEncoding(context));
            }
        }
        catch (ResourceNotFoundException rnfe) {
            this.log.error("#" + this.getName() + "(): cannot find resource '{}', called at {}", (Object)arg, (Object)StringUtils.formatFileString(this));
            throw rnfe;
        }
        catch (RuntimeException e) {
            this.log.error("#" + this.getName() + "(): arg = '{}', called at {}", (Object)arg, (Object)StringUtils.formatFileString(this));
            throw e;
        }
        catch (Exception e) {
            String msg = "#" + this.getName() + "(): arg = '" + arg + "', called at " + StringUtils.formatFileString(this);
            this.log.error(msg, (Throwable)e);
            throw new VelocityException(msg, e, this.rsvc.getLogContext().getStackTrace());
        }
        if (blockinput) {
            return true;
        }
        if (resource == null) {
            return false;
        }
        writer.write((String)resource.getData());
        return true;
    }

    private void outputErrorToStream(Writer writer, String msg) throws IOException {
        if (this.outputMsgStart != null && this.outputMsgEnd != null) {
            writer.write(this.outputMsgStart);
            writer.write(msg);
            writer.write(this.outputMsgEnd);
        }
    }

    protected Resource getResource(String path, String encoding) throws ResourceNotFoundException {
        return this.rsvc.getContent(path, encoding);
    }
}

